/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.compile;

import com.azul.gulp.text.GulpText;
import com.azul.java.MethodId;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.compile.CompileData;
import com.azul.jvm.compile.CompileStarted;
import com.azul.jvm.compile.CompilerId;
import com.azul.zing.console.matchers.ZephyrInliningContextLineMatcher;

@GulpText.LineMatchers(value={@GulpText.LineMatcher(regex="\\s*(\\d+)\\s+([123]) ([\\w\\d\\$\\.\\:\\<\\>]+)"), @GulpText.LineMatcher(value=ZephyrInliningContextLineMatcher.class)})
public final class ZingInliningContext {
    public final CompilationId compileId;
    public final Boolean osr;
    public final CompilerId compilerId;
    public final MethodId method;

    public ZingInliningContext(int compileId, CompilerId compilerId, String method) {
        this.compileId = CompilationId.of(compileId);
        this.compilerId = compilerId;
        this.osr = null;
        this.method = MethodId.byNameOnly(method);
    }

    public ZingInliningContext(CompileData compileData) {
        this.compileId = compileData.compileId;
        this.compilerId = compileData.compilerId;
        this.osr = compileData.osrBci != null;
        this.method = compileData.method;
    }

    public ZingInliningContext(CompileStarted compile) {
        this.compileId = compile.compileId;
        this.compilerId = compile.compilerId;
        this.osr = compile.osrBci != null;
        this.method = compile.method;
    }

    public final boolean isC1() {
        return this.compilerId == CompilerId.C1;
    }

    public final boolean isC2() {
        return this.compilerId == CompilerId.C2;
    }

    public final String toString() {
        return this.compileId + " " + (Object)((Object)this.compilerId) + " " + this.method;
    }
}

