/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.compile;

import com.azul.gulp.Gulp;
import com.azul.java.MethodId;
import com.azul.jvm.VmEventBase;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.compile.CompilationTier;
import com.azul.jvm.compile.CompilationTrigger;
import com.azul.jvm.compile.CompileData;
import com.azul.jvm.compile.CompileStarted;
import com.azul.jvm.compile.CompilerId;
import com.azul.jvm.compile.OptLevel;
import com.azul.jvm.compile.StashFlavor;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.jvm.logcompilation.WritingThread;
import com.azul.jvm.method.PersistentMethodId;
import java.util.Objects;

public abstract class CompileRelated
extends VmEventBase {
    @Gulp.Capture
    public WritingThread thread;
    public final CompilationId compileId;
    public final boolean isNative;
    public final boolean isOsr;
    public final boolean isSynchronized;
    public final boolean hasExceptionHandlers;
    public final boolean isReplacement;
    public final CompilationTier tier;
    public final CompilerId compilerId;
    public final MethodId method;
    public final String methodName;
    public final String signature;
    public final Long methodId;
    public final PersistentMethodId persistentMethodId;
    public final Integer klassId;
    public final PersistentKlassId persistentKlassId;
    public final Integer osrBci;
    public final Integer score;
    public final Integer generation;
    public final Integer bytes;
    public final CompilationTrigger waveTrigger;
    public final StashFlavor stashFlavor;
    public final OptLevel optLevel;
    public final Long scoreUpdated;
    public final Integer promoted;

    public CompileRelated(CompilationId compileId, boolean isNative, boolean isOsr, boolean isSynchronized, boolean hasExceptionHandlers, boolean isReplacement, CompilerId compilerId, CompilationTier tier, String method, String signature, Integer osrBci, Integer generation, Integer score, Integer bytes, CompilationTrigger waveTrigger, StashFlavor stashFlavor, OptLevel optLevel, Long methodId, PersistentMethodId persistentMethodId, Integer klassId, PersistentKlassId persistentKlassId, Long scoreUpdated, Integer promoted) {
        this.compileId = Objects.requireNonNull(compileId, "compileId");
        this.isNative = isNative;
        this.isOsr = isOsr;
        this.isSynchronized = isSynchronized;
        this.hasExceptionHandlers = hasExceptionHandlers;
        this.isReplacement = isReplacement;
        this.compilerId = compilerId;
        this.tier = tier;
        this.methodName = method;
        this.signature = signature;
        this.osrBci = osrBci;
        this.generation = generation;
        this.score = score;
        this.bytes = bytes;
        this.waveTrigger = waveTrigger;
        this.stashFlavor = stashFlavor;
        this.optLevel = optLevel;
        this.methodId = methodId;
        this.persistentMethodId = persistentMethodId;
        this.klassId = klassId;
        this.persistentKlassId = persistentKlassId;
        this.scoreUpdated = scoreUpdated;
        this.promoted = promoted;
        this.method = this.signature != null && this.bytes != null ? MethodId.byNameSigAndSize(this.methodName, this.signature, this.bytes) : (this.signature != null ? MethodId.byNameAndSig(this.methodName, this.signature) : (this.bytes != null ? MethodId.byNameAndSize(this.methodName, this.bytes) : MethodId.byNameOnly(this.methodName)));
    }

    public CompileRelated(CompileData compileData) {
        this.compileId = compileData.compileId;
        this.isNative = compileData.isNative;
        this.isOsr = compileData.isOsr;
        this.isSynchronized = compileData.isSynchronized;
        this.hasExceptionHandlers = compileData.hasExceptionHandlers;
        this.isReplacement = compileData.isReplacement;
        this.tier = compileData.tier;
        this.compilerId = compileData.compilerId;
        this.method = compileData.method;
        this.methodName = compileData.methodName;
        this.signature = compileData.signature;
        this.osrBci = compileData.osrBci;
        this.generation = compileData.generation;
        this.score = compileData.score;
        this.bytes = compileData.bytes;
        this.waveTrigger = compileData.waveTrigger;
        this.stashFlavor = compileData.stashFlavor;
        this.optLevel = compileData.optLevel;
        this.methodId = compileData.methodId;
        this.persistentMethodId = compileData.persistentMethodId;
        this.klassId = compileData.klassId;
        this.persistentKlassId = compileData.persistentKlassId;
        this.scoreUpdated = compileData.scoreUpdated;
        this.promoted = compileData.promoted;
    }

    public CompileRelated(CompileStarted compile) {
        this.compileId = compile.compileId;
        this.isNative = compile.isNative;
        this.isOsr = compile.isOsr;
        this.isSynchronized = compile.isSynchronized;
        this.hasExceptionHandlers = compile.hasExceptionHandlers;
        this.isReplacement = compile.isReplacement;
        this.tier = compile.tier;
        this.compilerId = compile.compilerId;
        this.method = compile.method;
        this.methodName = compile.methodName;
        this.signature = compile.signature;
        this.osrBci = compile.osrBci;
        this.generation = compile.generation;
        this.score = compile.score;
        this.bytes = compile.bytes;
        this.waveTrigger = compile.waveTrigger;
        this.stashFlavor = compile.stashFlavor;
        this.optLevel = compile.optLevel;
        this.methodId = compile.methodId;
        this.persistentMethodId = compile.persistentMethodId;
        this.klassId = compile.klassId;
        this.persistentKlassId = compile.persistentKlassId;
        this.scoreUpdated = compile.scoreUpdated;
        this.promoted = compile.promoted;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.methodName.length() + 30);
        builder.append(String.format("%5d", this.compileId.intValue()));
        builder.append(' ');
        builder.append(this.isNative ? (char)'n' : ' ');
        builder.append(this.isOsr ? (char)'%' : ' ');
        builder.append(this.isSynchronized ? (char)'s' : ' ');
        builder.append(this.hasExceptionHandlers ? (char)'!' : ' ');
        builder.append(this.isReplacement ? (char)'r' : ' ');
        builder.append(' ');
        builder.append((Object)this.tier);
        builder.append('/');
        builder.append((Object)this.compilerId);
        builder.append("   ");
        builder.append(this.method);
        if (this.osrBci != null) {
            builder.append(" @ ").append(this.osrBci);
        }
        return builder.toString();
    }
}

