/*
 * Decompiled with CFR 0.152.
 */
package com.azul.java;

import com.azul.java.NameUtils;
import java.util.Objects;

public final class MethodId
implements Comparable<MethodId> {
    public final String name;
    public final String sig;
    public final Integer size;
    public final String visibleId;
    private final int hashCode;

    public static MethodId byNameOnly(String name) {
        return new MethodId(name);
    }

    public static MethodId byNameOnly(String className, String shortName) {
        return MethodId.byNameOnly(className + "::" + shortName);
    }

    public static MethodId byNameAndSig(String name, String sig) {
        return new MethodId(name, sig);
    }

    public static MethodId byNameAndSig(String className, String shortName, String sig) {
        return MethodId.byNameAndSig(className + "::" + shortName, sig);
    }

    public static MethodId byNameAndSize(String name, int size) {
        return new MethodId(name, size);
    }

    public static MethodId byNameAndSize(String className, String shortName, int size) {
        return MethodId.byNameAndSize(className + "::" + shortName, size);
    }

    public static MethodId byNameSigAndSize(String name, String sig, int size) {
        return new MethodId(name, sig, size);
    }

    public static MethodId byNameSigAndSize(String className, String shortName, String sig, int size) {
        return MethodId.byNameSigAndSize(className + "::" + shortName, sig, size);
    }

    private MethodId(String name) {
        this.name = MethodId.normalizeName(name);
        this.sig = null;
        this.size = null;
        this.visibleId = name;
        this.hashCode = Objects.hash(this.name);
    }

    private MethodId(String name, String sig) {
        this.name = MethodId.normalizeName(name);
        this.sig = sig;
        this.size = null;
        this.visibleId = this.name + this.sig;
        this.hashCode = Objects.hash(this.name, this.sig);
    }

    private MethodId(String name, int size) {
        this.name = MethodId.normalizeName(name);
        this.sig = null;
        this.size = size;
        this.visibleId = this.name + " (" + this.size + " bytes)";
        this.hashCode = Objects.hash(this.name, this.size);
    }

    private MethodId(String name, String sig, int size) {
        this.name = MethodId.normalizeName(name);
        this.sig = sig;
        this.size = size;
        this.visibleId = this.name + this.sig + " (" + this.size + " bytes)";
        this.hashCode = Objects.hash(this.name, this.sig);
    }

    private static String normalizeName(String name) {
        if (name.contains("::")) {
            return MethodId.normalizeClassName(name);
        }
        throw new IllegalArgumentException("Invalid method name " + name);
    }

    private static String normalizeClassName(String className) {
        int dotPos = className.indexOf(46);
        if (dotPos != -1) {
            return className;
        }
        int slashPos = className.indexOf(47);
        if (slashPos == -1) {
            return className;
        }
        return className.replace('/', '.');
    }

    public final boolean inPackage(String pkg) {
        return NameUtils.packageOf(this.name).equals(pkg);
    }

    public final boolean inClass(String klass) {
        return this.className().equals(klass);
    }

    public final String packageName() {
        return NameUtils.packageOf(this.name);
    }

    public final String className() {
        return NameUtils.classOf(this.name);
    }

    public final String shortName() {
        return NameUtils.simpleNameOf(this.className()) + "::" + NameUtils.simpleNameOf(this.name);
    }

    public final String simpleName() {
        return NameUtils.simpleNameOf(this.name);
    }

    public final boolean sameClass(MethodId that) {
        return this.className().equals(that.className());
    }

    public final boolean isPrecise() {
        return this.sig != null || this.size != null;
    }

    public final MethodId nameOnly() {
        return MethodId.byNameOnly(this.name);
    }

    public final MethodId nameAndSize() {
        if (this.size == null) {
            throw new IllegalStateException();
        }
        return MethodId.byNameAndSize(this.name, this.size);
    }

    public final MethodId nameAndSig() {
        if (this.sig == null) {
            throw new IllegalStateException();
        }
        return MethodId.byNameAndSig(this.name, this.sig);
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean is(String name) {
        return this.matches(name);
    }

    public final boolean matches(String name) {
        return this.name.equals(MethodId.normalizeName(name));
    }

    public final boolean matches(String name, String signature) {
        return signature.equals(this.sig) && this.matches(name);
    }

    public final boolean matches(MethodId that) {
        if (!this.className().equals(that.className())) {
            return false;
        }
        if (!this.shortName().equals(that.shortName())) {
            return false;
        }
        if (this.sig != null && that.sig != null && !this.sig.equals(that.sig)) {
            return false;
        }
        return this.size == null || that.size == null || this.size == that.size;
    }

    public final boolean in(String[] names) {
        for (String name : names) {
            if (!this.matches(name)) continue;
            return true;
        }
        return false;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MethodId)) {
            return false;
        }
        MethodId that = (MethodId)obj;
        return this.hashCode == that.hashCode && this.visibleId.equals(that.visibleId);
    }

    @Override
    public final int compareTo(MethodId that) {
        int classCompare = this.className().compareTo(that.className());
        if (classCompare != 0) {
            return classCompare;
        }
        int nameCompare = this.name.compareTo(that.name);
        if (nameCompare != 0) {
            return nameCompare;
        }
        if (this.sig != null && that.sig != null) {
            return this.sig.compareTo(that.sig);
        }
        if (this.size != null && that.size != null) {
            return Integer.compare(this.size, that.size);
        }
        return Integer.compare(this.hashCode(), that.hashCode());
    }

    public final String toString() {
        return this.visibleId;
    }
}

