/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp.text.support;

import com.azul.gulp.text.Line;
import com.azul.gulp.text.RegexMatcher;
import com.azul.gulp.text.support.RegexLineMatcher;
import java.lang.reflect.Constructor;
import java.util.regex.Pattern;

public final class AnnotatedRegexLineMatcher<T>
extends RegexLineMatcher<T> {
    private final Class<T> dataClass;
    private Constructor<T> cachedCtor;

    public AnnotatedRegexLineMatcher(Class<T> dataClass, String regex) {
        this(dataClass, Pattern.compile(regex));
    }

    AnnotatedRegexLineMatcher(Class<T> dataClass, Pattern regex) {
        super(regex);
        this.dataClass = dataClass;
    }

    @Override
    public final T fromMatch(Line line, RegexMatcher matcher) throws Exception {
        Constructor<T> ctor = this.findConstructorFor(matcher);
        Class<?>[] paramTypes = ctor.getParameterTypes();
        Object[] params = new Object[paramTypes.length];
        try {
            int capturePos = 1;
            for (int i = 0; i < paramTypes.length; ++i) {
                params[i] = matcher.groupAs(capturePos++, paramTypes[i]);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Problem with pattern for " + this.dataClass.getSimpleName() + " @ line " + line.num, e);
        }
        try {
            return ctor.newInstance(params);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private Constructor<T> findConstructorFor(RegexMatcher matcher) {
        if (this.cachedCtor != null) {
            return this.cachedCtor;
        }
        int paramCount = matcher.groupCount();
        for (Constructor<?> ctor : this.dataClass.getDeclaredConstructors()) {
            if (AnnotatedRegexLineMatcher.getAdjustedParamCount(ctor) != paramCount) continue;
            Constructor<?> castedCtor = ctor;
            castedCtor.setAccessible(true);
            this.cachedCtor = castedCtor;
            return castedCtor;
        }
        throw new IllegalStateException("No matching constructor for regex");
    }

    private static int getAdjustedParamCount(Constructor<?> ctor) {
        int count = 0;
        for (Class<?> paramType : ctor.getParameterTypes()) {
            if (paramType.equals(Line.class)) continue;
            ++count;
        }
        return count;
    }
}

