/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp.standardplugins;

import com.azul.gulp.Gulp;
import com.azul.gulp.nexus.Nexus;
import com.azul.gulp.nexus.NexusHandler;
import com.azul.gulp.nexus.NexusNormalizer;
import com.azul.gulp.nexus.Plugin;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class EventCapturePlugin
extends Plugin {
    @Override
    public <V> void onEventRequest(Nexus nexus, Class<V> requiredType) throws Exception {
        EventFieldConnector connector;
        Class<?> fieldType;
        Gulp.Capture captureAnno;
        for (Field field : requiredType.getFields()) {
            captureAnno = field.getAnnotation(Gulp.Capture.class);
            if (captureAnno == null) continue;
            fieldType = field.getType();
            field.setAccessible(true);
            connector = new EventFieldConnector(field);
            nexus.handleOptional(fieldType, connector);
            nexus.normalize(requiredType, connector);
        }
        for (Field field : requiredType.getDeclaredFields()) {
            if (Modifier.isPublic(field.getModifiers()) || (captureAnno = field.getAnnotation(Gulp.Capture.class)) == null) continue;
            fieldType = field.getType();
            field.setAccessible(true);
            connector = new EventFieldConnector(field);
            nexus.handleOptional(fieldType, connector);
            nexus.normalize(requiredType, connector);
        }
    }

    @Override
    public <V> void onConnect(Nexus nexus, Object object) throws Exception {
        Class<?> fieldType;
        Gulp.Capture captureAnno;
        for (Field field : object.getClass().getFields()) {
            captureAnno = field.getAnnotation(Gulp.Capture.class);
            if (captureAnno == null) continue;
            fieldType = field.getType();
            field.setAccessible(true);
            nexus.handleOptional(fieldType, new InjectedObjectConnector(object, field));
        }
        for (Field field : object.getClass().getDeclaredFields()) {
            if (Modifier.isPublic(field.getModifiers()) || (captureAnno = field.getAnnotation(Gulp.Capture.class)) == null) continue;
            fieldType = field.getType();
            field.setAccessible(true);
            nexus.handleOptional(fieldType, new InjectedObjectConnector(object, field));
        }
    }

    private final class InjectedObjectConnector<T>
    implements NexusHandler<T> {
        private final Object target;
        private final Field field;

        public InjectedObjectConnector(Object target, Field field) {
            this.target = target;
            this.field = field;
        }

        @Override
        public final void handle(T value) throws Exception {
            this.field.set(this.target, value);
        }
    }

    private final class EventFieldConnector<R, T>
    implements NexusHandler<R>,
    NexusNormalizer<T> {
        private final Field field;
        private R last = null;

        public EventFieldConnector(Field field) {
            this.field = field;
        }

        @Override
        public final void handle(R value) throws Exception {
            if (value == null) {
                throw new IllegalArgumentException();
            }
            this.last = value;
        }

        @Override
        public final T normalize(T target) throws Exception {
            Object cur = this.field.get(target);
            if (cur != null && this.last == null) {
                return target;
            }
            this.field.set(target, this.last);
            return target;
        }
    }
}

