/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp.nexus;

import com.azul.gulp.nexus.Nexus;
import com.azul.gulp.nexus.Plugin;
import java.util.List;

public class CompositePlugin
extends Plugin {
    private final List<Plugin> plugins;

    public CompositePlugin(List<Plugin> plugins) {
        this.plugins = plugins;
    }

    @Override
    public <V> boolean handleEventRequest(Nexus engine, Class<V> requiredType) throws Exception {
        boolean handled = false;
        for (Plugin plugin : this.plugins) {
            handled |= plugin.handleEventRequest(engine, requiredType);
        }
        return handled;
    }

    @Override
    public <V> void onEventRequest(Nexus engine, Class<V> requiredType) throws Exception {
        for (Plugin plugin : this.plugins) {
            plugin.onEventRequest(engine, requiredType);
        }
    }

    @Override
    public <V> boolean connect(Nexus engine, Object object) throws Exception {
        boolean connected = false;
        for (Plugin plugin : this.plugins) {
            connected |= plugin.connect(engine, object);
        }
        return connected;
    }

    @Override
    public <V> void onConnect(Nexus engine, Object object) throws Exception {
        for (Plugin plugin : this.plugins) {
            plugin.onConnect(engine, object);
        }
    }
}

