/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp.kernel;

import com.azul.gulp.LogProcessingException;
import com.azul.gulp.kernel.ExceptionHandler;
import com.azul.gulp.kernel.TypeDispatcher;
import com.azul.gulp.nexus.FlexNexusHandler;
import com.azul.gulp.nexus.Nexus;
import com.azul.gulp.nexus.NexusEmitter;
import com.azul.gulp.nexus.NexusHandledMarker;
import com.azul.gulp.nexus.NexusHandler;
import com.azul.gulp.nexus.NexusNormalizer;
import com.azul.gulp.nexus.NexusUnhandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class Kernel {
    private final ExceptionHandler dispatchingExceptionHandler;
    private final Map<Class<?>, TypeDispatcher<?>> typeDispatchers = new HashMap();
    private List<FireEvent<?>> pending = null;

    public Kernel() {
        this.dispatchingExceptionHandler = new FiringExceptionHandler(this);
        TypeDispatcher<Throwable> exceptionDispatcher = new TypeDispatcher<Throwable>(WrappingExceptionHandler.INSTANCE);
        exceptionDispatcher.addHandler(RethrowHandler.INSTANCE);
        this.registerTypeDispatcher(Throwable.class, exceptionDispatcher);
    }

    public final <T> NexusEmitter<T> asTypeEmitter(final Class<T> eventType) {
        return new NexusEmitter<T>(){

            @Override
            public final void fire(T value) {
                Kernel.this.fire(eventType, value);
            }
        };
    }

    public final <T> NexusHandledMarker<T> asTypeMarker(final Class<T> eventType) {
        return new NexusHandledMarker<T>(){

            @Override
            public final boolean isActivated() {
                return Kernel.this.hasUnhandler(eventType);
            }

            @Override
            public final void mark(T value) {
                Kernel.this.markHandled(eventType, value);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void fire(Class<T> type, T data) throws LogProcessingException {
        Iterator<FireEvent<?>> iterator;
        if (this.pending != null) {
            this.pending.add(new FireEvent<T>(type, data));
            return;
        }
        this.pending = new ArrayList();
        try {
            this.getOrCreateTypeDispatcher(type).fire(this, data);
            List<FireEvent<?>> priorPending = this.pending;
            this.pending = null;
            iterator = priorPending.iterator();
        }
        catch (Throwable throwable) {
            List<FireEvent<?>> priorPending = this.pending;
            this.pending = null;
            Iterator<FireEvent<?>> iterator2 = priorPending.iterator();
            while (iterator2.hasNext()) {
                FireEvent<?> fireEvent;
                FireEvent<?> erasedEvent = fireEvent = iterator2.next();
                this.fire(erasedEvent.type, erasedEvent.data);
            }
            throw throwable;
        }
        while (iterator.hasNext()) {
            FireEvent<?> fireEvent;
            FireEvent<?> erasedEvent = fireEvent = iterator.next();
            this.fire(erasedEvent.type, erasedEvent.data);
        }
    }

    private <T> boolean hasUnhandler(Class<T> type) {
        TypeDispatcher<T> dispatcher = this.getTypeDispatcher(type);
        return dispatcher != null && dispatcher.hasUnhandler();
    }

    private <T> void markHandled(Class<T> type, T data) {
        TypeDispatcher<T> dispatcher = this.getTypeDispatcher(type);
        if (dispatcher != null) {
            dispatcher.markHandled(data);
        }
    }

    public final <T> void normalize(Class<T> type, NexusNormalizer<T> normalizer) {
        this.getOrCreateTypeDispatcher(type).addNormalizer(normalizer);
    }

    public final <T> void handle(Class<T> type, NexusHandler<? super T> handler) {
        this.getOrCreateTypeDispatcher(type).addHandler(handler);
    }

    public final <T> void remove(Class<T> type, NexusHandler<? super T> handler) {
        this.getTypeDispatcher(type).removeHandler(handler);
    }

    public final <T> void handle(FlexNexusHandler handler) {
        this.handle(handler.type(), handler);
    }

    public final <T> void remove(FlexNexusHandler handler) {
        this.remove(handler.type(), handler);
    }

    public final <T> void unhandle(Class<T> type, NexusUnhandler<? super T> unhandler) {
        this.getOrCreateTypeDispatcher(type).addUnhandler(unhandler);
    }

    public final <T> void remove(Class<T> type, NexusUnhandler<? super T> unhandler) {
        this.getTypeDispatcher(type).removeUnhandler(unhandler);
    }

    public final void init(Nexus ctx) {
        for (TypeDispatcher<?> dispatcher : this.typeDispatchers.values()) {
            dispatcher.init(ctx);
        }
    }

    public final void finish() {
        for (TypeDispatcher<?> dispatcher : this.typeDispatchers.values()) {
            dispatcher.finish();
        }
    }

    private <T> TypeDispatcher<T> getTypeDispatcher(Class<T> type) {
        TypeDispatcher<?> existingDispatcher = this.typeDispatchers.get(type);
        return existingDispatcher;
    }

    private <T> TypeDispatcher<T> getOrCreateTypeDispatcher(Class<T> type) {
        TypeDispatcher<T> existingDispatcher = this.getTypeDispatcher(type);
        if (existingDispatcher != null) {
            return existingDispatcher;
        }
        TypeDispatcher newDispatcher = new TypeDispatcher(this.dispatchingExceptionHandler);
        this.linkExistingParents(type, newDispatcher);
        this.linkExistingChildren(type, newDispatcher);
        this.typeDispatchers.put(type, newDispatcher);
        return newDispatcher;
    }

    private <T> void registerTypeDispatcher(Class<T> type, TypeDispatcher<T> newDispatcher) {
        this.typeDispatchers.put(type, newDispatcher);
    }

    private <T> void linkExistingParents(Class<T> type, TypeDispatcher<T> newDispatcher) {
        ArrayList superDispatchers = new ArrayList();
        for (Map.Entry<Class<?>, TypeDispatcher<?>> entry : this.typeDispatchers.entrySet()) {
            Class<T> curType = entry.getKey();
            if (!curType.isAssignableFrom(type)) continue;
            TypeDispatcher<?> curSuperDispatcher = entry.getValue();
            superDispatchers.add(curSuperDispatcher);
        }
        if (!superDispatchers.isEmpty()) {
            newDispatcher.addHandler(new SuperHandler(this, superDispatchers));
        }
    }

    private <T> void linkExistingChildren(Class<T> type, TypeDispatcher<T> dispatcher) {
        ExtendsHandler<T> handler = null;
        for (Map.Entry<Class<?>, TypeDispatcher<?>> entry : this.typeDispatchers.entrySet()) {
            Class<?> curType = entry.getKey();
            if (!type.isAssignableFrom(curType)) continue;
            TypeDispatcher<?> childDispatcher = entry.getValue();
            if (handler == null) {
                handler = new ExtendsHandler<T>(this, dispatcher);
            }
            childDispatcher.addHandler(handler);
        }
    }

    private static final class ExtendsHandler<T>
    extends CoreHandler<T> {
        private final Kernel engine;
        private final TypeDispatcher<T> dispatcher;

        ExtendsHandler(Kernel engine, TypeDispatcher<T> dispatcher) {
            this.engine = engine;
            this.dispatcher = dispatcher;
        }

        @Override
        public void handle(T value) throws Exception {
            this.dispatcher.fire(this.engine, value);
        }
    }

    private static final class FiringExceptionHandler
    extends ExceptionHandler {
        private final NexusEmitter<Throwable> emitter;

        public FiringExceptionHandler(Kernel engine) {
            this.emitter = engine.asTypeEmitter(Throwable.class);
        }

        @Override
        public final void handle(Throwable cause) throws LogProcessingException {
            this.emitter.fire(cause);
        }
    }

    private static final class WrappingExceptionHandler
    extends ExceptionHandler {
        private static final WrappingExceptionHandler INSTANCE = new WrappingExceptionHandler();

        private WrappingExceptionHandler() {
        }

        @Override
        public final void handle(Throwable cause) throws LogProcessingException {
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof LogProcessingException) {
                throw (LogProcessingException)cause;
            }
            throw new LogProcessingException(cause);
        }
    }

    private static final class RethrowHandler
    extends CoreHandler<Throwable> {
        private static final RethrowHandler INSTANCE = new RethrowHandler();

        private RethrowHandler() {
        }

        @Override
        public final void handle(Throwable value) throws Exception {
            if (value instanceof Error) {
                throw (Error)value;
            }
            if (value instanceof Exception) {
                throw (Exception)value;
            }
            throw new IllegalStateException();
        }
    }

    private static abstract class CoreHandler<T>
    implements NexusHandler<T> {
        private CoreHandler() {
        }

        @Override
        public void init(Nexus engine) throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    private static final class SuperHandler<T>
    implements NexusHandler<T> {
        private final Kernel engine;
        private final List<TypeDispatcher<? super T>> superDispatchers;

        SuperHandler(Kernel engine, List<TypeDispatcher<? super T>> superDispatchers) {
            this.engine = engine;
            this.superDispatchers = superDispatchers;
        }

        @Override
        public void handle(T value) throws Exception {
            for (TypeDispatcher<T> superDispatcher : this.superDispatchers) {
                superDispatcher.fire(this.engine, value);
            }
        }
    }

    static final class FireEvent<T> {
        final Class<T> type;
        final T data;

        public FireEvent(Class<T> type, T event) {
            this.type = type;
            this.data = event;
        }

        public final String toString() {
            return this.type + " " + this.data;
        }
    }
}

