/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp;

import com.azul.gulp.ResultProvider;
import com.azul.gulp.ThrowingFunction;

public final class Result<T> {
    private final Object label;
    private final Object processor;

    public Result(Object label, Object result) {
        this.label = label;
        this.processor = result;
    }

    public Result(Object processor) {
        this.label = null;
        this.processor = processor;
    }

    public <T2 extends T> T2 get() {
        Object casted = this.getImpl();
        return (T2)casted;
    }

    private Object getImpl() {
        if (this.processor instanceof ResultProvider) {
            ResultProvider resultProvider = (ResultProvider)this.processor;
            return resultProvider.result();
        }
        return this.processor;
    }

    private Number numValue() {
        return (Number)this.getImpl();
    }

    public final int intValue() {
        return this.numValue().intValue();
    }

    public final long longValue() {
        return this.numValue().longValue();
    }

    public final double doubleValue() {
        return this.numValue().doubleValue();
    }

    public <U> Result<U> map(ThrowingFunction<? super T, ? extends U> mapFn) {
        try {
            return new Result<T>(mapFn.apply(this.get()));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public final void print() {
        System.out.println(this);
    }

    public final void print(String heading) {
        System.out.println(heading);
        this.print();
    }

    public final String toString() {
        if (this.label != null) {
            return this.label + ":\t" + this.get().toString();
        }
        return this.get().toString();
    }
}

