/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp;

import java.util.Objects;

public class Range<C>
implements Comparable<Range<C>> {
    public final C start;
    public final C end;

    public static <C> Range<C> make(C start, C end) {
        return new Range<C>(start, end);
    }

    public static <C> Range<C> merge(Range<C> r1, Range<C> r2) {
        return Range.make(Range.min(r1.start, r2.start), Range.max(r1.end, r2.end));
    }

    public Range(C start, C end) {
        this.start = start;
        this.end = end;
    }

    public final boolean contains(C value) {
        return Range.compare(this.start, value) <= 0 && Range.compare(this.end, value) >= 0;
    }

    private static <C> int compare(C lhs, C rhs) {
        if (!(lhs instanceof Comparable)) {
            throw new UnsupportedOperationException();
        }
        if (!(rhs instanceof Comparable)) {
            throw new UnsupportedOperationException();
        }
        Comparable lhsComp = (Comparable)lhs;
        return lhsComp.compareTo(rhs);
    }

    private static <C> C min(C lhs, C rhs) {
        return Range.compare(lhs, rhs) <= 0 ? lhs : rhs;
    }

    private static <C> C max(C lhs, C rhs) {
        return Range.compare(lhs, rhs) >= 0 ? lhs : rhs;
    }

    public final int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof Range)) {
            return false;
        }
        Range that = (Range)obj;
        return this.start.equals(that.start) && this.end.equals(that.end);
    }

    @Override
    public int compareTo(Range<C> that) {
        int startComp = Range.compare(this.start, that.start);
        if (startComp != 0) {
            return startComp;
        }
        int endComp = Range.compare(this.end, that.end);
        return endComp;
    }

    public final String toString() {
        return "[" + this.start + ", " + this.end + "]";
    }
}

