/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp;

import com.azul.gulp.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public interface Groups<K, E>
extends Iterable<Group<K, E>> {
    public Group<K, E> get(K var1);

    default public Groups<K, E> sorted() {
        final Groups wrappedGroup = this;
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Group curGroup : this) {
            groups.add(curGroup);
        }
        Comparator keyComparator = (lhs, rhs) -> {
            Object lhsKey = lhs.key();
            Object rhsKey = rhs.key();
            if (lhsKey instanceof Comparable) {
                Comparable lhsComp = (Comparable)lhsKey;
                return lhsComp.compareTo(rhsKey);
            }
            return -1;
        };
        Collections.sort(groups, keyComparator);
        final List sortedGroups = Collections.unmodifiableList(groups);
        return new Groups<K, E>(){

            @Override
            public Iterator<Group<K, E>> iterator() {
                return sortedGroups.iterator();
            }

            @Override
            public Group<K, E> get(K key) {
                return wrappedGroup.get(key);
            }

            @Override
            public Groups<K, E> sorted() {
                return this;
            }
        };
    }
}

