/*
 * Decompiled with CFR 0.152.
 */
package com.azul.threadopt;

import com.azul.threadopt.CommandLineOptions;
import com.azul.threadopt.TimeMXBeanImpl;
import com.azul.threadopt.TimeUtils;
import com.azul.threadopt.mxbeans.TimeMXBean;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.management.MBeanServer;

public class Utils {
    private static final boolean verboseOnDefaultValue = false;
    private static final boolean verboseDefaultValue = false;
    private static final boolean verboseCommandDefaultValue = false;
    private static final boolean verbosePropertiesDefaultValue = false;
    private static final boolean verboseDisplayThreadsDefaultValue = false;
    private static final boolean verboseOptionsCheckDefaultValue = false;
    private static final boolean debugDefaultValue = false;
    private static final boolean printDetailedInfoDefaultValue = false;
    private static final boolean captureCommandOutputDefaultValue = false;
    private static boolean verboseOn = false;
    private static boolean verbose = false;
    private static boolean verboseCommand = false;
    private static boolean verboseProperties = false;
    private static boolean verboseDisplayThreads = false;
    private static boolean verboseOptionsCheck = false;
    private static boolean debug = false;
    private static boolean printDetailedInfo = false;
    private static boolean captureCommandOutput = false;
    private static boolean vendorCheck = true;
    private static String thisProcessPID = "";
    private static TimeMXBean timeMXBean = TimeMXBeanImpl.getInstance();
    private static final String defaultDateTimeFormatString = "EEE MMM dd HH:mm:ss.SSS zzz yyyy";
    private static final String tmpSuffix = ".tmp";
    private static final String slash = "/";
    private static final String slashTmpSlash = "/tmp/";
    private static int iter = 0;
    private static BufferedWriter bufferedWriter = null;
    private static final int byteArrayOutputStreamSize = 10000;
    private static final int processExitValueNotSet = 1018101;

    private static String getLogLinePrefix() {
        if (timeMXBean != null) {
            return timeMXBean.getElapsedTimeSinceJVMStartSecStr() + " [ThreadOpt] ";
        }
        return "[ThreadOpt] ";
    }

    public static String getDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(defaultDateTimeFormatString);
        Date date = new Date(System.currentTimeMillis());
        return simpleDateFormat.format(date);
    }

    public static void displayProcessThreads() {
        if (verboseDisplayThreads) {
            System.out.println(Utils.getLogLinePrefix() + " Display Java process threads: Start");
            ArrayList<String> arrayList = new ArrayList<String>();
            Utils.runACommand("kill -3 " + thisProcessPID, arrayList);
            System.out.println(Utils.getLogLinePrefix() + " Display Java process threads: End (will display when signal processed)");
        }
    }

    public static String getProcessPID() {
        Object object;
        if (thisProcessPID != null && !thisProcessPID.equals("")) {
            return thisProcessPID;
        }
        MBeanServer mBeanServer = null;
        Map<String, String> map = null;
        try {
            mBeanServer = ManagementFactory.getPlatformMBeanServer();
            object = ManagementFactory.newPlatformMXBeanProxy(mBeanServer, "java.lang:type=Runtime", RuntimeMXBean.class);
            map = object.getSystemProperties();
        }
        catch (Exception exception) {
            return "";
        }
        for (String string : map.keySet()) {
            if (verboseProperties) {
                System.out.println(Utils.getLogLinePrefix() + string.toString() + " = " + map.get(string));
            }
            if (string.toString().matches("sun.java.launcher.pid")) {
                thisProcessPID = map.get(string).substring(map.get(string).lastIndexOf("=") + 1);
                if (verboseProperties) {
                    System.out.println(Utils.getLogLinePrefix() + "Java process pid is " + thisProcessPID);
                }
            }
            if (!vendorCheck || !string.toString().matches("java.vm.vendor") || map.get(string).matches(".*Azul Systems.*")) continue;
            if (verboseProperties) {
                System.out.println(Utils.getLogLinePrefix() + "Completed.");
            }
            return "";
        }
        if (thisProcessPID.isEmpty()) {
            object = ManagementFactory.getRuntimeMXBean().getName();
            thisProcessPID = ((String)object).split("@")[0];
        }
        if (verboseProperties) {
            System.out.println(Utils.getLogLinePrefix() + "This is process: " + thisProcessPID);
        }
        return thisProcessPID;
    }

    public static String stackTraceString() {
        String string = Thread.currentThread().getStackTrace().toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(System.currentTimeMillis() + "\n");
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            stringBuilder.append(stackTraceElement.toString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    static void printStackTraceToFile() {
        try {
            String string = Utils.stackTraceString();
            if (bufferedWriter == null) {
                Utils.openLocalLoggingFile();
            }
            bufferedWriter.write(string);
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            System.err.println(Utils.getLogLinePrefix() + "Utils.printStackTrace: ERROR while trying to print stack trace.");
        }
    }

    private static BufferedWriter openLocalLoggingFile() {
        if (bufferedWriter != null) {
            return bufferedWriter;
        }
        bufferedWriter = null;
        try {
            String string = "threadOpt_local_log_" + timeMXBean.convertElapsedTimeSinceJVMStartSecToYearMonthDayPlusTimeString(TimeUtils.getUptimeMillis()) + "_pid_" + Utils.getProcessPID() + "_" + ++iter + ".log";
            File file = new File(string);
            if (!file.exists()) {
                // empty if block
            }
            FileWriter fileWriter = new FileWriter(file.getAbsoluteFile());
            bufferedWriter = new BufferedWriter(fileWriter);
        }
        catch (IOException iOException) {
            System.err.println(Utils.getLogLinePrefix() + "Utils.openLocalLoggingFile: ERROR");
            return null;
        }
        return bufferedWriter;
    }

    public static String createUniqueTempPathSlashFileName() {
        String string = "zing_threadopt_" + UUID.randomUUID() + "_";
        String string2 = System.getProperty("java.io.tmpdir");
        if (string2 == null || string2.equals("")) {
            string2 = slashTmpSlash;
        }
        File file = null;
        String string3 = null;
        try {
            file = File.createTempFile(string, tmpSuffix, new File(string2));
            string3 = file != null ? string2 + slash + file.getName() : slashTmpSlash + string + tmpSuffix;
        }
        catch (IOException iOException) {
            try {
                file = File.createTempFile(string, tmpSuffix, new File(slashTmpSlash));
                string3 = file != null ? slashTmpSlash + file.getName() : slashTmpSlash + string + tmpSuffix;
            }
            catch (IOException iOException2) {
                string3 = slashTmpSlash + string + tmpSuffix;
            }
        }
        Utils.deleteFile(string3);
        return string3;
    }

    public static String createSlashTmpSlashFileName(String string, double d) {
        String string2 = "zing_threadopt_" + string + "_" + timeMXBean.convertElapsedTimeSinceJVMStartSecToYearMonthDayPlusTimeString(d) + "_pid_" + Utils.getProcessPID() + ".log";
        String string3 = System.getProperty("java.io.tmpdir");
        if (string3 == null || string3.equals("")) {
            string3 = slashTmpSlash;
        }
        string2 = string3.substring(string3.length() - 1).equals(slash) ? string3 + string2 : string3 + slash + string2;
        return string2;
    }

    public static void deleteFile(String string) {
        try {
            boolean bl;
            File file = new File(string);
            if (file != null && !(bl = file.delete())) {
                System.err.println(Utils.getLogLinePrefix() + "ERROR: Unable to delete temporary file: " + string);
            }
        }
        catch (Exception exception) {
            System.err.println(Utils.getLogLinePrefix() + "ERROR: Unable to delete temporary file: " + string);
        }
    }

    public static int runACommand(String string, List<String> list) {
        int n = 1018101;
        try {
            String string2;
            Object object;
            if (verboseCommand) {
                System.out.println(Utils.getLogLinePrefix() + "runACommand CMD: >" + string + "<");
            }
            list.clear();
            Process process = null;
            System.out.flush();
            PrintStream printStream = System.out;
            System.err.flush();
            PrintStream printStream2 = System.err;
            ByteArrayOutputStream byteArrayOutputStream = null;
            if (captureCommandOutput) {
                byteArrayOutputStream = new ByteArrayOutputStream(10000);
                object = new PrintStream(byteArrayOutputStream);
                System.setOut((PrintStream)object);
                System.setErr((PrintStream)object);
            }
            process = Runtime.getRuntime().exec(string);
            if (captureCommandOutput) {
                System.out.flush();
                System.err.flush();
                System.setOut(printStream);
                System.setErr(printStream2);
                object = byteArrayOutputStream.toByteArray();
                System.out.println(Utils.getLogLinePrefix() + "runACommand Runtime exec parent process stdout/stderr output SIZE: " + ((Object)object).length);
                for (int i = 0; i < ((Object)object).length; ++i) {
                    if (i % 120 == 0) {
                        System.out.println(Utils.getLogLinePrefix() + "runACommand Runtime exec parent process stdout/stderr line: " + i + " | " + (char)object[i]);
                        continue;
                    }
                    System.out.print((char)object[i]);
                }
                System.out.flush();
            }
            object = null;
            InputStream inputStream = null;
            object = process.getInputStream();
            inputStream = process.getErrorStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
            while ((string2 = bufferedReader.readLine()) != null) {
                list.add(string2);
                if (!verboseCommand) continue;
                System.out.println(Utils.getLogLinePrefix() + "runACommand stdoutFromSubProcess: " + string2);
            }
            bufferedReader.close();
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(inputStream));
            while ((string2 = bufferedReader2.readLine()) != null) {
                list.add(string2);
                if (!verboseCommand) continue;
                System.out.println(Utils.getLogLinePrefix() + "runACommand stderrFromSubProcess: " + string2);
            }
            bufferedReader2.close();
            process.getOutputStream().close();
            process.getErrorStream().close();
            process.getInputStream().close();
            process.waitFor();
            n = process.exitValue();
            if (verboseCommand) {
                System.out.println(Utils.getLogLinePrefix() + "runACommand process exit value: " + n);
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println(Utils.getLogLinePrefix() + "runACommand Child process terminated");
            interruptedException.printStackTrace();
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(Utils.getLogLinePrefix() + "runACommand Child process terminated");
            numberFormatException.printStackTrace();
            return n;
        }
        catch (Exception exception) {
            System.err.println(Utils.getLogLinePrefix() + "runACommand Child process terminated");
            exception.printStackTrace();
            return n;
        }
        return n;
    }

    public static void printDetailedThreadStatusInfo() {
        if (printDetailedInfo) {
            int n;
            System.out.println(Utils.getLogLinePrefix() + "Threads Detail Output");
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            ThreadInfo[] threadInfoArray = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), 100);
            System.out.println(Utils.getLogLinePrefix() + "THREAD STATE");
            System.out.println(Utils.getLogLinePrefix() + "ThreadId ThreadName LockName BlockedCount WaitedCount");
            for (ThreadInfo threadInfo : threadInfoArray) {
                System.out.println(Utils.getLogLinePrefix() + threadInfo.getThreadId() + ", " + threadInfo.getThreadName() + ", " + threadInfo.getLockName() + ", " + threadInfo.getBlockedCount() + ", " + threadInfo.getWaitedCount());
            }
            System.out.println(Utils.getLogLinePrefix() + "RESOURCE USAGE");
            System.out.println(Utils.getLogLinePrefix() + "ThreadId ThreadCPUTime ThreadUserTime");
            ThreadInfo[] threadInfoArray2 = threadInfoArray;
            int n2 = threadInfoArray2.length;
            for (n = 0; n < n2; ++n) {
                ThreadInfo threadInfo;
                threadInfo = threadInfoArray2[n];
                System.out.println(Utils.getLogLinePrefix() + threadInfo.getThreadId() + ", " + threadMXBean.getThreadCpuTime(threadInfo.getThreadId()) + ", " + threadMXBean.getThreadUserTime(threadInfo.getThreadId()));
            }
            if (debug) {
                int n3;
                ThreadInfo[] threadInfoArray3 = threadInfoArray2 = threadMXBean.dumpAllThreads(true, true);
                n = threadInfoArray3.length;
                for (n3 = 0; n3 < n; ++n3) {
                    ThreadInfo threadInfo = threadInfoArray3[n3];
                    System.out.println(Utils.getLogLinePrefix() + "ID: " + threadInfo.getThreadId() + " Name: " + threadInfo.getThreadName() + " State: " + (Object)((Object)threadInfo.getThreadState()));
                    StackTraceElement[] stackTraceElementArray = threadInfo.getStackTrace();
                    for (int i = 0; i < stackTraceElementArray.length; ++i) {
                        System.out.println(Utils.getLogLinePrefix() + stackTraceElementArray[i].toString() + " Class: " + stackTraceElementArray[i].getClassName() + " Method: " + stackTraceElementArray[i].getMethodName() + " Filename: " + stackTraceElementArray[i].getFileName() + " Line: " + stackTraceElementArray[i].getLineNumber());
                    }
                }
                System.out.println(Utils.getLogLinePrefix() + "METHODS");
                int n4 = Thread.activeCount();
                Thread[] threadArray = new Thread[n4];
                Thread.enumerate(threadArray);
                System.out.println(Utils.getLogLinePrefix() + "Thread Name Method Class Filename Line ");
                for (n3 = 0; n3 < threadArray.length; ++n3) {
                    System.out.print(Utils.getLogLinePrefix() + ", " + n3 + ", " + threadArray[n3]);
                    for (int i = 0; i <= 10; ++i) {
                        try {
                            System.out.print(", " + threadArray[n3].getStackTrace()[i].getMethodName());
                            System.out.print(", " + threadArray[n3].getStackTrace()[i].getClassName());
                            System.out.print(", " + threadArray[n3].getStackTrace()[i].getFileName());
                            System.out.print(", " + threadArray[n3].getStackTrace()[i].getLineNumber());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        System.out.println("");
                    }
                }
            }
        }
    }

    public static boolean userHasIndicatedThreadOptShouldExit() {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        Utils.runACommand("ls /tmp/threadopt.disable", arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            if (verbose) {
                System.out.println(Utils.getLogLinePrefix() + "Check for existence of the file that tells ThreadOpt to terminate: " + (String)arrayList.get(i));
            }
            if (((String)arrayList.get(i)).indexOf("No such file or directory") == -1) continue;
            bl = true;
            break;
        }
        if (!bl && verbose) {
            System.out.println(Utils.getLogLinePrefix() + "ThreadOpt terminated because file /tmp/threadopt.disable found");
        }
        return !bl;
    }

    public static void processOptions(String string) {
        String[] stringArray = null;
        if (string != null && string.length() > 0) {
            stringArray = string.split("\\s+|%");
        }
        Utils.processOptions(stringArray);
    }

    public static void processOptions(String[] stringArray) {
        boolean bl = true;
        CommandLineOptions commandLineOptions = CommandLineOptions.getInstance();
        if (!commandLineOptions.isCommandLineOptionsInitialized()) {
            commandLineOptions.initializeCommandLineOptions(stringArray);
        }
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i].toLowerCase();
                if (string.matches("^voc")) {
                    verboseOptionsCheck = true;
                    commandLineOptions.processedOption(string);
                } else if (string.matches("^vdt")) {
                    verboseDisplayThreads = true;
                    commandLineOptions.processedOption(string);
                } else if (string.matches("^vprop")) {
                    verboseProperties = true;
                    commandLineOptions.processedOption(string);
                } else if (string.matches("^vc")) {
                    verboseCommand = true;
                    commandLineOptions.processedOption(string);
                } else if (string.matches("^verbose=.*")) {
                    String string2 = string.substring(8);
                    verboseOn = commandLineOptions.checkBooleanValue(string, string2);
                } else if (string.matches("^v")) {
                    verbose = true;
                    commandLineOptions.processedOption(string);
                } else if (string.matches("^cco")) {
                    captureCommandOutput = true;
                    commandLineOptions.processedOption(string);
                } else if (string.matches("^details")) {
                    printDetailedInfo = true;
                    commandLineOptions.processedOption(string);
                } else if (string.matches("^debug")) {
                    debug = true;
                    commandLineOptions.processedOption(string);
                }
                if (!verboseOn && !verbose) continue;
                if (bl) {
                    bl = false;
                    System.out.println(Utils.getLogLinePrefix() + "Process Utils options");
                }
                System.out.println(Utils.getLogLinePrefix() + "Option to ThreadOpt (UT): " + i + " = " + stringArray[i]);
            }
        }
        if (verboseOn || verbose) {
            String string = Utils.getLogLinePrefix() + "Options and internal variables settings: ";
            System.out.println(string + "Verbose [" + false + "] (v): " + verbose);
            if (verboseOptionsCheck) {
                System.out.println(string + "Print detailed info [" + false + "] (details): " + printDetailedInfo);
                System.out.println(string + "Debug info printing [" + false + "] (debug): " + debug);
            }
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("[ThreadOpt Utils] " + System.currentTimeMillis() + " Entry");
        System.out.println("[ThreadOpt Utils] " + System.currentTimeMillis() + " In main() with arguments: >" + stringArray + "<");
        Utils.processOptions(stringArray);
        System.out.println("[ThreadOpt Utils] " + System.currentTimeMillis() + " Process's PID: " + Utils.getProcessPID());
        String string = Utils.createUniqueTempPathSlashFileName();
        System.out.println("[ThreadOpt Utils] " + System.currentTimeMillis() + " createUniqueTempPathSlashFileName: " + string);
        ArrayList<String> arrayList = new ArrayList<String>();
        Utils.runACommand("find /sys/devices/system/cpu -iname thread_siblings -print -fprint " + string, arrayList);
        arrayList = new ArrayList();
        Utils.runACommand("xargs -r -n1000 -a " + string + " tail -v ", arrayList);
        Utils.deleteFile(string);
        for (int i = 0; i < arrayList.size(); ++i) {
            System.out.println("[ThreadOpt Utils] " + System.currentTimeMillis() + arrayList.get(i));
        }
        System.out.println("[ThreadOpt Utils] " + System.currentTimeMillis() + " Exit");
    }
}

