/*
 * Decompiled with CFR 0.152.
 */
package com.azul.threadopt;

import com.azul.threadopt.CommandLineOptions;
import com.azul.threadopt.MachineArchitecture;
import com.azul.threadopt.ProcessThreadsCPUUse;
import com.azul.threadopt.TimeMXBeanImpl;
import com.azul.threadopt.Utils;
import com.azul.threadopt.mxbeans.TimeMXBean;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ProcessThreads {
    private final boolean verboseOnDefaultValue = false;
    private final boolean verboseDefaultValue = false;
    private final boolean verbosePSProcessingDefaultValue = false;
    private final boolean verboseDisplayThreadsDefaultValue = false;
    private final boolean verboseThreadNameDefaultValue = false;
    private final boolean verboseOptionsCheckDefaultValue = false;
    private final int lowToHighCPUUseThresholdSecsDefaultValue = 20;
    private boolean verboseOn = false;
    private boolean verbose = false;
    private boolean verbosePSProcessing = false;
    private boolean verboseDisplayThreads = false;
    private boolean verboseThreadName = false;
    private boolean verboseOptionsCheck = false;
    private int lowToHighCPUUseThresholdSecs = 20;
    private boolean printDelayStartMessageDefaultValue;
    private boolean printDelayStartMessage = this.printDelayStartMessageDefaultValue = true;
    private boolean vendorCheck = true;
    private long startTimeMS = 0L;
    private TimeMXBean timeMXBean = TimeMXBeanImpl.getInstance();

    private String getLogLinePrefix() {
        if (this.timeMXBean != null) {
            return this.timeMXBean.getElapsedTimeSinceJVMStartSecStr() + " [ThreadOpt] ";
        }
        return "[ThreadOpt] ";
    }

    public void setLowToHighCPUUseThresholdSecs(int n) {
        if (n < 0) {
            System.err.println(this.getLogLinePrefix() + "ProcessThreads.lowToHighCPUUseThresholdSecs(int): Value of input parameter is not valid: " + n + " value will remain unchanged: " + this.lowToHighCPUUseThresholdSecs);
        } else {
            this.lowToHighCPUUseThresholdSecs = n;
        }
    }

    public int getLowToHighCPUUseThresholdSecs() {
        return this.lowToHighCPUUseThresholdSecs;
    }

    public void constructListsOfHighAndLowCPUConsumingAppThreadsBasedOnThreshold(List<Integer> list, List<Integer> list2) {
        if (this.verbose) {
            System.out.println(this.getLogLinePrefix() + "Start collection of application thread's elapsed CPU consumption");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Utils.runACommand("ps -p " + Utils.getProcessPID() + " -LP", arrayList);
        for (int i = 1; i < arrayList.size(); ++i) {
            int n;
            String string = ((String)arrayList.get(i)).toString();
            String[] stringArray = string.split("\\s+");
            if (this.verbosePSProcessing) {
                for (n = 0; n < stringArray.length; ++n) {
                    System.out.println(this.getLogLinePrefix() + "ps Output " + n + " = " + stringArray[n]);
                }
            }
            if (stringArray[n = 4].matches(".*:.*")) {
                if (this.verbosePSProcessing) {
                    System.out.println(this.getLogLinePrefix() + "ps Time field at 4: " + stringArray[n]);
                }
            } else {
                n = 5;
                if (stringArray[n].matches(".*:.*")) {
                    if (this.verbosePSProcessing) {
                        System.out.println(this.getLogLinePrefix() + "ps Time field at 5: " + stringArray[n]);
                    }
                } else {
                    System.err.println(this.getLogLinePrefix() + " ERROR: Found corrupted ps output: " + string);
                    continue;
                }
            }
            int n2 = 0;
            try {
                n2 = Integer.parseInt(stringArray[n].substring(0, 2)) * 60 * 60 + Integer.parseInt(stringArray[n].substring(3, 5)) * 60 + Integer.parseInt(stringArray[n].substring(6, 8));
            }
            catch (Exception exception) {
                System.err.println(this.getLogLinePrefix() + "ERROR: Non-numeric value found for CPU time: >" + n + "<");
            }
            int n3 = 2;
            if (n == 4) {
                n3 = 1;
            }
            if (this.lowToHighCPUUseThresholdSecs != 0 && n2 >= this.lowToHighCPUUseThresholdSecs) {
                if (this.verbose) {
                    System.out.println(this.getLogLinePrefix() + "Above or equal " + this.lowToHighCPUUseThresholdSecs + " seconds threshold: Add app thread to HIGH CPU consumers set: " + stringArray[n3] + " CPU Time: " + n2);
                }
                try {
                    list2.add(Integer.parseInt(stringArray[n3]));
                }
                catch (Exception exception) {
                    System.err.println(this.getLogLinePrefix() + "ERROR: Non-numeric value found for high CPU time consuming application thread candidate: >" + stringArray[n3] + "<");
                }
                continue;
            }
            if (this.verbose) {
                System.out.println(this.getLogLinePrefix() + "Below (or equal to zero) " + this.lowToHighCPUUseThresholdSecs + " seconds threshold: Add app thread to low CPU consumers set: " + stringArray[n3] + " CPU Time: " + n2);
            }
            try {
                list.add(Integer.parseInt(stringArray[n3]));
                continue;
            }
            catch (Exception exception) {
                System.err.println(this.getLogLinePrefix() + "ERROR: Non-numeric value found for low CPU time consuming application thread candidate: >" + stringArray[n3] + "<");
            }
        }
    }

    public ProcessThreadsCPUUse collectThreadCPUUseInfo() {
        long l = 0L;
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        if (this.verbose) {
            System.out.println(this.getLogLinePrefix() + "Start collection of map for application thread's elapsed CPU consumption");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Utils.runACommand("ps -p " + Utils.getProcessPID() + " -LP", arrayList);
        for (int i = 1; i < arrayList.size(); ++i) {
            int n;
            String string = ((String)arrayList.get(i)).toString();
            String[] stringArray = string.split("\\s+");
            if (this.verbosePSProcessing) {
                for (n = 0; n < stringArray.length; ++n) {
                    System.out.println(this.getLogLinePrefix() + "ps Output " + n + " = " + stringArray[n]);
                }
            }
            if (stringArray[n = 4].matches(".*:.*")) {
                if (this.verbosePSProcessing) {
                    System.out.println(this.getLogLinePrefix() + "ps Time field at 4: " + stringArray[n]);
                }
            } else {
                n = 5;
                if (stringArray[n].matches(".*:.*")) {
                    if (this.verbosePSProcessing) {
                        System.out.println(this.getLogLinePrefix() + "ps Time field at 5: " + stringArray[n]);
                    }
                } else {
                    System.err.println(this.getLogLinePrefix() + " ERROR: Found corrupted ps output: " + string);
                    continue;
                }
            }
            int n2 = 0;
            try {
                n2 = Integer.parseInt(stringArray[n].substring(0, 2)) * 60 * 60 + Integer.parseInt(stringArray[n].substring(3, 5)) * 60 + Integer.parseInt(stringArray[n].substring(6, 8));
            }
            catch (Exception exception) {
                System.err.println(this.getLogLinePrefix() + "ERROR: Non-numeric value found for CPU time: >" + n + "<");
            }
            l += (long)n2;
            int n3 = 2;
            if (n == 4) {
                n3 = 1;
            }
            try {
                Integer n4 = Integer.parseInt(stringArray[n3]);
                treeMap.put(n4, new Integer(n2));
                continue;
            }
            catch (Exception exception) {
                System.err.println(this.getLogLinePrefix() + "ERROR: Non-numeric value found for thread identifier: >" + stringArray[n3] + "<");
            }
        }
        long l2 = System.currentTimeMillis();
        return new ProcessThreadsCPUUse(l2 - this.startTimeMS, l2, l, treeMap);
    }

    public Map<Integer, String> getJavaProcessThreadNames() {
        String string;
        File file;
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        String string2 = System.getProperty("java.home");
        if (string2.indexOf("/jre") != -1) {
            string2 = string2 + "/..";
        }
        if (!(file = new File(string = string2 + "/bin/jstack")).exists()) {
            System.out.println(this.getLogLinePrefix() + "getJavaProcessThreadNames: No jstack available for obtaining stack traces");
            return treeMap;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Utils.runACommand(string + " -J-Dcom.azul.threadopt.runningJstackAsSubprocess=true " + Utils.getProcessPID(), arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            int n;
            String string3;
            block12: {
                String string4 = (String)arrayList.get(i);
                if (this.verboseThreadName) {
                    System.out.println(this.getLogLinePrefix() + "getJavaProcessThreadNames " + i + " " + string4);
                }
                boolean bl = false;
                int n2 = 0;
                string3 = "";
                String string5 = "";
                n = -1;
                try {
                    if (string4.length() > 0 && string4.substring(0, 1).equals("\"") && (n2 = string4.indexOf("nid=")) != -1) {
                        int n3 = string4.indexOf("\"", 1);
                        string3 = string4.substring(1, n3);
                        int n4 = string4.indexOf(" ", n2);
                        string5 = string4.substring(n2 + 6, n4);
                        try {
                            n = Integer.parseInt(string5, 16);
                        }
                        catch (Exception exception) {
                            n = 0;
                            System.err.println(this.getLogLinePrefix() + "ERROR: Non-numeric value found for thread native identifier: >" + string5 + "<");
                        }
                    }
                }
                catch (Exception exception) {
                    if (!this.verboseThreadName) break block12;
                    System.out.println(this.getLogLinePrefix() + "getJavaProcessThreadNames Not a header line (exception): " + i + " " + string4);
                    exception.printStackTrace();
                }
            }
            if (this.verboseThreadName) {
                System.out.println(this.getLogLinePrefix() + "Thread nid: " + n + " Name: " + string3);
            }
            if (n == -1) continue;
            treeMap.put(n, string3);
        }
        if (this.verbose) {
            Iterator iterator = treeMap.keySet().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                System.out.println(this.getLogLinePrefix() + "getJavaProcessThreadNames: " + n + "  " + (String)treeMap.get(n));
            }
        }
        return treeMap;
    }

    public void processOptions(String string) {
        String[] stringArray;
        boolean bl = true;
        if (string != null && string.length() > 0) {
            stringArray = string.split("\\s+|%");
            CommandLineOptions commandLineOptions = CommandLineOptions.getInstance();
            if (!commandLineOptions.isCommandLineOptionsInitialized()) {
                commandLineOptions.initializeCommandLineOptions(stringArray);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                block22: {
                    Object object;
                    String string2 = stringArray[i].toLowerCase();
                    if (string2.matches("^threshsecs=\\d+")) {
                        try {
                            object = Integer.parseInt(stringArray[i].substring(11));
                            if (object == null || (Integer)object < 0) {
                                commandLineOptions.processedOptionHasError(string2, "Invalid value for threshsecs (threhold for inclusion of application thread in low or high CPU time consuming CPU thread set): " + object + " Value must be greater than or equal to 0.");
                                break block22;
                            }
                            this.lowToHighCPUUseThresholdSecs = (Integer)object;
                            commandLineOptions.processedOption(string2);
                        }
                        catch (Exception exception) {
                            commandLineOptions.processedOptionHasError(string2, "Non-numeric value found: >" + string2.substring(11) + "<");
                        }
                    } else if (string2.matches("^voc")) {
                        this.verboseOptionsCheck = true;
                        commandLineOptions.processedOption(string2);
                    } else if (string2.matches("^vtn")) {
                        this.verboseThreadName = true;
                        commandLineOptions.processedOption(string2);
                    } else if (string2.matches("^vdt")) {
                        this.verboseDisplayThreads = true;
                        commandLineOptions.processedOption(string2);
                    } else if (string2.matches("^vps")) {
                        this.verbosePSProcessing = true;
                        commandLineOptions.processedOption(string2);
                    } else if (string2.matches("^verbose=.*")) {
                        object = string2.substring(8);
                        this.verboseOn = commandLineOptions.checkBooleanValue(string2, (String)object);
                    } else if (string2.matches("^v")) {
                        this.verbose = true;
                        commandLineOptions.processedOption(string2);
                    }
                }
                if (!this.verboseOn && !this.verbose) continue;
                if (bl) {
                    bl = false;
                    System.out.println(this.getLogLinePrefix() + "Process ProcessThreads options");
                }
                System.out.println(this.getLogLinePrefix() + "Option to ThreadOpt (PT): " + i + " = " + stringArray[i]);
            }
        }
        if (this.verboseOn || this.verbose) {
            stringArray = this.getLogLinePrefix() + "Options and internal variables settings: ";
            System.out.println((String)stringArray + "Verbose [" + false + "] (v): " + this.verbose);
            if (this.verboseOptionsCheck) {
                System.out.println((String)stringArray + "Print delay message at start of ThreadOpt work [" + this.printDelayStartMessageDefaultValue + "]: " + this.printDelayStartMessage);
            }
            System.out.println((String)stringArray + "Low to high CPU time use threshold for Single CPU Time Use Snapshot mode [" + 20 + "] (threshsecs): " + this.lowToHighCPUUseThresholdSecs);
        }
    }

    public ProcessThreads(String string) {
        this.startTimeMS = this.timeMXBean.getUnixTimeOfJVMStartMillis();
        this.processOptions(string);
    }

    public static void main(String[] stringArray) {
        System.out.println("[ProcessThreads] " + System.currentTimeMillis() + " Entry");
        String string = "";
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            string = stringArray[0];
        }
        System.out.println("[ProcessThreads] " + System.currentTimeMillis() + " In Process.main() with arguments: " + string);
        MachineArchitecture machineArchitecture = new MachineArchitecture(string);
        System.out.println("[ProcessThreads] " + System.currentTimeMillis() + " Start hardware analysis phase");
        machineArchitecture.getCPUNodeAndCPUThreadConfiguration();
        machineArchitecture.partitionCPUThreadsBetweenLowCPUConsumingAndHighCPUConsumingPartitions();
        machineArchitecture.identifyCPUThreadsRunningOnSameCore();
        System.out.println("[ProcessThreads] " + System.currentTimeMillis() + " End hardware analysis phase");
        ProcessThreads processThreads = new ProcessThreads(string);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        processThreads.constructListsOfHighAndLowCPUConsumingAppThreadsBasedOnThreshold(arrayList, arrayList2);
        System.out.println("[ProcessThreads] Low CPU consuming threads: " + arrayList);
        System.out.println("[ProcessThreads] High CPU consuming threads: " + arrayList2);
        Map<Integer, String> map = processThreads.getJavaProcessThreadNames();
        System.out.println("[ProcessThreads] Thread ID to thread name: " + map);
        System.out.println("[Process] " + System.currentTimeMillis() + " ProcessThreads has completed its work and will exit");
    }
}

