/*
 * Decompiled with CFR 0.152.
 */
package com.azul.threadopt;

import com.azul.threadopt.Error;
import com.azul.threadopt.TimeMXBeanImpl;
import com.azul.threadopt.mxbeans.TimeMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;

public class CommandLineOptions {
    private String[] _args = null;
    private List<String> _processedOptions = new ArrayList<String>();
    private List<Error> _processedOptionsWithErrors = new ArrayList<Error>();
    private static CommandLineOptions _instance = new CommandLineOptions();
    private TimeMXBean timeMXBean = TimeMXBeanImpl.getInstance();

    private String getLogLinePrefix() {
        if (this.timeMXBean != null) {
            return this.timeMXBean.getElapsedTimeSinceJVMStartSecStr() + " [ThreadOpt] ";
        }
        return "[ThreadOpt] ";
    }

    static CommandLineOptions getInstance() {
        return _instance;
    }

    private CommandLineOptions() {
    }

    public void initializeCommandLineOptions(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this._args = new String[0];
        } else {
            int n = stringArray.length;
            this._args = new String[n];
            for (int i = 0; i < n; ++i) {
                this._args[i] = stringArray[i].toLowerCase();
            }
        }
    }

    public boolean isCommandLineOptionsInitialized() {
        return this._args != null;
    }

    public void processedOption(String string) {
        this._processedOptions.add(string);
    }

    public void processedOptionHasError(String string, String string2) {
        Error error = new Error(string, string2);
        this._processedOptionsWithErrors.add(error);
    }

    public boolean checkBooleanValue(String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            if (string2.equals("f") || string2.equals("false")) {
                this.processedOption(string);
                return false;
            }
            if (string2.equals("t") || string2.equals("true")) {
                this.processedOption(string);
                return true;
            }
            this.processedOptionHasError(string, "Value must be true or false");
            return false;
        }
        this.processedOptionHasError(string, "Value must be true or false");
        return false;
    }

    public long dateAndTimeToMilliseconds(String string, String string2) {
        long l = 0L;
        try {
            if (string2 != null && string2.length() > 16) {
                long l2 = System.currentTimeMillis();
                Date date = null;
                date = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss").parse(string2);
                if (date != null) {
                    l = date.getTime() - l2;
                    if (l < 0L) {
                        l = 0L;
                        this.processedOptionHasError(string, "Provided date string not valid, must be greater than zero.");
                    } else {
                        this.processedOption(string);
                    }
                } else {
                    this.processedOptionHasError(string, "Provided date string not valid, must be in format yyyy-MM-dd-HH:mm:ss");
                }
            } else {
                this.processedOptionHasError(string, "Provided date string not valid, must be in format yyyy-MM-dd-HH:mm:ss");
            }
        }
        catch (Exception exception) {
            this.processedOptionHasError(string, "Provided time string not valid, must be in format yyyy-MM-dd-HH:mm:ss or other error has occurred.");
        }
        return l;
    }

    public long hoursMinutesSecondsToMilliseconds(String string, String string2) {
        long l = 0L;
        try {
            if (string2 != null && string2.length() > 5) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                Date date = simpleDateFormat.parse("1970-01-01 " + string2);
                if (date != null) {
                    l = (int)date.getTime();
                    if (l < 0L) {
                        l = 0L;
                        this.processedOptionHasError(string, "Provided time string not valid, must be greater than zero.");
                    } else {
                        this.processedOption(string);
                    }
                } else {
                    this.processedOptionHasError(string, "Provided time string >" + string2 + "< not valid, must be in format HH:mm:ss.");
                }
            } else {
                this.processedOptionHasError(string, "Provided time string not valid, must be in format HH:mm:ss.");
            }
        }
        catch (Exception exception) {
            this.processedOptionHasError(string, "Provided time string not valid, must be in format HH:mm:ss or other error has occurred.");
        }
        return l;
    }

    public long stringFloatInSecondsToMilliseconds(String string, String string2) {
        long l = 0L;
        try {
            if (string2 != null && string2.length() > 0) {
                float f;
                float f2 = Float.parseFloat(string2);
                if (f2 > (f = 3.1536E9f) || f2 < 0.0f) {
                    this.processedOptionHasError(string, "Provided time in seconds: " + f2 + " must be a positive value less than: " + f);
                } else {
                    l = (long)(f2 * 1000.0f + 0.5f);
                    this.processedOption(string);
                }
            } else {
                this.processedOptionHasError(string, "Invalid value for time (seconds) for option: " + string + " Value is: >" + string2 + "<");
            }
        }
        catch (Exception exception) {
            this.processedOptionHasError(string, "Invalid value for time (seconds) for option: " + string + " Value is: >" + string2 + "<");
        }
        return l;
    }

    public void finalProcessingOfCommandLineOptions() {
        if (this._args == null || this._args.length < 1) {
            return;
        }
        boolean bl = false;
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(this._args));
        HashSet<String> hashSet2 = new HashSet<String>(this._processedOptions);
        if (hashSet2 != null && hashSet2.size() != 0) {
            hashSet.removeAll(hashSet2);
        }
        for (String object : hashSet) {
            System.err.println("ThreadOpt: ERROR: Unrecognized option: " + object);
            bl = true;
        }
        for (Error error : this._processedOptionsWithErrors) {
            System.err.println(this.getLogLinePrefix() + "ERROR: Error encountered while processing option: " + error.getOption() + " Reason: " + error.getErrorMessage());
            bl = true;
        }
        if (bl) {
            System.err.println(this.getLogLinePrefix() + "ERROR: Process is exiting because command line options to ThreadOpt are incorrect.");
            System.exit(1);
        }
    }
}

