/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.internal.management;

import com.azul.zing.internal.management.DescribeObject;
import com.azul.zing.internal.management.NativeMemoryManagerDesc;
import com.azul.zing.internal.management.NativeMemoryPoolDesc;
import com.azul.zing.internal.management.ObjectComplexReturnedFromCommand;
import com.azul.zing.internal.management.ObjectGCDetailsReturnedFromCommand;
import com.azul.zing.internal.management.ObjectReturnedFromCommand;
import com.azul.zing.internal.management.ObjectSimpleReturnedFromCommand;
import com.azul.zing.internal.management.ReturnValuesToParametersGCDetails;
import com.azul.zing.internal.management.ReturnValuesToParametersMemoryUsage;
import com.azul.zing.internal.management.ReturnValuesToParametersNativeMemoryManagerDesc;
import com.azul.zing.internal.management.ReturnValuesToParametersNativeMemoryPoolDesc;
import com.azul.zing.internal.management.ReturnValuesToParametersPauseDetails;
import com.azul.zing.management.GCDetails;
import com.azul.zing.management.MemoryPoolSizeType;
import com.azul.zing.management.MemoryType;
import com.azul.zing.management.MemoryUsage;
import com.azul.zing.management.PauseDetails;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

class Utils {
    public static final boolean TRACE = Utils.checkTraceProperty();
    public static final boolean VERBOSE_MODE = Utils.checkVerboseModeProperty();
    public static boolean printErrorMessagesOn = Utils.checkVerboseModeProperty();
    private static final String namespaceString = "namespace";
    private static final String objectTypeString = "objectType";
    private static final String objectString = "object";
    private static final String messageString = "message";
    private static final String parameterCountString = "parameterCount";
    private static final String namespaceName = "ZingJMM";
    private static NativeMemoryManagerDesc[] _nativeMemoryManagerDescArraySpecifyingInvalidData = Utils.createNativeMemoryManagerDescArraySpecifyingInvalidData();
    private static NativeMemoryPoolDesc[] _nativeMemoryPoolDescArraySpecifyingInvalidData = Utils.createNativeMemoryPoolDescArraySpecifyingInvalidData();

    Utils() {
    }

    private static boolean checkTraceProperty() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    return System.getProperty("com.azul.zing.internal.management.trace") != null;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        });
    }

    private static boolean checkVerboseModeProperty() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    return System.getProperty("com.azul.zing.internal.management.verbose") != null;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        });
    }

    public static void printErrorMessage(String string, String string2) {
        System.err.println("com.azul.zing.management: ERROR: " + string + ": " + string2);
    }

    public static void printTraceMessage(String string, String string2) {
        System.out.println("com.azul.zing.management: Trace: " + string + ": " + string2);
    }

    private static NativeMemoryPoolDesc[] createNativeMemoryPoolDescArraySpecifyingInvalidData() {
        NativeMemoryPoolDesc[] nativeMemoryPoolDescArray = new NativeMemoryPoolDesc[]{new NativeMemoryPoolDesc("Invalid", null, null, null, false, false, false)};
        return nativeMemoryPoolDescArray;
    }

    private static NativeMemoryManagerDesc[] createNativeMemoryManagerDescArraySpecifyingInvalidData() {
        NativeMemoryManagerDesc[] nativeMemoryManagerDescArray = new NativeMemoryManagerDesc[]{new NativeMemoryManagerDesc("Invalid", 0, false)};
        return nativeMemoryManagerDescArray;
    }

    public static Object[] createCommandWithObjectMessage0Parameters(String string, String string2, String string3) {
        String[] stringArray = new String[]{namespaceString, objectTypeString, objectString, messageString, parameterCountString};
        Object[] objectArray = new Object[]{namespaceName, string, string2, string3, new Long(0L)};
        Object[] objectArray2 = new Object[]{stringArray, objectArray};
        if (TRACE) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Command:");
            for (int i = 0; i < 4; ++i) {
                stringBuilder.append(" ");
                stringBuilder.append((String)objectArray[i]);
            }
            stringBuilder.append(" ");
            stringBuilder.append((Long)objectArray[4]);
            System.out.println(stringBuilder);
        }
        return objectArray2;
    }

    public static Object[] createCommandWithObjectMessage1Parameter(String string, String string2, String string3, String string4, Object object) {
        String[] stringArray = new String[]{namespaceString, objectTypeString, objectString, messageString, parameterCountString, string4};
        Object[] objectArray = new Object[]{namespaceName, string, string2, string3, new Long(1L), object};
        Object[] objectArray2 = new Object[]{stringArray, objectArray};
        if (TRACE) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Command:");
            for (int i = 0; i < 4; ++i) {
                stringBuilder.append(" ");
                stringBuilder.append((String)objectArray[i]);
            }
            stringBuilder.append(" ");
            stringBuilder.append((Long)objectArray[4]);
            stringBuilder.append(" ");
            stringBuilder.append(object);
            System.out.println(stringBuilder);
        }
        return objectArray2;
    }

    public static Object[] createCommandWithObjectMessage2Parameters(String string, String string2, String string3, String string4, Object object, String string5, Object object2) {
        String[] stringArray = new String[]{namespaceString, objectTypeString, objectString, messageString, parameterCountString, string4, string5};
        Object[] objectArray = new Object[]{namespaceName, string, string2, string3, new Long(2L), object, object2};
        Object[] objectArray2 = new Object[]{stringArray, objectArray};
        if (TRACE) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Command:");
            for (int i = 0; i < 4; ++i) {
                stringBuilder.append(" ");
                stringBuilder.append((String)objectArray[i]);
            }
            stringBuilder.append(" ");
            stringBuilder.append((Long)objectArray[4]);
            stringBuilder.append(" ");
            stringBuilder.append(object);
            stringBuilder.append(" ");
            stringBuilder.append(object2);
            System.out.println(stringBuilder);
        }
        return objectArray2;
    }

    public static Object[] createCommandWithObjectMessage3Parameters(String string, String string2, String string3, String string4, Object object, String string5, Object object2, String string6, Object object3) {
        String[] stringArray = new String[]{namespaceString, objectTypeString, objectString, messageString, parameterCountString, string4, string5, string6};
        Object[] objectArray = new Object[]{namespaceName, string, string2, string3, new Long(3L), object, object2, object3};
        Object[] objectArray2 = new Object[]{stringArray, objectArray};
        if (TRACE) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Command:");
            for (int i = 0; i < 4; ++i) {
                stringBuilder.append(" ");
                stringBuilder.append((String)objectArray[i]);
            }
            stringBuilder.append(" ");
            stringBuilder.append((Long)objectArray[4]);
            stringBuilder.append(" ");
            stringBuilder.append(object);
            stringBuilder.append(" ");
            stringBuilder.append(object2);
            stringBuilder.append(" ");
            stringBuilder.append(object3);
            System.out.println(stringBuilder);
        }
        return objectArray2;
    }

    public static ObjectSimpleReturnedFromCommand makeCommandCall0ParametersAndCreateSimpleReturnObject(String string, String string2, String string3, int n) {
        ObjectReturnedFromCommand objectReturnedFromCommand = null;
        try {
            Object[] objectArray = Utils.createCommandWithObjectMessage0Parameters(string, string2, string3);
            Object object = Compiler.command((Object)objectArray);
            if (object != null) {
                if (TRACE) {
                    System.out.println(DescribeObject.describeObject(object));
                }
                objectReturnedFromCommand = new ObjectSimpleReturnedFromCommand(string, string2, string3, object, n);
            }
            if (objectReturnedFromCommand == null || objectReturnedFromCommand.isErrorOrExceptionDuringProcessing()) {
                if (printErrorMessagesOn) {
                    Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndCreateSimpleReturnObject on behalf of " + string + "." + string2 + "." + string3, "EXCEPTION or ERROR: query to wrapped resource failed");
                }
                return null;
            }
        }
        catch (Exception exception) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndCreateSimpleReturnObject on behalf of " + string + "." + string2 + "." + string3, "EXCEPTION or ERROR: Java Exception object thrown");
                exception.printStackTrace(System.err);
            }
            return null;
        }
        return objectReturnedFromCommand;
    }

    public static ObjectComplexReturnedFromCommand makeCommandCall0ParametersAndCreateComplexReturnObject(String string, String string2, String string3, int n, int n2, int n3, Object object) {
        ObjectReturnedFromCommand objectReturnedFromCommand = null;
        try {
            Object object2 = null;
            if (object == null) {
                Object[] objectArray = Utils.createCommandWithObjectMessage0Parameters(string, string2, string3);
                object2 = Compiler.command((Object)objectArray);
            } else {
                object2 = object;
            }
            if (object2 != null) {
                if (TRACE) {
                    System.out.println(DescribeObject.describeObject(object2));
                }
                objectReturnedFromCommand = new ObjectComplexReturnedFromCommand(string, string2, string3, object2, n, n2, n3);
            }
            if (objectReturnedFromCommand == null || objectReturnedFromCommand.isErrorOrExceptionDuringProcessing()) {
                if (printErrorMessagesOn) {
                    Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndCreateComplexReturnObject on behalf of " + string + "." + string2 + "." + string3, "EXCEPTION or ERROR: query to wrapped resource failed");
                }
                return null;
            }
        }
        catch (Exception exception) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndCreateComplexReturnObject on behalf of " + string + "." + string2 + "." + string3, "EXCEPTION or ERROR: Java Exception object thrown");
                exception.printStackTrace(System.err);
            }
            return null;
        }
        return objectReturnedFromCommand;
    }

    public static ObjectGCDetailsReturnedFromCommand makeCommandCall0ParametersAndCreateGCDetailsReturnObject(String string, String string2, String string3, int n, Object object) {
        ObjectReturnedFromCommand objectReturnedFromCommand = null;
        try {
            Object object2 = null;
            if (object == null) {
                Object[] objectArray = Utils.createCommandWithObjectMessage0Parameters(string, string2, string3);
                object2 = Compiler.command((Object)objectArray);
            } else {
                object2 = object;
            }
            if (object2 != null) {
                if (TRACE) {
                    System.out.println(DescribeObject.describeObject(object2));
                }
                objectReturnedFromCommand = new ObjectGCDetailsReturnedFromCommand(string, string2, string3, object2, n);
            }
            if (objectReturnedFromCommand == null || objectReturnedFromCommand.isErrorOrExceptionDuringProcessing()) {
                if (printErrorMessagesOn) {
                    Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndCreateGCDetailsReturnObject on behalf of " + string + "." + string2 + "." + string3, "EXCEPTION or ERROR: query to wrapped resource failed");
                }
                return null;
            }
        }
        catch (Exception exception) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndCreateGCDetailsReturnObject on behalf of " + string + "." + string2 + "." + string3, "EXCEPTION or ERROR: Java Exception object thrown");
                exception.printStackTrace(System.err);
            }
            return null;
        }
        return objectReturnedFromCommand;
    }

    public static int makeCommandCall0ParametersAndReturnInt(String string, String string2, String string3) {
        ObjectSimpleReturnedFromCommand objectSimpleReturnedFromCommand = Utils.makeCommandCall0ParametersAndCreateSimpleReturnObject(string, string2, string3, 1);
        if (objectSimpleReturnedFromCommand == null || objectSimpleReturnedFromCommand.isErrorOrExceptionDuringProcessing()) {
            return 0;
        }
        int n = objectSimpleReturnedFromCommand.getReturnedElementAsInt(1);
        if (objectSimpleReturnedFromCommand.isErrorOrExceptionDuringProcessing()) {
            return 0;
        }
        return n;
    }

    public static long makeCommandCall0ParametersAndReturnLong(String string, String string2, String string3) {
        ObjectSimpleReturnedFromCommand objectSimpleReturnedFromCommand = Utils.makeCommandCall0ParametersAndCreateSimpleReturnObject(string, string2, string3, 1);
        if (objectSimpleReturnedFromCommand == null || objectSimpleReturnedFromCommand.isErrorOrExceptionDuringProcessing()) {
            return 0L;
        }
        long l = objectSimpleReturnedFromCommand.getReturnedElementAsLong(1);
        if (objectSimpleReturnedFromCommand.isErrorOrExceptionDuringProcessing()) {
            return 0L;
        }
        return l;
    }

    public static double makeCommandCall0ParametersAndReturnDouble(String string, String string2, String string3) {
        ObjectSimpleReturnedFromCommand objectSimpleReturnedFromCommand = Utils.makeCommandCall0ParametersAndCreateSimpleReturnObject(string, string2, string3, 1);
        if (objectSimpleReturnedFromCommand == null || objectSimpleReturnedFromCommand.isErrorOrExceptionDuringProcessing()) {
            return 0.0;
        }
        double d = objectSimpleReturnedFromCommand.getReturnedElementAsDouble(1);
        if (objectSimpleReturnedFromCommand.isErrorOrExceptionDuringProcessing()) {
            return 0.0;
        }
        return d;
    }

    public static boolean makeCommandCall0ParametersAndReturnBoolean(String string, String string2, String string3) {
        ObjectSimpleReturnedFromCommand objectSimpleReturnedFromCommand = Utils.makeCommandCall0ParametersAndCreateSimpleReturnObject(string, string2, string3, 1);
        if (objectSimpleReturnedFromCommand == null || objectSimpleReturnedFromCommand.isErrorOrExceptionDuringProcessing()) {
            return false;
        }
        boolean bl = objectSimpleReturnedFromCommand.getReturnedElementAsBoolean(1);
        if (objectSimpleReturnedFromCommand.isErrorOrExceptionDuringProcessing()) {
            return false;
        }
        return bl;
    }

    public static MemoryUsage makeCommandCall0ParametersAndReturnMemoryUsage(String string, String string2, String string3, Object object) {
        try {
            MemoryUsage memoryUsage;
            int n;
            int n2 = 1;
            int n3 = 1;
            int n4 = 6;
            ObjectComplexReturnedFromCommand objectComplexReturnedFromCommand = Utils.makeCommandCall0ParametersAndCreateComplexReturnObject(string, string2, string3, n2, n3, n4, object);
            if (objectComplexReturnedFromCommand == null || objectComplexReturnedFromCommand.isErrorOrExceptionDuringProcessing()) {
                if (printErrorMessagesOn) {
                    Utils.printErrorMessage("Utils.makeCommandCall0ParameterAndReturnMemoryUsage on behalf of " + string + "." + string2 + "." + string3, "EXCEPTION or ERROR: query to wrapped resource failed");
                }
                return new MemoryUsage(MemoryPoolSizeType.enumValue(0L), 0L, 0L, 0L, 0.0);
            }
            Object[] objectArray = objectComplexReturnedFromCommand.getKeyObjArray(0);
            Object[] objectArray2 = objectComplexReturnedFromCommand.getValueObjArray(0);
            ReturnValuesToParametersMemoryUsage returnValuesToParametersMemoryUsage = new ReturnValuesToParametersMemoryUsage();
            int n5 = returnValuesToParametersMemoryUsage.numberOfExpectedParameters();
            if (TRACE) {
                for (int i = 0; i < objectArray.length; ++i) {
                    Utils.printTraceMessage("Utils.makeCommandCall0ParameterAndReturnMemoryUsage on behalf of " + string + "." + string2 + "." + string3, "key: " + objectArray[i] + " value: " + objectArray2[i]);
                }
            }
            if (objectArray.length != objectArray2.length) {
                if (printErrorMessagesOn) {
                    Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndReturnMemoryUsage on behalf of " + string + "." + string2 + "." + string3, "ERROR: key length: " + objectArray.length + " value length:" + objectArray2.length);
                }
                return new MemoryUsage(MemoryPoolSizeType.enumValue(0L), 0L, 0L, 0L, 0.0);
            }
            if (objectArray.length != n5) {
                if (printErrorMessagesOn) {
                    Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndReturnMemoryUsage on behalf of " + string + "." + string2 + "." + string3, "ERROR: expected key length: " + n5 + " returned key length: " + objectArray.length);
                }
                return new MemoryUsage(MemoryPoolSizeType.enumValue(0L), 0L, 0L, 0L, 0.0);
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(n5);
            for (n = 0; n < n5; ++n) {
                if (!(objectArray[n] instanceof String)) {
                    if (!printErrorMessagesOn) break;
                    Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndReturnMemoryUsage on behalf of " + string + "." + string2 + "." + string3, "ERROR: key[" + n + "] is not a String: " + objectArray[n] + " value: " + objectArray2[n]);
                    break;
                }
                hashMap.put((String)objectArray[n], objectArray2[n]);
                if (!TRACE) continue;
                Utils.printTraceMessage("Utils.makeCommandCall0ParametersAndReturnMemoryUsage on behalf of " + string + "." + string2 + "." + string3, "Add to HashMap key: " + objectArray[n] + " value: " + objectArray2[n]);
            }
            for (n = 0; n < n5; ++n) {
                String string4 = returnValuesToParametersMemoryUsage.getReturnValuesToParameters(n).expectedKeyValue();
                if (string4 == null) {
                    if (!printErrorMessagesOn) break;
                    Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndReturnMemoryUsage on behalf of " + string + "." + string2 + "." + string3, "ERROR: key[" + n + "] value is null");
                    break;
                }
                Object v = hashMap.get(string4);
                if (v == null) {
                    if (!printErrorMessagesOn) break;
                    Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndReturnMemoryUsage on behalf of " + string + "." + string2 + "." + string3, "ERROR: key[" + n + "] value of \"" + string4 + "\" not in return values");
                    break;
                }
                if (v.getClass() != returnValuesToParametersMemoryUsage.getReturnValuesToParameters(n).expectedType()) {
                    if (!printErrorMessagesOn) break;
                    Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndReturnMemoryUsage on behalf of " + string + "." + string2 + "." + string3, "ERROR: key[" + n + "] with value of \"" + string4 + "\" has type mismatch with value returned. Type is: " + v.getClass() + " and expected type is: " + returnValuesToParametersMemoryUsage.getReturnValuesToParameters(n).expectedType());
                    break;
                }
                returnValuesToParametersMemoryUsage.setValueObject(n, v);
            }
            if ((memoryUsage = new MemoryUsage(MemoryPoolSizeType.enumValue(returnValuesToParametersMemoryUsage.getParamAs_long(1)), returnValuesToParametersMemoryUsage.getParamAs_long(2), returnValuesToParametersMemoryUsage.getParamAs_long(3), returnValuesToParametersMemoryUsage.getParamAs_long(4), returnValuesToParametersMemoryUsage.getParamAs_double(5))) == null || returnValuesToParametersMemoryUsage.errorOrExceptionOccurred()) {
                if (printErrorMessagesOn) {
                    Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndReturnMemoryUsage on behalf of " + string + "." + string2 + "." + string3, "ERROR: failure to create MemoryUsage object using returned values");
                }
                return new MemoryUsage(MemoryPoolSizeType.enumValue(0L), 0L, 0L, 0L, 0.0);
            }
            return memoryUsage;
        }
        catch (Exception exception) {
            if (TRACE) {
                Utils.printTraceMessage("Utils.makeCommandCall0ParametersAndReturnMemoryUsage on behalf of " + string + "." + string2 + "." + string3, "ERROR in processing returned values");
            }
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndReturnMemoryUsage on behalf of " + string + "." + string2 + "." + string3, "EXCEPTION or ERROR: exception caught during processing of returned values");
                exception.printStackTrace(System.err);
            }
            return new MemoryUsage(MemoryPoolSizeType.enumValue(0L), 0L, 0L, 0L, 0.0);
        }
    }

    public static boolean makeCommandCall1BooleanParameterAndReturnBoolean(String string, String string2, String string3, String string4, Boolean bl) {
        int n;
        ObjectSimpleReturnedFromCommand objectSimpleReturnedFromCommand;
        Object[] objectArray = Utils.createCommandWithObjectMessage1Parameter(string, string2, string3, string4, bl);
        Object object = Compiler.command((Object)objectArray);
        if (TRACE) {
            System.out.println(DescribeObject.describeObject(object));
        }
        if ((objectSimpleReturnedFromCommand = new ObjectSimpleReturnedFromCommand(string, string2, string3, object, n = 1)).isErrorOrExceptionDuringProcessing()) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.makeCommandCall1BooleanParameterAndReturnBoolean on behalf of " + string + "." + string2 + "." + string3, "EXCEPTION or ERROR: query to wrapped resource failed");
            }
            return false;
        }
        boolean bl2 = objectSimpleReturnedFromCommand.getReturnedElementAsBoolean(1);
        if (objectSimpleReturnedFromCommand.isErrorOrExceptionDuringProcessing()) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.makeCommandCall1BooleanParameterAndReturnBoolean on behalf of " + string + "." + string2 + "." + string3, "EXCEPTION or ERROR: conversion of return value to type Boolean failed");
            }
            return false;
        }
        return bl2;
    }

    public static boolean makeCommandCall1LongParameterAndReturnBoolean(String string, String string2, String string3, String string4, Long l) {
        int n;
        ObjectSimpleReturnedFromCommand objectSimpleReturnedFromCommand;
        Object[] objectArray = Utils.createCommandWithObjectMessage1Parameter(string, string2, string3, string4, l);
        Object object = Compiler.command((Object)objectArray);
        if (TRACE) {
            System.out.println(DescribeObject.describeObject(object));
        }
        if ((objectSimpleReturnedFromCommand = new ObjectSimpleReturnedFromCommand(string, string2, string3, object, n = 1)).isErrorOrExceptionDuringProcessing()) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.makeCommandCall1LongParameterAndReturnBoolean on behalf of " + string + "." + string2 + "." + string3, "EXCEPTION or ERROR: query to wrapped resource failed");
            }
            return false;
        }
        boolean bl = objectSimpleReturnedFromCommand.getReturnedElementAsBoolean(1);
        if (objectSimpleReturnedFromCommand.isErrorOrExceptionDuringProcessing()) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.makeCommandCall1LongParameterAndReturnBoolean on behalf of " + string + "." + string2 + "." + string3, "EXCEPTION or ERROR: conversion of return value to type Boolean failed");
            }
            return false;
        }
        return bl;
    }

    public static boolean makeCommandCall1DoubleParameterAndReturnBoolean(String string, String string2, String string3, String string4, Double d) {
        int n;
        ObjectSimpleReturnedFromCommand objectSimpleReturnedFromCommand;
        Object[] objectArray = Utils.createCommandWithObjectMessage1Parameter(string, string2, string3, string4, d);
        Object object = Compiler.command((Object)objectArray);
        if (TRACE) {
            System.out.println(DescribeObject.describeObject(object));
        }
        if ((objectSimpleReturnedFromCommand = new ObjectSimpleReturnedFromCommand(string, string2, string3, object, n = 1)).isErrorOrExceptionDuringProcessing()) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.makeCommandCall1DoubleParameterAndReturnBoolean on behalf of " + string + "." + string2 + "." + string3, "EXCEPTION or ERROR: query to wrapped resource failed");
            }
            return false;
        }
        boolean bl = objectSimpleReturnedFromCommand.getReturnedElementAsBoolean(1);
        if (objectSimpleReturnedFromCommand.isErrorOrExceptionDuringProcessing()) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.makeCommandCall1DoubleParameterAndReturnBoolean on behalf of " + string + "." + string2 + "." + string3, "EXCEPTION or ERROR: conversion of return value to type Boolean failed");
            }
            return false;
        }
        return bl;
    }

    public static boolean makeCommandCall3StringParametersAndReturnBoolean(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        int n;
        ObjectSimpleReturnedFromCommand objectSimpleReturnedFromCommand;
        Object[] objectArray = Utils.createCommandWithObjectMessage3Parameters(string, string2, string3, string4, string5, string6, string7, string8, string9);
        Object object = Compiler.command((Object)objectArray);
        if (TRACE) {
            System.out.println(DescribeObject.describeObject(object));
        }
        if ((objectSimpleReturnedFromCommand = new ObjectSimpleReturnedFromCommand(string, string2, string3, object, n = 1)).isErrorOrExceptionDuringProcessing()) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.makeCommandCall3StringParametersAndReturnBoolean on behalf of " + string + "." + string2 + "." + string3, "EXCEPTION or ERROR: query to wrapped resource failed");
            }
            return false;
        }
        boolean bl = objectSimpleReturnedFromCommand.getReturnedElementAsBoolean(1);
        if (objectSimpleReturnedFromCommand.isErrorOrExceptionDuringProcessing()) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.makeCommandCall3StringParametersAndReturnBoolean on behalf of " + string + "." + string2 + "." + string3, "EXCEPTION or ERROR: conversion of return value to type Boolean failed");
            }
            return false;
        }
        return bl;
    }

    public static Map<String, MemoryUsage> processGCMemoryUsageToMap(String string, String string2, String string3, Object[] objectArray, Object[] objectArray2, int n) {
        int n2;
        if ((objectArray == null || objectArray2 == null) && printErrorMessagesOn) {
            Utils.printErrorMessage("Utils.processGCMemoryUsageToMap on behalf of " + string + "." + string2 + "." + string3, "ERROR: input values keyArray and/or ValueArrayArray is/are null");
            return Utils.createMemoryUsageMapSpecifyingInvalidData(n);
        }
        if (objectArray2.length != n && printErrorMessagesOn) {
            Utils.printErrorMessage("Utils.processGCMemoryUsageToMap on behalf of " + string + "." + string2 + "." + string3, "ERROR: input length of ValueArrayArray[" + objectArray2.length + "] does not match exppected: " + n);
            return Utils.createMemoryUsageMapSpecifyingInvalidData(n);
        }
        ReturnValuesToParametersMemoryUsage returnValuesToParametersMemoryUsage = new ReturnValuesToParametersMemoryUsage();
        int n3 = returnValuesToParametersMemoryUsage.numberOfExpectedParameters();
        for (n2 = 0; n2 < n3; ++n2) {
            if (objectArray[n2] instanceof String) continue;
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.processGCMemoryUsageToMap on behalf of " + string + "." + string2 + "." + string3, "ERROR: key[" + n2 + "] is not a String: " + objectArray[n2]);
            }
            return Utils.createMemoryUsageMapSpecifyingInvalidData(n);
        }
        if (TRACE) {
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                Utils.printTraceMessage("Utils.processGCMemoryUsageToMap on behalf of " + string + "." + string2 + "." + string3, "converting MemoryUsage: key: " + objectArray[n2]);
            }
        }
        if (objectArray.length != n3) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.processGCMemoryUsageToMap on behalf of " + string + "." + string2 + "." + string3, "ERROR: expected key length: " + n3 + " returned key length: " + objectArray.length);
            }
            return Utils.createMemoryUsageMapSpecifyingInvalidData(n);
        }
        HashMap<String, MemoryUsage> hashMap = new HashMap<String, MemoryUsage>(n);
        for (int i = 0; i < n; ++i) {
            String string4;
            int n4;
            if (!objectArray2[i].getClass().isArray()) {
                if (printErrorMessagesOn) {
                    Utils.printErrorMessage("Utils.processGCMemoryUsageToMap on behalf of " + string + "." + string2 + "." + string3, "ERROR: value[" + i + "] with value of \"" + objectArray2[i].getClass() + "\" has a type mismatch with expected Object[] type.");
                }
                return Utils.createMemoryUsageMapSpecifyingInvalidData(n);
            }
            Object[] objectArray3 = (Object[])objectArray2[i];
            if (objectArray.length != objectArray3.length) {
                if (printErrorMessagesOn) {
                    Utils.printErrorMessage("Utils.processGCMemoryUsageToMap on behalf of " + string + "." + string2 + "." + string3, "ERROR: mismatch between key length: " + objectArray.length + " and value length:" + objectArray3.length);
                }
                return Utils.createMemoryUsageMapSpecifyingInvalidData(n);
            }
            if (TRACE) {
                for (int j = 0; j < objectArray.length; ++j) {
                    Utils.printTraceMessage("Utils.processGCMemoryUsageToMap on behalf of " + string + "." + string2 + "." + string3, "key: " + objectArray[j] + " value: " + objectArray3[j]);
                }
            }
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>(n3);
            for (n4 = 0; n4 < n3; ++n4) {
                hashMap2.put((String)objectArray[n4], objectArray3[n4]);
                if (!TRACE) continue;
                Utils.printTraceMessage("Utils.processGCMemoryUsageToMap on behalf of " + string + "." + string2 + "." + string3, "Add to HashMap key: " + objectArray[n4] + " value: " + objectArray3[n4]);
            }
            for (n4 = 0; n4 < n3; ++n4) {
                string4 = returnValuesToParametersMemoryUsage.getReturnValuesToParameters(n4).expectedKeyValue();
                if (string4 == null) {
                    if (printErrorMessagesOn) {
                        Utils.printErrorMessage("Utils.processGCMemoryUsageToMap on behalf of " + string + "." + string2 + "." + string3, "ERROR: key[" + n4 + "] value is null");
                    }
                    return Utils.createMemoryUsageMapSpecifyingInvalidData(n);
                }
                Object v = hashMap2.get(string4);
                if (v == null) {
                    if (printErrorMessagesOn) {
                        Utils.printErrorMessage("Utils.processGCMemoryUsageToMap on behalf of " + string + "." + string2 + "." + string3, "ERROR: key[" + n4 + "] with value of \"" + string4 + "\" is not in return values");
                    }
                    return Utils.createMemoryUsageMapSpecifyingInvalidData(n);
                }
                if (v.getClass() != returnValuesToParametersMemoryUsage.getReturnValuesToParameters(n4).expectedType()) {
                    if (printErrorMessagesOn) {
                        Utils.printErrorMessage("Utils.processGCMemoryUsageToMap on behalf of " + string + "." + string2 + "." + string3, "ERROR: key[" + n4 + "] with value of \"" + string4 + "\" has type mismatch with value returned. Type is: " + v.getClass() + " and expected type is: " + returnValuesToParametersMemoryUsage.getReturnValuesToParameters(n4).expectedType());
                    }
                    return Utils.createMemoryUsageMapSpecifyingInvalidData(n);
                }
                returnValuesToParametersMemoryUsage.setValueObject(n4, v);
            }
            MemoryUsage memoryUsage = new MemoryUsage(MemoryPoolSizeType.enumValue(returnValuesToParametersMemoryUsage.getParamAs_long(1)), returnValuesToParametersMemoryUsage.getParamAs_long(2), returnValuesToParametersMemoryUsage.getParamAs_long(3), returnValuesToParametersMemoryUsage.getParamAs_long(4), returnValuesToParametersMemoryUsage.getParamAs_double(5));
            if (memoryUsage == null || returnValuesToParametersMemoryUsage.errorOrExceptionOccurred()) {
                if (printErrorMessagesOn) {
                    Utils.printErrorMessage("Utils.processGCMemoryUsageToMap on behalf of " + string + "." + string2 + "." + string3, "ERROR: unable to create return MemoryUsage object, failure to process returned values");
                }
                return Utils.createMemoryUsageMapSpecifyingInvalidData(n);
            }
            string4 = returnValuesToParametersMemoryUsage.getParamAs_String(0);
            if (returnValuesToParametersMemoryUsage.errorOrExceptionOccurred()) {
                if (printErrorMessagesOn) {
                    Utils.printErrorMessage("Utils.processGCMemoryUsageToMap on behalf of " + string + "." + string2 + "." + string3, "ERROR failure to access memory pool name in returned values");
                }
                return Utils.createMemoryUsageMapSpecifyingInvalidData(n);
            }
            hashMap.put(string4, memoryUsage);
        }
        return hashMap;
    }

    public static Map<String, MemoryUsage> createMemoryUsageMapSpecifyingInvalidData(int n) {
        return null;
    }

    public static GCDetails makeCommandCall0ParametersAndReturnGCDetails(String string, String string2, String string3, Object object) {
        PauseDetails[] pauseDetailsArray2;
        Object object22;
        Map<String, MemoryUsage> map;
        Object object3;
        int n;
        int n2 = 5;
        ObjectGCDetailsReturnedFromCommand objectGCDetailsReturnedFromCommand = Utils.makeCommandCall0ParametersAndCreateGCDetailsReturnObject(string, string2, string3, n2, object);
        if (objectGCDetailsReturnedFromCommand == null) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.makeCommandCall0ParameterAndReturnGCDetails on behalf of " + string + "." + string2 + "." + string3, "EXCEPTION or ERROR: query to wrapped resource failed");
            }
            return null;
        }
        if (objectGCDetailsReturnedFromCommand.isErrorOrExceptionDuringProcessing()) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.makeCommandCall0ParameterAndReturnGCDetails on behalf of " + string + "." + string2 + "." + string3, "EXCEPTION or ERROR: query to wrapped resource failed");
            }
            return null;
        }
        Object[] objectArray = objectGCDetailsReturnedFromCommand.getKeyObjArray();
        Object[] objectArray2 = objectGCDetailsReturnedFromCommand.getValueObjArray();
        ReturnValuesToParametersGCDetails returnValuesToParametersGCDetails = new ReturnValuesToParametersGCDetails();
        int n3 = returnValuesToParametersGCDetails.numberOfExpectedParameters();
        if (TRACE) {
            for (int i = 0; i < objectArray.length; ++i) {
                Utils.printTraceMessage("Utils.makeCommandCall0ParametersAndReturnGCDetails on behalf of " + string + "." + string2 + "." + string3, "key: " + objectArray[i] + " value: " + objectArray2[i]);
            }
        }
        if (objectArray.length != objectArray2.length && printErrorMessagesOn) {
            Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndReturnGCDetails on behalf of " + string + "." + string2 + "." + string3, "ERROR: key length: " + objectArray.length + " value length:" + objectArray2.length);
        }
        if (objectArray.length != n3 && printErrorMessagesOn) {
            Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndReturnGCDetails on behalf of " + string + "." + string2 + "." + string3, "ERROR: expected key length: " + n3 + " returned key length: " + objectArray.length);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(n3);
        for (n = 0; n < n3; ++n) {
            if (!(objectArray[n] instanceof String)) {
                if (!printErrorMessagesOn) break;
                Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndReturnGCDetails on behalf of " + string + "." + string2 + "." + string3, "ERROR: key[" + n + "] is not a String: " + objectArray[n] + " value: " + objectArray2[n]);
                break;
            }
            hashMap.put((String)objectArray[n], objectArray2[n]);
            if (!TRACE) continue;
            Utils.printTraceMessage("Utils.makeCommandCall0ParametersAndReturnGCDetails on behalf of " + string + "." + string2 + "." + string3, "Add to HashMap key: " + objectArray[n] + " value: " + objectArray2[n]);
        }
        for (n = 0; n < n3; ++n) {
            object3 = returnValuesToParametersGCDetails.getReturnValuesToParameters(n).expectedKeyValue();
            if (object3 == null) {
                if (!printErrorMessagesOn) break;
                Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndReturnGCDetails on behalf of " + string + "." + string2 + "." + string3, "ERROR: key[" + n + "] value is null");
                break;
            }
            Object v = hashMap.get(object3);
            if (v == null) {
                if (!printErrorMessagesOn) break;
                Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndReturnGCDetails on behalf of " + string + "." + string2 + "." + string3, "ERROR: key[" + n + "] value of \"" + (String)object3 + "\" not in return values");
                break;
            }
            if (v.getClass() != returnValuesToParametersGCDetails.getReturnValuesToParameters(n).expectedType()) {
                if (!printErrorMessagesOn) break;
                Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndReturnGCDetails on behalf of " + string + "." + string2 + "." + string3, "ERROR: key[" + n + "] with value of \"" + (String)object3 + "\" has type mismatch with value returned. Type is: " + v.getClass() + " and expected type is: " + returnValuesToParametersGCDetails.getReturnValuesToParameters(n).expectedType());
                break;
            }
            returnValuesToParametersGCDetails.setValueObject(n, v);
        }
        if ((map = Utils.processGCMemoryUsageToMap(string, string2, string3, objectGCDetailsReturnedFromCommand.getValueObjArrayMemoryUsageAtStartOfGCKeyArray(), objectGCDetailsReturnedFromCommand.getValueObjArrayMemoryUsageAtStartOfGCValueArray(), objectGCDetailsReturnedFromCommand.getLengthOfMemoryUsageAtStartOfGCValueArray())) == null) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndReturnGCDetails on behalf of " + string + "." + string2 + "." + string3, "ERROR: attempt to allocate Map<String, MemoryUage> failed.");
            }
            return null;
        }
        object3 = new TreeMap<String, MemoryUsage>(map);
        int n4 = 0;
        String[] stringArray = new String[((TreeMap)object3).size()];
        MemoryUsage[] memoryUsageArray = new MemoryUsage[((TreeMap)object3).size()];
        for (Object object22 : ((TreeMap)object3).keySet()) {
            if (TRACE) {
                Utils.printTraceMessage("Utils.makeCommandCall0ParametersAndReturnGCDetails on behalf of " + string + "." + string2 + "." + string3, "Sorted data for return: " + (String)object22 + " " + ((TreeMap)object3).get(object22));
            }
            stringArray[n4] = object22;
            memoryUsageArray[n4] = (MemoryUsage)((TreeMap)object3).get(object22);
            ++n4;
        }
        Map<String, MemoryUsage> map2 = Utils.processGCMemoryUsageToMap(string, string2, string3, objectGCDetailsReturnedFromCommand.getValueObjArrayMemoryUsageAtEndOfGCKeyArray(), objectGCDetailsReturnedFromCommand.getValueObjArrayMemoryUsageAtEndOfGCValueArray(), objectGCDetailsReturnedFromCommand.getLengthOfMemoryUsageAtEndOfGCValueArray());
        if (map2 == null) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndReturnGCDetails on behalf of " + string + "." + string2 + "." + string3, "ERROR: attempt to allocate Map<String, MemoryUage> failed.");
            }
            return null;
        }
        object22 = new TreeMap(map2);
        n4 = 0;
        String[] stringArray2 = new String[((TreeMap)object22).size()];
        MemoryUsage[] memoryUsageArray2 = new MemoryUsage[((TreeMap)object22).size()];
        for (PauseDetails[] pauseDetailsArray2 : ((TreeMap)object22).keySet()) {
            if (TRACE) {
                Utils.printTraceMessage("Utils.makeCommandCall0ParametersAndReturnGCDetails on behalf of " + string + "." + string2 + "." + string3, "Sorted data for return: " + (String)pauseDetailsArray2 + " " + ((TreeMap)object22).get(pauseDetailsArray2));
            }
            stringArray2[n4] = pauseDetailsArray2;
            memoryUsageArray2[n4] = (MemoryUsage)((TreeMap)object22).get(pauseDetailsArray2);
            ++n4;
        }
        PauseDetails[] pauseDetailsArray3 = Utils.processGCPauseDetailsToArray(string, string2, string3, objectGCDetailsReturnedFromCommand.getValueObjArrayGCPauseDetailsKeyArray(), objectGCDetailsReturnedFromCommand.getValueObjArrayGCPauseDetailsValueArray(), objectGCDetailsReturnedFromCommand.getLengthOfGCPauseDetailsValueArray());
        pauseDetailsArray2 = Utils.processGCPauseDetailsToArray(string, string2, string3, objectGCDetailsReturnedFromCommand.getValueObjArrayMaxGCPauseDetailsKeyArray(), objectGCDetailsReturnedFromCommand.getValueObjArrayMaxGCPauseDetailsValueArray(), objectGCDetailsReturnedFromCommand.getLengthOfMaxGCPauseDetailsValueArray());
        double d = returnValuesToParametersGCDetails.getParamAs_double(1);
        double d2 = returnValuesToParametersGCDetails.getParamAs_double(2);
        GCDetails gCDetails = new GCDetails(true, returnValuesToParametersGCDetails.getParamAs_long(0), d, d2, returnValuesToParametersGCDetails.getParamAs_double(3), d2 - d, returnValuesToParametersGCDetails.getParamAs_double(4), returnValuesToParametersGCDetails.getParamAs_String(5), returnValuesToParametersGCDetails.getParamAs_String(6), returnValuesToParametersGCDetails.getParamAs_long(7), returnValuesToParametersGCDetails.getParamAs_long(8), returnValuesToParametersGCDetails.getParamAs_long(9), returnValuesToParametersGCDetails.getParamAs_long(10), returnValuesToParametersGCDetails.getParamAs_long(11), returnValuesToParametersGCDetails.getParamAs_long(12), returnValuesToParametersGCDetails.getParamAs_long(13), returnValuesToParametersGCDetails.getParamAs_boolean(14), returnValuesToParametersGCDetails.getParamAs_boolean(15), returnValuesToParametersGCDetails.getParamAs_double(16), returnValuesToParametersGCDetails.getParamAs_double(17), returnValuesToParametersGCDetails.getParamAs_double(18), returnValuesToParametersGCDetails.getParamAs_double(19), returnValuesToParametersGCDetails.getParamAs_boolean(20), returnValuesToParametersGCDetails.getParamAs_boolean(21), returnValuesToParametersGCDetails.getParamAs_long(22), returnValuesToParametersGCDetails.getParamAs_long(23), returnValuesToParametersGCDetails.getParamAs_boolean(24), returnValuesToParametersGCDetails.getParamAs_long(25), returnValuesToParametersGCDetails.getParamAs_long(26), returnValuesToParametersGCDetails.getParamAs_long(27), returnValuesToParametersGCDetails.getParamAs_double(28), returnValuesToParametersGCDetails.getParamAs_double(29), returnValuesToParametersGCDetails.getParamAs_long(30), returnValuesToParametersGCDetails.getParamAs_long(31), returnValuesToParametersGCDetails.getParamAs_long(32), returnValuesToParametersGCDetails.getParamAs_long(33), returnValuesToParametersGCDetails.getParamAs_long(34), returnValuesToParametersGCDetails.getParamAs_long(35), returnValuesToParametersGCDetails.getParamAs_long(36), returnValuesToParametersGCDetails.getParamAs_long(37), returnValuesToParametersGCDetails.getParamAs_boolean(38), (Map<String, MemoryUsage>)object3, (Map<String, MemoryUsage>)object22, Arrays.asList(pauseDetailsArray3), Arrays.asList(pauseDetailsArray2));
        if (returnValuesToParametersGCDetails.errorOrExceptionOccurred()) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndReturnGCDetails on behalf of " + string + "." + string2 + "." + string3, "ERROR: processing of returned values failed");
            }
            return null;
        }
        return gCDetails;
    }

    private static PauseDetails[] createPauseDetailsArraySpecifyingInvalidData(int n) {
        PauseDetails[] pauseDetailsArray = new PauseDetails[n];
        PauseDetails pauseDetails = new PauseDetails(0.0, 0.0, "InvalidData", 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0L);
        for (int i = 0; i < n; ++i) {
            pauseDetailsArray[i] = pauseDetails;
        }
        return pauseDetailsArray;
    }

    public static PauseDetails[] processGCPauseDetailsToArray(String string, String string2, String string3, Object[] objectArray, Object[] objectArray2, int n) {
        int n2;
        if (objectArray == null || objectArray2 == null) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.processGCPauseDetailsToArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: input values keyArray or ValueArrayArray are null");
            }
            return Utils.createPauseDetailsArraySpecifyingInvalidData(n);
        }
        ReturnValuesToParametersPauseDetails returnValuesToParametersPauseDetails = new ReturnValuesToParametersPauseDetails();
        int n3 = returnValuesToParametersPauseDetails.numberOfExpectedParameters();
        for (n2 = 0; n2 < n3; ++n2) {
            if (objectArray[n2] instanceof String) continue;
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.processGCPauseDetailsToArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: key[" + n2 + "] is not a String: " + objectArray[n2]);
            }
            return Utils.createPauseDetailsArraySpecifyingInvalidData(n);
        }
        if (TRACE) {
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                Utils.printTraceMessage("Utils.processGCPauseDetailsToArray on behalf of " + string + "." + string2 + "." + string3, "GCDetails converting PauseDetails: key: " + objectArray[n2]);
            }
        }
        if (objectArray.length != n3) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.processGCPauseDetailsToArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: expected key length: " + n3 + " returned key length: " + objectArray.length);
            }
            return Utils.createPauseDetailsArraySpecifyingInvalidData(n);
        }
        PauseDetails[] pauseDetailsArray = new PauseDetails[n];
        for (int i = 0; i < n; ++i) {
            int n4;
            if (!objectArray2[i].getClass().isArray()) {
                if (printErrorMessagesOn) {
                    Utils.printErrorMessage("Utils.processGCPauseDetailsToArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: value[" + i + "] with value of \"" + objectArray2[i].getClass() + "\" has a type mismatch with expected Object[] type.");
                }
                return Utils.createPauseDetailsArraySpecifyingInvalidData(n);
            }
            Object[] objectArray3 = (Object[])objectArray2[i];
            if (objectArray.length != objectArray3.length) {
                if (printErrorMessagesOn) {
                    Utils.printErrorMessage("Utils.processGCPauseDetailsToArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: mismatch between key length: " + objectArray.length + " and value length:" + objectArray3.length);
                }
                return Utils.createPauseDetailsArraySpecifyingInvalidData(n);
            }
            if (TRACE) {
                for (int j = 0; j < objectArray.length; ++j) {
                    Utils.printTraceMessage("Utils.processGCPauseDetailsToArray on behalf of " + string + "." + string2 + "." + string3, "key: " + objectArray[j] + " value: " + objectArray3[j]);
                }
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(n3);
            for (n4 = 0; n4 < n3; ++n4) {
                hashMap.put((String)objectArray[n4], objectArray3[n4]);
                if (!TRACE) continue;
                Utils.printTraceMessage("Utils.processGCPauseDetailsToArray on behalf of " + string + "." + string2 + "." + string3, "Add to HashMap key: " + objectArray[n4] + " value: " + objectArray3[n4]);
            }
            for (n4 = 0; n4 < n3; ++n4) {
                String string4 = returnValuesToParametersPauseDetails.getReturnValuesToParameters(n4).expectedKeyValue();
                if (string4 == null) {
                    if (printErrorMessagesOn) {
                        Utils.printErrorMessage("Utils.processGCPauseDetailsToArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: key[" + n4 + "] value is null");
                    }
                    return Utils.createPauseDetailsArraySpecifyingInvalidData(n);
                }
                Object v = hashMap.get(string4);
                if (v == null) {
                    if (printErrorMessagesOn) {
                        Utils.printErrorMessage("Utils.processGCPauseDetailsToArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: key[" + n4 + "] value of \"" + string4 + "\" not in return values");
                    }
                    return Utils.createPauseDetailsArraySpecifyingInvalidData(n);
                }
                if (v.getClass() != returnValuesToParametersPauseDetails.getReturnValuesToParameters(n4).expectedType()) {
                    if (printErrorMessagesOn) {
                        Utils.printErrorMessage("Utils.processGCPauseDetailsToArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: key[" + n4 + "] with value of \"" + string4 + "\" has type mismatch with value returned. Type is: " + v.getClass() + " and expected type is: " + returnValuesToParametersPauseDetails.getReturnValuesToParameters(n4).expectedType());
                    }
                    return Utils.createPauseDetailsArraySpecifyingInvalidData(n);
                }
                returnValuesToParametersPauseDetails.setValueObject(n4, v);
            }
            PauseDetails pauseDetails = new PauseDetails(returnValuesToParametersPauseDetails.getParamAs_double(0), returnValuesToParametersPauseDetails.getParamAs_double(1), returnValuesToParametersPauseDetails.getParamAs_String(2), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0L);
            if (returnValuesToParametersPauseDetails.errorOrExceptionOccurred()) {
                if (printErrorMessagesOn) {
                    Utils.printErrorMessage("Utils.processGCPauseDetailsToArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: failure to create PauseDetails object using returned values");
                }
                return Utils.createPauseDetailsArraySpecifyingInvalidData(n);
            }
            pauseDetailsArray[i] = pauseDetails;
        }
        return pauseDetailsArray;
    }

    public static PauseDetails[] makeCommandCall0ParametersAndReturnPauseDetailsArray(String string, String string2, String string3) {
        int n = 1;
        int n2 = 4;
        int n3 = 3;
        ObjectComplexReturnedFromCommand objectComplexReturnedFromCommand = Utils.makeCommandCall0ParametersAndCreateComplexReturnObject(string, string2, string3, n, n2, n3, null);
        if (objectComplexReturnedFromCommand == null || objectComplexReturnedFromCommand.isErrorOrExceptionDuringProcessing()) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.makeCommandCall0ParameterAndReturnPauseDetailsArray on behalf of " + string + "." + string2 + "." + string3, "EXCEPTION or ERROR: query to wrapped resource failed");
            }
            return Utils.createPauseDetailsArraySpecifyingInvalidData(n2);
        }
        Object[] objectArray = objectComplexReturnedFromCommand.getKeyObjArray(0);
        Object[] objectArray2 = objectComplexReturnedFromCommand.getValueObjArray();
        PauseDetails[] pauseDetailsArray = Utils.processGCPauseDetailsToArray(string, string2, string3, objectArray, objectArray2, objectComplexReturnedFromCommand.getExpectedNumberOfMessageReturnValues());
        return pauseDetailsArray;
    }

    public static NativeMemoryManagerDesc[] processNativeMemoryManagerDescArray(String string, String string2, String string3, Object[] objectArray, Object[] objectArray2, int n) {
        int n2;
        if (objectArray == null || objectArray2 == null) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.processNativeMemoryManagerDescArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: input values keyArray or ValueArrayArray are null");
            }
            return _nativeMemoryManagerDescArraySpecifyingInvalidData;
        }
        ReturnValuesToParametersNativeMemoryManagerDesc returnValuesToParametersNativeMemoryManagerDesc = new ReturnValuesToParametersNativeMemoryManagerDesc();
        int n3 = returnValuesToParametersNativeMemoryManagerDesc.numberOfExpectedParameters();
        for (n2 = 0; n2 < n3; ++n2) {
            if (objectArray[n2] instanceof String) continue;
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.processNativeMemoryManagerDescArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: key[" + n2 + "] is not a String: " + objectArray[n2]);
            }
            return _nativeMemoryManagerDescArraySpecifyingInvalidData;
        }
        if (TRACE) {
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                Utils.printTraceMessage("Utils.processNativeMemoryManagerDescArray on behalf of " + string + "." + string2 + "." + string3, "key: " + objectArray[n2]);
            }
        }
        if (objectArray.length != n3) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.processNativeMemoryManagerDescArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: expected key length: " + n3 + " returned key length: " + objectArray.length);
            }
            return _nativeMemoryManagerDescArraySpecifyingInvalidData;
        }
        NativeMemoryManagerDesc[] nativeMemoryManagerDescArray = new NativeMemoryManagerDesc[n];
        for (int i = 0; i < n; ++i) {
            int n4;
            if (!objectArray2[i].getClass().isArray()) {
                if (printErrorMessagesOn) {
                    Utils.printErrorMessage("Utils.processNativeMemoryManagerDescArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: value[" + i + "] with value of \"" + objectArray2[i].getClass() + "\" has a type mismatch with expected Object[] type.");
                }
                return _nativeMemoryManagerDescArraySpecifyingInvalidData;
            }
            Object[] objectArray3 = (Object[])objectArray2[i];
            if (objectArray.length != objectArray3.length) {
                if (printErrorMessagesOn) {
                    Utils.printErrorMessage("Utils.processNativeMemoryManagerDescArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: mismatch between key length: " + objectArray.length + " and value length:" + objectArray3.length);
                }
                return _nativeMemoryManagerDescArraySpecifyingInvalidData;
            }
            if (TRACE) {
                for (int j = 0; j < objectArray.length; ++j) {
                    Utils.printTraceMessage("Utils.processNativeMemoryManagerDescArray on behalf of " + string + "." + string2 + "." + string3, "key: " + objectArray[j] + " value: " + objectArray3[j]);
                }
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(n3);
            for (n4 = 0; n4 < n3; ++n4) {
                hashMap.put((String)objectArray[n4], objectArray3[n4]);
                if (!TRACE) continue;
                Utils.printTraceMessage("Utils.processNativeMemoryManagerDescArray on behalf of " + string + "." + string2 + "." + string3, "Add to HashMap key: " + objectArray[n4] + " value: " + objectArray3[n4]);
            }
            for (n4 = 0; n4 < n3; ++n4) {
                String string4 = returnValuesToParametersNativeMemoryManagerDesc.getReturnValuesToParameters(n4).expectedKeyValue();
                if (string4 == null) {
                    if (printErrorMessagesOn) {
                        Utils.printErrorMessage("Utils.processNativeMemoryManagerDescArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: key[" + n4 + "] value is null");
                    }
                    return _nativeMemoryManagerDescArraySpecifyingInvalidData;
                }
                Object v = hashMap.get(string4);
                if (v == null) {
                    if (printErrorMessagesOn) {
                        Utils.printErrorMessage("Utils.processNativeMemoryManagerDescArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: key[" + n4 + "] value of \"" + string4 + "\" not in return values");
                    }
                    return _nativeMemoryManagerDescArraySpecifyingInvalidData;
                }
                if (v.getClass() != returnValuesToParametersNativeMemoryManagerDesc.getReturnValuesToParameters(n4).expectedType()) {
                    if (printErrorMessagesOn) {
                        Utils.printErrorMessage("Utils.processNativeMemoryManagerDescArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: key[" + n4 + "] with value of \"" + string4 + "\" has type mismatch with value returned. Type is: " + v.getClass() + " and expected type is: " + returnValuesToParametersNativeMemoryManagerDesc.getReturnValuesToParameters(n4).expectedType());
                    }
                    return _nativeMemoryManagerDescArraySpecifyingInvalidData;
                }
                returnValuesToParametersNativeMemoryManagerDesc.setValueObject(n4, v);
            }
            NativeMemoryManagerDesc nativeMemoryManagerDesc = new NativeMemoryManagerDesc(returnValuesToParametersNativeMemoryManagerDesc.getParamAs_String(0), returnValuesToParametersNativeMemoryManagerDesc.getParamAs_int(1), returnValuesToParametersNativeMemoryManagerDesc.getParamAs_boolean(2));
            if (returnValuesToParametersNativeMemoryManagerDesc.errorOrExceptionOccurred()) {
                if (printErrorMessagesOn) {
                    Utils.printErrorMessage("Utils.processNativeMemoryManagerDescArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: failure to create NativeMemoryManagerDesc object using returned values");
                }
                return _nativeMemoryManagerDescArraySpecifyingInvalidData;
            }
            nativeMemoryManagerDescArray[i] = nativeMemoryManagerDesc;
        }
        return nativeMemoryManagerDescArray;
    }

    public static NativeMemoryManagerDesc[] makeCommandCall0ParametersAndReturnNativeMemoryManagerDescArray(String string, String string2, String string3) {
        int n = 1;
        int n2 = -1;
        int n3 = 3;
        ObjectComplexReturnedFromCommand objectComplexReturnedFromCommand = Utils.makeCommandCall0ParametersAndCreateComplexReturnObject(string, string2, string3, n, n2, n3, null);
        if (objectComplexReturnedFromCommand == null || objectComplexReturnedFromCommand.isErrorOrExceptionDuringProcessing()) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndReturnNativeMemoryManagerDescArray on behalf of " + string + "." + string2 + "." + string3, "EXCEPTION or ERROR: query to wrapped resource failed");
            }
            return _nativeMemoryManagerDescArraySpecifyingInvalidData;
        }
        Object[] objectArray = objectComplexReturnedFromCommand.getKeyObjArray(0);
        Object[] objectArray2 = objectComplexReturnedFromCommand.getValueObjArray();
        NativeMemoryManagerDesc[] nativeMemoryManagerDescArray = Utils.processNativeMemoryManagerDescArray(string, string2, string3, objectArray, objectArray2, objectComplexReturnedFromCommand.getExpectedNumberOfMessageReturnValues());
        return nativeMemoryManagerDescArray;
    }

    public static NativeMemoryPoolDesc[] processNativeMemoryPoolDescArray(String string, String string2, String string3, Object[] objectArray, Object[] objectArray2, int n) {
        int n2;
        if (objectArray == null || objectArray2 == null) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.processNativeMemoryPoolDescArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: input values keyArray or ValueArrayArray are null");
            }
            return _nativeMemoryPoolDescArraySpecifyingInvalidData;
        }
        ReturnValuesToParametersNativeMemoryPoolDesc returnValuesToParametersNativeMemoryPoolDesc = new ReturnValuesToParametersNativeMemoryPoolDesc();
        int n3 = returnValuesToParametersNativeMemoryPoolDesc.numberOfExpectedParameters();
        for (n2 = 0; n2 < n3; ++n2) {
            if (objectArray[n2] instanceof String) continue;
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.processNativeMemoryPoolDescArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: key[" + n2 + "] is not a String: " + objectArray[n2]);
            }
            return _nativeMemoryPoolDescArraySpecifyingInvalidData;
        }
        if (TRACE) {
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                Utils.printTraceMessage("Utils.processNativeMemoryPoolDescArray on behalf of " + string + "." + string2 + "." + string3, "key: " + objectArray[n2]);
            }
        }
        if (objectArray.length != n3) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.processNativeMemoryPoolDescArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: expected key length: " + n3 + " returned key length: " + objectArray.length);
            }
            return _nativeMemoryPoolDescArraySpecifyingInvalidData;
        }
        NativeMemoryPoolDesc[] nativeMemoryPoolDescArray = new NativeMemoryPoolDesc[n];
        for (int i = 0; i < n; ++i) {
            int n4;
            if (!objectArray2[i].getClass().isArray()) {
                if (printErrorMessagesOn) {
                    Utils.printErrorMessage("Utils.processNativeMemoryPoolDescArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: value[" + i + "] with value of \"" + objectArray2[i].getClass() + "\" has a type mismatch with expected Object[] type.");
                }
                return _nativeMemoryPoolDescArraySpecifyingInvalidData;
            }
            Object[] objectArray3 = (Object[])objectArray2[i];
            if (objectArray.length != objectArray3.length) {
                if (printErrorMessagesOn) {
                    Utils.printErrorMessage("Utils.processNativeMemoryPoolDescArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: mismatch between key length: " + objectArray.length + " and value length:" + objectArray3.length);
                }
                return _nativeMemoryPoolDescArraySpecifyingInvalidData;
            }
            if (TRACE) {
                for (int j = 0; j < objectArray.length; ++j) {
                    Utils.printTraceMessage("Utils.processNativeMemoryPoolDescArray on behalf of " + string + "." + string2 + "." + string3, "key: " + objectArray[j] + " value: " + objectArray3[j]);
                }
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(n3);
            for (n4 = 0; n4 < n3; ++n4) {
                hashMap.put((String)objectArray[n4], objectArray3[n4]);
                if (!TRACE) continue;
                Utils.printTraceMessage("Utils.processNativeMemoryPoolDescArray on behalf of " + string + "." + string2 + "." + string3, "Add to HashMap key: " + objectArray[n4] + " value: " + objectArray3[n4]);
            }
            for (n4 = 0; n4 < n3; ++n4) {
                String string4 = returnValuesToParametersNativeMemoryPoolDesc.getReturnValuesToParameters(n4).expectedKeyValue();
                if (string4 == null) {
                    if (printErrorMessagesOn) {
                        Utils.printErrorMessage("Utils.processNativeMemoryPoolDescArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: key[" + n4 + "] value is null");
                    }
                    return _nativeMemoryPoolDescArraySpecifyingInvalidData;
                }
                Object v = hashMap.get(string4);
                if (v != null && v.getClass() != returnValuesToParametersNativeMemoryPoolDesc.getReturnValuesToParameters(n4).expectedType()) {
                    if (printErrorMessagesOn) {
                        Utils.printErrorMessage("Utils.processNativeMemoryPoolDescArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: key[" + n4 + "] with value of \"" + string4 + "\" has type mismatch with value returned. Type is: " + v.getClass() + " and expected type is: " + returnValuesToParametersNativeMemoryPoolDesc.getReturnValuesToParameters(n4).expectedType());
                    }
                    return _nativeMemoryPoolDescArraySpecifyingInvalidData;
                }
                returnValuesToParametersNativeMemoryPoolDesc.setValueObject(n4, v);
            }
            NativeMemoryPoolDesc nativeMemoryPoolDesc = new NativeMemoryPoolDesc(returnValuesToParametersNativeMemoryPoolDesc.getParamAs_String(0), MemoryType.enumValue(returnValuesToParametersNativeMemoryPoolDesc.getParamAs_int(1)), returnValuesToParametersNativeMemoryPoolDesc.getParamAs_String_unchecked(2), returnValuesToParametersNativeMemoryPoolDesc.getParamAs_StringArray_unchecked(3), returnValuesToParametersNativeMemoryPoolDesc.getParamAs_boolean(4), returnValuesToParametersNativeMemoryPoolDesc.getParamAs_boolean(5), returnValuesToParametersNativeMemoryPoolDesc.getParamAs_boolean(6));
            if (returnValuesToParametersNativeMemoryPoolDesc.errorOrExceptionOccurred()) {
                if (printErrorMessagesOn) {
                    Utils.printErrorMessage("Utils.processNativeMemoryPoolDescArray on behalf of " + string + "." + string2 + "." + string3, "ERROR: failure to create NativeMemoryPoolDesc object using returned values");
                }
                return _nativeMemoryPoolDescArraySpecifyingInvalidData;
            }
            nativeMemoryPoolDescArray[i] = nativeMemoryPoolDesc;
        }
        return nativeMemoryPoolDescArray;
    }

    public static NativeMemoryPoolDesc[] makeCommandCall0ParametersAndReturnNativeMemoryPoolDescArray(String string, String string2, String string3) {
        int n = 1;
        int n2 = -1;
        int n3 = 7;
        ObjectComplexReturnedFromCommand objectComplexReturnedFromCommand = Utils.makeCommandCall0ParametersAndCreateComplexReturnObject(string, string2, string3, n, n2, n3, null);
        if (objectComplexReturnedFromCommand == null || objectComplexReturnedFromCommand.isErrorOrExceptionDuringProcessing()) {
            if (printErrorMessagesOn) {
                Utils.printErrorMessage("Utils.makeCommandCall0ParametersAndReturnNativeMemoryPoolDescArray on behalf of " + string + "." + string2 + "." + string3, "EXCEPTION or ERROR: query to wrapped resource failed");
            }
            return _nativeMemoryPoolDescArraySpecifyingInvalidData;
        }
        Object[] objectArray = objectComplexReturnedFromCommand.getKeyObjArray(0);
        Object[] objectArray2 = objectComplexReturnedFromCommand.getValueObjArray();
        NativeMemoryPoolDesc[] nativeMemoryPoolDescArray = Utils.processNativeMemoryPoolDescArray(string, string2, string3, objectArray, objectArray2, objectComplexReturnedFromCommand.getExpectedNumberOfMessageReturnValues());
        return nativeMemoryPoolDescArray;
    }
}

