/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.internal.management;

import com.azul.zing.internal.management.ExceptionHandler;
import com.azul.zing.internal.management.Utils;
import java.security.AccessController;
import java.security.PrivilegedAction;

class ObjectReturnedFromCommand {
    public static final boolean TRACE = ObjectReturnedFromCommand.checkTraceProperty();
    public static boolean printErrorMessagesOn = true;
    public static final String namespaceString = "namespace";
    public static final String objectTypeString = "objectType";
    public static final String objectString = "object";
    public static final String messageString = "message";
    public static final String parameterCountString = "parameterCount";
    protected static final int _numberOfReturnObjArrayMetaDataElements = 2;
    protected static final int _numberOfReturnObjArrayEntriesPerReturnValue = 2;
    protected String _objectType = null;
    protected String _objectName = null;
    protected String _messageName = null;
    protected int _expectedNumberOfMessageReturnValues = 0;
    protected int _numberOfMessageReturnValues = 0;
    protected Object[] _returnObjArray = null;
    protected int _lengthOfReturnObjArray = 0;
    protected Exception _exceptionPassedBackFromCommand = null;
    protected boolean _isExceptionPassedBackFromCommand = false;
    protected boolean _isErrorDuringProcessing = true;
    protected boolean _isExceptionDuringProcessing = false;
    private static final String ObjectReturnedFromCommand_init = "ObjectReturnedFromCommand.init";
    private static final String ObjectReturnedFromCommand_getReturnedObject = "ObjectReturnedFromCommand.getReturnedObject";
    private static final String ObjectReturnedFromCommand_getReturnedElementAsInt = "ObjectReturnedFromCommand.getReturnedElementAsInt";
    private static final String ObjectReturnedFromCommand_getReturnedElementAsLong = "ObjectReturnedFromCommand.getReturnedElementAsLong";
    private static final String ObjectReturnedFromCommand_getReturnedElementAsDouble = "ObjectReturnedFromCommand.getReturnedElementAsDouble";
    private static final String ObjectReturnedFromCommand_getReturnedElementAsBoolean = "ObjectReturnedFromCommand.getReturnedElementAsBoolean";

    private static boolean checkTraceProperty() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    return System.getProperty("com.azul.zing.internal.management.object.trace") != null;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        });
    }

    public Exception getExceptionPassedBackFromCommand() {
        return this._exceptionPassedBackFromCommand;
    }

    public boolean isExceptionPassedBackFromCommand() {
        if (this._isExceptionPassedBackFromCommand) {
            if (Utils.printErrorMessagesOn) {
                Utils.printErrorMessage(this._objectType + "." + this._objectName + "." + this._messageName, "EXCEPTION during processing of the Command");
            }
            return true;
        }
        return false;
    }

    public boolean isErrorDuringProcessing() {
        return this._isErrorDuringProcessing;
    }

    public boolean isExceptionDuringProcessing() {
        return this._isExceptionDuringProcessing;
    }

    public boolean isErrorOrExceptionDuringProcessing() {
        if (this._isErrorDuringProcessing || this._isExceptionDuringProcessing) {
            if (Utils.printErrorMessagesOn) {
                Utils.printErrorMessage(this._objectType + "." + this._objectName + "." + this._messageName, "EXCEPTION or ERROR occurred while processing command");
            }
            return true;
        }
        return false;
    }

    public Object[] getReturnObjArray() {
        return this._returnObjArray;
    }

    public long getLlengthOfReturnObjArray() {
        return this._lengthOfReturnObjArray;
    }

    public int getExpectedNumberOfMessageReturnValues() {
        return this._expectedNumberOfMessageReturnValues;
    }

    public String getObjectType() {
        return this._objectType;
    }

    public String getObjectName() {
        return this._objectName;
    }

    public String getMessageName() {
        return this._messageName;
    }

    public ObjectReturnedFromCommand(String string, String string2, String string3, Object object, int n, int n2) {
        if (string == null) {
            if (Utils.printErrorMessagesOn) {
                Utils.printErrorMessage(ObjectReturnedFromCommand_init, "First parameter, the Object type is null");
            }
            return;
        }
        this._objectType = string;
        if (string2 == null) {
            if (Utils.printErrorMessagesOn) {
                Utils.printErrorMessage(ObjectReturnedFromCommand_init, "Second parameter, the Object name is null");
            }
            return;
        }
        this._objectName = string2;
        if (string3 == null) {
            if (Utils.printErrorMessagesOn) {
                Utils.printErrorMessage(ObjectReturnedFromCommand_init, "Third parameter, the Message name is null");
            }
            return;
        }
        this._messageName = string3;
        if (object == null) {
            if (Utils.printErrorMessagesOn) {
                Utils.printErrorMessage(ObjectReturnedFromCommand_init, "Fourth parameter, value of the return Object from the command is null");
            }
            return;
        }
        if (!(object instanceof Object[])) {
            if (Utils.printErrorMessagesOn) {
                Utils.printErrorMessage(ObjectReturnedFromCommand_init, "Fourth parameter, type of the return Object from the command must be an Object[]");
            }
            return;
        }
        this._returnObjArray = (Object[])object;
        this._lengthOfReturnObjArray = this._returnObjArray.length;
        if (this._lengthOfReturnObjArray < n2) {
            if (Utils.printErrorMessagesOn) {
                Utils.printErrorMessage(ObjectReturnedFromCommand_init, "Type of the return Object from the command must be an Object[] with at least " + n2 + " elements");
            }
            return;
        }
        if (this._returnObjArray[0] != null) {
            if (Utils.printErrorMessagesOn) {
                System.out.println("ObjectReturnedFromCommand.init: Return Object[0] points to an object");
            }
            if (!(this._returnObjArray[0] instanceof Exception)) {
                Utils.printErrorMessage(ObjectReturnedFromCommand_init, "Return Object[0] indicates exception occurred but is an object that has a type other than java.lang.Exception");
                return;
            }
            Utils.printErrorMessage(ObjectReturnedFromCommand_init, "Exception encountered during processing of the request for Zing monitoring and management information.");
            ExceptionHandler.printDetailsOfRuntimeException(string, string2, string3, ObjectReturnedFromCommand_init, (Exception)this._returnObjArray[0]);
            this._exceptionPassedBackFromCommand = (Exception)this._returnObjArray[0];
            this._isExceptionPassedBackFromCommand = true;
            this._isExceptionDuringProcessing = true;
            return;
        }
        if (!(this._returnObjArray[1] instanceof Long)) {
            if (Utils.printErrorMessagesOn) {
                Utils.printErrorMessage(ObjectReturnedFromCommand_init, "Return ObjArray[1] must be an instance of java.lang.Long");
            }
            return;
        }
        long l = (Long)this._returnObjArray[1];
        if (Utils.TRACE) {
            System.out.println("Number of message return values: " + l);
        }
        if (l > Integer.MAX_VALUE) {
            if (Utils.printErrorMessagesOn) {
                Utils.printErrorMessage(ObjectReturnedFromCommand_init, "Number of return values exceeds the maximum: 2147483647; value is: " + l);
            }
            return;
        }
        int n3 = (int)l;
        if (n == -1) {
            n = n3;
        }
        this._numberOfMessageReturnValues = n;
        this._expectedNumberOfMessageReturnValues = n;
        this._isErrorDuringProcessing = false;
    }

    public Object getReturnedObject(int n) {
        int n2;
        if (this.isErrorOrExceptionDuringProcessing()) {
            if (Utils.printErrorMessagesOn) {
                Utils.printErrorMessage(ObjectReturnedFromCommand_getReturnedObject, "EXCEPTION or ERROR occurred during previous processing - not passing precondition check on method entry");
            }
            return null;
        }
        if (n < 1 || n > this._expectedNumberOfMessageReturnValues) {
            if (Utils.printErrorMessagesOn) {
                Utils.printErrorMessage(ObjectReturnedFromCommand_getReturnedElementAsLong, "Requested return value: " + n + " is either less than the minimum of 1 or greater than the maximum: " + (this._lengthOfReturnObjArray - 2));
            }
            this._isErrorDuringProcessing = true;
            return null;
        }
        if (TRACE) {
            System.out.println("ObjectReturnedFromCommand.getReturnedObjectnumberOfTheReturnValue: " + n);
            System.out.println(this.toString());
        }
        if (this._returnObjArray[n2 = n * 2 + 2 - 1] == null) {
            Utils.printErrorMessage(ObjectReturnedFromCommand_getReturnedObject, "For the return object: " + n + " The corresponding element in the returnObjArray has an index of: " + n2 + " that accesses a null entry in the returnObjArray");
            this._isErrorDuringProcessing = true;
            return null;
        }
        return this._returnObjArray[n2];
    }

    public int getReturnedElementAsInt(int n) {
        Object object = this.getReturnedObject(n);
        if (this.isErrorOrExceptionDuringProcessing()) {
            if (Utils.printErrorMessagesOn) {
                Utils.printErrorMessage(ObjectReturnedFromCommand_getReturnedElementAsInt, "EXCEPTION or ERROR occurred during previous processing - not passing precondition check on method entry");
            }
            return 0;
        }
        if (!(object instanceof Integer)) {
            if (Utils.VERBOSE_MODE) {
                Utils.printErrorMessage(ObjectReturnedFromCommand_getReturnedElementAsInt, "Return value: " + n + " must be type java.lang.Integer");
            }
            this._isErrorDuringProcessing = true;
            return 0;
        }
        int n2 = (Integer)object;
        if (TRACE) {
            System.out.println("ObjectReturnedFromCommand.getReturnedElementAsInt returning: " + n2);
        }
        return n2;
    }

    public long getReturnedElementAsLong(int n) {
        Object object = this.getReturnedObject(n);
        if (this.isErrorOrExceptionDuringProcessing()) {
            if (Utils.printErrorMessagesOn) {
                Utils.printErrorMessage(ObjectReturnedFromCommand_getReturnedElementAsLong, "EXCEPTION or ERROR occurred during previous processing - not passing precondition check on method entry");
            }
            return 0L;
        }
        if (!(object instanceof Long)) {
            if (Utils.printErrorMessagesOn) {
                Utils.printErrorMessage(ObjectReturnedFromCommand_getReturnedElementAsLong, "Return value: " + n + " must be type java.lang.Long");
            }
            this._isErrorDuringProcessing = true;
            return 0L;
        }
        long l = (Long)object;
        if (TRACE) {
            System.out.println("ObjectReturnedFromCommand.getReturnedElementAsLong returning: " + l);
        }
        return l;
    }

    public double getReturnedElementAsDouble(int n) {
        Object object = this.getReturnedObject(n);
        if (this.isErrorOrExceptionDuringProcessing()) {
            if (Utils.printErrorMessagesOn) {
                Utils.printErrorMessage(ObjectReturnedFromCommand_getReturnedElementAsDouble, "EXCEPTION or ERROR occurred during previous processing - not passing precondition check on method entry");
            }
            return 0.0;
        }
        if (!(object instanceof Double)) {
            if (Utils.printErrorMessagesOn) {
                Utils.printErrorMessage(ObjectReturnedFromCommand_getReturnedElementAsDouble, "Return value: " + n + " must be type java.lang.Double");
            }
            this._isErrorDuringProcessing = true;
            return 0.0;
        }
        double d = (Double)object;
        if (TRACE) {
            System.out.println("ObjectReturnedFromCommand.getReturnedElementAsDouble returning: " + d);
        }
        return d;
    }

    public boolean getReturnedElementAsBoolean(int n) {
        Object object = this.getReturnedObject(n);
        if (this.isErrorOrExceptionDuringProcessing()) {
            if (Utils.printErrorMessagesOn) {
                Utils.printErrorMessage(ObjectReturnedFromCommand_getReturnedElementAsBoolean, "EXCEPTION or ERROR occurred during previous processing - not passing precondition check on method entry");
            }
            this._isErrorDuringProcessing = true;
            return false;
        }
        if (!(object instanceof Boolean)) {
            if (Utils.printErrorMessagesOn) {
                Utils.printErrorMessage(ObjectReturnedFromCommand_getReturnedElementAsBoolean, "Return value: " + n + " must be type java.lang.Boolean");
            }
            this._isErrorDuringProcessing = true;
            return false;
        }
        boolean bl = (Boolean)object;
        if (TRACE) {
            System.out.println("ObjectReturnedFromCommand.getReturnedElementAsBoolean returning: " + bl);
        }
        return bl;
    }

    public String toString() {
        return "ObjectReturnedFromCommand:\n_objectType = " + this._objectType + "\n_objectName = " + this._objectName + "\n_messageName = " + this._messageName + "\n_expectedNumberOfMessageReturnValues = " + this._expectedNumberOfMessageReturnValues + "\n_numberOfMessageReturnValues = " + this._numberOfMessageReturnValues + "\n_lengthOfReturnObjArray = " + this._lengthOfReturnObjArray + "\n_exceptionPassedBackFromCommand = " + this._exceptionPassedBackFromCommand + "\n_isExceptionPassedBackFromCommand = " + this._isExceptionPassedBackFromCommand + "\n_isErrorDuringProcessing = " + this._isErrorDuringProcessing + "\n_isExceptionDuringProcessing = " + this._isExceptionDuringProcessing;
    }
}

