/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.internal.management;

import com.azul.zing.internal.management.ExceptionHandler;
import com.azul.zing.internal.management.Utils;
import com.azul.zing.management.MemoryPoolSizeType;
import com.azul.zing.management.MemoryUsage;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class MemoryPoolMXBeanInternal {
    private static final String objectType = "Pool";
    private static final String dateTimeFormatString = "EEE MMM dd HH:mm:ss.SSS zzz yyyy";
    static final String MemoryPoolMXBeanInternal_convertToMemoryUsage = "MemoryPoolMXBeanInternal.convertToMemoryUsage";

    public MemoryUsage getCurrentMemoryUsage(String string) {
        MemoryUsage memoryUsage = null;
        try {
            memoryUsage = Utils.makeCommandCall0ParametersAndReturnMemoryUsage(objectType, string, "getCurrentUsage", null);
        }
        catch (Exception exception) {
            StackTraceElement[] stackTraceElementArray;
            long l = System.currentTimeMillis();
            Date date = new Date(l);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateTimeFormatString);
            System.err.println("com.azul.zing.management: Exception encountered during processing --------------------------");
            System.err.println("com.azul.zing.management: Exception time:    " + simpleDateFormat.format(date));
            System.err.println("com.azul.zing.management: Exception cause:   " + exception.getCause());
            System.err.println("com.azul.zing.management: Exception message: " + exception.getMessage());
            for (StackTraceElement stackTraceElement : stackTraceElementArray = exception.getStackTrace()) {
                System.err.println("com.azul.zing.management: Stack trace:   " + stackTraceElement.toString());
            }
        }
        return memoryUsage;
    }

    public MemoryPoolSizeType getMemoryPoolSizeType(String string) {
        MemoryUsage memoryUsage = this.getCurrentMemoryUsage(string);
        if (memoryUsage == null) {
            return MemoryPoolSizeType.enumValue(0L);
        }
        return memoryUsage.getMemoryPoolSizeType();
    }

    public long getCurrentUse(String string) {
        MemoryUsage memoryUsage = this.getCurrentMemoryUsage(string);
        if (memoryUsage == null) {
            return 0L;
        }
        return memoryUsage.getUsed();
    }

    public long getCurrentSize(String string) {
        MemoryUsage memoryUsage = this.getCurrentMemoryUsage(string);
        if (memoryUsage == null) {
            return 0L;
        }
        return memoryUsage.getSize();
    }

    public long getInitialReserved(String string) {
        MemoryUsage memoryUsage = this.getCurrentMemoryUsage(string);
        if (memoryUsage == null) {
            return 0L;
        }
        return memoryUsage.getInitialReserved();
    }

    public MemoryUsage getPeakUsage(String string) {
        return Utils.makeCommandCall0ParametersAndReturnMemoryUsage(objectType, string, "getPeakUsage", null);
    }

    public double resetPeakUsage(String string) {
        return Utils.makeCommandCall0ParametersAndReturnDouble(objectType, string, "resetPeakUsage");
    }

    public double getTimeOfLastResetPeakUsageSec(String string) {
        return Utils.makeCommandCall0ParametersAndReturnDouble(objectType, string, "getTimeOfLastResetPeakUsageSec");
    }

    public MemoryUsage getStartOfCollectionUsage(String string) {
        return Utils.makeCommandCall0ParametersAndReturnMemoryUsage(objectType, string, "getStartOfCollectionUsage", null);
    }

    public MemoryUsage getEndOfCollectionUsage(String string) {
        return Utils.makeCommandCall0ParametersAndReturnMemoryUsage(objectType, string, "getEndOfCollectionUsage", null);
    }

    public MemoryUsage getPeakEndOfCollectionUsage(String string) {
        return Utils.makeCommandCall0ParametersAndReturnMemoryUsage(objectType, string, "getPeakEndOfCollectionUsage", null);
    }

    public double resetPeakEndOfCollectionUsage(String string) {
        return Utils.makeCommandCall0ParametersAndReturnDouble(objectType, string, "resetPeakEndOfCollectionUsage");
    }

    public double getTimeOfLastResetPeakEndOfCollectionUsageSec(String string) {
        return Utils.makeCommandCall0ParametersAndReturnDouble(objectType, string, "getTimeOfLastResetPeakEndOfCollectionUsageSec");
    }

    public boolean isValid(String string) {
        return Utils.makeCommandCall0ParametersAndReturnBoolean(objectType, string, "isValid");
    }

    public boolean isAfterCollectionUseThresholdSupported(String string) {
        return Utils.makeCommandCall0ParametersAndReturnBoolean(objectType, string, "isAfterCollectionUseThresholdSupported");
    }

    public boolean setAfterCollectionUseThreshold(String string, long l) {
        return Utils.makeCommandCall1LongParameterAndReturnBoolean(objectType, string, "setAfterCollectionUseThreshold", "threshold", l);
    }

    public long getAfterCollectionUseThreshold(String string) {
        return Utils.makeCommandCall0ParametersAndReturnLong(objectType, string, "getAfterCollectionUseThreshold");
    }

    public long getAfterCollectionUseThresholdExceededCount(String string) {
        return Utils.makeCommandCall0ParametersAndReturnLong(objectType, string, "getAfterCollectionUseThresholdExceededCount");
    }

    public boolean isAfterCollectionUseThresholdExceeded(String string) {
        return Utils.makeCommandCall0ParametersAndReturnBoolean(objectType, string, "isAfterCollectionUseThresholdExceeded");
    }

    public boolean isUseThresholdSupported(String string) {
        return Utils.makeCommandCall0ParametersAndReturnBoolean(objectType, string, "isUseThresholdSupported");
    }

    public boolean setUseThreshold(String string, long l) {
        return Utils.makeCommandCall1LongParameterAndReturnBoolean(objectType, string, "setUseThreshold", "threshold", l);
    }

    public long getUseThreshold(String string) {
        return Utils.makeCommandCall0ParametersAndReturnLong(objectType, string, "getUseThreshold");
    }

    public long getUseThresholdExceededCount(String string) {
        return Utils.makeCommandCall0ParametersAndReturnLong(objectType, string, "getUseThresholdExceededCount");
    }

    public boolean isUseThresholdExceeded(String string) {
        return Utils.makeCommandCall0ParametersAndReturnBoolean(objectType, string, "isUseThresholdExceeded");
    }

    public boolean isLiveSetSizeThresholdSupported(String string) {
        return Utils.makeCommandCall0ParametersAndReturnBoolean(objectType, string, "isLiveSetSizeThresholdSupported");
    }

    public boolean setLiveSetSizeThreshold(String string, long l) {
        return Utils.makeCommandCall1LongParameterAndReturnBoolean(objectType, string, "setLiveSetSizeThreshold", "threshold", l);
    }

    public long getLiveSetSizeThreshold(String string) {
        return Utils.makeCommandCall0ParametersAndReturnLong(objectType, string, "getLiveSetSizeThreshold");
    }

    public long getLiveSetSizeThresholdExceededCount(String string) {
        return Utils.makeCommandCall0ParametersAndReturnLong(objectType, string, "getLiveSetSizeThresholdExceededCount");
    }

    public boolean isLiveSetSizeThresholdExceeded(String string) {
        return Utils.makeCommandCall0ParametersAndReturnBoolean(objectType, string, "isLiveSetSizeThresholdExceeded");
    }

    public MemoryUsage convertToMemoryUsage(String string, Object object) {
        MemoryUsage memoryUsage = null;
        try {
            memoryUsage = Utils.makeCommandCall0ParametersAndReturnMemoryUsage(objectType, string, "convertToMemoryUsage", object);
        }
        catch (Exception exception) {
            ExceptionHandler.printDetailsOfRuntimeException(objectType, string, "convertToMemoryUsage", MemoryPoolMXBeanInternal_convertToMemoryUsage, exception);
            memoryUsage = null;
        }
        return memoryUsage;
    }

    public boolean setNotificationCallback(String string, String string2, String string3, String string4) {
        return Utils.makeCommandCall3StringParametersAndReturnBoolean(objectType, string, "setNotificationCallback", "className", string2, "notifyListeners", string3, "signature", string4);
    }

    public boolean setNotificationEnabled(String string) {
        return Utils.makeCommandCall0ParametersAndReturnBoolean(objectType, string, "setNotificationEnabled");
    }

    public boolean setNotificationDisabled(String string) {
        return Utils.makeCommandCall0ParametersAndReturnBoolean(objectType, string, "setNotificationDisabled");
    }

    public boolean setIntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded(String string, long l) {
        return Utils.makeCommandCall1LongParameterAndReturnBoolean(objectType, string, "setIntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded", "secondsToWaitBeforeRenotify", l);
    }

    public long getIntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded(String string) {
        return Utils.makeCommandCall0ParametersAndReturnLong(objectType, string, "getIntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded");
    }

    public boolean setIntervalToWaitBetweenUseThresholdChecks(String string, long l) {
        return Utils.makeCommandCall1LongParameterAndReturnBoolean(objectType, string, "setIntervalToWaitBetweenUseThresholdChecks", "secondsBetweenUseThresholdChecks", l);
    }

    public long getIntervalToWaitBetweenUseThresholdChecks(String string) {
        return Utils.makeCommandCall0ParametersAndReturnLong(objectType, string, "getIntervalToWaitBetweenUseThresholdChecks");
    }
}

