/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.impl.management;

import com.azul.zing.impl.management.DynamicMXBeanImpl;
import com.azul.zing.impl.management.ManagementUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

abstract class NotificationEmitterImpl
extends DynamicMXBeanImpl
implements NotificationEmitter {
    private List<NotifListener> notifListenerList = Collections.emptyList();
    private Object listenerLock = new Object();

    protected NotificationEmitterImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        if (notificationListener == null) {
            throw new IllegalArgumentException("NotificationEmitterImpl.addNotificationListener: value of input parameter listener (type NotificationListener) cannot be null");
        }
        if (ManagementUtils.TRACE_NOTIFICATIONS) {
            System.out.println("NotificationEmitterImpl.addNotificationListener: Enter");
            System.out.println("NotificationEmitterImpl.addNotificationListener: listener: " + notificationListener);
            System.out.println("NotificationEmitterImpl.addNotificationListener: filter: " + notificationFilter);
            System.out.println("NotificationEmitterImpl.addNotificationListener: handback: " + object);
        }
        Object object2 = this.listenerLock;
        synchronized (object2) {
            boolean bl = false;
            for (int i = this.notifListenerList.size() - 1; i >= 0; --i) {
                NotifListener notifListener = this.notifListenerList.get(i);
                if (notifListener.getListener() != notificationListener || notifListener.getFilter() != notificationFilter || notifListener.getHandback() != object) continue;
                bl = true;
            }
            if (!bl) {
                ArrayList<NotifListener> arrayList = new ArrayList<NotifListener>(this.notifListenerList.size() + 1);
                arrayList.addAll(this.notifListenerList);
                arrayList.add(new NotifListener(notificationListener, notificationFilter, object));
                this.notifListenerList = arrayList;
                if (ManagementUtils.TRACE_NOTIFICATIONS) {
                    System.out.println("NotificationEmitterImpl.addNotificationListener: Added listener");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        if (ManagementUtils.TRACE_NOTIFICATIONS) {
            System.out.println("NotificationEmitterImpl.removeNotificationListener: Enter");
            System.out.println("NotificationEmitterImpl.removeNotificationListener: listener: " + notificationListener);
            System.out.println("NotificationEmitterImpl.removeNotificationListener: filter: " + notificationFilter);
            System.out.println("NotificationEmitterImpl.removeNotificationListener: handback: " + object);
        }
        boolean bl = false;
        boolean bl2 = false;
        Object object2 = this.listenerLock;
        synchronized (object2) {
            ArrayList<NotifListener> arrayList = new ArrayList<NotifListener>(this.notifListenerList);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                NotifListener notifListener = (NotifListener)arrayList.get(i);
                if (notifListener.getListener() != notificationListener) continue;
                bl = true;
                if (notifListener.getFilter() != notificationFilter || notifListener.getHandback() != object) continue;
                bl2 = true;
                arrayList.remove(i);
                if (!ManagementUtils.TRACE_NOTIFICATIONS) continue;
                System.out.println("NotificationEmitterImpl.removeNotificationListener: Removed listener");
            }
            this.notifListenerList = arrayList;
        }
        if (bl && !bl2) {
            throw new ListenerNotFoundException("NotificationEmitterImpl.removeNotificationListener: found matching listener but filter/handback did not match");
        }
        if (!bl) {
            throw new ListenerNotFoundException("NotificationEmitterImpl.removeNotificationListener: value of input parameter listener (type NotificationListener) not registered");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        if (ManagementUtils.TRACE_NOTIFICATIONS) {
            System.out.println("NotificationEmitterImpl.removeNotificationListener(listener): Enter");
        }
        Object object = this.listenerLock;
        synchronized (object) {
            ArrayList<NotifListener> arrayList = new ArrayList<NotifListener>(this.notifListenerList);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                NotifListener notifListener = (NotifListener)arrayList.get(i);
                if (notifListener.getListener() != notificationListener) continue;
                arrayList.remove(i);
                if (!ManagementUtils.TRACE_NOTIFICATIONS) continue;
                System.out.println("NotificationEmitterImpl.removeNotificationListener(listener): Removed listener");
            }
            if (this.notifListenerList.size() == arrayList.size()) {
                throw new ListenerNotFoundException("NotificationEmitterImpl.removeNotificationListener: value of input parameter listener (type NotificationListener) not registered");
            }
            this.notifListenerList = arrayList;
        }
    }

    @Override
    public abstract MBeanNotificationInfo[] getNotificationInfo();

    public boolean hasListeners() {
        return this.notifListenerList.size() > 0;
    }

    public long getListenerCount() {
        return this.notifListenerList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendNotification(Notification notification) {
        if (ManagementUtils.TRACE_NOTIFICATIONS) {
            System.out.println("NotificationEmitterImpl.sendNotification: Enter");
        }
        if (notification == null) {
            return;
        }
        ArrayList<NotifListener> arrayList = null;
        Object object = this.listenerLock;
        synchronized (object) {
            arrayList = new ArrayList<NotifListener>(this.notifListenerList);
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            NotifListener notifListener = (NotifListener)arrayList.get(i);
            if (notifListener.getFilter() != null && !notifListener.getFilter().isNotificationEnabled(notification)) continue;
            try {
                notifListener.getListener().handleNotification(notification, notifListener.handback);
                continue;
            }
            catch (Exception exception) {
                System.err.println("NotificationEmitterImpl.sendNotification: Failure to handleNotification");
                exception.printStackTrace();
                throw new AssertionError((Object)"NotificationEmitterImpl.sendNotification: Failure to handleNotification");
            }
        }
    }

    class NotifListener {
        private NotificationListener listener;
        private NotificationFilter filter;
        private Object handback;

        public NotifListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
            this.listener = notificationListener;
            this.filter = notificationFilter;
            this.handback = object;
        }

        public NotificationListener getListener() {
            return this.listener;
        }

        public NotificationFilter getFilter() {
            return this.filter;
        }

        public Object getHandback() {
            return this.handback;
        }
    }
}

