/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.impl.management;

import com.azul.zing.impl.management.ManagementCompositeData;
import com.azul.zing.impl.management.ManagementMXBeanUtils;
import com.azul.zing.impl.management.ManagementUtils;
import com.azul.zing.impl.management.MemoryMXBeanImpl;
import com.azul.zing.impl.management.NotificationEmitterImpl;
import com.azul.zing.impl.management.internal.nls.Messages;
import com.azul.zing.internal.management.MemoryPoolMXBeanInternal;
import com.azul.zing.management.ManagementPermission;
import com.azul.zing.management.MemoryManagerMXBean;
import com.azul.zing.management.MemoryPoolMXBean;
import com.azul.zing.management.MemoryPoolNotificationInfo;
import com.azul.zing.management.MemoryPoolSizeType;
import com.azul.zing.management.MemoryType;
import com.azul.zing.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

public final class MemoryPoolMXBeanImpl
extends NotificationEmitterImpl
implements MemoryPoolMXBean {
    private final String name;
    private MemoryPoolMXBeanInternal memoryPoolMXBeanInternal = null;
    private static final String memoryPoolMXBeanVersion = "1.0.0";
    private final int id;
    private final MemoryType type;
    private final MemoryMXBeanImpl memBean;
    private final String parentPool;
    private final String[] childPools;
    private final boolean supportsMemoryUseThreshold;
    private final boolean supportsAfterCollectionMemoryUseThreshold;
    private final boolean supportsLiveSetSizeThreshold;
    private Object seqNumberLock = new Object();
    private long _seqNumber = 0L;
    private static List<MemoryPoolNameObjectPair> mpNameObjectPairList = new ArrayList<MemoryPoolNameObjectPair>(2);
    private static final String fromJVMCreateMemoryPoolNotification = "fromJVMCreateMemoryPoolNotification";
    private boolean setNotificationCallbackRegistered = false;

    @Override
    public String getVersion() {
        return memoryPoolMXBeanVersion;
    }

    MemoryPoolMXBeanImpl(String string, MemoryType memoryType, int n, MemoryMXBeanImpl memoryMXBeanImpl, String string2, String[] stringArray, boolean bl, boolean bl2, boolean bl3) {
        if (ManagementUtils.TRACE) {
            System.out.println("MemoryPoolMXBeanImpl.MemoryPoolMXBeanImpl \"" + string + "\" | " + (Object)((Object)memoryType) + " | " + n + " | " + memoryMXBeanImpl);
        }
        this.name = string;
        this.type = memoryType;
        this.id = n;
        this.memBean = memoryMXBeanImpl;
        this.memoryPoolMXBeanInternal = new MemoryPoolMXBeanInternal();
        this.parentPool = string2;
        this.childPools = stringArray;
        this.supportsMemoryUseThreshold = bl;
        this.supportsAfterCollectionMemoryUseThreshold = bl2;
        this.supportsLiveSetSizeThreshold = bl3;
        this.setMBeanInfo(ManagementMXBeanUtils.getMBeanInfo(MemoryPoolMXBean.class.getName()));
        MemoryPoolNameObjectPair memoryPoolNameObjectPair = new MemoryPoolNameObjectPair(string, this);
        MemoryPoolMXBeanImpl.addMemoryPoolNameObjectPairToListOfPools(memoryPoolNameObjectPair);
    }

    public ObjectName getObjectName() {
        try {
            return ObjectName.getInstance("com.azul.zing:type=MemoryPool,name=" + this.getName());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new IllegalArgumentException(malformedObjectNameException);
        }
    }

    @Override
    public String[] getMemoryManagerNames() {
        if (ManagementUtils.TRACE) {
            System.out.println("MemoryPoolMXBeanImpl.getMemoryManagerNames");
        }
        Iterator<MemoryManagerMXBean> iterator = this.memBean.getMemoryManagerMXBeans().iterator();
        LinkedList<String> linkedList = new LinkedList<String>();
        block0: while (iterator.hasNext()) {
            MemoryManagerMXBean memoryManagerMXBean = iterator.next();
            String[] stringArray = memoryManagerMXBean.getMemoryPoolNames();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(this.name)) continue;
                linkedList.add(memoryManagerMXBean.getName());
                continue block0;
            }
        }
        return linkedList.toArray(new String[0]);
    }

    @Override
    public String getName() {
        if (ManagementUtils.TRACE) {
            System.out.println("MemoryPoolMXBeanImpl.getName");
        }
        return this.name;
    }

    @Override
    public MemoryType getType() {
        return this.type;
    }

    @Override
    public MemoryPoolSizeType getMemoryPoolSizeType() {
        return this.memoryPoolMXBeanInternal.getMemoryPoolSizeType(this.name);
    }

    @Override
    public MemoryUsage getCurrentMemoryUsage() {
        return this.memoryPoolMXBeanInternal.getCurrentMemoryUsage(this.name);
    }

    @Override
    public long getCurrentUse() {
        return this.memoryPoolMXBeanInternal.getCurrentUse(this.name);
    }

    @Override
    public long getCurrentSize() {
        return this.memoryPoolMXBeanInternal.getCurrentSize(this.name);
    }

    @Override
    public long getInitialReserved() {
        return this.memoryPoolMXBeanInternal.getInitialReserved(this.name);
    }

    @Override
    public MemoryUsage getPeakUsage() {
        return this.memoryPoolMXBeanInternal.getPeakUsage(this.name);
    }

    @Override
    public double resetPeakUsage() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        return this.memoryPoolMXBeanInternal.resetPeakUsage(this.name);
    }

    @Override
    public double getTimeOfLastResetPeakUsageSec() {
        return this.memoryPoolMXBeanInternal.getTimeOfLastResetPeakUsageSec(this.name);
    }

    @Override
    public MemoryUsage getStartOfCollectionUsage() {
        return this.memoryPoolMXBeanInternal.getStartOfCollectionUsage(this.name);
    }

    @Override
    public MemoryUsage getEndOfCollectionUsage() {
        return this.memoryPoolMXBeanInternal.getEndOfCollectionUsage(this.name);
    }

    @Override
    public MemoryUsage getPeakEndOfCollectionUsage() {
        return this.memoryPoolMXBeanInternal.getPeakEndOfCollectionUsage(this.name);
    }

    @Override
    public double resetPeakEndOfCollectionUsage() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        return this.memoryPoolMXBeanInternal.resetPeakEndOfCollectionUsage(this.name);
    }

    @Override
    public double getTimeOfLastResetPeakEndOfCollectionUsageSec() {
        return this.memoryPoolMXBeanInternal.getTimeOfLastResetPeakEndOfCollectionUsageSec(this.name);
    }

    @Override
    public boolean isValid() {
        return this.memoryPoolMXBeanInternal.isValid(this.name);
    }

    private boolean exceedsMaxPoolSize(long l) {
        MemoryUsage memoryUsage = this.getCurrentMemoryUsage();
        return memoryUsage.getMemoryPoolSizeType() == MemoryPoolSizeType.FIXED && l > memoryUsage.getInitialReserved();
    }

    @Override
    public String getParentPool() {
        return this.parentPool;
    }

    @Override
    public String[] getChildPools() {
        return this.childPools;
    }

    private void throwUnsupportedOperationException(String string) {
        throw new UnsupportedOperationException(string);
    }

    @Override
    public long getAfterCollectionUseThreshold() {
        if (!this.isAfterCollectionUseThresholdSupported()) {
            String string = Messages.getString("lm.13", this.name, "MemoryPoolMXBean.getAfterCollectionUseThreshold");
            this.throwUnsupportedOperationException(string);
        }
        return this.memoryPoolMXBeanInternal.getAfterCollectionUseThreshold(this.name);
    }

    @Override
    public long getAfterCollectionUseThresholdExceededCount() {
        if (!this.isAfterCollectionUseThresholdSupported()) {
            String string = Messages.getString("lm.13", this.name, "MemoryPoolMXBean.getAfterCollectionUseThresholdExceededCount");
            this.throwUnsupportedOperationException(string);
        }
        return this.memoryPoolMXBeanInternal.getAfterCollectionUseThresholdExceededCount(this.name);
    }

    @Override
    public long getUseThreshold() {
        if (!this.isUseThresholdSupported()) {
            String string = Messages.getString("lm.14", this.name, "MemoryPoolMXBean.getUseThreshold");
            this.throwUnsupportedOperationException(string);
        }
        return this.memoryPoolMXBeanInternal.getUseThreshold(this.name);
    }

    @Override
    public long getUseThresholdExceededCount() {
        if (!this.isUseThresholdSupported()) {
            String string = Messages.getString("lm.14", this.name, "MemoryPoolMXBean.getUseThresholdExceededCount");
            this.throwUnsupportedOperationException(string);
        }
        return this.memoryPoolMXBeanInternal.getUseThresholdExceededCount(this.name);
    }

    @Override
    public long getLiveSetSizeThreshold() {
        if (!this.isLiveSetSizeThresholdSupported()) {
            String string = Messages.getString("lm.21", this.name, "MemoryPoolMXBean.getLiveSetSizeThreshold");
            this.throwUnsupportedOperationException(string);
        }
        return this.memoryPoolMXBeanInternal.getLiveSetSizeThreshold(this.name);
    }

    @Override
    public long getLiveSetSizeThresholdExceededCount() {
        if (!this.isLiveSetSizeThresholdSupported()) {
            String string = Messages.getString("lm.21", this.name, "MemoryPoolMXBean.getLiveSetSizeThresholdExceededCount");
            this.throwUnsupportedOperationException(string);
        }
        return this.memoryPoolMXBeanInternal.getLiveSetSizeThresholdExceededCount(this.name);
    }

    @Override
    public boolean isAfterCollectionUseThresholdExceeded() {
        if (!this.isAfterCollectionUseThresholdSupported()) {
            String string = Messages.getString("lm.13", this.name, "MemoryPoolMXBean.isAfterCollectionUseThresholdExceeded");
            this.throwUnsupportedOperationException(string);
        }
        return this.memoryPoolMXBeanInternal.isAfterCollectionUseThresholdExceeded(this.name);
    }

    @Override
    public boolean isAfterCollectionUseThresholdSupported() {
        return this.memoryPoolMXBeanInternal.isAfterCollectionUseThresholdSupported(this.name);
    }

    @Override
    public boolean isUseThresholdExceeded() {
        if (!this.isUseThresholdSupported()) {
            String string = Messages.getString("lm.14", this.name, "MemoryPoolMXBean.isUseThresholdExceeded");
            this.throwUnsupportedOperationException(string);
        }
        return this.memoryPoolMXBeanInternal.isUseThresholdExceeded(this.name);
    }

    @Override
    public boolean isUseThresholdSupported() {
        return this.memoryPoolMXBeanInternal.isUseThresholdSupported(this.name);
    }

    @Override
    public boolean isLiveSetSizeThresholdExceeded() {
        if (!this.isLiveSetSizeThresholdSupported()) {
            String string = Messages.getString("lm.21", this.name, "MemoryPoolMXBean.isLiveSetSizeThresholdExceeded()");
            this.throwUnsupportedOperationException(string);
        }
        return this.memoryPoolMXBeanInternal.isLiveSetSizeThresholdExceeded(this.name);
    }

    @Override
    public boolean isLiveSetSizeThresholdSupported() {
        return this.memoryPoolMXBeanInternal.isLiveSetSizeThresholdSupported(this.name);
    }

    @Override
    public boolean setAfterCollectionUseThreshold(long l) {
        Object object;
        if (!this.isAfterCollectionUseThresholdSupported()) {
            object = Messages.getString("lm.13", this.name, "MemoryPoolMXBeanImpl.setAfterCollectionUseThreshold");
            this.throwUnsupportedOperationException((String)object);
        }
        if (l < 0L) {
            throw new IllegalArgumentException(Messages.getString("lm.27", "MemoryPoolMXBeanImpl.setAfterCollectionUseThreshold", "threshold", l));
        }
        if (this.exceedsMaxPoolSize(l)) {
            throw new IllegalArgumentException(Messages.getString("lm.16"));
        }
        object = System.getSecurityManager();
        if (object != null) {
            ((SecurityManager)object).checkPermission(new ManagementPermission("control"));
        }
        return this.memoryPoolMXBeanInternal.setAfterCollectionUseThreshold(this.name, l);
    }

    @Override
    public boolean setUseThreshold(long l) {
        Object object;
        if (!this.isUseThresholdSupported()) {
            object = Messages.getString("lm.14", this.name, "MemoryPoolMXBean.setUseThreshold");
            this.throwUnsupportedOperationException((String)object);
        }
        if (l < 0L) {
            throw new IllegalArgumentException(Messages.getString("lm.27", "MemoryPoolMXBeanImpl.setUseThreshold", "threshold", l));
        }
        if (this.exceedsMaxPoolSize(l)) {
            throw new IllegalArgumentException(Messages.getString("lm.20"));
        }
        object = System.getSecurityManager();
        if (object != null) {
            ((SecurityManager)object).checkPermission(new ManagementPermission("control"));
        }
        return this.memoryPoolMXBeanInternal.setUseThreshold(this.name, l);
    }

    @Override
    public boolean setLiveSetSizeThreshold(long l) {
        Object object;
        if (!this.isLiveSetSizeThresholdSupported()) {
            object = Messages.getString("lm.21", this.name, "MemoryPoolMXBean.setLiveSetSizeThreshold");
            this.throwUnsupportedOperationException((String)object);
        }
        if (l < 0L) {
            throw new IllegalArgumentException(Messages.getString("lm.27", "MemoryPoolMXBeanImpl.setLiveSetSizeThreshold", "threshold", l));
        }
        if (this.exceedsMaxPoolSize(l)) {
            throw new IllegalArgumentException(Messages.getString("lm.23"));
        }
        object = System.getSecurityManager();
        if (object != null) {
            ((SecurityManager)object).checkPermission(new ManagementPermission("control"));
        }
        return this.memoryPoolMXBeanInternal.setLiveSetSizeThreshold(this.name, l);
    }

    @Override
    public boolean setIntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded(long l) {
        Object object;
        if (l < 0L) {
            throw new IllegalArgumentException(Messages.getString("lm.27", "MemoryPoolMXBeanImpl.setIntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded", "secondsToWaitBeforeRenotify", l));
        }
        if (!(this.isAfterCollectionUseThresholdSupported() || this.isUseThresholdSupported() || this.isLiveSetSizeThresholdSupported())) {
            object = Messages.getString("lm.28", "MemoryPoolMXBeanImpl");
            this.throwUnsupportedOperationException((String)object);
        }
        if ((object = System.getSecurityManager()) != null) {
            ((SecurityManager)object).checkPermission(new ManagementPermission("control"));
        }
        return this.memoryPoolMXBeanInternal.setIntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded(this.name, l);
    }

    @Override
    public long getIntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded() {
        return this.memoryPoolMXBeanInternal.getIntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded(this.name);
    }

    @Override
    public boolean setIntervalToWaitBetweenUseThresholdChecks(long l) {
        Object object;
        if (!this.isUseThresholdSupported()) {
            object = Messages.getString("lm.14", this.name, "MemoryPoolMXBeanImpl.setIntervalToWaitBetweenUseThresholdChecks");
            this.throwUnsupportedOperationException((String)object);
        }
        if (l < 0L) {
            throw new IllegalArgumentException(Messages.getString("lm.27", "MemoryPoolMXBeanImpl.setIntervalToWaitBetweenUseThresholdChecks", "secondsBetweenUseThresholdChecks", l));
        }
        object = System.getSecurityManager();
        if (object != null) {
            ((SecurityManager)object).checkPermission(new ManagementPermission("control"));
        }
        return this.memoryPoolMXBeanInternal.setIntervalToWaitBetweenUseThresholdChecks(this.name, l);
    }

    @Override
    public long getIntervalToWaitBetweenUseThresholdChecks() {
        if (!this.isUseThresholdSupported()) {
            String string = Messages.getString("lm.14", this.name, "MemoryPoolMXBeanImpl.getIntervalToWaitBetweenUseThresholdChecks");
            this.throwUnsupportedOperationException(string);
        }
        return this.memoryPoolMXBeanInternal.getIntervalToWaitBetweenUseThresholdChecks(this.name);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        if (this.isAfterCollectionUseThresholdSupported()) {
            arrayList.add("com.azul.zing.management.memory.use.threshold.exceeded");
        }
        if (this.isUseThresholdSupported()) {
            arrayList.add("com.azul.zing.management.memory.use.after_collection.threshold.exceeded");
        }
        if (this.isLiveSetSizeThresholdSupported()) {
            arrayList.add("com.azul.zing.management.memory.live_set_size.threshold.exceeded");
        }
        String[] stringArray = (String[])arrayList.toArray();
        if (ManagementUtils.TRACE_NOTIFICATIONS) {
            System.out.println("MemoryPoolMXBeanImpl.getNotificationInfo: " + this.getName() + " Supported types: " + arrayList);
        }
        String string = Notification.class.getName();
        String string2 = "Memory Pool " + this.getName() + " Notification for Exceeding Threshold";
        MBeanNotificationInfo mBeanNotificationInfo = new MBeanNotificationInfo(stringArray, string, string2);
        return new MBeanNotificationInfo[]{mBeanNotificationInfo};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextSeqNumber() {
        Object object = this.seqNumberLock;
        synchronized (object) {
            ++this._seqNumber;
        }
        return this._seqNumber;
    }

    private long getSeqNumber() {
        return this._seqNumber;
    }

    private static void addMemoryPoolNameObjectPairToListOfPools(MemoryPoolNameObjectPair memoryPoolNameObjectPair) {
        for (MemoryPoolNameObjectPair memoryPoolNameObjectPair2 : mpNameObjectPairList) {
            if (memoryPoolNameObjectPair2.doesNameMatch(memoryPoolNameObjectPair.getName()) == null) continue;
            System.err.println("MemoryPoolMXBeanImpl.addMemoryPoolNameObjectPairToListOfPools attempt to add duplicate pool: " + memoryPoolNameObjectPair.getName());
            return;
        }
        mpNameObjectPairList.add(memoryPoolNameObjectPair);
    }

    private static MemoryPoolMXBeanImpl getMemoryPoolMXBeanImplFromName(String string) {
        for (MemoryPoolNameObjectPair memoryPoolNameObjectPair : mpNameObjectPairList) {
            if (memoryPoolNameObjectPair.doesNameMatch(string) == null) continue;
            return memoryPoolNameObjectPair.getMemoryPoolMXBeanImpl();
        }
        return null;
    }

    public static long getMemoryPoolSize(String string) {
        MemoryPoolMXBeanImpl memoryPoolMXBeanImpl = MemoryPoolMXBeanImpl.getMemoryPoolMXBeanImplFromName(string);
        if (memoryPoolMXBeanImpl == null) {
            return 0L;
        }
        return memoryPoolMXBeanImpl.getCurrentSize();
    }

    public static long getMemoryPoolInitialReserved(String string) {
        MemoryPoolMXBeanImpl memoryPoolMXBeanImpl = MemoryPoolMXBeanImpl.getMemoryPoolMXBeanImplFromName(string);
        if (memoryPoolMXBeanImpl == null) {
            return 0L;
        }
        MemoryUsage memoryUsage = memoryPoolMXBeanImpl.getCurrentMemoryUsage();
        return memoryUsage.getInitialReserved();
    }

    public static void fromJVMCreateMemoryPoolNotification(long l, String string, String string2, long l2, Object object) {
        MemoryPoolMXBeanImpl memoryPoolMXBeanImpl = MemoryPoolMXBeanImpl.getMemoryPoolMXBeanImplFromName(string);
        if (memoryPoolMXBeanImpl == null) {
            return;
        }
        memoryPoolMXBeanImpl.createMemoryPoolNotification(l, string2, l2, object);
    }

    private void createMemoryPoolNotification(long l, String string, long l2, Object object) {
        if (ManagementUtils.TRACE_NOTIFICATIONS) {
            System.out.println("MemoryPoolMXBeanImpl.createMemoryPoolNotification " + l + " listeners: " + this.hasListeners() + " " + this.getName() + " Reason: " + string + " Times threshold crossed: " + l2);
        }
        if (!this.hasListeners()) {
            return;
        }
        Notification notification = new Notification(string, this.getObjectName(), l2, l, this.getName());
        MemoryUsage memoryUsage = this.memoryPoolMXBeanInternal.convertToMemoryUsage(this.getName(), object);
        if (ManagementUtils.TRACE_NOTIFICATIONS && memoryUsage != null) {
            System.out.println("MemoryPoolMXBeanImpl.createMemoryPoolNotification " + memoryUsage.toString());
        }
        MemoryPoolNotificationInfo memoryPoolNotificationInfo = new MemoryPoolNotificationInfo(this.getName(), string, l2, memoryUsage);
        CompositeData compositeData = ManagementCompositeData.toMemoryPoolNotificationInfoCompositeData(memoryPoolNotificationInfo);
        notification.setUserData(compositeData);
        this.sendNotification(notification);
    }

    @Override
    public synchronized void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        boolean bl = this.hasListeners();
        super.addNotificationListener(notificationListener, notificationFilter, object);
        boolean bl2 = this.hasListeners();
        if (!bl && bl2) {
            this.setNotificationEnabled(true);
        }
    }

    @Override
    public synchronized void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        boolean bl = this.hasListeners();
        super.removeNotificationListener(notificationListener);
        boolean bl2 = this.hasListeners();
        if (bl && !bl2) {
            this.setNotificationEnabled(false);
        }
    }

    @Override
    public synchronized void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        boolean bl = this.hasListeners();
        super.removeNotificationListener(notificationListener, notificationFilter, object);
        boolean bl2 = this.hasListeners();
        if (bl && !bl2) {
            this.setNotificationEnabled(false);
        }
    }

    private synchronized boolean setNotificationEnabled(boolean bl) {
        if (ManagementUtils.TRACE_NOTIFICATIONS) {
            System.out.println("MemoryPoolMXBeanImpl.setNotificationEnabled called enable: " + bl + " " + this.getName() + " com/azul/zing/impl/management/MemoryPoolMXBeanImpl " + fromJVMCreateMemoryPoolNotification + " (JLjava/lang/String;Ljava/lang/String;JLjava/lang/Object;)V");
        }
        if (bl) {
            if (!this.setNotificationCallbackRegistered) {
                boolean bl2 = this.memoryPoolMXBeanInternal.setNotificationCallback(this.getName(), "com/azul/zing/impl/management/MemoryPoolMXBeanImpl", fromJVMCreateMemoryPoolNotification, "(JLjava/lang/String;Ljava/lang/String;JLjava/lang/Object;)V");
                if (!bl2) {
                    System.err.println("ERROR: Zing MXBeans: MemoryPoolMXBeanImpl.setNotificationEnabled failed to register callback");
                    System.err.println("ERROR: Zing MXBeans: Notifications will not work");
                    return false;
                }
                this.setNotificationCallbackRegistered = true;
            }
            return this.memoryPoolMXBeanInternal.setNotificationEnabled(this.getName());
        }
        return this.memoryPoolMXBeanInternal.setNotificationDisabled(this.getName());
    }

    public class MemoryPoolNameObjectPair {
        private String name;
        private MemoryPoolMXBeanImpl mpMXBeanImpl;

        MemoryPoolNameObjectPair(String string, MemoryPoolMXBeanImpl memoryPoolMXBeanImpl2) {
            this.name = string;
            this.mpMXBeanImpl = memoryPoolMXBeanImpl2;
        }

        String getName() {
            return this.name;
        }

        MemoryPoolMXBeanImpl getMemoryPoolMXBeanImpl() {
            return this.mpMXBeanImpl;
        }

        MemoryPoolMXBeanImpl doesNameMatch(String string) {
            if (this.name.equals(string)) {
                return this.mpMXBeanImpl;
            }
            return null;
        }
    }
}

