/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.impl.management;

import com.azul.zing.impl.management.GarbageCollectorMXBeanImpl;
import com.azul.zing.impl.management.ManagementCompositeData;
import com.azul.zing.impl.management.ManagementMXBeanUtils;
import com.azul.zing.impl.management.ManagementUtils;
import com.azul.zing.impl.management.MemoryManagerMXBeanImpl;
import com.azul.zing.impl.management.NotificationEmitterImpl;
import com.azul.zing.impl.management.internal.nls.Messages;
import com.azul.zing.internal.management.MemoryMXBeanInternal;
import com.azul.zing.internal.management.MemoryPoolMXBeanInternal;
import com.azul.zing.internal.management.NativeMemoryManagerDesc;
import com.azul.zing.management.ManagementPermission;
import com.azul.zing.management.MemoryMXBean;
import com.azul.zing.management.MemoryManagerMXBean;
import com.azul.zing.management.MemoryNotificationInfo;
import com.azul.zing.management.MemoryUsage;
import java.util.LinkedList;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

public final class MemoryMXBeanImpl
extends NotificationEmitterImpl
implements MemoryMXBean {
    private static final String processMemoryName = "ProcessMemory";
    private static MemoryMXBeanImpl instance = new MemoryMXBeanImpl();
    private List<MemoryManagerMXBean> memoryManagerList;
    private MemoryMXBeanInternal memoryMXBeanInternal = null;
    private MemoryPoolMXBeanInternal memoryPoolMXBeanInternal = null;
    private static final String memoryMXBeanVersion = "1.0.0";
    public static final String MEMORY_MXBEAN_DOMAIN_TYPE = "com.azul.zing:type=Memory";
    private static final boolean supportsPercentJavaHeapOccupiedAfterCollectionThreshold = true;
    private Object seqNumberLock = new Object();
    private long _seqNumber = 0L;
    private static final String fromJVMCreateMemoryNotification = "fromJVMCreateMemoryNotification";
    private boolean setNotificationCallbackRegistered = false;

    @Override
    public String getVersion() {
        return memoryMXBeanVersion;
    }

    private MemoryMXBeanImpl() {
        this.memoryMXBeanInternal = new MemoryMXBeanInternal();
        this.memoryPoolMXBeanInternal = new MemoryPoolMXBeanInternal();
        this.setMBeanInfo(ManagementMXBeanUtils.getMBeanInfo(MemoryMXBean.class.getName()));
        this.memoryManagerList = new LinkedList<MemoryManagerMXBean>();
        this.createMemoryManagers();
    }

    public ObjectName getObjectName() {
        try {
            return ObjectName.getInstance("com.azul.zing:type=Memory,name=memory");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new IllegalArgumentException(malformedObjectNameException);
        }
    }

    static MemoryMXBeanImpl getInstance() {
        return instance;
    }

    private void createMemoryManagers() {
        if (ManagementUtils.TRACE) {
            System.out.println("MemoryMXBeanImpl.createMemoryManagers");
        }
        NativeMemoryManagerDesc[] nativeMemoryManagerDescArray = this.memoryMXBeanInternal.getMemoryManagers(processMemoryName);
        for (int i = 0; i < nativeMemoryManagerDescArray.length; ++i) {
            this.createMemoryManagerHelper(nativeMemoryManagerDescArray[i].getName(), nativeMemoryManagerDescArray[i].getInternalID(), nativeMemoryManagerDescArray[i].getIsGC());
        }
    }

    private void createMemoryManagerHelper(String string, int n, boolean bl) {
        if (ManagementUtils.TRACE) {
            System.out.println("MemoryMXBeanImpl.createMemoryManagerHelper \"" + string + "\" ID: " + n + " isGC: " + bl);
        }
        if (bl) {
            this.memoryManagerList.add(new GarbageCollectorMXBeanImpl(string, n, this));
        } else {
            this.memoryManagerList.add(new MemoryManagerMXBeanImpl(string, n, this));
        }
    }

    List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return this.memoryManagerList;
    }

    @Override
    public void fullGC() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        this.memoryMXBeanInternal.fullGC(processMemoryName);
    }

    @Override
    public void newGenerationGC() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        String string = Messages.getString("lm.29");
        this.throwUnsupportedOperationException(string);
    }

    @Override
    public MemoryUsage getJavaHeapMemoryUsage() {
        return this.memoryMXBeanInternal.getJavaHeapMemoryUsage(processMemoryName);
    }

    @Override
    public MemoryUsage getNonJavaHeapMemoryUsage() {
        return this.memoryMXBeanInternal.getNonJavaHeapMemoryUsage(processMemoryName);
    }

    @Override
    public long getJavaHeapUse() {
        return this.memoryMXBeanInternal.getJavaHeapUse(processMemoryName);
    }

    @Override
    public long getNonJavaHeapUse() {
        return this.memoryMXBeanInternal.getNonJavaHeapUse(processMemoryName);
    }

    @Override
    public long getApplicationObjectHeapUse() {
        return this.memoryMXBeanInternal.getApplicationObjectHeapUse(processMemoryName);
    }

    @Override
    public long getApplicationObjectHeapUsableMemory() {
        return this.memoryMXBeanInternal.getApplicationObjectHeapUsableMemory(processMemoryName);
    }

    @Override
    public double getApplicationObjectHeapMemoryPercentInUse() {
        long l = this.getApplicationObjectHeapUsableMemory();
        double d = 0.0;
        if (l > 0L) {
            d = (double)this.getApplicationObjectHeapUse() * 100.0 / (double)l;
        }
        return d;
    }

    @Override
    public double getPercentJavaHeapOccupiedAfterCollection() {
        return this.memoryMXBeanInternal.getPercentJavaHeapOccupiedAfterCollection(processMemoryName);
    }

    @Override
    public boolean isJavaHeapUsingMoreMemoryThanInitiallyReserved() {
        return this.memoryMXBeanInternal.isJavaHeapUsingMoreMemoryThanInitiallyReserved(processMemoryName);
    }

    @Override
    public int getObjectsPendingFinalizationCount() {
        return this.memoryMXBeanInternal.getObjectsPendingFinalizationCount(processMemoryName);
    }

    @Override
    public long getObjectsWithFinalizerCumulativeAllocationCount() {
        return this.memoryMXBeanInternal.getObjectsWithFinalizerCumulativeAllocationCount(processMemoryName);
    }

    @Override
    public double resetObjectsWithFinalizerCumulativeAllocationCount() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        return this.memoryMXBeanInternal.resetObjectsWithFinalizerCumulativeAllocationCount(processMemoryName);
    }

    @Override
    public double getTimeOfLastResetObjectsWithFinalizerCumulativeAllocationCount() {
        return this.memoryMXBeanInternal.getTimeOfLastResetObjectsWithFinalizerCumulativeAllocationCount(processMemoryName);
    }

    @Override
    public boolean isVerbose() {
        return this.memoryMXBeanInternal.isVerbose(processMemoryName);
    }

    @Override
    public boolean setVerbose(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        return this.memoryMXBeanInternal.setVerbose(processMemoryName, bl);
    }

    @Override
    public boolean isDetailedVerbose() {
        return this.memoryMXBeanInternal.isDetailedVerbose(processMemoryName);
    }

    @Override
    public boolean setDetailedVerbose(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        return this.memoryMXBeanInternal.setDetailedVerbose(processMemoryName, bl);
    }

    private void throwUnsupportedOperationException(String string) {
        throw new UnsupportedOperationException(string);
    }

    @Override
    public boolean isPercentJavaHeapOccupiedAfterCollectionThresholdSupported() {
        return this.memoryMXBeanInternal.isPercentJavaHeapOccupiedAfterCollectionThresholdSupported(processMemoryName);
    }

    @Override
    public boolean setPercentJavaHeapOccupiedAfterCollectionThreshold(double d) {
        Object object;
        if (!this.isPercentJavaHeapOccupiedAfterCollectionThresholdSupported()) {
            object = Messages.getString("lm.13");
            this.throwUnsupportedOperationException((String)object);
        }
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("lm.27", "MemoryMXBeanImpl.setPercentJavaHeapOccupiedAfterCollectionThreshold", "threshold", d));
        }
        object = System.getSecurityManager();
        if (object != null) {
            ((SecurityManager)object).checkPermission(new ManagementPermission("control"));
        }
        return this.memoryMXBeanInternal.setPercentJavaHeapOccupiedAfterCollectionThreshold(processMemoryName, d);
    }

    @Override
    public double getPercentJavaHeapOccupiedAfterCollectionThreshold() {
        if (!this.isPercentJavaHeapOccupiedAfterCollectionThresholdSupported()) {
            String string = Messages.getString("lm.13");
            this.throwUnsupportedOperationException(string);
        }
        return this.memoryMXBeanInternal.getPercentJavaHeapOccupiedAfterCollectionThreshold(processMemoryName);
    }

    @Override
    public boolean isPercentJavaHeapOccupiedAfterCollectionThresholdExceeded() {
        if (!this.isPercentJavaHeapOccupiedAfterCollectionThresholdSupported()) {
            String string = Messages.getString("lm.13");
            this.throwUnsupportedOperationException(string);
        }
        return this.memoryMXBeanInternal.isPercentJavaHeapOccupiedAfterCollectionThresholdExceeded(processMemoryName);
    }

    @Override
    public long getPercentJavaHeapOccupiedAfterCollectionThresholdExceededCount() {
        if (!this.isPercentJavaHeapOccupiedAfterCollectionThresholdSupported()) {
            String string = Messages.getString("lm.13");
            this.throwUnsupportedOperationException(string);
        }
        return this.memoryMXBeanInternal.getPercentJavaHeapOccupiedAfterCollectionThresholdExceededCount(processMemoryName);
    }

    @Override
    public boolean setIntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded(long l) {
        Object object;
        if (!this.isPercentJavaHeapOccupiedAfterCollectionThresholdSupported()) {
            object = Messages.getString("lm.28", "MemoryMXBeanImpl");
            this.throwUnsupportedOperationException((String)object);
        }
        if (l < 0L) {
            throw new IllegalArgumentException(Messages.getString("lm.27", "MemoryMXBeanImpl.setIntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded", "secondsToWaitBeforeRenotify", l));
        }
        object = System.getSecurityManager();
        if (object != null) {
            ((SecurityManager)object).checkPermission(new ManagementPermission("control"));
        }
        return this.memoryMXBeanInternal.setIntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded(processMemoryName, l);
    }

    @Override
    public long getIntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded() {
        return this.memoryMXBeanInternal.getIntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded(processMemoryName);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] stringArray = new String[]{"com.azul.zing.management.memory.percent_java_heap_occupied_after_collection.threshold.exceeded", "com.azul.zing.management.memory.java_heap_using_more_than_initially_reserved"};
        String string = Notification.class.getName();
        String string2 = "Memory Notification for Exceeding Threshold";
        MBeanNotificationInfo mBeanNotificationInfo = new MBeanNotificationInfo(stringArray, string, string2);
        return new MBeanNotificationInfo[]{mBeanNotificationInfo};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextSeqNumber() {
        Object object = this.seqNumberLock;
        synchronized (object) {
            ++this._seqNumber;
        }
        return this._seqNumber;
    }

    private long getSeqNumber() {
        return this._seqNumber;
    }

    public static void fromJVMCreateMemoryNotification(long l, String string, String string2, long l2, Object object) {
        MemoryMXBeanImpl.getInstance().createMemoryNotification(l, string2, l2, object);
    }

    private void createMemoryNotification(long l, String string, long l2, Object object) {
        if (ManagementUtils.TRACE_NOTIFICATIONS) {
            System.out.println("MemoryMXBeanImpl.createMemoryNotification " + l + " listeners: " + this.hasListeners() + " Memory Reason: " + string + " Times threshold crossed: " + l2);
        }
        if (!this.hasListeners()) {
            return;
        }
        Notification notification = new Notification(string, this.getObjectName(), l2, l, processMemoryName);
        MemoryUsage memoryUsage = this.memoryPoolMXBeanInternal.convertToMemoryUsage(processMemoryName, object);
        if (ManagementUtils.TRACE_NOTIFICATIONS && memoryUsage != null) {
            System.out.println("MemoryMXBeanImpl.createMemoryNotification " + memoryUsage.toString());
        }
        MemoryNotificationInfo memoryNotificationInfo = new MemoryNotificationInfo("Java Heap", string, l2, memoryUsage);
        CompositeData compositeData = ManagementCompositeData.toMemoryNotificationInfoCompositeData(memoryNotificationInfo);
        notification.setUserData(compositeData);
        this.sendNotification(notification);
    }

    @Override
    public synchronized void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        boolean bl = this.hasListeners();
        super.addNotificationListener(notificationListener, notificationFilter, object);
        boolean bl2 = this.hasListeners();
        if (!bl && bl2) {
            this.setNotificationEnabled(true);
        }
    }

    @Override
    public synchronized void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        boolean bl = this.hasListeners();
        super.removeNotificationListener(notificationListener);
        boolean bl2 = this.hasListeners();
        if (bl && !bl2) {
            this.setNotificationEnabled(false);
        }
    }

    @Override
    public synchronized void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        boolean bl = this.hasListeners();
        super.removeNotificationListener(notificationListener, notificationFilter, object);
        boolean bl2 = this.hasListeners();
        if (bl && !bl2) {
            this.setNotificationEnabled(false);
        }
    }

    private synchronized boolean setNotificationEnabled(boolean bl) {
        if (ManagementUtils.TRACE_NOTIFICATIONS) {
            System.out.println("MemoryMXBeanImpl.setNotificationEnabled called enable: " + bl + " " + processMemoryName + " com.azul.zing.impl.management.MemoryMXBeanImpl " + fromJVMCreateMemoryNotification + " (JLjava/lang/String;Ljava/lang/String;JLjava/lang/Object;)V");
        }
        if (bl) {
            if (!this.setNotificationCallbackRegistered) {
                boolean bl2 = this.memoryMXBeanInternal.setNotificationCallback(processMemoryName, "com/azul/zing/impl/management/MemoryMXBeanImpl", fromJVMCreateMemoryNotification, "(JLjava/lang/String;Ljava/lang/String;JLjava/lang/Object;)V");
                if (!bl2) {
                    System.err.println("ERROR: Zing MXBeans: MemoryMXBeanImpl.setNotificationEnabled failed to register callback");
                    System.err.println("ERROR: Zing MXBeans: Notifications will not work");
                    return false;
                }
                this.setNotificationCallbackRegistered = true;
            }
            return this.memoryMXBeanInternal.setNotificationEnabled(processMemoryName);
        }
        return this.memoryMXBeanInternal.setNotificationDisabled(processMemoryName);
    }
}

