/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.impl.management;

import com.azul.zing.impl.management.GarbageCollectorMXBeanImpl;
import com.azul.zing.impl.management.MemoryMXBeanImpl;
import com.azul.zing.impl.management.MemoryManagerMXBeanImpl;
import com.azul.zing.impl.management.MemoryPoolMXBeanImpl;
import com.azul.zing.impl.management.PersistentProfileMXBeanImpl;
import com.azul.zing.impl.management.TimeMXBeanImpl;
import com.azul.zing.management.GarbageCollectorMXBean;
import com.azul.zing.management.MemoryMXBean;
import com.azul.zing.management.MemoryManagerMXBean;
import com.azul.zing.management.MemoryPoolMXBean;
import com.azul.zing.management.TimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.Notification;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

public class ManagementMXBeanUtils {
    private static Map<String, MBeanInfo> infoMap = ManagementMXBeanUtils.buildInfoMap();

    static MBeanInfo getMBeanInfo(String string) {
        return infoMap.get(string);
    }

    private static Map<String, MBeanInfo> buildInfoMap() {
        HashMap<String, MBeanInfo> hashMap = new HashMap<String, MBeanInfo>();
        ManagementMXBeanUtils.addGarbageCollectorBeanInfo(hashMap);
        ManagementMXBeanUtils.addMemoryBeanInfo(hashMap);
        ManagementMXBeanUtils.addMemoryPoolBeanInfo(hashMap);
        ManagementMXBeanUtils.addTimeBeanInfo(hashMap);
        ManagementMXBeanUtils.addMemoryManagerBeanInfo(hashMap);
        return hashMap;
    }

    private static void addMemoryPoolBeanInfo(HashMap<String, MBeanInfo> hashMap) {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[]{new MBeanAttributeInfo("MemoryManagerNames", "[Ljava.lang.String;", "Memory Manager Names", true, false, false), new MBeanAttributeInfo("Name", String.class.getName(), "Name of Memory Pool", true, false, false), new MBeanAttributeInfo("Type", String.class.getName(), "Memory Type (Process's memory from Java Heap or non Java Heap or System memory", true, false, false), new MBeanAttributeInfo("MemoryPoolSizeType", String.class.getName(), "Memory Pool Size Type (FIXED, ELASTIC or UNINITIALIZED", true, false, false), new MBeanAttributeInfo("CurrentMemoryUsage", CompositeData.class.getName(), "Current MemoryUsage Metrics", true, false, false), new MBeanAttributeInfo("CurrentUse", Long.TYPE.getName(), "Current Use", true, false, false), new MBeanAttributeInfo("CurrentSize", Long.TYPE.getName(), "Current Size", true, false, false), new MBeanAttributeInfo("InitialReserved", Long.TYPE.getName(), "Initial Memory Reserved", true, false, false), new MBeanAttributeInfo("PeakUsage", CompositeData.class.getName(), "Peak Memory Usage", true, false, false), new MBeanAttributeInfo("TimeOfLastResetPeakUsageSec", Double.TYPE.getName(), "Time Of Last Reset Peak Usage (Sec)", true, false, false), new MBeanAttributeInfo("StartOfCollectionUsage", CompositeData.class.getName(), "Start Of Collection Usage", true, false, false), new MBeanAttributeInfo("EndOfCollectionUsage", CompositeData.class.getName(), "End Of Collection Usage", true, false, false), new MBeanAttributeInfo("PeakEndOfCollectionUsage", CompositeData.class.getName(), "Peak End Of Collection Usage", true, false, false), new MBeanAttributeInfo("TimeOfLastResetPeakEndOfCollectionUsageSec", Double.TYPE.getName(), "Time Of Last Reset Peak End Of Collection Usage (Sec)", true, false, false), new MBeanAttributeInfo("Valid", Boolean.TYPE.getName(), "Valid, Active, In-use Memory Pool", true, false, true), new MBeanAttributeInfo("ParentPool", String.class.getName(), "Parent Pool", true, false, false), new MBeanAttributeInfo("ChildPools", "[Ljava.lang.String;", "Child Pools", true, false, false), new MBeanAttributeInfo("AfterCollectionUseThreshold", Long.TYPE.getName(), "AfterCollectionUseThreshold", true, true, false), new MBeanAttributeInfo("AfterCollectionUseThresholdExceededCount", Long.TYPE.getName(), "AfterCollectionUseThresholdExceededCount", true, false, false), new MBeanAttributeInfo("UseThreshold", Long.TYPE.getName(), "UseThreshold", true, true, false), new MBeanAttributeInfo("UseThresholdExceededCount", Long.TYPE.getName(), "UseThresholdExceededCount", true, false, false), new MBeanAttributeInfo("LiveSetSizeThreshold", Long.TYPE.getName(), "LiveSetSizeThreshold", true, true, false), new MBeanAttributeInfo("LiveSetSizeThresholdExceededCount", Long.TYPE.getName(), "LiveSetSizeThresholdExceededCount", true, false, false), new MBeanAttributeInfo("AfterCollectionUseThresholdExceeded", Boolean.TYPE.getName(), "AfterCollectionUseThresholdExceeded", true, false, true), new MBeanAttributeInfo("AfterCollectionUseThresholdSupported", Boolean.TYPE.getName(), "AfterCollectionUseThresholdSupported", true, false, true), new MBeanAttributeInfo("UseThresholdExceeded", Boolean.TYPE.getName(), "UseThresholdExceeded", true, false, true), new MBeanAttributeInfo("UseThresholdSupported", Boolean.TYPE.getName(), "UseThresholdSupported", true, false, true), new MBeanAttributeInfo("LiveSetSizeThresholdExceeded", Boolean.TYPE.getName(), "LiveSetSizeThresholdExceeded", true, false, true), new MBeanAttributeInfo("LiveSetSizeThresholdSupported", Boolean.TYPE.getName(), "LiveSetSizeThresholdSupported", true, false, true), new MBeanAttributeInfo("IntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded", Long.TYPE.getName(), "IntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded", true, true, false), new MBeanAttributeInfo("IntervalToWaitBetweenUseThresholdChecks", Long.TYPE.getName(), "IntervalToWaitBetweenUseThresholdChecks", true, true, false), new MBeanAttributeInfo("Version", String.class.getName(), "Version of the MemoryPoolMXBean API", true, false, false)};
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[7];
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[]{};
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("resetPeakUsage", "Reset Stored Peak MemoryUsage Value", mBeanParameterInfoArray, Double.TYPE.getName(), 2);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("resetPeakEndOfCollectionUsage", "Reset Stored Peak End Of Collection MemoryUsage Value", mBeanParameterInfoArray, Double.TYPE.getName(), 2);
        MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[]{new MBeanParameterInfo("SetAfterThreshold", Long.TYPE.getName(), "After Collection Use Threshold in Bytes")};
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("setAfterCollectionUseThreshold", "Set After Collection Use Threshold (bytes)", mBeanParameterInfoArray2, Boolean.TYPE.getName(), 2);
        MBeanParameterInfo[] mBeanParameterInfoArray3 = new MBeanParameterInfo[]{new MBeanParameterInfo("SetUseThreshold", Long.TYPE.getName(), "Use Threshold in Bytes")};
        mBeanOperationInfoArray[3] = new MBeanOperationInfo("setUseThreshold", "Set Use Threshold (bytes)", mBeanParameterInfoArray3, Boolean.TYPE.getName(), 2);
        MBeanParameterInfo[] mBeanParameterInfoArray4 = new MBeanParameterInfo[]{new MBeanParameterInfo("SetLiveThreshold", Long.TYPE.getName(), "Live Set Size Threshold in Bytes")};
        mBeanOperationInfoArray[4] = new MBeanOperationInfo("setLiveSetSizeThreshold", "Set Live Set Size Threshold (bytes)", mBeanParameterInfoArray4, Boolean.TYPE.getName(), 2);
        MBeanParameterInfo[] mBeanParameterInfoArray5 = new MBeanParameterInfo[]{new MBeanParameterInfo("SecondsToWaitBeforeRenotify", Long.TYPE.getName(), "Seconds To Wait Before Renotify")};
        mBeanOperationInfoArray[5] = new MBeanOperationInfo("setIntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded", "Set Interval To Wait Before Renotify When Threshold Continuously Exceeded (seconds)", mBeanParameterInfoArray5, Boolean.TYPE.getName(), 2);
        MBeanParameterInfo[] mBeanParameterInfoArray6 = new MBeanParameterInfo[]{new MBeanParameterInfo("SecondsBetweenUseThresholdChecks", Long.TYPE.getName(), "Seconds.Between Use Threshold Checks")};
        mBeanOperationInfoArray[6] = new MBeanOperationInfo("setIntervalToWaitBetweenUseThresholdChecks", "Set Interval To Wait Between Use Threshold Checks (seconds)", mBeanParameterInfoArray6, Boolean.TYPE.getName(), 2);
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        String[] stringArray = new String[]{"com.azul.zing.management.memory.use.threshold.exceeded", "com.azul.zing.management.memory.use.after_collection.threshold.exceeded", "com.azul.zing.management.memory.live_set_size.threshold.exceeded"};
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(stringArray, Notification.class.getName(), "Memory Pool Notification Event");
        MBeanInfo mBeanInfo = new MBeanInfo(MemoryPoolMXBeanImpl.class.getName(), MemoryPoolMXBeanImpl.class.getName(), mBeanAttributeInfoArray, null, mBeanOperationInfoArray, mBeanNotificationInfoArray);
        hashMap.put(MemoryPoolMXBean.class.getName(), mBeanInfo);
    }

    private static void addMemoryBeanInfo(HashMap<String, MBeanInfo> hashMap) {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[]{new MBeanAttributeInfo("JavaHeapMemoryUsage", CompositeData.class.getName(), "Process Java Heap MemoryUsage Metrics", true, false, false), new MBeanAttributeInfo("NonJavaHeapMemoryUsage", CompositeData.class.getName(), "Process Non-Java Heap MemoryUsage Metrics", true, false, false), new MBeanAttributeInfo("JavaHeapUse", Long.TYPE.getName(), "Java Heap Use", true, false, false), new MBeanAttributeInfo("NonJavaHeapUse", Long.TYPE.getName(), "Non-Java Heap Use", true, false, false), new MBeanAttributeInfo("ApplicationObjectHeapUse", Long.TYPE.getName(), "Application Object Heap (New Generation and Old Generation) Use", true, false, false), new MBeanAttributeInfo("ApplicationObjectHeapUsableMemory", Long.TYPE.getName(), "Application Object Heap (New Generation and Old Generation) Usable Memory", true, false, false), new MBeanAttributeInfo("ApplicationObjectHeapMemoryPercentInUse", Double.TYPE.getName(), "Application Object Heap (New Generation and Old Generation) Percent of Usable Memory in Use", true, false, false), new MBeanAttributeInfo("PercentJavaHeapOccupiedAfterCollection", Double.TYPE.getName(), "Percent of Java Heap Memory Occupied after Garbage Collection", true, false, false), new MBeanAttributeInfo("JavaHeapUsingMoreMemoryThanInitiallyReserved", Boolean.TYPE.getName(), "Java Heap Using More Memory than Initially Reserved", true, false, true), new MBeanAttributeInfo("ObjectsPendingFinalizationCount", Integer.TYPE.getName(), "Count of the Number of Objects Pending Finalization", true, false, false), new MBeanAttributeInfo("ObjectsWithFinalizerCumulativeAllocationCount", Long.TYPE.getName(), "Cumulative Count of the Number of Allocations of Objects with a Finalizer", true, false, false), new MBeanAttributeInfo("TimeOfLastResetObjectsWithFinalizerCumulativeAllocationCount", Double.TYPE.getName(), "Time of Reset of Cumulative Count of the Number of Allocations of Objects with a Finalizer", true, false, false), new MBeanAttributeInfo("Verbose", Boolean.TYPE.getName(), "Verbose GC Enabled (+PrintGC)", true, false, true), new MBeanAttributeInfo("DetailedVerbose", Boolean.TYPE.getName(), "Detailed Verbose GC Enabled (+PrintGCDetails)", true, false, true), new MBeanAttributeInfo("PercentJavaHeapOccupiedAfterCollectionThresholdSupported", Boolean.TYPE.getName(), "Percent of Java Heap Occupied After Garbage Collection - Threshold Supported", true, false, true), new MBeanAttributeInfo("PercentJavaHeapOccupiedAfterCollectionThreshold", Double.TYPE.getName(), "Percent of Java Heap Occupied After Garbage Collection - Threshold", true, false, false), new MBeanAttributeInfo("PercentJavaHeapOccupiedAfterCollectionThresholdExceeded", Boolean.TYPE.getName(), "Percent of Java Heap Occupied After Garbage Collection - Threshold Exceeded", true, false, true), new MBeanAttributeInfo("PercentJavaHeapOccupiedAfterCollectionThresholdExceededCount", Long.TYPE.getName(), "Percent of Java Heap Occupied After Garbage Collection - Threshold Exceeded Count", true, false, false), new MBeanAttributeInfo("IntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded", Long.TYPE.getName(), "IntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded", true, true, false), new MBeanAttributeInfo("Version", String.class.getName(), "Version of the MemoryMXBean API", true, false, false)};
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[7];
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[]{};
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("fullGC", "Force Garbage Collection of the Entire Collectible Java Heap", mBeanParameterInfoArray, Void.TYPE.getName(), 2);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("newGenerationGC", "Force Garbage Collection of the New Generation of the Java Heap", mBeanParameterInfoArray, Void.TYPE.getName(), 2);
        MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[]{new MBeanParameterInfo("enable", Boolean.TYPE.getName(), "Enable Verbose GC")};
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("setVerbose", "Enable/Disable Verbose GC (PrintGC)", mBeanParameterInfoArray2, Boolean.TYPE.getName(), 2);
        MBeanParameterInfo[] mBeanParameterInfoArray3 = new MBeanParameterInfo[]{new MBeanParameterInfo("enable", Boolean.TYPE.getName(), "Enable Detailed Verbose GC")};
        mBeanOperationInfoArray[3] = new MBeanOperationInfo("setDetailedVerbose", "Enable/Disable Detailed Verbose GC (PrintGCDetails)", mBeanParameterInfoArray3, Boolean.TYPE.getName(), 2);
        MBeanParameterInfo[] mBeanParameterInfoArray4 = new MBeanParameterInfo[]{};
        mBeanOperationInfoArray[4] = new MBeanOperationInfo("resetObjectsWithFinalizerCumulativeAllocationCount", "Reset Cumulative Count of the Number of Allocations of Objects with a Finalizer", mBeanParameterInfoArray4, Double.TYPE.getName(), 2);
        MBeanParameterInfo[] mBeanParameterInfoArray5 = new MBeanParameterInfo[]{new MBeanParameterInfo("percentJavaHeapOccupiedAfterCollectionThreshold", Double.TYPE.getName(), "Percent Java Heap Occupied After Collection Threshold [0 - 100+]")};
        mBeanOperationInfoArray[5] = new MBeanOperationInfo("setPercentJavaHeapOccupiedAfterCollectionThreshold", "Set Percent Java Heap Occupied After Collection Threshold [0 - 100+]", mBeanParameterInfoArray5, Boolean.TYPE.getName(), 2);
        MBeanParameterInfo[] mBeanParameterInfoArray6 = new MBeanParameterInfo[]{new MBeanParameterInfo("SecondsToWaitBeforeRenotify", Long.TYPE.getName(), "Seconds To Wait Before Renotify")};
        mBeanOperationInfoArray[6] = new MBeanOperationInfo("setIntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded", "Set Interval To Wait Before Renotify When Threshold Continuously Exceeded (seconds)", mBeanParameterInfoArray6, Boolean.TYPE.getName(), 2);
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        String[] stringArray = new String[]{"com.azul.zing.management.memory.percent_java_heap_occupied_after_collection.threshold.exceeded", "com.azul.zing.management.memory.java_heap_using_more_than_initially_reserved"};
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(stringArray, Notification.class.getName(), "Memory Notification Event");
        MBeanInfo mBeanInfo = new MBeanInfo(MemoryMXBeanImpl.class.getName(), MemoryMXBeanImpl.class.getName(), mBeanAttributeInfoArray, null, mBeanOperationInfoArray, mBeanNotificationInfoArray);
        hashMap.put(MemoryMXBean.class.getName(), mBeanInfo);
    }

    private static void addTimeBeanInfo(HashMap<String, MBeanInfo> hashMap) {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[]{new MBeanAttributeInfo("ElapsedTimeSinceJVMStartSec", Double.TYPE.getName(), "Elapsed Time Since the Start of the Zing VM or load of the Zing VM shared library (Sec)", true, false, false), new MBeanAttributeInfo("UnixTimeOfJVMStartMillis", Long.TYPE.getName(), "Start Time of Zing VM (millisec since 1970, Unix Time)", true, false, false), new MBeanAttributeInfo("UnixTimeOfJVMStartAsDateTimeString", String.class.getName(), "Start Time of Zing VM (millisec since 1970, Unix Time) as a String Using Environment's Timezone", true, false, false), new MBeanAttributeInfo("Version", String.class.getName(), "Version of the TimeMXBean API", true, false, false)};
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[3];
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[]{new MBeanParameterInfo("timeSec", Double.TYPE.getName(), "Time Since the Start of the Zing VM (seconds)")};
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("convertElapsedTimeSinceJVMStartSecToDateTimeString", "Convert Elapsed Time Since JVM Start (seconds) to Date-Time String", mBeanParameterInfoArray, String.class.getName(), 2);
        MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[]{new MBeanParameterInfo("formatString", String.class.getName(), "Format String to use to Format Date-Time String")};
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("setFormatForDateTimeString", "Set Custom Format For Date-Time String", mBeanParameterInfoArray2, Boolean.TYPE.getName(), 2);
        MBeanParameterInfo[] mBeanParameterInfoArray3 = new MBeanParameterInfo[]{};
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("setFormatForDateTimeStringToDefaultValue", "Set Format String for Date-Time String to the Default Value", mBeanParameterInfoArray3, Boolean.TYPE.getName(), 2);
        MBeanInfo mBeanInfo = new MBeanInfo(TimeMXBeanImpl.class.getName(), TimeMXBeanImpl.class.getName(), mBeanAttributeInfoArray, null, mBeanOperationInfoArray, null);
        hashMap.put(TimeMXBean.class.getName(), mBeanInfo);
    }

    private static void addMemoryManagerBeanInfo(HashMap<String, MBeanInfo> hashMap) {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[]{new MBeanAttributeInfo("MemoryPoolNames", "[Ljava.lang.String;", "Names of the Memory Pools Managed by this Memory Manager", true, false, false), new MBeanAttributeInfo("Name", String.class.getName(), "Name of this Memory Manager", true, false, false), new MBeanAttributeInfo("Valid", Boolean.TYPE.getName(), "Valid, Active, In-use Memory Manager", true, false, true), new MBeanAttributeInfo("Version", String.class.getName(), "Version of the MemoryManagerMXBean API", true, false, false)};
        hashMap.put(MemoryManagerMXBean.class.getName(), new MBeanInfo(MemoryManagerMXBeanImpl.class.getName(), MemoryManagerMXBeanImpl.class.getName(), mBeanAttributeInfoArray, null, null, null));
    }

    private static void addGarbageCollectorBeanInfo(HashMap<String, MBeanInfo> hashMap) {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[]{new MBeanAttributeInfo("MemoryPoolNames", "[Ljava.lang.String;", "Names of the Memory Pools Managed by this Garbage Collector ", true, false, false), new MBeanAttributeInfo("Name", String.class.getName(), "Name of the Garbage Collector", true, false, false), new MBeanAttributeInfo("Valid", Boolean.TYPE.getName(), "Valid, Active, In-use Garbage Collector", true, false, true), new MBeanAttributeInfo("CollectionCount", Long.TYPE.getName(), "Collection Count", true, false, false), new MBeanAttributeInfo("DurationOfLastCompletedCollection", Double.TYPE.getName(), "Duration of Last Completed Collection", true, false, false), new MBeanAttributeInfo("TimeOfLastCollectionEnd", Double.TYPE.getName(), "Time of Last Collection End", true, false, false), new MBeanAttributeInfo("TimeOfPenultimateCollectionEnd", Double.TYPE.getName(), "Time of Penultimate Collection End", true, false, false), new MBeanAttributeInfo("CollectorCumulativeRunningTimeSec", Double.TYPE.getName(), "Collector Cumulative Running Time (Sec)", true, false, false), new MBeanAttributeInfo("CollectorCumulativePauseTimeSec", Double.TYPE.getName(), "Collector Cumulative Pause Time (Sec)", true, false, false), new MBeanAttributeInfo("TimeOfLastResetCollectorCumulativeCounters", Double.TYPE.getName(), "Time of Last Reset for Collector Cumulative Counters", true, false, false), new MBeanAttributeInfo("PercentageOfTimeCollectorIsRunning", Double.TYPE.getName(), "Percentage of Time Collector is Running", true, false, false), new MBeanAttributeInfo("HighestPercentageOfTimeCollectorIsRunning", Double.TYPE.getName(), "Highest Percentage of Time Collector is Running", true, false, false), new MBeanAttributeInfo("TimeOfLastResetHighestPercentageOfTimeCollectorIsRunning", Double.TYPE.getName(), "Time of Last Reset of the Highest Percentage of Time Collector is Running", true, false, false), new MBeanAttributeInfo("CollectorMaxPauseDetails", TabularData.class.getName(), "Collector's Maximum PauseDetails Metrics for each Collection-Related Safepoint", true, false, false), new MBeanAttributeInfo("TimeOfLastResetCollectorMaxPauseDetails", Double.TYPE.getName(), "Time of Last Reset of the Collector's Maximum PauseDetails Metrics", true, false, false), new MBeanAttributeInfo("GarbageCollectorThreadCount", Integer.TYPE.getName(), "Garbage Collector Thread Count", true, false, false), new MBeanAttributeInfo("LastGCDetails", CompositeData.class.getName(), "GCDetails Metrics for the Last Completed Garbage Collection by this Collector", true, false, false), new MBeanAttributeInfo("PercentageOfTimeCollectorIsRunningThreshold", Double.TYPE.getName(), "Value of the Threshold at which a Notification is Generated for the Percentage of Time the Collector is Running", true, true, false), new MBeanAttributeInfo("PercentageOfTimeCollectorIsRunningThresholdExceededCount", Long.TYPE.getName(), "Number of Times the Value of the Threshold for the Percentage of Time the Collector is Running has been Exceeded", true, false, false), new MBeanAttributeInfo("PercentageOfTimeCollectorIsRunningThresholdExceeded", Boolean.TYPE.getName(), "Was the Value of the Threshold for the Percentage of Time the Collector is Running Exceeded over the Interval Between the End of the Penultimate and Last Completed Collection for this Collector", true, false, true), new MBeanAttributeInfo("GarbageCollectionPauseDurationThreshold", Double.TYPE.getName(), "Value of the Threshold at which a Notification is Generated for the Pause Duration", true, true, false), new MBeanAttributeInfo("GarbageCollectionPauseDurationThresholdExceededCount", Long.TYPE.getName(), "Number of Times the Value of the Threshold for the Pause Duration has been Exceeded", true, false, false), new MBeanAttributeInfo("GarbageCollectionPauseDurationThresholdExceeded", Boolean.TYPE.getName(), "Was the Value of the Threshold for the Pause Duration Exceeded over the Interval Between the End of the Penultimate and Last Completed Collection for this Collector", true, false, true), new MBeanAttributeInfo("GarbageCollectionDurationThreshold", Double.TYPE.getName(), "Value of the Threshold at which a Notification is Generated for the Collection Duration", true, true, false), new MBeanAttributeInfo("GarbageCollectionDurationThresholdExceededCount", Long.TYPE.getName(), "Number of Times the Value of the Threshold for the Collection Duration has been Exceeded", true, false, false), new MBeanAttributeInfo("GarbageCollectionDurationThresholdExceeded", Boolean.TYPE.getName(), "Was the Value of the Threshold for the Collection Duration Exceeded over the Interval Between the End of the Penultimate and Last Completed Collection for this Collector", true, false, true), new MBeanAttributeInfo("IntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded", Long.TYPE.getName(), "IntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded", true, true, false), new MBeanAttributeInfo("Version", String.class.getName(), "Version of the GarbageCollectorMXBean API", true, false, false)};
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[7];
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[]{};
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("resetCollectorCumulativeCounters", "Reset Collector Cumulative Counters", mBeanParameterInfoArray, Double.TYPE.getName(), 2);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("resetHighestPercentageOfTimeCollectorIsRunning", "Reset Highest Percentage of Time Collector is Running", mBeanParameterInfoArray, Double.TYPE.getName(), 2);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("resetCollectorMaxPauseDetails", "Reset Collector Max Pause Details", mBeanParameterInfoArray, Double.TYPE.getName(), 2);
        MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[]{new MBeanParameterInfo("SetThreshold", Double.TYPE.getName(), "Threshold Value in Percent [0 - 100]")};
        mBeanOperationInfoArray[3] = new MBeanOperationInfo("setPercentageOfTimeCollectorIsRunningThreshold", "Set Percentage of Time Collector is Running Threshold [1 - 100]", mBeanParameterInfoArray2, Boolean.TYPE.getName(), 2);
        MBeanParameterInfo[] mBeanParameterInfoArray3 = new MBeanParameterInfo[]{new MBeanParameterInfo("SetThreshold", Double.TYPE.getName(), "Theshold Value in Seconds")};
        mBeanOperationInfoArray[4] = new MBeanOperationInfo("setGarbageCollectionPauseDurationThreshold", "Set Garbage Collection Pause Duration Threshold (seconds)", mBeanParameterInfoArray3, Boolean.TYPE.getName(), 2);
        MBeanParameterInfo[] mBeanParameterInfoArray4 = new MBeanParameterInfo[]{new MBeanParameterInfo("SetThreshold", Double.TYPE.getName(), "Theshold Value in Seconds")};
        mBeanOperationInfoArray[5] = new MBeanOperationInfo("setGarbageCollectionDurationThreshold", "Set Garbage Collection Duration Threshold (seconds)", mBeanParameterInfoArray4, Boolean.TYPE.getName(), 2);
        MBeanParameterInfo[] mBeanParameterInfoArray5 = new MBeanParameterInfo[]{new MBeanParameterInfo("SecondsToWaitBeforeRenotify", Long.TYPE.getName(), "Seconds To Wait Before Renotify")};
        mBeanOperationInfoArray[6] = new MBeanOperationInfo("setIntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded", "Set Interval To Wait Before Renotify When Threshold Continuously Exceeded (seconds)", mBeanParameterInfoArray5, Boolean.TYPE.getName(), 2);
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        String[] stringArray = new String[]{"com.azul.zing.management.garbage.collector.collection.notification", "com.azul.zing.management.garbage.collector.application_thread_allocation_delayed.notification", "com.azul.zing.management.garbage.collector.percentage_of_time_collector_is_running.threshold.exceeded", "com.azul.zing.management.garbage.collector.pause_duration.threshold.exceeded", "com.azul.zing.management.garbage.collector.collection_duration.threshold.exceeded"};
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(stringArray, Notification.class.getName(), "Garbage Collector Notification");
        MBeanInfo mBeanInfo = new MBeanInfo(GarbageCollectorMXBeanImpl.class.getName(), GarbageCollectorMXBeanImpl.class.getName(), mBeanAttributeInfoArray, null, mBeanOperationInfoArray, mBeanNotificationInfoArray);
        hashMap.put(GarbageCollectorMXBean.class.getName(), mBeanInfo);
    }

    public static MemoryMXBeanImpl getMemoryBean() {
        return MemoryMXBeanImpl.getInstance();
    }

    public static TimeMXBeanImpl getTimeBean() {
        return TimeMXBeanImpl.getInstance();
    }

    public static PersistentProfileMXBeanImpl getPersistentProfileBean() {
        return PersistentProfileMXBeanImpl.getInstance();
    }

    public static Object getConnectedCompilerClientBean() {
        try {
            Class<?> clazz = Class.forName("com.azul.zing.impl.management.ConnectedCompilerClientMXBeanImpl");
            Method method = clazz.getDeclaredMethod("getInstance", new Class[0]);
            return method.invoke(clazz, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return new LinkedList<MemoryManagerMXBean>(ManagementMXBeanUtils.getMemoryBean().getMemoryManagerMXBeans());
    }

    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        LinkedList<MemoryPoolMXBean> linkedList = new LinkedList<MemoryPoolMXBean>();
        for (MemoryManagerMXBeanImpl memoryManagerMXBeanImpl : ManagementMXBeanUtils.getMemoryManagerMXBeans()) {
            linkedList.addAll(memoryManagerMXBeanImpl.getMemoryPoolMXBeans());
        }
        return linkedList;
    }

    public static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        LinkedList<GarbageCollectorMXBean> linkedList = new LinkedList<GarbageCollectorMXBean>();
        for (MemoryManagerMXBean memoryManagerMXBean : ManagementMXBeanUtils.getMemoryBean().getMemoryManagerMXBeans()) {
            if (!(memoryManagerMXBean instanceof GarbageCollectorMXBean)) continue;
            linkedList.add((GarbageCollectorMXBean)memoryManagerMXBean);
        }
        return linkedList;
    }

    public static <T> boolean isANotificationEmitter(Class<T> clazz) {
        MBeanNotificationInfo[] mBeanNotificationInfoArray;
        boolean bl = false;
        MBeanInfo mBeanInfo = ManagementMXBeanUtils.getMBeanInfo(clazz.getName());
        if (mBeanInfo != null && (mBeanNotificationInfoArray = mBeanInfo.getNotifications()) != null && mBeanNotificationInfoArray.length > 0) {
            bl = true;
        }
        return bl;
    }
}

