/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.impl.management;

import com.azul.zing.impl.management.ManagementUtils;
import com.azul.zing.impl.management.internal.nls.Messages;
import com.azul.zing.management.GCDetails;
import com.azul.zing.management.GarbageCollectorNotificationInfo;
import com.azul.zing.management.MemoryNotificationInfo;
import com.azul.zing.management.MemoryPoolNotificationInfo;
import com.azul.zing.management.MemoryType;
import com.azul.zing.management.MemoryUsage;
import com.azul.zing.management.PauseDetails;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class ManagementCompositeData {
    private static CompositeType PAUSEDETAILS_COMPOSITETYPE = null;
    private static CompositeType MEMORYUSAGE_COMPOSITETYPE = null;
    private static CompositeType MEMORYNOTIFICATIONINFO_COMPOSITETYPE = null;
    private static CompositeType MEMORYPOOLNOTIFICATIONINFO_COMPOSITETYPE = null;
    private static CompositeType GARBAGECOLLECTORNOTIFICATIONINFO_COMPOSITETYPE = null;
    private static CompositeType GCDETAILS_COMPOSITETYPE = null;
    private static String[] GCDETAILS_ATTRIBUTENAMES = null;
    private static final String[] memoryUsageItemNames = new String[]{"memoryPoolSizeType", "initialReserved", "size", "used", "elapsedTimeSinceJVMStartSec"};
    private static final String[] memoryUsageItemDescs = new String[]{"memoryPoolSizeType", "initialReserved", "size", "used", "elapsedTimeSinceJVMStartSec"};
    private static final OpenType<?>[] memoryUsageItemOpenTypes = new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.DOUBLE};
    private static final String[] mapStringMemoryUsageItemNames = new String[]{"key", "value"};
    private static final String[] mapStringMemoryUsageItemDescs = new String[]{"key", "value"};
    private static final OpenType<?>[] mapStringMemoryUsageItemOpenTypes = new OpenType[]{SimpleType.STRING, ManagementCompositeData.getMemoryUsageCompositeType()};
    private static final String[] pauseDetailsItemNames = new String[]{"elapsedTimeSinceJVMStartSec", "durationSec", "reason", "initialThreadsLockAcquireTimeSec", "collectorSuspendTimeSec", "threadsNotifyTimeSec", "timeForThreadsToSuspendSec", "collectorSecondSuspendTimeSec", "operationTimeSec", "postOperationCleanupTimeSec", "timeToWakeupThreadsSec", "pauseId"};
    private static final String[] pauseDetailsItemDescs = new String[]{"elapsedTimeSinceJVMStartSec", "durationSec", "reason", "initialThreadsLockAcquireTimeSec", "collectorSuspendTimeSec", "threadsNotifyTimeSec", "timeForThreadsToSuspendSec", "collectorSecondSuspendTimeSec", "operationTimeSec", "postOperationCleanupTimeSec", "timeToWakeupThreadsSec", "pauseId"};
    private static final OpenType<?>[] pauseDetailsItemOpenTypes = new OpenType[]{SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.STRING, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.LONG};

    public static void verifyFieldTypes(CompositeData compositeData, String[] stringArray, String[] stringArray2) {
        Object[] objectArray = compositeData.getAll(stringArray);
        if (objectArray.length != stringArray2.length) {
            throw new IllegalArgumentException("ManagementCompositeData.verifyFieldTypes with Type mismatch of length with allVals.length: " + objectArray.length + " and expectedTypes.length: " + stringArray2.length);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            String string;
            String string2 = stringArray2[i];
            Object object = objectArray[i];
            if (object == null || (string = object.getClass().getName()).equals(string2) || string2.equals(CompositeData.class.getName()) && objectArray[i] instanceof CompositeData) continue;
            throw new IllegalArgumentException("ManagementCompositeData.verifyFieldTypes with Type mismatch at index " + i + " with expectedType: " + string2 + " and actualType: " + string);
        }
    }

    public static void verifyFieldNames(CompositeData compositeData, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (compositeData.containsKey(stringArray[i])) continue;
            throw new IllegalArgumentException(Messages.getString("lm.10", stringArray[i]));
        }
    }

    public static void verifyFieldNumber(CompositeData compositeData, int n) {
        if (compositeData.values().size() < n) {
            throw new IllegalArgumentException(Messages.getString("lm.11"));
        }
    }

    public static String[] getGCDetailsAttributeNames() {
        if (GCDETAILS_ATTRIBUTENAMES == null) {
            GCDETAILS_ATTRIBUTENAMES = new String[]{"validData", "id", "startTime", "endTime", "timeFromEndOfPreviousToStart", "collectionDuration", "percentageOfTimeCollectorIsRunning", "garbageCollectionType", "garbageCollectionCause", "garbageCollectionMinorMajorTotalCount", "liveInGeneration", "fragmentedSpaceInGeneration", "garbageFound", "garbageCollected", "peakJavaHeapUsedSinceEndOfPreviousCollection", "maximumMemoryAvailableForJavaHeap", "ableToUseContingencyMemory", "hasContingencyMemoryBeenUsedSinceEndOfPreviousCollection", "allocationRateDuringCollection", "allocationRateBetweenEndOfPreviousAndStart", "permAllocationRateDuringCollection", "permAllocationRateBetweenEndOfPreviousAndStart", "hasPausePreventionMemoryBeenUsedSinceEndOfPreviousCollection", "hasRequestForPausePreventionMemoryFailedSinceEndOfPreviousCollection", "peakPausePreventionMemoryUsedSinceEndOfPreviousCollection", "unreturnedPausePreventionMemory", "ableToUsePausePreventionMemory", "garbageCollectorThreadCount", "totalApplicationThreadCount", "numberOfApplicationThreadsDelayed", "averageApplicationThreadDelay", "maximumApplicationThreadDelay", "sidebandMemoryUse", "promotedPages", "relocatedPages", "noRelocatePages", "relocSpikePages", "smallSpacePages", "midSpacePages", "largeSpacePages", "compilersEnabled", "memoryUsageAtStartOfGC", "memoryUsageAtEndOfGC", "collectorRequiredPauseDetails", "collectorRequiredMaxPauseDetails"};
        }
        return GCDETAILS_ATTRIBUTENAMES;
    }

    public static CompositeData toCompositeDataFromGCDetails(GCDetails gCDetails) {
        CompositeDataSupport compositeDataSupport;
        block2: {
            compositeDataSupport = null;
            Object[] objectArray = new Object[]{gCDetails.isValidData(), gCDetails.getId(), gCDetails.getStartTime(), gCDetails.getEndTime(), gCDetails.getTimeFromEndOfPreviousToStart(), gCDetails.getCollectionDuration(), gCDetails.getPercentageOfTimeCollectorIsRunning(), gCDetails.getGarbageCollectionType(), gCDetails.getGarbageCollectionCause(), gCDetails.getGarbageCollectionMinorMajorTotalCount(), gCDetails.getLiveInGeneration(), gCDetails.getFragmentedSpaceInGeneration(), gCDetails.getGarbageFound(), gCDetails.getGarbageCollected(), gCDetails.getPeakJavaHeapUsedSinceEndOfPreviousCollection(), gCDetails.getMaximumMemoryAvailableForJVMsJavaHeap(), gCDetails.isAbleToUseContingencyMemory(), gCDetails.getHasContingencyMemoryBeenUsedSinceEndOfPreviousCollection(), gCDetails.getAllocationRateDuringCollection(), gCDetails.getAllocationRateBetweenEndOfPreviousAndStart(), gCDetails.getPermAllocationRateDuringCollection(), gCDetails.getPermAllocationRateBetweenEndOfPreviousAndStart(), gCDetails.getHasPausePreventionMemoryBeenUsedSinceEndOfPreviousCollection(), gCDetails.getHasRequestForPausePreventionMemoryFailedSinceEndOfPreviousCollection(), gCDetails.getPeakPausePreventionMemoryUsedSinceEndOfPreviousCollection(), gCDetails.getUnreturnedPausePreventionMemory(), gCDetails.isAbleToUsePausePreventionMemory(), gCDetails.getGarbageCollectorThreadCount(), gCDetails.getTotalApplicationThreadCount(), gCDetails.getNumberOfApplicationThreadsDelayed(), gCDetails.getAverageApplicationThreadDelay(), gCDetails.getMaximumApplicationThreadDelay(), gCDetails.getSidebandMemoryUse(), gCDetails.getPromotedPages(), gCDetails.getRelocatedPages(), gCDetails.getNoRelocatePages(), gCDetails.getRelocSpikePages(), gCDetails.getSmallSpacePages(), gCDetails.getMidSpacePages(), gCDetails.getLargeSpacePages(), gCDetails.getCompilersEnabled(), ManagementCompositeData.toTabularDataFromMapStringMemoryUsage(gCDetails.getMemoryUsageAtStartOfGC()), ManagementCompositeData.toTabularDataFromMapStringMemoryUsage(gCDetails.getMemoryUsageAtEndOfGC()), ManagementCompositeData.toTabularDataFromListOfPauseDetails(gCDetails.getCollectorRequiredPauseDetails()), ManagementCompositeData.toTabularDataFromListOfPauseDetails(gCDetails.getCollectorRequiredMaxPauseDetails())};
            CompositeType compositeType = ManagementCompositeData.getGCDetailsCompositeType();
            try {
                compositeDataSupport = new CompositeDataSupport(compositeType, ManagementCompositeData.getGCDetailsAttributeNames(), objectArray);
            }
            catch (OpenDataException openDataException) {
                if (!ManagementUtils.VERBOSE_MODE) break block2;
                openDataException.printStackTrace(System.err);
            }
        }
        return compositeDataSupport;
    }

    private static CompositeType getGCDetailsCompositeType() {
        block8: {
            Object object;
            Serializable serializable;
            TabularType tabularType;
            TabularType tabularType2;
            block7: {
                tabularType2 = null;
                tabularType = null;
                try {
                    serializable = new HashMap<String, MemoryUsage>();
                    tabularType2 = ManagementCompositeData.getTabularTypeForMapStringMemoryUsage(serializable);
                    if (tabularType2 == null) {
                        System.err.println("ManagementCompositeData.getGCDetailsCompositeType value of Map<String, MemoryUsage> TabularType is null");
                    }
                    if ((tabularType = ManagementCompositeData.getTabularTypeForPauseDetails((PauseDetails)(object = new PauseDetails(0.0, 0.0, "", 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0L)))) == null) {
                        System.err.println("ManagementCompositeData.getGCDetailsCompositeType value of PauseDetails TabularType is null");
                    }
                }
                catch (Exception exception) {
                    if (!ManagementUtils.VERBOSE_MODE) break block7;
                    exception.printStackTrace(System.err);
                }
            }
            if (GCDETAILS_COMPOSITETYPE == null) {
                try {
                    serializable = SimpleType.BOOLEAN;
                    object = SimpleType.DOUBLE;
                    SimpleType<Long> simpleType = SimpleType.LONG;
                    SimpleType<String> simpleType2 = SimpleType.STRING;
                    OpenType[] openTypeArray = new OpenType[]{serializable, simpleType, object, object, object, object, object, simpleType2, simpleType2, simpleType, simpleType, simpleType, simpleType, simpleType, simpleType, simpleType, serializable, serializable, object, object, object, object, serializable, serializable, simpleType, simpleType, serializable, simpleType, simpleType, simpleType, object, object, simpleType, simpleType, simpleType, simpleType, simpleType, simpleType, simpleType, simpleType, serializable, tabularType2, tabularType2, tabularType, tabularType};
                    GCDETAILS_COMPOSITETYPE = new CompositeType(GCDetails.class.getName(), GCDetails.class.getName(), ManagementCompositeData.getGCDetailsAttributeNames(), ManagementCompositeData.getGCDetailsAttributeNames(), openTypeArray);
                }
                catch (OpenDataException openDataException) {
                    if (!ManagementUtils.VERBOSE_MODE) break block8;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return GCDETAILS_COMPOSITETYPE;
    }

    private static MemoryType convertStringToMemoryType(String string) {
        MemoryType memoryType;
        block2: {
            memoryType = null;
            try {
                memoryType = MemoryType.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!ManagementUtils.VERBOSE_MODE) break block2;
                illegalArgumentException.printStackTrace(System.err);
            }
        }
        return memoryType;
    }

    public static CompositeType getMemoryUsageCompositeType() {
        if (MEMORYUSAGE_COMPOSITETYPE == null) {
            try {
                MEMORYUSAGE_COMPOSITETYPE = new CompositeType(MemoryUsage.class.getName(), MemoryUsage.class.getName(), memoryUsageItemNames, memoryUsageItemDescs, memoryUsageItemOpenTypes);
            }
            catch (OpenDataException openDataException) {
                if (ManagementUtils.VERBOSE_MODE) {
                    openDataException.printStackTrace(System.err);
                }
                return null;
            }
            catch (Exception exception) {
                if (ManagementUtils.VERBOSE_MODE) {
                    exception.printStackTrace(System.err);
                }
                return null;
            }
        }
        return MEMORYUSAGE_COMPOSITETYPE;
    }

    public static CompositeData createCompositeDataFromMemoryUsageObject(MemoryUsage memoryUsage) {
        if (memoryUsage == null) {
            return null;
        }
        CompositeDataSupport compositeDataSupport = null;
        Object[] objectArray = new Object[]{memoryUsage.getMemoryPoolSizeType().toString(), memoryUsage.getInitialReserved(), memoryUsage.getSize(), memoryUsage.getUsed(), memoryUsage.getElapsedTimeSinceJVMStartSec()};
        CompositeType compositeType = ManagementCompositeData.getMemoryUsageCompositeType();
        if (compositeType == null) {
            return null;
        }
        try {
            compositeDataSupport = new CompositeDataSupport(compositeType, memoryUsageItemNames, objectArray);
        }
        catch (OpenDataException openDataException) {
            if (ManagementUtils.VERBOSE_MODE) {
                openDataException.printStackTrace(System.err);
            }
            return null;
        }
        catch (Exception exception) {
            if (ManagementUtils.VERBOSE_MODE) {
                exception.printStackTrace(System.err);
            }
            return null;
        }
        return compositeDataSupport;
    }

    public static TabularData toTabularDataFromArrayOfMemoryUsage(Object object) {
        if (object == null) {
            return null;
        }
        TabularDataSupport tabularDataSupport = null;
        try {
            MemoryUsage[] memoryUsageArray = (MemoryUsage[])object;
            int n = memoryUsageArray.length;
            if (n < 1 || memoryUsageArray[0] == null) {
                if (ManagementUtils.VERBOSE_MODE) {
                    System.err.println("ManagementCompositeData.toTabularDataFromArrayOfMemoryUsage: ERROR: MemoryUsage array is empty");
                    Thread.dumpStack();
                }
                return null;
            }
            CompositeType compositeType = ManagementCompositeData.getMemoryUsageCompositeType();
            TabularType tabularType = new TabularType(memoryUsageArray[0].getClass().getName(), memoryUsageArray[0].getClass().getName(), compositeType, memoryUsageItemNames);
            tabularDataSupport = new TabularDataSupport(tabularType);
            for (int i = 0; i < n; ++i) {
                MemoryUsage memoryUsage = memoryUsageArray[i];
                tabularDataSupport.put(new CompositeDataSupport(compositeType, memoryUsageItemNames, new Object[]{memoryUsage.getMemoryPoolSizeType().toString(), memoryUsage.getInitialReserved(), memoryUsage.getSize(), memoryUsage.getUsed(), memoryUsage.getElapsedTimeSinceJVMStartSec()}));
            }
        }
        catch (OpenDataException openDataException) {
            if (ManagementUtils.VERBOSE_MODE) {
                openDataException.printStackTrace(System.err);
            }
            tabularDataSupport = null;
        }
        catch (Exception exception) {
            if (ManagementUtils.VERBOSE_MODE) {
                exception.printStackTrace(System.err);
            }
            tabularDataSupport = null;
        }
        return tabularDataSupport;
    }

    public static CompositeType getCompositeTypeForMapStringMemoryUsage(Map<String, MemoryUsage> map) {
        CompositeType compositeType = null;
        try {
            String string = map.getClass().getName();
            if (ManagementUtils.TRACE) {
                System.out.println("ManagementCompositeData.getCompositeTypeForMapStringMemoryUsage(): input name: " + string);
            }
            string = "java.util.Map<String,MemoryUsage>";
            if (ManagementUtils.TRACE) {
                System.out.println("ManagementCompositeData.getCompositeTypeForMapStringMemoryUsage(): using name: " + string);
            }
            compositeType = new CompositeType(string, string, mapStringMemoryUsageItemNames, mapStringMemoryUsageItemDescs, mapStringMemoryUsageItemOpenTypes);
        }
        catch (OpenDataException openDataException) {
            if (ManagementUtils.VERBOSE_MODE) {
                openDataException.printStackTrace(System.err);
            }
            compositeType = null;
        }
        catch (Exception exception) {
            if (ManagementUtils.VERBOSE_MODE) {
                exception.printStackTrace(System.err);
            }
            compositeType = null;
        }
        return compositeType;
    }

    public static TabularType getTabularTypeForMapStringMemoryUsage(Map<String, MemoryUsage> map) {
        TabularType tabularType = null;
        try {
            CompositeType compositeType = ManagementCompositeData.getCompositeTypeForMapStringMemoryUsage(map);
            if (compositeType == null) {
                return null;
            }
            String string = map.getClass().getName();
            string = "java.util.Map<String,MemoryUsage>";
            tabularType = new TabularType(string, string, compositeType, mapStringMemoryUsageItemNames);
        }
        catch (OpenDataException openDataException) {
            if (ManagementUtils.VERBOSE_MODE) {
                openDataException.printStackTrace(System.err);
            }
            tabularType = null;
        }
        catch (Exception exception) {
            if (ManagementUtils.VERBOSE_MODE) {
                exception.printStackTrace(System.err);
            }
            tabularType = null;
        }
        return tabularType;
    }

    public static TabularData toTabularDataFromMapStringMemoryUsage(Map<String, MemoryUsage> map) {
        if (map == null) {
            if (ManagementUtils.VERBOSE_MODE) {
                System.err.println("ManagementCompositeData.toTabularDataFromMapStringMemoryUsage(): null parameter passed in");
                Thread.dumpStack();
            }
            return null;
        }
        TabularDataSupport tabularDataSupport = null;
        try {
            CompositeType compositeType = ManagementCompositeData.getCompositeTypeForMapStringMemoryUsage(map);
            if (compositeType == null) {
                if (ManagementUtils.VERBOSE_MODE) {
                    System.err.println("ManagementCompositeData.toTabularDataFromMapStringMemoryUsage(): null row type");
                    Thread.dumpStack();
                }
                return null;
            }
            TabularType tabularType = ManagementCompositeData.getTabularTypeForMapStringMemoryUsage(map);
            if (tabularType == null) {
                if (ManagementUtils.VERBOSE_MODE) {
                    System.err.println("ManagementCompositeData.toTabularDataFromMapStringMemoryUsage(): null after creation of TabularType1");
                    Thread.dumpStack();
                }
                return null;
            }
            tabularDataSupport = new TabularDataSupport(tabularType);
            Set<Map.Entry<String, MemoryUsage>> set = map.entrySet();
            for (Map.Entry<String, MemoryUsage> entry : set) {
                MemoryUsage memoryUsage = entry.getValue();
                CompositeData compositeData = ManagementCompositeData.createCompositeDataFromMemoryUsageObject(memoryUsage);
                tabularDataSupport.put(new CompositeDataSupport(compositeType, mapStringMemoryUsageItemNames, new Object[]{entry.getKey(), compositeData}));
            }
        }
        catch (OpenDataException openDataException) {
            if (ManagementUtils.VERBOSE_MODE) {
                System.err.println("ManagementCompositeData.toTabularDataFromMapStringMemoryUsage(): OpenDataException");
                openDataException.printStackTrace(System.err);
            }
            tabularDataSupport = null;
        }
        catch (Exception exception) {
            if (ManagementUtils.VERBOSE_MODE) {
                System.err.println("ManagementCompositeData.toTabularDataFromMapStringMemoryUsage(): Exception");
                exception.printStackTrace(System.err);
            }
            tabularDataSupport = null;
        }
        if (ManagementUtils.TRACE) {
            System.out.println("ManagementCompositeData.toTabularDataFromMapStringMemoryUsage(): exit");
        }
        return tabularDataSupport;
    }

    public static CompositeType getPauseDetailsCompositeType() {
        if (PAUSEDETAILS_COMPOSITETYPE == null) {
            try {
                PAUSEDETAILS_COMPOSITETYPE = new CompositeType(PauseDetails.class.getName(), PauseDetails.class.getName(), pauseDetailsItemNames, pauseDetailsItemDescs, pauseDetailsItemOpenTypes);
            }
            catch (OpenDataException openDataException) {
                if (ManagementUtils.VERBOSE_MODE) {
                    openDataException.printStackTrace(System.err);
                }
                return null;
            }
            catch (Exception exception) {
                if (ManagementUtils.VERBOSE_MODE) {
                    exception.printStackTrace(System.err);
                }
                return null;
            }
        }
        return PAUSEDETAILS_COMPOSITETYPE;
    }

    public static TabularType getTabularTypeForPauseDetails(PauseDetails pauseDetails) {
        TabularType tabularType = null;
        try {
            CompositeType compositeType = ManagementCompositeData.getPauseDetailsCompositeType();
            if (compositeType == null) {
                return null;
            }
            String string = pauseDetails.getClass().getName();
            tabularType = new TabularType(string, string, compositeType, pauseDetailsItemNames);
        }
        catch (OpenDataException openDataException) {
            if (ManagementUtils.VERBOSE_MODE) {
                openDataException.printStackTrace(System.err);
            }
            tabularType = null;
        }
        catch (Exception exception) {
            if (ManagementUtils.VERBOSE_MODE) {
                exception.printStackTrace(System.err);
            }
            tabularType = null;
        }
        return tabularType;
    }

    public static CompositeData createCompositeDataFromPauseDetailsObject(PauseDetails pauseDetails) {
        if (pauseDetails == null) {
            return null;
        }
        CompositeDataSupport compositeDataSupport = null;
        Object[] objectArray = new Object[]{pauseDetails.getElapsedTimeSinceJVMStartSec(), pauseDetails.getDurationSec(), pauseDetails.getReason().toString(), pauseDetails.getInitialThreadsLockAcquireTimeSec(), pauseDetails.getCollectorSuspendTimeSec(), pauseDetails.getThreadsNotifyTimeSec(), pauseDetails.getTimeForThreadsToSuspendSec(), pauseDetails.getCollectorSecondSuspendTimeSec(), pauseDetails.getOperationTimeSec(), pauseDetails.getPostOperationCleanupTimeSec(), pauseDetails.getTimeToWakeupThreadsSec(), pauseDetails.getPauseId()};
        CompositeType compositeType = ManagementCompositeData.getPauseDetailsCompositeType();
        try {
            compositeDataSupport = new CompositeDataSupport(compositeType, pauseDetailsItemNames, objectArray);
        }
        catch (OpenDataException openDataException) {
            if (ManagementUtils.VERBOSE_MODE) {
                openDataException.printStackTrace(System.err);
            }
            compositeDataSupport = null;
        }
        catch (Exception exception) {
            if (ManagementUtils.VERBOSE_MODE) {
                exception.printStackTrace(System.err);
            }
            compositeDataSupport = null;
        }
        return compositeDataSupport;
    }

    public static TabularData toTabularDataFromListOfPauseDetails(Object object) {
        TabularDataSupport tabularDataSupport;
        block21: {
            if (ManagementUtils.VERBOSE_MODE) {
                System.err.println("ManagementCompositeData.toTabularDataFromListOfPauseDetails: Entry");
            }
            if (object == null) {
                return null;
            }
            tabularDataSupport = null;
            try {
                CompositeType compositeType = ManagementCompositeData.getPauseDetailsCompositeType();
                String string = PauseDetails.class.getName();
                TabularType tabularType = new TabularType(string, string, compositeType, pauseDetailsItemNames);
                tabularDataSupport = new TabularDataSupport(tabularType);
                if (object instanceof List) {
                    if (ManagementUtils.VERBOSE_MODE) {
                        System.err.println("ManagementCompositeData.toTabularDataFromListOfPauseDetails: List");
                    }
                    Class<PauseDetails> clazz = PauseDetails.class;
                    ArrayList arrayList = new ArrayList();
                    for (Object e : (List)object) {
                        if (e != null && clazz.isAssignableFrom(e.getClass())) {
                            arrayList.add(clazz.cast(e));
                            continue;
                        }
                        if (ManagementUtils.VERBOSE_MODE) {
                            System.err.println("ManagementCompositeData.toTabularDataFromListOfPauseDetails (List): ERROR: List of PauseDetails has entry that is null or is not a PauseDetails object");
                        }
                        return null;
                    }
                    int n = arrayList.size();
                    if (n < 1 || arrayList.get(0) == null) {
                        if (ManagementUtils.VERBOSE_MODE) {
                            System.err.println("ManagementCompositeData.toTabularDataFromListOfPauseDetails (List): ERROR: PauseDetails list is empty");
                        }
                        return null;
                    }
                    for (int i = 0; i < n; ++i) {
                        PauseDetails pauseDetails = (PauseDetails)arrayList.get(i);
                        tabularDataSupport.put(new CompositeDataSupport(compositeType, pauseDetailsItemNames, new Object[]{pauseDetails.getElapsedTimeSinceJVMStartSec(), pauseDetails.getDurationSec(), pauseDetails.getReason(), pauseDetails.getInitialThreadsLockAcquireTimeSec(), pauseDetails.getCollectorSuspendTimeSec(), pauseDetails.getThreadsNotifyTimeSec(), pauseDetails.getTimeForThreadsToSuspendSec(), pauseDetails.getCollectorSecondSuspendTimeSec(), pauseDetails.getOperationTimeSec(), pauseDetails.getPostOperationCleanupTimeSec(), pauseDetails.getTimeToWakeupThreadsSec(), pauseDetails.getPauseId()}));
                    }
                    break block21;
                }
                if (object.getClass().isArray()) {
                    PauseDetails[] pauseDetailsArray;
                    int n;
                    if (ManagementUtils.VERBOSE_MODE) {
                        System.err.println("ManagementCompositeData.toTabularDataFromListOfPauseDetails: Array");
                    }
                    if ((n = (pauseDetailsArray = (PauseDetails[])object).length) < 1 || pauseDetailsArray[0] == null) {
                        if (ManagementUtils.VERBOSE_MODE) {
                            System.err.println("ManagementCompositeData.toTabularDataFromListOfPauseDetails (Array): ERROR: PauseDetails array is empty; returning null");
                        }
                        return null;
                    }
                    for (int i = 0; i < n; ++i) {
                        PauseDetails pauseDetails = pauseDetailsArray[i];
                        tabularDataSupport.put(new CompositeDataSupport(compositeType, pauseDetailsItemNames, new Object[]{pauseDetails.getElapsedTimeSinceJVMStartSec(), pauseDetails.getDurationSec(), pauseDetails.getReason(), pauseDetails.getInitialThreadsLockAcquireTimeSec(), pauseDetails.getCollectorSuspendTimeSec(), pauseDetails.getThreadsNotifyTimeSec(), pauseDetails.getTimeForThreadsToSuspendSec(), pauseDetails.getCollectorSecondSuspendTimeSec(), pauseDetails.getOperationTimeSec(), pauseDetails.getPostOperationCleanupTimeSec(), pauseDetails.getTimeToWakeupThreadsSec(), pauseDetails.getPauseId()}));
                    }
                    break block21;
                }
                if (ManagementUtils.VERBOSE_MODE) {
                    System.err.println("ManagementCompositeData.toTabularDataFromListOfPauseDetails (Array): ERROR: Unrecognized PauseDetails tabular type; returning null");
                }
                return null;
            }
            catch (OpenDataException openDataException) {
                if (ManagementUtils.VERBOSE_MODE) {
                    openDataException.printStackTrace(System.err);
                }
                tabularDataSupport = null;
            }
            catch (Exception exception) {
                if (ManagementUtils.VERBOSE_MODE) {
                    exception.printStackTrace(System.err);
                }
                tabularDataSupport = null;
            }
        }
        return tabularDataSupport;
    }

    public static TabularData toTabularDataFromMapStringString(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        TabularDataSupport tabularDataSupport = null;
        try {
            String[] stringArray = new String[]{"key", "value"};
            String[] stringArray2 = new String[]{"key", "value"};
            OpenType[] openTypeArray = new OpenType[]{SimpleType.STRING, SimpleType.STRING};
            CompositeType compositeType = new CompositeType(map.getClass().getName(), map.getClass().getName(), stringArray, stringArray2, openTypeArray);
            TabularType tabularType = new TabularType(map.getClass().getName(), map.getClass().getName(), compositeType, new String[]{"key"});
            tabularDataSupport = new TabularDataSupport(tabularType);
            Set<Map.Entry<String, String>> set = map.entrySet();
            for (Map.Entry<String, String> entry : set) {
                tabularDataSupport.put(new CompositeDataSupport(compositeType, stringArray, new String[]{entry.getKey(), entry.getValue()}));
            }
        }
        catch (OpenDataException openDataException) {
            if (ManagementUtils.VERBOSE_MODE) {
                openDataException.printStackTrace(System.err);
            }
            tabularDataSupport = null;
        }
        return tabularDataSupport;
    }

    private static CompositeType getMemoryNotificationInfoCompositeType() {
        block3: {
            if (MEMORYNOTIFICATIONINFO_COMPOSITETYPE == null) {
                String[] stringArray = new String[]{"poolName", "notificationReason", "count", "memoryUsage"};
                String[] stringArray2 = new String[]{"poolName", "notificationReason", "count", "memoryUsage"};
                OpenType[] openTypeArray = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, ManagementCompositeData.getMemoryUsageCompositeType()};
                try {
                    MEMORYNOTIFICATIONINFO_COMPOSITETYPE = new CompositeType(MemoryNotificationInfo.class.getName(), MemoryNotificationInfo.class.getName(), stringArray, stringArray2, openTypeArray);
                }
                catch (OpenDataException openDataException) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return MEMORYNOTIFICATIONINFO_COMPOSITETYPE;
    }

    public static CompositeData toMemoryNotificationInfoCompositeData(MemoryNotificationInfo memoryNotificationInfo) {
        CompositeDataSupport compositeDataSupport;
        block3: {
            if (memoryNotificationInfo == null) {
                return null;
            }
            compositeDataSupport = null;
            String[] stringArray = new String[]{"poolName", "notificationReason", "count", "memoryUsage"};
            Object[] objectArray = new Object[]{memoryNotificationInfo.getPoolName(), memoryNotificationInfo.getNotificationReason(), memoryNotificationInfo.getCount(), ManagementCompositeData.createCompositeDataFromMemoryUsageObject(memoryNotificationInfo.getMemoryUsage())};
            CompositeType compositeType = ManagementCompositeData.getMemoryNotificationInfoCompositeType();
            try {
                compositeDataSupport = new CompositeDataSupport(compositeType, stringArray, objectArray);
            }
            catch (OpenDataException openDataException) {
                if (!ManagementUtils.VERBOSE_MODE) break block3;
                openDataException.printStackTrace(System.err);
            }
        }
        return compositeDataSupport;
    }

    private static CompositeType getMemoryPoolNotificationInfoCompositeType() {
        block3: {
            if (MEMORYPOOLNOTIFICATIONINFO_COMPOSITETYPE == null) {
                String[] stringArray = new String[]{"poolName", "notificationReason", "count", "memoryUsage"};
                String[] stringArray2 = new String[]{"poolName", "notificationReason", "count", "memoryUsage"};
                OpenType[] openTypeArray = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, ManagementCompositeData.getMemoryUsageCompositeType()};
                try {
                    MEMORYPOOLNOTIFICATIONINFO_COMPOSITETYPE = new CompositeType(MemoryPoolNotificationInfo.class.getName(), MemoryPoolNotificationInfo.class.getName(), stringArray, stringArray2, openTypeArray);
                }
                catch (OpenDataException openDataException) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return MEMORYPOOLNOTIFICATIONINFO_COMPOSITETYPE;
    }

    public static CompositeData toMemoryPoolNotificationInfoCompositeData(MemoryPoolNotificationInfo memoryPoolNotificationInfo) {
        CompositeDataSupport compositeDataSupport;
        block3: {
            if (memoryPoolNotificationInfo == null) {
                return null;
            }
            compositeDataSupport = null;
            String[] stringArray = new String[]{"poolName", "notificationReason", "count", "memoryUsage"};
            Object[] objectArray = new Object[]{memoryPoolNotificationInfo.getPoolName(), memoryPoolNotificationInfo.getNotificationReason(), memoryPoolNotificationInfo.getCount(), ManagementCompositeData.createCompositeDataFromMemoryUsageObject(memoryPoolNotificationInfo.getMemoryUsage())};
            CompositeType compositeType = ManagementCompositeData.getMemoryPoolNotificationInfoCompositeType();
            try {
                compositeDataSupport = new CompositeDataSupport(compositeType, stringArray, objectArray);
            }
            catch (OpenDataException openDataException) {
                if (!ManagementUtils.VERBOSE_MODE) break block3;
                openDataException.printStackTrace(System.err);
            }
        }
        return compositeDataSupport;
    }

    private static CompositeType getGarbageCollectorNotificationInfoCompositeType() {
        block3: {
            if (GARBAGECOLLECTORNOTIFICATIONINFO_COMPOSITETYPE == null) {
                String[] stringArray = new String[]{"collectorName", "notificationReason", "count", "gcDetails"};
                String[] stringArray2 = new String[]{"collectorName", "notificationReason", "count", "gcDetails"};
                OpenType[] openTypeArray = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, ManagementCompositeData.getGCDetailsCompositeType()};
                try {
                    GARBAGECOLLECTORNOTIFICATIONINFO_COMPOSITETYPE = new CompositeType(GarbageCollectorNotificationInfo.class.getName(), GarbageCollectorNotificationInfo.class.getName(), stringArray, stringArray2, openTypeArray);
                }
                catch (OpenDataException openDataException) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return GARBAGECOLLECTORNOTIFICATIONINFO_COMPOSITETYPE;
    }

    public static CompositeData toGarbageCollectorNotificationInfoCompositeData(GarbageCollectorNotificationInfo garbageCollectorNotificationInfo) {
        CompositeDataSupport compositeDataSupport;
        block3: {
            if (garbageCollectorNotificationInfo == null) {
                return null;
            }
            compositeDataSupport = null;
            String[] stringArray = new String[]{"collectorName", "notificationReason", "count", "gcDetails"};
            Object[] objectArray = new Object[]{garbageCollectorNotificationInfo.getCollectorName(), garbageCollectorNotificationInfo.getNotificationReason(), garbageCollectorNotificationInfo.getCount(), ManagementCompositeData.toCompositeDataFromGCDetails(garbageCollectorNotificationInfo.getGCDetails())};
            CompositeType compositeType = ManagementCompositeData.getGarbageCollectorNotificationInfoCompositeType();
            try {
                compositeDataSupport = new CompositeDataSupport(compositeType, stringArray, objectArray);
            }
            catch (OpenDataException openDataException) {
                if (!ManagementUtils.VERBOSE_MODE) break block3;
                openDataException.printStackTrace(System.err);
            }
        }
        return compositeDataSupport;
    }

    public static Object convertTabularDataToMap(TabularData tabularData) {
        if (tabularData == null) {
            return null;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Set<String> set = tabularData.getTabularType().getRowType().keySet();
        if (set.size() != 2) {
            throw new IllegalArgumentException(Messages.getString("lm.12"));
        }
        String[] stringArray = new String[2];
        int n = 0;
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = iterator.next();
        }
        Collection<?> collection = tabularData.values();
        for (CompositeData compositeData : collection) {
            hashMap.put(compositeData.get(stringArray[0]), compositeData.get(stringArray[1]));
        }
        return hashMap;
    }

    public static <T> T convertFromCompositeData(CompositeData compositeData, Class<T> clazz) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (compositeData == null) {
            return null;
        }
        Method method = clazz.getMethod("from", CompositeData.class);
        return (T)method.invoke(null, compositeData);
    }

    public static <T> T convertFromOpenType(Object object, Class<?> clazz, Class<T> clazz2) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        if (object == null) {
            return null;
        }
        Object object2 = null;
        if (clazz.isArray() && clazz2.isArray()) {
            Class<?> clazz3 = clazz.getComponentType();
            Class<?> clazz4 = clazz2.getComponentType();
            Object[] objectArray = (Object[])object;
            object2 = Array.newInstance(clazz4, objectArray.length);
            for (int i = 0; i < Array.getLength(object2); ++i) {
                Array.set(object2, i, ManagementCompositeData.convertFromOpenType(objectArray[i], clazz3, clazz4));
            }
        } else if (clazz.equals(CompositeData.class)) {
            object2 = ManagementCompositeData.convertFromCompositeData((CompositeData)object, clazz2);
        } else if (clazz.equals(TabularData.class)) {
            if (clazz2.equals(Map.class)) {
                object2 = ManagementCompositeData.convertTabularDataToMap((TabularData)object);
            }
        } else if (clazz.equals(String[].class)) {
            if (clazz2.equals(List.class)) {
                object2 = ManagementCompositeData.convertStringArrayToList((String[])object);
            }
        } else if (clazz.equals(String.class) && clazz2.equals(MemoryType.class)) {
            object2 = ManagementCompositeData.convertStringToMemoryType((String)object);
        }
        return (T)object2;
    }

    public static <T> T convertToOpenType(Object object, Class<T> clazz, Class<?> clazz2) {
        if (object == null) {
            return null;
        }
        if (ManagementUtils.TRACE) {
            System.out.println("ManagementCompositeData.convertToOpenType realClass: " + clazz2.getName() + " openClass: " + clazz.getName());
        }
        Object object2 = null;
        if (clazz.isArray() && clazz2.isArray()) {
            if (ManagementUtils.TRACE) {
                System.out.println("ManagementCompositeData.convertToOpenType (openClass.isArray() && realClass.isArray())");
            }
            Class<?> clazz3 = clazz.getComponentType();
            Class<?> clazz4 = clazz2.getComponentType();
            Object[] objectArray = (Object[])object;
            object2 = Array.newInstance(clazz3, objectArray.length);
            for (int i = 0; i < Array.getLength(object2); ++i) {
                Array.set(object2, i, ManagementCompositeData.convertToOpenType(objectArray[i], clazz3, clazz4));
            }
        } else if (clazz.equals(CompositeData.class)) {
            if (clazz2.equals(MemoryUsage.class)) {
                if (ManagementUtils.TRACE) {
                    System.out.println("ManagementCompositeData.convertToOpenType CompositeData MemoryUsage");
                }
                object2 = ManagementCompositeData.createCompositeDataFromMemoryUsageObject((MemoryUsage)object);
            } else if (clazz2.equals(PauseDetails.class)) {
                if (ManagementUtils.TRACE) {
                    System.out.println("ManagementCompositeData.convertToOpenType CompositeData PauseDetails");
                }
                object2 = ManagementCompositeData.createCompositeDataFromPauseDetailsObject((PauseDetails)object);
            } else if (clazz2.equals(GCDetails.class)) {
                if (ManagementUtils.TRACE) {
                    System.out.println("ManagementCompositeData.convertToOpenType CompositeData GCDetails");
                }
                object2 = ManagementCompositeData.toCompositeDataFromGCDetails((GCDetails)object);
            } else if (ManagementUtils.TRACE) {
                System.out.println("ManagementCompositeData.convertToOpenType CompositeData ERROR: NO MATCHING TYPE FOUND");
            }
        } else if (clazz.equals(TabularData.class)) {
            if (clazz2.getName().equals("[Lcom.azul.zing.management.PauseDetails;")) {
                if (ManagementUtils.TRACE) {
                    System.out.println("ManagementCompositeData.convertToOpenType tabular PauseDetails");
                }
                object2 = ManagementCompositeData.toTabularDataFromListOfPauseDetails(object);
            } else if (clazz2.getName().equals("[Lcom.azul.zing.management.MemoryUsage;")) {
                if (ManagementUtils.TRACE) {
                    System.out.println("ManagementCompositeData.convertToOpenType tabular MemoryUsage");
                }
                object2 = ManagementCompositeData.toTabularDataFromArrayOfMemoryUsage(object);
            } else if (clazz2.equals(Map.class)) {
                if (ManagementUtils.TRACE) {
                    System.out.println("ManagementCompositeData.convertToOpenType tabular Map class");
                }
                object2 = ManagementCompositeData.toTabularDataFromMapStringString((Map)object);
            } else if (ManagementUtils.TRACE) {
                System.out.println("ManagementCompositeData.convertToOpenType TabularData ERROR: NO MATCHING TYPE FOUND");
            }
        } else if (clazz.equals(String[].class)) {
            if (clazz2.equals(List.class)) {
                object2 = ManagementCompositeData.convertListToArray((List)object, clazz, clazz.getComponentType());
            }
        } else if (clazz.equals(String.class)) {
            if (clazz2.isEnum()) {
                object2 = ((Enum)object).name();
            }
        } else if (ManagementUtils.TRACE) {
            System.out.println("ManagementCompositeData.convertToOpenType CompositeData/TabularData ERROR: NO MATCHING TYPE FOUND FOR OpenClass: " + clazz);
        }
        if (ManagementUtils.TRACE) {
            if (object2 == null) {
                System.out.println("ManagementCompositeData.convertToOpenType CompositeData/TabularData ERROR: FAILURE TO CONVERT - VALUE IS NULL");
            }
            System.out.println("ManagementCompositeData.convertToOpenType exiting");
        }
        return (T)object2;
    }

    private static <T, E> T convertListToArray(List<E> list, Class<T> clazz, Class<E> clazz2) {
        Object object = Array.newInstance(clazz2, list.size());
        Iterator<E> iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            E e = iterator.next();
            Array.set(object, n++, e);
        }
        return (T)object;
    }

    public static List<String> convertStringArrayToList(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public static Class<?> getClassMaybePrimitive(String string) throws ClassNotFoundException {
        Class<Object> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (string.equals(Boolean.TYPE.getName())) {
                clazz = Boolean.TYPE;
            }
            if (string.equals(Character.TYPE.getName())) {
                clazz = Character.TYPE;
            }
            if (string.equals(Byte.TYPE.getName())) {
                clazz = Byte.TYPE;
            }
            if (string.equals(Short.TYPE.getName())) {
                clazz = Short.TYPE;
            }
            if (string.equals(Integer.TYPE.getName())) {
                clazz = Integer.TYPE;
            }
            if (string.equals(Long.TYPE.getName())) {
                clazz = Long.TYPE;
            }
            if (string.equals(Float.TYPE.getName())) {
                clazz = Float.TYPE;
            }
            if (string.equals(Double.TYPE.getName())) {
                clazz = Double.TYPE;
            }
            if (string.equals(Void.TYPE.getName())) {
                clazz = Void.TYPE;
            }
            if (ManagementUtils.VERBOSE_MODE) {
                classNotFoundException.printStackTrace(System.err);
            }
            throw classNotFoundException;
        }
        return clazz;
    }

    public static boolean isWrapperClass(Class<? extends Object> clazz, Class<?> clazz2) {
        boolean bl = true;
        if (clazz2.equals(Boolean.TYPE) && !clazz.equals(Boolean.class)) {
            bl = false;
        } else if (clazz2.equals(Character.TYPE) && !clazz.equals(Character.class)) {
            bl = false;
        } else if (clazz2.equals(Byte.TYPE) && !clazz.equals(Byte.class)) {
            bl = false;
        } else if (clazz2.equals(Short.TYPE) && !clazz.equals(Short.class)) {
            bl = false;
        } else if (clazz2.equals(Integer.TYPE) && !clazz.equals(Integer.class)) {
            bl = false;
        } else if (clazz2.equals(Long.TYPE) && !clazz.equals(Long.class)) {
            bl = false;
        } else if (clazz2.equals(Float.TYPE) && !clazz.equals(Float.class)) {
            bl = false;
        } else if (clazz2.equals(Double.TYPE) && !clazz.equals(Double.class)) {
            bl = false;
        }
        return bl;
    }
}

