/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.impl.management;

import com.azul.zing.impl.management.ManagementCompositeData;
import com.azul.zing.impl.management.ManagementUtils;
import com.azul.zing.impl.management.internal.nls.Messages;
import java.lang.reflect.Method;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;

public abstract class DynamicMXBeanImpl
implements DynamicMBean {
    protected MBeanInfo info;

    protected void setMBeanInfo(MBeanInfo mBeanInfo) {
        this.info = mBeanInfo;
    }

    @Override
    public AttributeList getAttributes(String[] stringArray) {
        if (ManagementUtils.TRACE) {
            System.out.println("getAttributes");
        }
        AttributeList attributeList = new AttributeList();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Object object = this.getAttribute(stringArray[i]);
                attributeList.add(new Attribute(stringArray[i], object));
                continue;
            }
            catch (Exception exception) {
                if (!ManagementUtils.VERBOSE_MODE) continue;
                exception.printStackTrace(System.err);
            }
        }
        return attributeList;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributeList) {
        AttributeList attributeList2 = new AttributeList();
        for (int i = 0; i < attributeList.size(); ++i) {
            Attribute attribute = (Attribute)attributeList.get(i);
            String string = null;
            Object object = null;
            try {
                this.setAttribute(attribute);
                string = attribute.getName();
                object = this.getAttribute(string);
                attributeList2.add(new Attribute(string, object));
                continue;
            }
            catch (Exception exception) {
                if (!ManagementUtils.VERBOSE_MODE) continue;
                exception.printStackTrace(System.err);
            }
        }
        return attributeList2;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.info;
    }

    protected MBeanAttributeInfo getPresentAttribute(String string, AttributeAccessType attributeAccessType) {
        if (ManagementUtils.TRACE) {
            System.out.println("getPresentAttribute");
        }
        MBeanAttributeInfo[] mBeanAttributeInfoArray = this.info.getAttributes();
        MBeanAttributeInfo mBeanAttributeInfo = null;
        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
            MBeanAttributeInfo mBeanAttributeInfo2 = mBeanAttributeInfoArray[i];
            if (!mBeanAttributeInfo2.getName().equals(string)) continue;
            if (attributeAccessType.equals((Object)AttributeAccessType.READING)) {
                if (!mBeanAttributeInfo2.isReadable()) continue;
                mBeanAttributeInfo = mBeanAttributeInfo2;
                break;
            }
            if (!mBeanAttributeInfo2.isWritable()) continue;
            mBeanAttributeInfo = mBeanAttributeInfo2;
            break;
        }
        return mBeanAttributeInfo;
    }

    @Override
    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        String string2;
        if (ManagementUtils.TRACE) {
            System.out.println("getAttribute: " + string);
        }
        Object object = null;
        Method method = null;
        MBeanAttributeInfo mBeanAttributeInfo = this.getPresentAttribute(string, AttributeAccessType.READING);
        if (mBeanAttributeInfo == null) {
            throw new AttributeNotFoundException(Messages.getString("lm.0A", string));
        }
        try {
            string2 = mBeanAttributeInfo.isIs() ? "is" : "get";
            method = this.getClass().getMethod(string2 + string, null);
        }
        catch (Exception exception) {
            if (ManagementUtils.VERBOSE_MODE) {
                exception.printStackTrace(System.err);
            }
            throw new ReflectionException(exception);
        }
        string2 = method.getReturnType().getName();
        String string3 = mBeanAttributeInfo.getType();
        object = this.invokeMethod(method, null);
        if (ManagementUtils.TRACE) {
            System.out.println("Return from invoke and process return; real: " + string2 + " openType: " + string3);
        }
        try {
            if (!string2.equals(string3)) {
                object = ManagementCompositeData.convertToOpenType(object, Class.forName(string3), Class.forName(string2));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (ManagementUtils.VERBOSE_MODE) {
                classNotFoundException.printStackTrace(System.err);
            }
            throw new MBeanException(classNotFoundException);
        }
        return object;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (ManagementUtils.TRACE) {
            System.out.println("setAttribute");
        }
        Class<?> clazz = null;
        MBeanAttributeInfo mBeanAttributeInfo = this.getPresentAttribute(attribute.getName(), AttributeAccessType.WRITING);
        if (mBeanAttributeInfo == null) {
            throw new AttributeNotFoundException(Messages.getString("lm.0A", attribute));
        }
        try {
            clazz = ManagementCompositeData.getClassMaybePrimitive(mBeanAttributeInfo.getType());
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (ManagementUtils.VERBOSE_MODE) {
                classNotFoundException.printStackTrace(System.err);
            }
            throw new ReflectionException(classNotFoundException);
        }
        if (clazz.isPrimitive() ? !ManagementCompositeData.isWrapperClass(attribute.getValue().getClass(), clazz) : !clazz.equals(attribute.getValue().getClass())) {
            throw new InvalidAttributeValueException(Messages.getString("lm.0B", mBeanAttributeInfo.getName(), mBeanAttributeInfo.getType()));
        }
        Method method = null;
        try {
            method = this.getClass().getMethod("set" + attribute.getName(), clazz);
        }
        catch (Exception exception) {
            if (ManagementUtils.VERBOSE_MODE) {
                exception.printStackTrace(System.err);
            }
            throw new ReflectionException(exception);
        }
        this.invokeMethod(method, attribute.getValue());
        try {
            method.invoke((Object)this, attribute.getValue());
        }
        catch (Exception exception) {
            Throwable throwable;
            if (ManagementUtils.VERBOSE_MODE) {
                exception.printStackTrace(System.err);
            }
            if ((throwable = exception.getCause()) instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new MBeanException((Exception)throwable);
        }
    }

    @Override
    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        Object object;
        MBeanOperationInfo mBeanOperationInfo;
        Object object2 = null;
        String[] stringArray2 = stringArray;
        if (stringArray2 == null) {
            stringArray2 = new String[]{};
        }
        if ((mBeanOperationInfo = this.getPresentOperation(string, stringArray2)) == null) {
            throw new ReflectionException(new NoSuchMethodException(string), Messages.getString("lm.0C", string));
        }
        Method method = null;
        try {
            object = new Class[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                object[i] = ManagementCompositeData.getClassMaybePrimitive(stringArray2[i]);
                if (!ManagementUtils.TRACE) continue;
                System.out.println("Parameters: " + object[i] + " for: " + string);
            }
            if (ManagementUtils.TRACE) {
                // empty if block
            }
            method = this.getClass().getMethod(string, (Class<?>)object);
        }
        catch (Exception exception) {
            if (ManagementUtils.TRACE) {
                System.out.println("Parameters: exception from getClass().getMethodName()");
            }
            if (ManagementUtils.VERBOSE_MODE) {
                exception.printStackTrace(System.err);
            }
            throw new ReflectionException(exception);
        }
        object = method.getReturnType().getName();
        String string2 = mBeanOperationInfo.getReturnType();
        object2 = this.invokeMethod(method, objectArray);
        try {
            if (!((String)object).equals(string2)) {
                object2 = ManagementCompositeData.convertToOpenType(object2, Class.forName(string2), Class.forName((String)object));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (ManagementUtils.VERBOSE_MODE) {
                classNotFoundException.printStackTrace(System.err);
            }
            throw new MBeanException(classNotFoundException);
        }
        return object2;
    }

    protected MBeanOperationInfo getPresentOperation(String string, String[] stringArray) {
        if (ManagementUtils.TRACE) {
            System.out.println("getPresentOperation");
        }
        MBeanOperationInfo[] mBeanOperationInfoArray = this.info.getOperations();
        MBeanOperationInfo mBeanOperationInfo = null;
        for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
            MBeanOperationInfo mBeanOperationInfo2 = mBeanOperationInfoArray[i];
            if (!mBeanOperationInfo2.getName().equals(string) || stringArray.length != mBeanOperationInfo2.getSignature().length) continue;
            boolean bl = true;
            MBeanParameterInfo[] mBeanParameterInfoArray = mBeanOperationInfo2.getSignature();
            for (int j = 0; j < mBeanParameterInfoArray.length; ++j) {
                MBeanParameterInfo mBeanParameterInfo = mBeanParameterInfoArray[j];
                if (mBeanParameterInfo.getType().equals(stringArray[j])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            mBeanOperationInfo = mBeanOperationInfo2;
            break;
        }
        return mBeanOperationInfo;
    }

    private Object invokeMethod(Method method, Object ... objectArray) throws MBeanException {
        if (ManagementUtils.TRACE) {
            System.out.println("invokeMethod");
        }
        Object object = null;
        try {
            object = method.invoke((Object)this, objectArray);
        }
        catch (Exception exception) {
            Throwable throwable;
            if (ManagementUtils.VERBOSE_MODE) {
                exception.printStackTrace(System.err);
            }
            if ((throwable = exception.getCause()) instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new MBeanException((Exception)throwable);
        }
        return object;
    }

    static enum AttributeAccessType {
        READING,
        WRITING;

    }
}

