import { SchemaInterface, ChannelParametersInterface, ServerVariablesInterface } from '@asyncapi/parser';
export declare enum SchemaCustomTypes {
    ANY = "any",
    RESTRICTED_ANY = "restricted any",
    NEVER = "never",
    UNKNOWN = "unknown"
}
export declare class SchemaHelpers {
    static extRenderAdditionalInfo: string;
    static extRawValue: string;
    static extParameterLocation: string;
    static toSchemaType(schema: SchemaInterface): string;
    static applicatorSchemaName(idx: number, firstCase: string, otherCases: string, title?: string): string;
    static prettifyValue(value: any, strict?: boolean): string;
    static humanizeConstraints(schema: SchemaInterface): string[];
    static isExpandable(schema: SchemaInterface): boolean;
    static serverVariablesToSchema(urlVariables?: ServerVariablesInterface): SchemaInterface | undefined;
    static parametersToSchema(parameters?: ChannelParametersInterface): SchemaInterface | undefined;
    static jsonToSchema(value: any): any;
    static getCustomExtensions(value: any): Record<string, unknown> | undefined;
    static getDependentRequired(propertyName: string, schema: SchemaInterface): string[] | undefined;
    static getDependentSchemas(schema: SchemaInterface): SchemaInterface | undefined;
    private static toType;
    private static toItemsType;
    private static toCombinedType;
    private static inferType;
    private static humanizeNumberRangeConstraint;
    private static humanizeMultipleOfConstraint;
    private static humanizeRangeConstraint;
    private static jsonFieldToSchema;
    private static isJSONSchema;
}
//# sourceMappingURL=schema.d.ts.map