"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getResolvedSignatureTsServer = exports.areTypesMutuallyAssignableTsServer = exports.getTypePropertyTsServer = exports.getTypePropertiesTsServer = exports.getSymbolTypeTsServer = exports.getElementTypeTsServer = exports.decorateLanguageService = void 0;
const ide_get_element_type_1 = require("./ide-get-element-type");
const utils_1 = require("./utils");
const decoratedLanguageServices = new WeakSet();
function decorateLanguageService(languageService) {
    if (decoratedLanguageServices.has(languageService)) {
        return;
    }
    decoratedLanguageServices.add(languageService);
    languageService.webStormGetElementType = (ts, fileName, startOffset, endOffset, typeRequestKind, forceReturnType, cancellationToken, reverseMapper) => {
        // see getQuickInfoAtPosition
        let program = languageService.getProgram();
        if (!program) {
            return undefined;
        }
        const sourceFile = program.getSourceFile(fileName);
        if (!sourceFile) {
            return undefined;
        }
        return (0, ide_get_element_type_1.getElementTypeByOffsets)(ts, languageService.ideProjectId, program, sourceFile, startOffset, endOffset, typeRequestKind, forceReturnType, cancellationToken, reverseMapper);
    };
    languageService.webStormGetSymbolType = (ts, symbolId, cancellationToken, reverseMapper) => {
        let program = languageService.getProgram();
        if (!program) {
            return undefined;
        }
        return (0, ide_get_element_type_1.getSymbolType)(ts, program, symbolId, cancellationToken, reverseMapper);
    };
    languageService.webStormGetTypeProperties = (ts, typeId, cancellationToken, reverseMapper) => {
        let program = languageService.getProgram();
        if (!program) {
            return undefined;
        }
        return (0, ide_get_element_type_1.getTypeProperties)(ts, program, typeId, cancellationToken, reverseMapper);
    };
    languageService.webStormGetTypeProperty = (ts, typeId, propertyName, cancellationToken, reverseMapper) => {
        let program = languageService.getProgram();
        if (!program) {
            return undefined;
        }
        return (0, ide_get_element_type_1.getTypeProperty)(ts, program, typeId, propertyName, cancellationToken, reverseMapper);
    };
    languageService.webStormAreTypesMutuallyAssignable = function (ts, type1Id, type2Id, cancellationToken) {
        const program = languageService.getProgram();
        if (!program) {
            return undefined;
        }
        return (0, ide_get_element_type_1.areTypesMutuallyAssignable)(ts, program, type1Id, type2Id, cancellationToken);
    };
    languageService.webStormGetResolvedSignature = function (ts, fileName, startOffset, endOffset, cancellationToken, reverseMapper) {
        const program = languageService.getProgram();
        if (!program) {
            return undefined;
        }
        const sourceFile = program.getSourceFile(fileName);
        if (!sourceFile) {
            return undefined;
        }
        // Convert offsets to Range
        const start = ts.getLineAndCharacterOfPosition(sourceFile, startOffset);
        const end = ts.getLineAndCharacterOfPosition(sourceFile, endOffset);
        const range = { start, end };
        return (0, ide_get_element_type_1.getResolvedSignature)(ts, languageService.ideProjectId, program, sourceFile, range, cancellationToken, reverseMapper);
    };
}
exports.decorateLanguageService = decorateLanguageService;
function getElementTypeTsServer(ts, projectService, requestArguments) {
    let fileName = ts.server.toNormalizedPath(requestArguments.file);
    let { project, sourceFile } = projectService.ideProjectService.getProjectAndSourceFile(requestArguments.file, requestArguments.projectFileName);
    if (!project || !sourceFile)
        return undefined;
    let range = requestArguments.range;
    let startOffset = ts.getPositionOfLineAndCharacter(sourceFile, range.start.line, range.start.character);
    let endOffset = ts.getPositionOfLineAndCharacter(sourceFile, range.end.line, range.end.character);
    return project.getLanguageService().webStormGetElementType(ts, fileName, startOffset, endOffset, requestArguments.typeRequestKind, requestArguments.forceReturnType, projectService.cancellationToken);
}
exports.getElementTypeTsServer = getElementTypeTsServer;
function getSymbolTypeTsServer(ts, projectService, requestArguments) {
    const languageService = findLanguageService(projectService, requestArguments.ideProjectId, requestArguments.ideTypeCheckerId);
    if (!languageService) {
        return undefined;
    }
    return languageService.webStormGetSymbolType(ts, requestArguments.symbolId, projectService.cancellationToken);
}
exports.getSymbolTypeTsServer = getSymbolTypeTsServer;
function getTypePropertiesTsServer(ts, projectService, requestArguments) {
    const languageService = findLanguageService(projectService, requestArguments.ideProjectId, requestArguments.ideTypeCheckerId);
    if (!languageService) {
        return undefined;
    }
    return languageService.webStormGetTypeProperties(ts, requestArguments.typeId, projectService.cancellationToken);
}
exports.getTypePropertiesTsServer = getTypePropertiesTsServer;
function getTypePropertyTsServer(ts, projectService, requestArguments) {
    const languageService = findLanguageService(projectService, requestArguments.ideProjectId, requestArguments.ideTypeCheckerId);
    if (!languageService) {
        return undefined;
    }
    return languageService.webStormGetTypeProperty(ts, requestArguments.typeId, requestArguments.propertyName, projectService.cancellationToken);
}
exports.getTypePropertyTsServer = getTypePropertyTsServer;
function areTypesMutuallyAssignableTsServer(ts, projectService, requestArguments) {
    const languageService = findLanguageService(projectService, requestArguments.ideProjectId, requestArguments.ideTypeCheckerId);
    if (!languageService) {
        return undefined;
    }
    return languageService.webStormAreTypesMutuallyAssignable(ts, requestArguments.type1Id, requestArguments.type2Id, projectService.cancellationToken);
}
exports.areTypesMutuallyAssignableTsServer = areTypesMutuallyAssignableTsServer;
function getResolvedSignatureTsServer(ts, projectService, requestArguments) {
    let fileName = ts.server.toNormalizedPath(requestArguments.file);
    let { project, sourceFile } = projectService.ideProjectService.getProjectAndSourceFile(requestArguments.file, requestArguments.projectFileName);
    if (!project || !sourceFile)
        return undefined;
    let range = requestArguments.range;
    let startOffset = ts.getPositionOfLineAndCharacter(sourceFile, range.start.line, range.start.character);
    let endOffset = ts.getPositionOfLineAndCharacter(sourceFile, range.end.line, range.end.character);
    return project.getLanguageService().webStormGetResolvedSignature(ts, fileName, startOffset, endOffset, projectService.cancellationToken);
}
exports.getResolvedSignatureTsServer = getResolvedSignatureTsServer;
function findLanguageService(projectService, ideProjectId, ideTypeCheckerId) {
    for (let [, project] of projectService.configuredProjects) {
        if (project.ideProjectId === ideProjectId) {
            return getLanguageService(project);
        }
    }
    for (let inferredProject of projectService.inferredProjects) {
        if (inferredProject.ideProjectId === ideProjectId) {
            return getLanguageService(inferredProject);
        }
    }
    for (let externalProject of projectService.externalProjects) {
        if (externalProject.ideProjectId === ideProjectId) {
            return getLanguageService(externalProject);
        }
    }
    function getLanguageService(project) {
        var _a, _b;
        let program = project.getLanguageService().getProgram();
        if (((_b = (_a = program === null || program === void 0 ? void 0 : program.getTypeChecker()) === null || _a === void 0 ? void 0 : _a.webStormCacheInfo) === null || _b === void 0 ? void 0 : _b.ideTypeCheckerId) == ideTypeCheckerId) {
            return project.getLanguageService();
        }
        (0, utils_1.throwIdeError)("OutdatedTypeCheckerIdException");
    }
    console.error(`findLanguageService - failed to find language service for ideProjectId ${ideProjectId}`);
}
//# sourceMappingURL=get-element-type-ts-server.js.map