/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.model.converters;

import com.intellij.jpa.model.xml.impl.converters.ClassWithShortcutsResolvingConverter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.ConvertContext;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class GeneratorClassResolvingConverter
extends ClassWithShortcutsResolvingConverter {
    @NonNls
    private static final Map<String, String> GENERATOR_CLASS_MAP = new HashMap<String, String>();

    @NotNull
    protected String getBaseClassName(ConvertContext context) {
        return "org.hibernate.id.IdentifierGenerator";
    }

    @NotNull
    protected Map<String, String> getShortcutsMap(ConvertContext context) {
        Map<String, String> map = GENERATOR_CLASS_MAP;
        if (map == null) {
            GeneratorClassResolvingConverter.$$$reportNull$$$0(0);
        }
        return map;
    }

    public static String getGeneratorClassName(String classNameOrShortcut) {
        String name = GENERATOR_CLASS_MAP.get(classNameOrShortcut);
        return StringUtil.isNotEmpty((String)name) ? name : classNameOrShortcut;
    }

    static {
        GENERATOR_CLASS_MAP.put("increment", "org.hibernate.id.IncrementGenerator");
        GENERATOR_CLASS_MAP.put("identity", "org.hibernate.id.IdentityGenerator");
        GENERATOR_CLASS_MAP.put("sequence", "org.hibernate.id.SequenceGenerator");
        GENERATOR_CLASS_MAP.put("hilo", "org.hibernate.id.TableHiLoGenerator");
        GENERATOR_CLASS_MAP.put("seqhilo", "org.hibernate.id.SequenceHiLoGenerator");
        GENERATOR_CLASS_MAP.put("uuid", "org.hibernate.id.UUIDHexGenerator");
        GENERATOR_CLASS_MAP.put("guid", "org.hibernate.id.GUIDGenerator");
        GENERATOR_CLASS_MAP.put("native", "");
        GENERATOR_CLASS_MAP.put("assigned", "org.hibernate.id.Assigned");
        GENERATOR_CLASS_MAP.put("select", "org.hibernate.id.SelectGenerator");
        GENERATOR_CLASS_MAP.put("foreign", "org.hibernate.id.ForeignGenerator");
        GENERATOR_CLASS_MAP.put("sequence-identity", "org.hibernate.id.SequenceIdentityGenerator");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/model/converters/GeneratorClassResolvingConverter", "getShortcutsMap"));
    }
}

