/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.converters;

import com.intellij.hibernate.facet.HibernateVersion;
import com.intellij.hibernate.model.converters.GeneratorClassResolvingConverter;
import com.intellij.hibernate.model.enums.EntityModeType;
import com.intellij.hibernate.model.enums.HBM2DDLAutoType;
import com.intellij.hibernate.model.enums.ReleaseConnectionsType;
import com.intellij.hibernate.model.xml.config.Property;
import com.intellij.hibernate.model.xml.mapping.HbmGenerator;
import com.intellij.hibernate.model.xml.mapping.HbmParam;
import com.intellij.hibernate.util.HibernateUtil;
import com.intellij.jpa.JpaImplementationProvider;
import com.intellij.jpa.model.JavaeePersistenceORMResolveConverters;
import com.intellij.jpa.model.xml.impl.converters.ClassWithShortcutsResolvingConverter;
import com.intellij.jpa.model.xml.impl.converters.PersistenceConvertersRegistry;
import com.intellij.jpa.model.xml.impl.converters.providers.PersistenceConverters;
import com.intellij.jpa.model.xml.persistence.PersistenceUnit;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.psi.PsiFile;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.EnumConverter;
import com.intellij.util.xml.ModuleContextProvider;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HibernateConverters
extends PersistenceConverters {
    private static final Condition<com.intellij.jpa.model.xml.persistence.Property> ourHibernateProviderCondition = domElement -> JpaUtil.isHibernate((JpaImplementationProvider)JpaUtil.findJpaProvider(null, (PersistencePackage)((PersistencePackage)domElement.getParentOfType(PersistenceUnit.class, true)), (boolean)false), null);
    private final Map<HibernateVersion, Map<String, String>> SESSION_CONTEXT_MAP = new HashMap<HibernateVersion, Map<String, String>>();

    public HibernateConverters() {
        this.sessionContextMap(HibernateVersion.Hibernate_3_X, "jta", "org.hibernate.context.JTASessionContext");
        this.sessionContextMap(HibernateVersion.Hibernate_3_X, "thread", "org.hibernate.context.ThreadLocalSessionContext");
        this.sessionContextMap(HibernateVersion.Hibernate_3_X, "managed", "org.hibernate.context.ManagedSessionContext");
        this.sessionContextMap(HibernateVersion.Hibernate_4_X, "jta", "org.hibernate.context.internal.JTASessionContext");
        this.sessionContextMap(HibernateVersion.Hibernate_4_X, "thread", "org.hibernate.context.internal.ThreadLocalSessionContext");
        this.sessionContextMap(HibernateVersion.Hibernate_4_X, "managed", "org.hibernate.context.internal.ManagedSessionContext");
        this.sessionContextMap(HibernateVersion.Hibernate_5_0, "jta", "org.hibernate.context.internal.JTASessionContext");
        this.sessionContextMap(HibernateVersion.Hibernate_5_0, "thread", "org.hibernate.context.internal.ThreadLocalSessionContext");
        this.sessionContextMap(HibernateVersion.Hibernate_5_0, "managed", "org.hibernate.context.internal.ManagedSessionContext");
        this.sessionContextMap(HibernateVersion.Hibernate_5_2, "jta", "org.hibernate.context.internal.JTASessionContext");
        this.sessionContextMap(HibernateVersion.Hibernate_5_2, "thread", "org.hibernate.context.internal.ThreadLocalSessionContext");
        this.sessionContextMap(HibernateVersion.Hibernate_5_2, "managed", "org.hibernate.context.internal.ManagedSessionContext");
        this.registerAllConverters();
    }

    protected Condition<com.intellij.jpa.model.xml.persistence.Property> getCondition() {
        return ourHibernateProviderCondition;
    }

    private void sessionContextMap(HibernateVersion version, @NotNull String key, @NotNull String value) {
        if (key == null) {
            HibernateConverters.$$$reportNull$$$0(0);
        }
        if (value == null) {
            HibernateConverters.$$$reportNull$$$0(1);
        }
        if (!this.SESSION_CONTEXT_MAP.containsKey((Object)version)) {
            this.SESSION_CONTEXT_MAP.put(version, new HashMap());
        }
        this.SESSION_CONTEXT_MAP.get((Object)version).put(key, value);
    }

    private void registerAllConverters() {
        ConverterManager converterManager = (ConverterManager)ApplicationManager.getApplication().getService(ConverterManager.class);
        HibernateConverters.registerConfigProperty(this.myRegistry, "transaction.auto_close_session", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "connection.driver_class", HibernateConverters.getPsiClassConverter((String)"java.sql.Driver"));
        HibernateConverters.registerConfigProperty(this.myRegistry, "connection.isolation", Converter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "connection.url", ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "connection.username", ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "connection.password", ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "connection.autocommit", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "connection.pool_size", Converter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "connection.datasource", ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "jndi.class", ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "jndi.url", ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "session_factory_name", ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "default_schema", HibernateConverters.getSchemaConverter(converterManager));
        HibernateConverters.registerConfigProperty(this.myRegistry, "default_catalog", HibernateConverters.getCatalogConverter(converterManager));
        HibernateConverters.registerConfigProperty(this.myRegistry, "show_sql", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "format_sql", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "use_sql_comments", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "max_fetch_depth", Converter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "default_batch_fetch_size", Converter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "jdbc.use_streams_for_binary", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "jdbc.use_scrollable_resultset", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "jdbc.use_get_generated_keys", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "jdbc.fetch_size", Converter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "jdbc.batch_size", Converter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "jdbc.batch_versioned_data", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "xml.output_stylesheet", HibernateConverters.getResourceConverter());
        HibernateConverters.registerConfigProperty(this.myRegistry, "c3p0.max_size", Converter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "c3p0.min_size", Converter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "c3p0.timeout", Converter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "c3p0.max_statements", Converter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "c3p0.acquire_increment", Converter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "c3p0.idle_test_period", Converter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "proxool.xml", ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "proxool.properties", ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "proxool.existing_pool", ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "proxool.pool_alias", ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "transaction.auto_close_session", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "transaction.flush_before_completion", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "connection.release_mode", EnumConverter.createEnumConverter(ReleaseConnectionsType.class));
        HibernateConverters.registerConfigProperty(this.myRegistry, "jta.UserTransaction", ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "cache.provider_configuration_file_resource_path", HibernateConverters.getFilePathConverter());
        HibernateConverters.registerConfigProperty(this.myRegistry, "cache.jndi", ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "cache.use_query_cache", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "cache.use_second_level_cache", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "cache.use_minimal_puts", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "cache.region_prefix", ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "cache.use_structured_entries", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "generate_statistics", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "use_identifier_rollback", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "bytecode.use_reflection_optimizer", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "query.substitutions", ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "hbm2ddl.auto", EnumConverter.createEnumConverter(HBM2DDLAutoType.class));
        HibernateConverters.registerConfigProperty(this.myRegistry, "jdbc.wrap_result_sets", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "order_updates", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "default_entity_mode", EnumConverter.createEnumConverter(EntityModeType.class));
        HibernateConverters.registerConfigProperty(this.myRegistry, "jacc_context_id", ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "query.jpaql_strict_compliance", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myRegistry, "connection.provider_class", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.connection.ConnectionProvider", HibernateVersion.Hibernate_3_X).add("org.hibernate.service.jdbc.connections.spi.ConnectionProvider", HibernateVersion.Hibernate_4_X, HibernateVersion.Hibernate_5_0, HibernateVersion.Hibernate_5_2)));
        HibernateConverters.registerConfigProperty(this.myRegistry, "dialect", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.dialect.Dialect", HibernateVersion.values())));
        HibernateConverters.registerConfigProperty(this.myRegistry, "jdbc.factory_class", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.jdbc.Batcher", HibernateVersion.Hibernate_3_X)));
        HibernateConverters.registerConfigProperty(this.myRegistry, "ejb.naming_strategy", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.cfg.NamingStrategy", HibernateVersion.values())));
        HibernateConverters.registerConfigProperty(this.myRegistry, "transaction.factory_class", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.transaction.TransactionFactory", HibernateVersion.Hibernate_3_X).add("org.hibernate.engine.transaction.spi.TransactionFactory", HibernateVersion.Hibernate_4_X)));
        HibernateConverters.registerConfigProperty(this.myRegistry, "transaction.manager_lookup_class", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.transaction.TransactionManagerLookup", HibernateVersion.Hibernate_4_X, HibernateVersion.Hibernate_3_X)));
        HibernateConverters.registerConfigProperty(this.myRegistry, "cache.provider_class", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.cache.CacheProvider", HibernateVersion.Hibernate_3_X)));
        HibernateConverters.registerConfigProperty(this.myRegistry, "cache.query_cache_factory", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.cache.spi.QueryCacheFactory", HibernateVersion.Hibernate_5_2, HibernateVersion.Hibernate_5_0, HibernateVersion.Hibernate_4_X).add("org.hibernate.cache.QueryCacheFactory", HibernateVersion.Hibernate_3_X)));
        HibernateConverters.registerConfigProperty(this.myRegistry, "query.factory_class", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.hql.spi.QueryTranslatorFactory", HibernateVersion.Hibernate_5_2, HibernateVersion.Hibernate_5_0, HibernateVersion.Hibernate_4_X).add("org.hibernate.hql.QueryTranslatorFactory", HibernateVersion.Hibernate_3_X)));
        HibernateConverters.registerConfigProperty(this.myRegistry, "jdbc.sql_exception_converter", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.exception.SQLExceptionConverter", HibernateVersion.values())));
        HibernateConverters.registerConfigProperty(this.myRegistry, "bytecode.provider", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.bytecode.spi.BytecodeProvider", HibernateVersion.Hibernate_5_2, HibernateVersion.Hibernate_5_0, HibernateVersion.Hibernate_4_X).add("org.hibernate.bytecode.BytecodeProvider", HibernateVersion.Hibernate_3_X)));
        this.registrySessionContextClass();
        Condition<HbmParam> genAssignedCondition = HibernateConverters.createGeneratorTypeCondition("org.hibernate.id.Assigned");
        this.myRegistry.registerValueConverter(HbmParam.class, genAssignedCondition, "entity_name", HibernateConverters.getEntityConverter());
        Condition<HbmParam> genIncrementCondition = HibernateConverters.createGeneratorTypeCondition("org.hibernate.id.IncrementGenerator");
        this.myRegistry.registerValueConverter(HbmParam.class, genIncrementCondition, "schema", HibernateConverters.getSchemaConverter(converterManager));
        this.myRegistry.registerValueConverter(HbmParam.class, genIncrementCondition, "catalog", HibernateConverters.getCatalogConverter(converterManager));
        this.myRegistry.registerValueConverter(HbmParam.class, genIncrementCondition, "tables", HibernateConverters.getTableConverter(true, converterManager));
        this.myRegistry.registerValueConverter(HbmParam.class, genIncrementCondition, "identity_tables", HibernateConverters.getTableConverter(true, converterManager));
        this.myRegistry.registerValueConverter(HbmParam.class, genIncrementCondition, "target_column", HibernateConverters.getColumnConverter(converterManager));
        this.myRegistry.registerValueConverter(HbmParam.class, genIncrementCondition, "column", HibernateConverters.getCatalogConverter(converterManager));
        Condition<HbmParam> genSequenceCondition = HibernateConverters.createGeneratorTypeCondition("org.hibernate.id.SequenceGenerator");
        this.myRegistry.registerValueConverter(HbmParam.class, genSequenceCondition, "schema", HibernateConverters.getSchemaConverter(converterManager));
        this.myRegistry.registerValueConverter(HbmParam.class, genSequenceCondition, "catalog", HibernateConverters.getCatalogConverter(converterManager));
        this.myRegistry.registerValueConverter(HbmParam.class, genSequenceCondition, "sequence", HibernateConverters.getSequenceConverter(converterManager));
        this.myRegistry.registerValueConverter(HbmParam.class, genSequenceCondition, "parameters", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        Condition<HbmParam> genHiLoCondition = HibernateConverters.createGeneratorTypeCondition("org.hibernate.id.TableHiLoGenerator");
        this.myRegistry.registerValueConverter(HbmParam.class, genHiLoCondition, "schema", HibernateConverters.getSchemaConverter(converterManager));
        this.myRegistry.registerValueConverter(HbmParam.class, genHiLoCondition, "catalog", HibernateConverters.getCatalogConverter(converterManager));
        this.myRegistry.registerValueConverter(HbmParam.class, genHiLoCondition, "table", HibernateConverters.getTableConverter(false, converterManager));
        this.myRegistry.registerValueConverter(HbmParam.class, genHiLoCondition, "max_lo", Converter.INTEGER_CONVERTER);
        Condition<HbmParam> genSeqHiLoCondition = HibernateConverters.createGeneratorTypeCondition("org.hibernate.id.SequenceHiLoGenerator");
        this.myRegistry.registerValueConverter(HbmParam.class, genSeqHiLoCondition, "schema", HibernateConverters.getSchemaConverter(converterManager));
        this.myRegistry.registerValueConverter(HbmParam.class, genSeqHiLoCondition, "catalog", HibernateConverters.getCatalogConverter(converterManager));
        this.myRegistry.registerValueConverter(HbmParam.class, genSeqHiLoCondition, "sequence", HibernateConverters.getSequenceConverter(converterManager));
        this.myRegistry.registerValueConverter(HbmParam.class, genSeqHiLoCondition, "parameters", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        this.myRegistry.registerValueConverter(HbmParam.class, genSeqHiLoCondition, "max_lo", Converter.INTEGER_CONVERTER);
        Condition<HbmParam> genSelectCondition = HibernateConverters.createGeneratorTypeCondition("org.hibernate.id.SelectGenerator");
        this.myRegistry.registerValueConverter(HbmParam.class, genSelectCondition, "key", HibernateConverters.getPropertyConverter());
        Condition<HbmParam> genForeignCondition = HibernateConverters.createGeneratorTypeCondition("org.hibernate.id.ForeignGenerator");
        this.myRegistry.registerValueConverter(HbmParam.class, genForeignCondition, "property", HibernateConverters.getPropertyConverter());
        this.myRegistry.registerValueConverter(HbmParam.class, genForeignCondition, "entity_name", HibernateConverters.getEntityConverter());
        Condition<HbmParam> genSequenceIdentityCondition = HibernateConverters.createGeneratorTypeCondition("org.hibernate.id.SequenceIdentityGenerator");
        this.myRegistry.registerValueConverter(HbmParam.class, genSequenceIdentityCondition, "schema", HibernateConverters.getSchemaConverter(converterManager));
        this.myRegistry.registerValueConverter(HbmParam.class, genSequenceIdentityCondition, "catalog", HibernateConverters.getCatalogConverter(converterManager));
        this.myRegistry.registerValueConverter(HbmParam.class, genSequenceIdentityCondition, "sequence", HibernateConverters.getSequenceConverter(converterManager));
        this.myRegistry.registerValueConverter(HbmParam.class, genSequenceIdentityCondition, "parameters", (Converter)ResolvingConverter.EMPTY_CONVERTER);
    }

    private void registrySessionContextClass() {
        ClassWithShortcutsResolvingConverter converter = new ClassWithShortcutsResolvingConverter(){

            @Nullable
            protected String getBaseClassName(ConvertContext context) {
                String className = null;
                for (Module module : ModuleContextProvider.getModules((PsiFile)context.getFile())) {
                    HibernateVersion version = HibernateUtil.getHibernateVersion(module);
                    if (version == HibernateVersion.Hibernate_3_X) {
                        className = "org.hibernate.context.CurrentSessionContext";
                        break;
                    }
                    if (version != HibernateVersion.Hibernate_4_X && version != HibernateVersion.Hibernate_5_0 && version != HibernateVersion.Hibernate_5_2) continue;
                    className = "org.hibernate.context.spi.CurrentSessionContext";
                    break;
                }
                return className;
            }

            @NotNull
            protected Map<String, String> getShortcutsMap(ConvertContext context) {
                HibernateVersion version;
                Map<String, String> sessionContextMap;
                Module module = context.getModule();
                if (module != null && (sessionContextMap = HibernateConverters.this.SESSION_CONTEXT_MAP.get((Object)(version = HibernateUtil.getHibernateVersion(module)))) != null) {
                    Map<String, String> map = sessionContextMap;
                    if (map == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return map;
                }
                Map<String, String> map = Collections.emptyMap();
                if (map == null) {
                    1.$$$reportNull$$$0(1);
                }
                return map;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/converters/HibernateConverters$1", "getShortcutsMap"));
            }
        };
        HibernateConverters.registerConfigProperty(this.myRegistry, "current_session_context_class", converter);
    }

    private static void registerConfigProperty(PersistenceConvertersRegistry registry, String name, Converter<?> converter) {
        registry.registerValueConverter(Property.class, Conditions.alwaysTrue(), name, converter);
        registry.registerValueConverter(Property.class, Conditions.alwaysTrue(), "hibernate." + name, converter);
        registry.registerValueConverter(com.intellij.jpa.model.xml.persistence.Property.class, ourHibernateProviderCondition, name, converter);
        registry.registerValueConverter(com.intellij.jpa.model.xml.persistence.Property.class, ourHibernateProviderCondition, "hibernate." + name, converter);
    }

    private static Condition<HbmParam> createGeneratorTypeCondition(String generatorClassName) {
        return domElement -> {
            DomElement parent = domElement.getParent();
            if (!(parent instanceof HbmGenerator)) {
                return false;
            }
            HbmGenerator generator = (HbmGenerator)parent;
            String className = GeneratorClassResolvingConverter.getGeneratorClassName(generator.getClazz().getStringValue());
            return Objects.equals(className, generatorClassName);
        };
    }

    private static Converter<?> getConverter(final VersionsHelper helper) {
        return new ClassWithShortcutsResolvingConverter(){

            @Nullable
            protected String getBaseClassName(ConvertContext context) {
                for (Module module : ModuleContextProvider.getModules((PsiFile)context.getFile())) {
                    HibernateVersion version = HibernateUtil.getHibernateVersion(module);
                    String s = helper.getVersionsMap().get((Object)version);
                    if (s == null) continue;
                    return s;
                }
                return null;
            }

            @NotNull
            protected Map<String, String> getShortcutsMap(ConvertContext context) {
                Map<String, String> map = Collections.emptyMap();
                if (map == null) {
                    2.$$$reportNull$$$0(0);
                }
                return map;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/converters/HibernateConverters$2", "getShortcutsMap"));
            }
        };
    }

    private static Converter<?> getSchemaConverter(ConverterManager converterManager) {
        return converterManager.getConverterInstance(JavaeePersistenceORMResolveConverters.SchemaResolver.class);
    }

    private static Converter<?> getCatalogConverter(ConverterManager converterManager) {
        return converterManager.getConverterInstance(JavaeePersistenceORMResolveConverters.CatalogResolver.class);
    }

    private static Converter<?> getTableConverter(boolean isList, ConverterManager converterManager) {
        if (!isList) {
            return converterManager.getConverterInstance(JavaeePersistenceORMResolveConverters.TableResolver.class);
        }
        return ResolvingConverter.EMPTY_CONVERTER;
    }

    private static Converter<?> getSequenceConverter(ConverterManager converterManager) {
        return converterManager.getConverterInstance(JavaeePersistenceORMResolveConverters.SequenceResolver.class);
    }

    private static Converter<?> getColumnConverter(ConverterManager converterManager) {
        return converterManager.getConverterInstance(JavaeePersistenceORMResolveConverters.ColumnResolver.class);
    }

    private static Converter<?> getEntityConverter() {
        return ResolvingConverter.EMPTY_CONVERTER;
    }

    private static Converter<?> getPropertyConverter() {
        return ResolvingConverter.EMPTY_CONVERTER;
    }

    private static Converter<?> getResourceConverter() {
        return ResolvingConverter.EMPTY_CONVERTER;
    }

    private static Converter<?> getFilePathConverter() {
        return ResolvingConverter.EMPTY_CONVERTER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "key";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "value";
                break;
            }
        }
        objectArray[1] = "com/intellij/hibernate/converters/HibernateConverters";
        objectArray[2] = "sessionContextMap";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class VersionsHelper {
        Map<HibernateVersion, String> myMap = new HashMap<HibernateVersion, String>();

        private VersionsHelper() {
        }

        public Map<HibernateVersion, String> getVersionsMap() {
            return this.myMap;
        }

        public VersionsHelper add(HibernateVersion version, String s) {
            this.myMap.put(version, s);
            return this;
        }

        public VersionsHelper add(String s, HibernateVersion ... versions) {
            for (HibernateVersion version : versions) {
                this.myMap.put(version, s);
            }
            return this;
        }

        public static VersionsHelper get(String s, HibernateVersion ... versions) {
            VersionsHelper c = new VersionsHelper();
            c.add(s, versions);
            return c;
        }
    }
}

