/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.examples.server;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.BuiltInServerManager;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/httpClient/examples/server/HttpClientExampleServerManager;", "", "<init>", "()V", "serverRequests", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Ljava/time/LocalDateTime;", "isRequestScheduled", "", "scheduleRequest", "", "Companion", "intellij.restClient"})
public final class HttpClientExampleServerManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentLinkedDeque<LocalDateTime> serverRequests = new ConcurrentLinkedDeque();
    @NotNull
    public static final String EXAMPLES_PREFIX = "/http-client/examples";
    private static final Duration REQUEST_LIFE_TIME = Duration.ofSeconds(5L);

    public final boolean isRequestScheduled() {
        LocalDateTime current = null;
        LocalDateTime now = LocalDateTime.now();
        do {
            if ((current = this.serverRequests.peekFirst()) == null) continue;
            this.serverRequests.remove(current);
        } while (current != null && current.plus(REQUEST_LIFE_TIME).compareTo(now) < 0);
        return current != null;
    }

    public final void scheduleRequest() {
        this.serverRequests.offer(LocalDateTime.now());
    }

    @JvmStatic
    @NotNull
    public static final HttpClientExampleServerManager getInstance() {
        return Companion.getInstance();
    }

    @NotNull
    public static final String getExampleServerAddress() {
        return Companion.getExampleServerAddress();
    }

    @JvmStatic
    @NotNull
    public static final String hideExampleServerAddress(@NotNull String url) {
        return Companion.hideExampleServerAddress(url);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\u00078FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\t\u0010\u0003\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/httpClient/examples/server/HttpClientExampleServerManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/httpClient/examples/server/HttpClientExampleServerManager;", "EXAMPLES_PREFIX", "", "exampleServerAddress", "getExampleServerAddress$annotations", "getExampleServerAddress", "()Ljava/lang/String;", "hideExampleServerAddress", "url", "REQUEST_LIFE_TIME", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "intellij.restClient"})
    @SourceDebugExtension(value={"SMAP\nHttpClientExampleServerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientExampleServerManager.kt\ncom/intellij/httpClient/examples/server/HttpClientExampleServerManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,48:1\n42#2,3:49\n*S KotlinDebug\n*F\n+ 1 HttpClientExampleServerManager.kt\ncom/intellij/httpClient/examples/server/HttpClientExampleServerManager$Companion\n*L\n33#1:49,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final HttpClientExampleServerManager getInstance() {
            boolean $i$f$service = false;
            Class<HttpClientExampleServerManager> serviceClass$iv = HttpClientExampleServerManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (HttpClientExampleServerManager)object;
        }

        @NotNull
        public final String getExampleServerAddress() {
            return "localhost:" + BuiltInServerManager.Companion.getInstance().getPort() + HttpClientExampleServerManager.EXAMPLES_PREFIX;
        }

        @JvmStatic
        public static /* synthetic */ void getExampleServerAddress$annotations() {
        }

        @JvmStatic
        @NotNull
        public final String hideExampleServerAddress(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return StringsKt.replace$default((String)url, (String)this.getExampleServerAddress(), (String)"{{$exampleServer}}", (boolean)false, (int)4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

