/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.datasource;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.persistence.database.ConfigurationFileInfo;
import com.intellij.persistence.database.DataSourcePropertyWithPrefixDataInfo;
import com.intellij.persistence.database.RecognizedDatabaseConfig;
import com.intellij.persistence.database.config.impl.DataSourceKeyType;
import com.intellij.persistence.database.config.impl.urlParser.CommonDatabaseUrl;
import com.intellij.persistence.database.config.impl.urlParser.DatabaseType;
import com.intellij.persistence.database.config.impl.urlParser.DatabaseUrl;
import com.intellij.persistence.database.config.impl.urlParser.DatabaseUrlParserKt;
import com.intellij.persistence.database.config.impl.urlParser.DatabasesKt;
import com.intellij.persistence.database.config.impl.urlParser.RawDatabaseUrl;
import com.intellij.quarkus.config.datasource.QsConfigPropertyValueSearcher;
import com.intellij.quarkus.config.datasource.QsConfigProvider;
import com.intellij.quarkus.config.datasource.QsRedisDataSourcesKeyTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J,\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/quarkus/config/datasource/QsRedisDataSourceConfigProvider;", "Lcom/intellij/quarkus/config/datasource/QsConfigProvider;", "<init>", "()V", "getConfigs", "", "Lcom/intellij/persistence/database/RecognizedDatabaseConfig;", "fileInfo", "Lcom/intellij/persistence/database/ConfigurationFileInfo;", "propertyInfo", "Lcom/intellij/persistence/database/DataSourcePropertyWithPrefixDataInfo;", "retrieveUrls", "", "Lcom/intellij/persistence/database/config/impl/urlParser/DatabaseUrl;", "collected", "", "Lcom/intellij/persistence/database/config/impl/DataSourceKeyType;", "", "defaultUrl", "intellij.quarkus"})
@SourceDebugExtension(value={"SMAP\nQsRedisDataSourceConfigProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsRedisDataSourceConfigProvider.kt\ncom/intellij/quarkus/config/datasource/QsRedisDataSourceConfigProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n1563#2:50\n1634#2,3:51\n1563#2:55\n1634#2,3:56\n774#2:59\n865#2,2:60\n1563#2:62\n1634#2,3:63\n1#3:54\n*S KotlinDebug\n*F\n+ 1 QsRedisDataSourceConfigProvider.kt\ncom/intellij/quarkus/config/datasource/QsRedisDataSourceConfigProvider\n*L\n23#1:50\n23#1:51,3\n43#1:55\n43#1:56,3\n43#1:59\n43#1:60,2\n44#1:62\n44#1:63,3\n*E\n"})
public final class QsRedisDataSourceConfigProvider
extends QsConfigProvider {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<RecognizedDatabaseConfig> getConfigs(@NotNull ConfigurationFileInfo fileInfo, @NotNull DataSourcePropertyWithPrefixDataInfo propertyInfo) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
        Intrinsics.checkNotNullParameter((Object)propertyInfo, (String)"propertyInfo");
        DatabaseDriver databaseDriver = DatabasesKt.findDatabaseDriver((DatabaseType)DatabaseType.REDIS);
        if (databaseDriver == null) {
            return CollectionsKt.emptyList();
        }
        DatabaseDriver driver = databaseDriver;
        QsConfigPropertyValueSearcher valueSearcher = new QsConfigPropertyValueSearcher(fileInfo, propertyInfo.getDocumentId());
        Map collected = this.collectValues((List)QsRedisDataSourcesKeyTypes.getEntries(), propertyInfo, valueSearcher);
        String password = (String)collected.get((Object)QsRedisDataSourcesKeyTypes.QS_REDIS_PASSWORD);
        String string = propertyInfo.getKeyPrefixInfo().getDatabaseName();
        if (string == null) {
            string = "redis";
        }
        String serviceName = string;
        String string2 = driver.getSampleUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSampleUrl(...)");
        Iterable $this$map$iv = this.retrieveUrls(collected, string2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            String host;
            void url;
            DatabaseUrl databaseUrl = (DatabaseUrl)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string3 = url.host();
            if (string3 == null) {
                string3 = host = "localhost";
            }
            if ((object = url.dataSourceItemName()) == null) {
                object = serviceName + "@" + host;
            }
            String dataSourceItemName = object;
            String string4 = url.toDbDialogUrl();
            String string5 = driver.getDriverClass();
            if (string5 == null) {
                string5 = "";
            }
            String string6 = url.username();
            String string7 = url.password();
            if (string7 == null) {
                string7 = password;
            }
            collection.add(new RecognizedDatabaseConfig(string4, string5, string6, string7, dataSourceItemName));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<DatabaseUrl> retrieveUrls(Map<DataSourceKeyType, String> collected, String defaultUrl) {
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String it;
        Collection collection;
        void $this$mapTo$iv$iv;
        String hosts;
        block6: {
            Object object;
            block8: {
                block7: {
                    hosts = collected.get((Object)QsRedisDataSourcesKeyTypes.QS_REDIS_HOSTS);
                    if (hosts != null) break block6;
                    object = DatabaseUrlParserKt.parseToCommonDatabaseUrl$default((String)defaultUrl, null, null, null, (int)14, null);
                    if (object == null) break block7;
                    CommonDatabaseUrl it2 = object;
                    boolean bl = false;
                    Set set = SetsKt.setOf((Object)it2);
                    object = set;
                    if (set != null) break block8;
                }
                object = SetsKt.emptySet();
            }
            return object;
        }
        String[] stringArray = new String[]{","};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)hosts, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void url;
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            CommonDatabaseUrl commonDatabaseUrl = DatabaseUrlParserKt.parseToCommonDatabaseUrl$default((String)url, null, null, null, (int)14, null);
            collection.add(commonDatabaseUrl != null && (commonDatabaseUrl = CommonDatabaseUrl.copy$default((CommonDatabaseUrl)commonDatabaseUrl, null, null, null, null, null, (String)"jdbc:redis", null, null, (int)223, null)) != null ? (DatabaseUrl)commonDatabaseUrl : (DatabaseUrl)new RawDatabaseUrl(DatabaseType.REDIS, "0", (String)url));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }
}

