/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.psi;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.light.LightPsiClassBuilder;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import de.plushnikov.intellij.plugin.psi.LombokLightModifierList;
import icons.LombokIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LombokLightClassBuilder
extends LightPsiClassBuilder
implements PsiExtensibleClass,
SyntheticElement {
    private final String myQualifiedName;
    private final Icon myBaseIcon;
    private final LombokLightModifierList myModifierList;
    private boolean myIsEnum;
    private boolean myIsAnnotationType;
    private PsiField[] myFields;
    private PsiMethod[] myMethods;
    private Function<PsiClass, ? extends Collection<PsiField>> fieldSupplier;
    private Function<PsiClass, ? extends Collection<PsiMethod>> methodSupplier;

    public LombokLightClassBuilder(@NotNull PsiElement context, @NotNull String simpleName, @NotNull String qualifiedName) {
        if (context == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(0);
        }
        if (simpleName == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(1);
        }
        if (qualifiedName == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(2);
        }
        super(context, simpleName);
        this.fieldSupplier = c -> Collections.emptyList();
        this.methodSupplier = c -> Collections.emptyList();
        this.myIsEnum = false;
        this.myIsAnnotationType = false;
        this.myQualifiedName = qualifiedName;
        this.myBaseIcon = LombokIcons.Nodes.LombokClass;
        this.myModifierList = new LombokLightModifierList(context.getManager(), context.getLanguage()).withParent((PsiElement)this);
    }

    @NotNull
    public LombokLightModifierList getModifierList() {
        LombokLightModifierList lombokLightModifierList = this.myModifierList;
        if (lombokLightModifierList == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(3);
        }
        return lombokLightModifierList;
    }

    public PsiElement getScope() {
        if (this.getContainingClass() != null) {
            return this.getContainingClass().getScope();
        }
        return super.getScope();
    }

    public PsiElement getParent() {
        return this.getContainingClass();
    }

    @Nullable
    public String getQualifiedName() {
        return this.myQualifiedName;
    }

    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = IconManager.getInstance().createLayeredIcon((Iconable)this, this.myBaseIcon, ElementPresentationUtil.getFlags((PsiModifierListOwner)this, (boolean)false));
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, (int)flags, (RowIcon)baseIcon);
    }

    public TextRange getTextRange() {
        TextRange r = super.getTextRange();
        return r == null ? TextRange.EMPTY_RANGE : r;
    }

    public PsiFile getContainingFile() {
        if (null != this.getContainingClass()) {
            return this.getContainingClass().getContainingFile();
        }
        return super.getContainingFile();
    }

    public boolean isEnum() {
        return this.myIsEnum;
    }

    public boolean isAnnotationType() {
        return this.myIsAnnotationType;
    }

    public PsiField @NotNull [] getFields() {
        if (null == this.myFields) {
            DumbService dumbService = DumbService.getInstance((Project)this.getProject());
            Collection generatedFields = dumbService.isDumb() && !dumbService.isAlternativeResolveEnabled() ? (Collection)dumbService.computeWithAlternativeResolveEnabled(() -> this.fieldSupplier.apply((PsiClass)this)) : this.fieldSupplier.apply((PsiClass)this);
            this.myFields = generatedFields.toArray(PsiField.EMPTY_ARRAY);
            this.fieldSupplier = c -> Collections.emptyList();
        }
        if (this.myFields == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(4);
        }
        return this.myFields;
    }

    public PsiMethod @NotNull [] getMethods() {
        if (null == this.myMethods) {
            DumbService dumbService = DumbService.getInstance((Project)this.getProject());
            Collection generatedMethods = dumbService.isDumb() && !dumbService.isAlternativeResolveEnabled() ? (Collection)dumbService.computeWithAlternativeResolveEnabled(() -> this.methodSupplier.apply((PsiClass)this)) : this.methodSupplier.apply((PsiClass)this);
            this.myMethods = generatedMethods.toArray(PsiMethod.EMPTY_ARRAY);
            this.methodSupplier = c -> Collections.emptyList();
        }
        if (this.myMethods == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(5);
        }
        return this.myMethods;
    }

    @NotNull
    public List<PsiField> getOwnFields() {
        List<PsiField> list = Collections.emptyList();
        if (list == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<PsiMethod> getOwnMethods() {
        List<PsiMethod> list = Collections.emptyList();
        if (list == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public List<PsiClass> getOwnInnerClasses() {
        List<PsiClass> list = Collections.emptyList();
        if (list == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(8);
        }
        return list;
    }

    public LombokLightClassBuilder withFieldSupplier(Function<PsiClass, ? extends Collection<PsiField>> fieldSupplier) {
        this.fieldSupplier = fieldSupplier;
        return this;
    }

    public LombokLightClassBuilder withMethodSupplier(Function<PsiClass, ? extends Collection<PsiMethod>> methodSupplier) {
        this.methodSupplier = methodSupplier;
        return this;
    }

    public LombokLightClassBuilder withEnum(boolean isEnum) {
        this.myIsEnum = isEnum;
        return this;
    }

    public LombokLightClassBuilder withAnnotationType(boolean isAnnotationType) {
        this.myIsAnnotationType = isAnnotationType;
        return this;
    }

    public LombokLightClassBuilder withImplicitModifier(@PsiModifier.ModifierConstant @NotNull @NonNls String modifier) {
        if (modifier == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(9);
        }
        this.myModifierList.addImplicitModifierProperty(modifier);
        return this;
    }

    public LombokLightClassBuilder withModifier(@PsiModifier.ModifierConstant @NotNull @NonNls String modifier) {
        if (modifier == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(10);
        }
        this.myModifierList.addModifier(modifier);
        return this;
    }

    public LombokLightClassBuilder withContainingClass(@NotNull PsiClass containingClass) {
        if (containingClass == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(11);
        }
        this.setContainingClass(containingClass);
        return this;
    }

    public LombokLightClassBuilder withNavigationElement(PsiElement navigationElement) {
        this.setNavigationElement(navigationElement);
        return this;
    }

    public LombokLightClassBuilder withExtends(PsiClassType baseClassType) {
        this.getExtendsList().addReference(baseClassType);
        return this;
    }

    public LombokLightClassBuilder withParameterTypes(@Nullable PsiTypeParameterList parameterList) {
        if (parameterList != null) {
            Stream.of(parameterList.getTypeParameters()).forEach(this::withParameterType);
        }
        return this;
    }

    public LombokLightClassBuilder withParameterType(@NotNull PsiTypeParameter psiTypeParameter) {
        if (psiTypeParameter == null) {
            LombokLightClassBuilder.$$$reportNull$$$0(12);
        }
        this.getTypeParameterList().addParameter(psiTypeParameter);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LombokLightClassBuilder that = (LombokLightClassBuilder)((Object)o);
        return this.myQualifiedName.equals(that.myQualifiedName);
    }

    public int hashCode() {
        return this.myQualifiedName.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/psi/LombokLightClassBuilder";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiTypeParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/psi/LombokLightClassBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnFields";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnMethods";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnInnerClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "withImplicitModifier";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "withModifier";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "withContainingClass";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "withParameterType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

