/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.handler.singular;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import de.plushnikov.intellij.plugin.processor.handler.BuilderHandler;
import de.plushnikov.intellij.plugin.processor.handler.BuilderInfo;
import de.plushnikov.intellij.plugin.processor.handler.singular.BuilderElementHandler;
import de.plushnikov.intellij.plugin.psi.LombokLightFieldBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.thirdparty.CapitalizationStrategy;
import de.plushnikov.intellij.plugin.thirdparty.LombokAddNullAnnotations;
import de.plushnikov.intellij.plugin.thirdparty.LombokCopyableAnnotations;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import de.plushnikov.intellij.plugin.util.PsiTypeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.core.handlers.Singulars;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSingularHandler
implements BuilderElementHandler {
    private static final String BUILDER_TEMP_VAR = "builder";
    final String collectionQualifiedName;

    AbstractSingularHandler(String qualifiedName) {
        this.collectionQualifiedName = qualifiedName;
    }

    @Override
    public Collection<PsiField> renderBuilderFields(@NotNull BuilderInfo info) {
        if (info == null) {
            AbstractSingularHandler.$$$reportNull$$$0(0);
        }
        PsiType builderFieldType = this.getBuilderFieldType(info.getFieldType(), info.getProject());
        return Collections.singleton(new LombokLightFieldBuilder(info.getManager(), info.getFieldName(), builderFieldType).withContainingClass(info.getBuilderClass()).withModifier("private").withNavigationElement((PsiElement)info.getVariable()));
    }

    @NotNull
    protected PsiType getBuilderFieldType(@NotNull PsiType psiFieldType, @NotNull Project project) {
        if (psiFieldType == null) {
            AbstractSingularHandler.$$$reportNull$$$0(1);
        }
        if (project == null) {
            AbstractSingularHandler.$$$reportNull$$$0(2);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiType elementType = PsiTypeUtil.extractOneElementType(psiFieldType, psiManager);
        PsiType psiType = PsiTypeUtil.createCollectionType(psiManager, "java.util.ArrayList", elementType);
        if (psiType == null) {
            AbstractSingularHandler.$$$reportNull$$$0(3);
        }
        return psiType;
    }

    @Override
    public Collection<PsiMethod> renderBuilderMethod(@NotNull BuilderInfo info, Map<String, List<List<PsiType>>> alreadyExistedMethods) {
        String singularClearMethodName;
        String singularAddAllMethodName;
        if (info == null) {
            AbstractSingularHandler.$$$reportNull$$$0(4);
        }
        ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>();
        PsiType returnType = info.getBuilderType();
        String fieldName = info.getFieldName();
        String singularName = this.createSingularName(info.getSingularAnnotation(), fieldName);
        PsiClass builderClass = info.getBuilderClass();
        String singularAddOneMethodName = LombokUtils.buildAccessorName(info.getSetterPrefix(), singularName, info.getCapitalizationStrategy());
        if (!BuilderHandler.matchMethodWithParams(alreadyExistedMethods, singularAddOneMethodName, this.getOneMethodParameterTypes(info))) {
            LombokLightMethodBuilder oneAddMethodBuilder = new LombokLightMethodBuilder(info.getManager(), singularAddOneMethodName).withContainingClass(builderClass).withMethodReturnType(returnType).withNavigationElement((PsiElement)info.getVariable()).withModifier(info.getVisibilityModifier()).withAnnotations(info.getAnnotations()).withWriteAccess();
            this.addOneMethodParameter(oneAddMethodBuilder, info.getFieldType(), singularName);
            PsiVariable psiVariable = info.getVariable();
            if (psiVariable instanceof PsiField) {
                PsiField psiField = (PsiField)psiVariable;
                LombokCopyableAnnotations.copyCopyableAnnotations(psiField, oneAddMethodBuilder.getModifierList(), LombokCopyableAnnotations.COPY_TO_BUILDER_SINGULAR_SETTER);
            }
            String oneMethodBody = this.getOneMethodBody(singularName, info);
            oneAddMethodBuilder.withBodyText(oneMethodBody);
            LombokAddNullAnnotations.createRelevantNonNullAnnotation(info.getNullAnnotationLibrary(), oneAddMethodBuilder);
            methods.add((PsiMethod)oneAddMethodBuilder);
        }
        if (!BuilderHandler.matchMethodWithParams(alreadyExistedMethods, singularAddAllMethodName = LombokUtils.buildAccessorName(info.getSetterPrefix(), fieldName, info.getCapitalizationStrategy()), this.getAllMethodParameterTypes(info))) {
            LombokLightMethodBuilder allAddMethodBuilder = new LombokLightMethodBuilder(info.getManager(), singularAddAllMethodName).withContainingClass(builderClass).withMethodReturnType(returnType).withNavigationElement((PsiElement)info.getVariable()).withModifier(info.getVisibilityModifier()).withAnnotations(info.getAnnotations()).withWriteAccess();
            this.addAllMethodParameter(allAddMethodBuilder, info.getFieldType(), fieldName);
            PsiVariable psiVariable = info.getVariable();
            if (psiVariable instanceof PsiField) {
                PsiField psiField = (PsiField)psiVariable;
                LombokCopyableAnnotations.copyCopyableAnnotations(psiField, allAddMethodBuilder.getModifierList(), LombokCopyableAnnotations.COPY_TO_SETTER);
            }
            String allMethodBody = this.getAllMethodBody(fieldName, info);
            allAddMethodBuilder.withBodyText(allMethodBody);
            LombokAddNullAnnotations.createRelevantNonNullAnnotation(info.getNullAnnotationLibrary(), allAddMethodBuilder);
            methods.add((PsiMethod)allAddMethodBuilder);
        }
        if (!BuilderHandler.matchMethodWithParams(alreadyExistedMethods, singularClearMethodName = AbstractSingularHandler.createSingularClearMethodName(fieldName, info.getCapitalizationStrategy()), Collections.emptyList())) {
            LombokLightMethodBuilder clearMethodBuilder = new LombokLightMethodBuilder(info.getManager(), singularClearMethodName).withContainingClass(builderClass).withMethodReturnType(returnType).withNavigationElement((PsiElement)info.getVariable()).withModifier(info.getVisibilityModifier()).withAnnotations(info.getAnnotations()).withWriteAccess();
            String clearMethodBlockText = this.getClearMethodBody(info);
            clearMethodBuilder.withBodyText(clearMethodBlockText);
            LombokAddNullAnnotations.createRelevantNonNullAnnotation(info.getNullAnnotationLibrary(), clearMethodBuilder);
            methods.add((PsiMethod)clearMethodBuilder);
        }
        return methods;
    }

    @NotNull
    private static String createSingularClearMethodName(String fieldName, CapitalizationStrategy capitalizationStrategy) {
        String string = LombokUtils.buildAccessorName("clear", fieldName, capitalizationStrategy);
        if (string == null) {
            AbstractSingularHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public List<String> getBuilderMethodNames(@NotNull String fieldName, @NotNull String prefix, @Nullable PsiAnnotation singularAnnotation, CapitalizationStrategy capitalizationStrategy) {
        if (fieldName == null) {
            AbstractSingularHandler.$$$reportNull$$$0(6);
        }
        if (prefix == null) {
            AbstractSingularHandler.$$$reportNull$$$0(7);
        }
        String accessorName = LombokUtils.buildAccessorName(prefix, fieldName, capitalizationStrategy);
        return Arrays.asList(this.createSingularName(singularAnnotation, accessorName), accessorName, AbstractSingularHandler.createSingularClearMethodName(fieldName, capitalizationStrategy));
    }

    @Override
    public String renderToBuilderCall(@NotNull BuilderInfo info) {
        if (info == null) {
            AbstractSingularHandler.$$$reportNull$$$0(8);
        }
        String instanceGetter = info.getInstanceVariableName() + "." + info.getVariable().getName();
        return info.getFieldName() + "(" + instanceGetter + " == null ? " + this.getEmptyCollectionCall(info) + " : " + instanceGetter + ")";
    }

    @Override
    public String renderToBuilderAppendCall(@NotNull BuilderInfo info) {
        if (info == null) {
            AbstractSingularHandler.$$$reportNull$$$0(9);
        }
        String accessorName = LombokUtils.buildAccessorName(info.getSetterPrefix(), info.getFieldName(), info.getCapitalizationStrategy());
        String instanceGetter = info.getInstanceVariableName() + "." + info.getVariable().getName();
        return "if(" + instanceGetter + " != null) builder." + accessorName + "(" + instanceGetter + ");";
    }

    protected abstract String getEmptyCollectionCall(@NotNull BuilderInfo var1);

    protected abstract String getClearMethodBody(@NotNull BuilderInfo var1);

    protected abstract List<PsiType> getOneMethodParameterTypes(@NotNull BuilderInfo var1);

    protected abstract List<PsiType> getAllMethodParameterTypes(@NotNull BuilderInfo var1);

    protected abstract void addOneMethodParameter(@NotNull LombokLightMethodBuilder var1, @NotNull PsiType var2, @NotNull String var3);

    protected abstract void addAllMethodParameter(@NotNull LombokLightMethodBuilder var1, @NotNull PsiType var2, @NotNull String var3);

    protected abstract String getOneMethodBody(@NotNull String var1, @NotNull BuilderInfo var2);

    protected abstract String getAllMethodBody(@NotNull String var1, @NotNull BuilderInfo var2);

    @Override
    public String createSingularName(@NotNull PsiAnnotation singularAnnotation, String psiFieldName) {
        String singularName;
        if (singularAnnotation == null) {
            AbstractSingularHandler.$$$reportNull$$$0(10);
        }
        if (StringUtil.isEmptyOrSpaces((String)(singularName = PsiAnnotationUtil.getStringAnnotationValue(singularAnnotation, "value", ""))) && (singularName = Singulars.autoSingularize(psiFieldName)) == null) {
            singularName = psiFieldName;
        }
        return singularName;
    }

    public static boolean validateSingularName(PsiAnnotation singularAnnotation, String psiFieldName) {
        String singularName = PsiAnnotationUtil.getStringAnnotationValue(singularAnnotation, "value", "");
        if (StringUtil.isEmptyOrSpaces((String)singularName)) {
            singularName = Singulars.autoSingularize(psiFieldName);
            return singularName != null;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFieldType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/handler/singular/AbstractSingularHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singularAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/handler/singular/AbstractSingularHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilderFieldType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createSingularClearMethodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "renderBuilderFields";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderFieldType";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "renderBuilderMethod";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderMethodNames";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "renderToBuilderCall";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "renderToBuilderAppendCall";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createSingularName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }
}

