/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.spring.model.ResolvedConstructorArgs;
import com.intellij.spring.model.converters.ConstructorArgNameConverter;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.ConvertContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstructorArgNameConverterImpl
extends ConstructorArgNameConverter {
    public PsiParameter fromString(@Nullable String s, @NotNull ConvertContext context) {
        if (context == null) {
            ConstructorArgNameConverterImpl.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmpty((String)s)) {
            return null;
        }
        SpringBean bean = (SpringBean)SpringConverterUtil.getCurrentBean((ConvertContext)context);
        if (bean == null) {
            return null;
        }
        ResolvedConstructorArgs resolvedArgs = bean.getResolvedConstructorArgs();
        PsiMethod resolvedMethod = resolvedArgs.getResolvedMethod();
        if (resolvedMethod != null) {
            ConstructorArg constructorArg = (ConstructorArg)context.getInvocationElement().getParentOfType(ConstructorArg.class, false);
            Map args = resolvedArgs.getResolvedArgs(resolvedMethod);
            assert (args != null);
            return (PsiParameter)args.get(constructorArg);
        }
        List checkedMethods = resolvedArgs.getCheckedMethods();
        for (PsiMethod method : checkedMethods) {
            for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
                if (!s.equals(psiParameter.getName())) continue;
                return psiParameter;
            }
        }
        return null;
    }

    @NotNull
    public Collection<PsiParameter> getVariants(@NotNull ConvertContext context) {
        if (context == null) {
            ConstructorArgNameConverterImpl.$$$reportNull$$$0(1);
        }
        Collection<PsiParameter> collection = ConstructorArgNameConverterImpl.getAllConstructorParams(context);
        if (collection == null) {
            ConstructorArgNameConverterImpl.$$$reportNull$$$0(2);
        }
        return collection;
    }

    private static Collection<PsiParameter> getAllConstructorParams(ConvertContext context) {
        HashMap<String, PsiParameter> params = new HashMap<String, PsiParameter>();
        SpringBean springBean = (SpringBean)context.getInvocationElement().getParentOfType(SpringBean.class, false);
        if (springBean != null) {
            List psiMethods = springBean.getInstantiationMethods();
            for (PsiMethod psiMethod : psiMethods) {
                for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
                    params.put(parameter.getName(), parameter);
                }
            }
        }
        return params.values();
    }

    public LookupElement createLookupElement(PsiParameter psiParameter) {
        return LookupElementBuilder.create((PsiNamedElement)psiParameter).withIcon(AllIcons.Nodes.Parameter).withTypeText(psiParameter.getType().getPresentableText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/converters/ConstructorArgNameConverterImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/converters/ConstructorArgNameConverterImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

