/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.facet;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/javaee/web/facet/WebRootData;", "", "url", "", "relativePath", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getUrl", "()Ljava/lang/String;", "getRelativePath", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.javaee.web"})
public final class WebRootData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private final String relativePath;

    public WebRootData(@NotNull String url, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        this.url = url;
        this.relativePath = relativePath;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final String getRelativePath() {
        return this.relativePath;
    }

    @Nullable
    public final VirtualFile findFile() {
        return VirtualFileManager.getInstance().findFileByUrl(this.url);
    }

    @NotNull
    public final String component1() {
        return this.url;
    }

    @NotNull
    public final String component2() {
        return this.relativePath;
    }

    @NotNull
    public final WebRootData copy(@NotNull String url, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return new WebRootData(url, relativePath);
    }

    public static /* synthetic */ WebRootData copy$default(WebRootData webRootData, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = webRootData.url;
        }
        if ((n & 2) != 0) {
            string2 = webRootData.relativePath;
        }
        return webRootData.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "WebRootData(url=" + this.url + ", relativePath=" + this.relativePath + ")";
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = result * 31 + this.relativePath.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WebRootData)) {
            return false;
        }
        WebRootData webRootData = (WebRootData)other;
        if (!Intrinsics.areEqual((Object)this.url, (Object)webRootData.url)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.relativePath, (Object)webRootData.relativePath);
    }

    @JvmStatic
    @NotNull
    public static final WebRootData create(@NotNull Element element) {
        return Companion.create(element);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/javaee/web/facet/WebRootData$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/javaee/web/facet/WebRootData;", "element", "Lorg/jdom/Element;", "intellij.javaee.web"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final WebRootData create(@NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String string = element.getAttributeValue("url");
            if (string == null) {
                string = "";
            }
            String url = string;
            String string2 = element.getAttributeValue("relative");
            if (string2 == null) {
                throw new InvalidDataException("No relative attribute in Web Root element " + element);
            }
            String relativePath = string2;
            return new WebRootData(url, relativePath);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

