/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tailwind.lsp;

import com.intellij.execution.wsl.WslPath;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.javascript.nodejs.settings.NodeSettingsConfigurable;
import com.intellij.javascript.runtime.settings.JavaScriptRuntimeConfigurableKt;
import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lang.lsWidget.LanguageServicePopupSection;
import com.intellij.platform.lang.lsWidget.LanguageServiceWidgetItem;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.LspServerManager;
import com.intellij.platform.lsp.api.LspServerSupportProvider;
import com.intellij.platform.lsp.api.lsWidget.LspServerWidgetItem;
import com.intellij.tailwind.TailwindCssBundle;
import com.intellij.tailwind.lsp.TailwindLspServerDescriptor;
import com.intellij.tailwind.lsp.TailwindProblemWidgetItem;
import com.intellij.tailwind.settings.TailwindConfigurable;
import com.intellij.tailwind.util.TailwindUtil;
import icons.TailwindcssIcons;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\tH\u0002J \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0016J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/tailwind/lsp/TailwindLspServerSupportProvider;", "Lcom/intellij/platform/lsp/api/LspServerSupportProvider;", "<init>", "()V", "fileOpened", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "serverStarter", "Lcom/intellij/platform/lsp/api/LspServerSupportProvider$LspServerStarter;", "isTailwindProjectRoot", "", "rootDir", "createLspWidgetItems", "", "Lcom/intellij/platform/lang/lsWidget/LanguageServiceWidgetItem;", "currentFile", "createLspServerWidgetItem", "Lcom/intellij/platform/lsp/api/lsWidget/LspServerWidgetItem;", "lspServer", "Lcom/intellij/platform/lsp/api/LspServer;", "intellij.tailwindcss"})
public final class TailwindLspServerSupportProvider
implements LspServerSupportProvider {
    public void fileOpened(@NotNull Project project, @NotNull VirtualFile file, @NotNull LspServerSupportProvider.LspServerStarter serverStarter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)serverStarter, (String)"serverStarter");
        NodeJsInterpreter nodeJsInterpreter = NodeJsInterpreterManager.getInstance((Project)project).getInterpreter();
        if (nodeJsInterpreter == null) {
            return;
        }
        NodeJsInterpreter node = nodeJsInterpreter;
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        boolean isWslPath = WslPath.Companion.isWslUncPath(string);
        if (isWslPath && node instanceof NodeJsLocalInterpreter) {
            return;
        }
        if (!TailwindUtil.isSupportedFile(project, file)) {
            return;
        }
        VirtualFile virtualFile = BaseProjectDirectories.Companion.getInstance(project).getBaseDirectoryFor(file);
        if (virtualFile == null) {
            return;
        }
        VirtualFile baseDir = virtualFile;
        if (this.isTailwindProjectRoot(project, baseDir)) {
            serverStarter.ensureServerStarted((LspServerDescriptor)new TailwindLspServerDescriptor(project, baseDir));
        }
    }

    private final boolean isTailwindProjectRoot(Project project, VirtualFile rootDir) {
        for (VirtualFile packageJson : PackageJsonFileManager.getInstance((Project)project).getValidPackageJsonFiles()) {
            BaseProjectDirectories baseProjectDirectories = BaseProjectDirectories.Companion.getInstance(project);
            Intrinsics.checkNotNull((Object)packageJson);
            if (!Intrinsics.areEqual((Object)rootDir, (Object)baseProjectDirectories.getBaseDirectoryFor(packageJson)) || !TailwindUtil.isTailwindProject(project, packageJson)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<LanguageServiceWidgetItem> createLspWidgetItems(@NotNull Project project, @Nullable VirtualFile currentFile) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!LspServerManager.Companion.getInstance(project).getServersForProvider(this.getClass()).isEmpty()) {
            return super.createLspWidgetItems(project, currentFile);
        }
        if (currentFile == null) {
            return CollectionsKt.emptyList();
        }
        if (!TailwindUtil.isSupportedFile(project, currentFile)) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile = BaseProjectDirectories.Companion.getInstance(project).getBaseDirectoryFor(currentFile);
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile baseDir = virtualFile;
        if (!this.isTailwindProjectRoot(project, baseDir)) {
            return CollectionsKt.emptyList();
        }
        NodeJsInterpreter node = NodeJsInterpreterManager.getInstance((Project)project).getInterpreter();
        String string2 = currentFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        boolean isWslPath = WslPath.Companion.isWslUncPath(string2);
        if (node == null) {
            string = TailwindCssBundle.message("widget.item.problem.no.node", new Object[0]);
        } else if (isWslPath && node instanceof NodeJsLocalInterpreter) {
            Object[] objectArray = new Object[]{((NodeJsLocalInterpreter)node).getPresentableName()};
            string = TailwindCssBundle.message("widget.item.problem.wsl.project.not.wsl.node", objectArray);
        } else {
            return CollectionsKt.emptyList();
        }
        String problemText = string;
        Intrinsics.checkNotNull((Object)problemText);
        return CollectionsKt.listOf((Object)((Object)new TailwindProblemWidgetItem(problemText, LanguageServicePopupSection.ForCurrentFile, JavaScriptRuntimeConfigurableKt.getJavaScriptRuntimeConfigurableClass(NodeSettingsConfigurable.class))));
    }

    @NotNull
    public LspServerWidgetItem createLspServerWidgetItem(@NotNull LspServer lspServer, @Nullable VirtualFile currentFile) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        Icon icon = TailwindcssIcons.Tailwind_16;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Tailwind_16");
        return new LspServerWidgetItem(lspServer, currentFile, icon, TailwindConfigurable.class);
    }
}

