/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.gui;

import com.intellij.jpa.jpb.model.ui.component.CreationSourceFileDialog;
import com.intellij.liquibase.common.ChangeLogWriterEP;
import com.intellij.liquibase.common.LiquibaseFileType;
import com.intellij.liquibase.common.LiquibaseHelper;
import com.intellij.liquibase.common.config.DatabaseMigrationConfig;
import com.intellij.liquibase.common.config.DiffGenerationConfig;
import com.intellij.liquibase.common.msg.LiquibaseResourceBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.PsiDirectory;
import com.intellij.util.ui.FormBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0012\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u0016\u001a\u00020\fH\u0002J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u0016J\u0006\u0010\u0019\u001a\u00020\fJ\b\u0010\u001a\u001a\u00020\u0005H\u0016R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/liquibase/common/gui/ChangeLogCreationDialog;", "Lcom/intellij/jpa/jpb/model/ui/component/CreationSourceFileDialog;", "project", "Lcom/intellij/openapi/project/Project;", "directoryPath", "", "selectedResourcesDir", "Lcom/intellij/psi/PsiDirectory;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/psi/PsiDirectory;)V", "fileTypeComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/liquibase/common/LiquibaseFileType;", "createCenterPanel", "Ljavax/swing/JComponent;", "initFormBuilder", "", "formBuilder", "Lcom/intellij/util/ui/FormBuilder;", "getInitFileName", "completedDirectory", "getLastSelectedDirectoryPath", "getlastSelectedFileType", "saveSettings", "duplicateFileErrorMsg", "getFileType", "getFileExt", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nChangeLogCreationDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeLogCreationDialog.kt\ncom/intellij/liquibase/common/gui/ChangeLogCreationDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,67:1\n1563#2:68\n1634#2,3:69\n37#3,2:72\n106#4:74\n78#4,22:75\n*S KotlinDebug\n*F\n+ 1 ChangeLogCreationDialog.kt\ncom/intellij/liquibase/common/gui/ChangeLogCreationDialog\n*L\n30#1:68\n30#1:69,3\n31#1:72,2\n57#1:74\n57#1:75,22\n*E\n"})
public class ChangeLogCreationDialog
extends CreationSourceFileDialog {
    private ComboBox<LiquibaseFileType> fileTypeComboBox;

    public ChangeLogCreationDialog(@NotNull Project project, @NotNull String directoryPath, @Nullable PsiDirectory selectedResourcesDir) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        super(project, directoryPath, selectedResourcesDir);
        this.setTitle(LiquibaseResourceBundle.message("new.liquibase.database.change.log", new Object[0]));
    }

    public /* synthetic */ ChangeLogCreationDialog(Project project, String string, PsiDirectory psiDirectory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            psiDirectory = null;
        }
        this(project, string, psiDirectory);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected JComponent createCenterPanel() {
        void $this$mapTo$iv$iv;
        Project project = this.project;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Iterable $this$map$iv = ChangeLogWriterEP.Companion.getAll(project);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChangeLogWriterEP changeLogWriterEP = (ChangeLogWriterEP)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.supportedFileType());
        }
        List fileTypes = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        Collection $this$toTypedArray$iv = fileTypes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.fileTypeComboBox = new ComboBox((Object[])thisCollection$iv.toArray(new LiquibaseFileType[0]));
        ComboBox<LiquibaseFileType> comboBox = this.fileTypeComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fileTypeComboBox");
            comboBox = null;
        }
        comboBox.setSelectedItem((Object)this.getlastSelectedFileType());
        return super.createCenterPanel();
    }

    protected void initFormBuilder(@NotNull FormBuilder formBuilder) {
        Intrinsics.checkNotNullParameter((Object)formBuilder, (String)"formBuilder");
        FormBuilder formBuilder2 = formBuilder.addLabeledComponent(LiquibaseResourceBundle.messageWithColon("source.root", new Object[0]), (JComponent)this.getSourceRootField()).addLabeledComponent(LiquibaseResourceBundle.messageWithColon("directory", new Object[0]), (JComponent)this.getDirectoryField()).addLabeledComponent(LiquibaseResourceBundle.messageWithColon("file.name", new Object[0]), (JComponent)this.getFileNameField());
        String string = LiquibaseResourceBundle.messageWithColon("file.type", new Object[0]);
        ComboBox<LiquibaseFileType> comboBox = this.fileTypeComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fileTypeComboBox");
            comboBox = null;
        }
        formBuilder2.addLabeledComponent(string, (JComponent)comboBox);
    }

    @NotNull
    public String getInitFileName(@Nullable PsiDirectory completedDirectory) {
        PsiDirectory psiDirectory;
        Project project = this.project;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return LiquibaseHelper.generateChangeLogName$default(LiquibaseHelper.Companion.getInstance(project), (psiDirectory = completedDirectory) != null && (psiDirectory = psiDirectory.getVirtualFile()) != null ? psiDirectory.getPath() : null, CollectionsKt.emptyList(), false, 4, null);
    }

    @Nullable
    public String getLastSelectedDirectoryPath() {
        Project project = this.project;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return DiffGenerationConfig.Companion.getInstance(project).getLiquibaseDirectory();
    }

    private final LiquibaseFileType getlastSelectedFileType() {
        Project project = this.project;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return DatabaseMigrationConfig.Companion.getInstance(project).getState().getLiquibaseFileType();
    }

    /*
     * WARNING - void declaration
     */
    public void saveSettings() {
        void $this$trim$iv;
        Project project = this.project;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        DiffGenerationConfig diffGenerationConfig = DiffGenerationConfig.Companion.getInstance(project);
        String string = this.getDirectoryField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        DiffGenerationConfig diffGenerationConfig2 = diffGenerationConfig;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        diffGenerationConfig2.setLiquibaseDirectory(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
        Project project2 = this.project;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        DatabaseMigrationConfig.Companion.getInstance(project2).getState().setLiquibaseFileType(this.getFileType());
    }

    @Nullable
    public String duplicateFileErrorMsg() {
        return LiquibaseResourceBundle.message("Validation.changeLogFileExists", new Object[0]);
    }

    @NotNull
    public final LiquibaseFileType getFileType() {
        Object object;
        LiquibaseFileType liquibaseFileType;
        ComboBox<LiquibaseFileType> comboBox = this.fileTypeComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fileTypeComboBox");
            comboBox = null;
        }
        if ((liquibaseFileType = (object = comboBox.getSelectedItem()) instanceof LiquibaseFileType ? (LiquibaseFileType)((Object)object) : null) == null) {
            liquibaseFileType = LiquibaseFileType.XML;
        }
        return liquibaseFileType;
    }

    @NotNull
    public String getFileExt() {
        return (String)ArraysKt.first((Object[])this.getFileType().getFileExtensions());
    }
}

