/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.action;

import com.intellij.liquibase.common.action.RemoveChangesActionGroup;
import com.intellij.liquibase.common.gui.ChangeLogModel;
import com.intellij.liquibase.common.gui.ChangeLogPreviewDialog;
import com.intellij.liquibase.common.gui.ChangeLogTree;
import com.intellij.liquibase.common.gui.ChangeLogTreeKt;
import com.intellij.liquibase.common.gui.ChangeModel;
import com.intellij.liquibase.common.gui.ChangeSetModel;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/liquibase/common/action/AbstractRemoveAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "isIgnore", "", "<init>", "(Z)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "removeSelectedNodes", "tree", "Lcom/intellij/liquibase/common/gui/ChangeLogTree;", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nRemoveChangesActionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveChangesActionGroup.kt\ncom/intellij/liquibase/common/action/AbstractRemoveAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1869#2,2:109\n1869#2,2:111\n*S KotlinDebug\n*F\n+ 1 RemoveChangesActionGroup.kt\ncom/intellij/liquibase/common/action/AbstractRemoveAction\n*L\n70#1:109,2\n84#1:111,2\n*E\n"})
public abstract class AbstractRemoveAction
extends AnAction {
    private final boolean isIgnore;

    public AbstractRemoveAction(boolean isIgnore) {
        this.isIgnore = isIgnore;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataKey<ChangeLogTree> dataKey = ChangeLogPreviewDialog.Companion.getCHANGE_LOG_TREE_KEY();
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Object object = dataKey.getData(dataContext);
        Intrinsics.checkNotNull((Object)object);
        this.removeSelectedNodes((ChangeLogTree)((Object)object));
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataKey<ChangeLogTree> dataKey = ChangeLogPreviewDialog.Companion.getCHANGE_LOG_TREE_KEY();
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        ChangeLogTree tree = (ChangeLogTree)((Object)dataKey.getData(dataContext));
        e.getPresentation().setEnabledAndVisible(RemoveChangesActionGroup.Companion.isAvailableAction(tree));
    }

    private final void removeSelectedNodes(ChangeLogTree tree) {
        LinkedHashSet<DefaultMutableTreeNode> toMoveChangeNodes = new LinkedHashSet<DefaultMutableTreeNode>();
        Iterable $this$forEach$iv = tree.getSelectedNodes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)element$iv;
            boolean bl = false;
            Object object = selectedNode.getUserObject();
            if (object instanceof ChangeModel) {
                toMoveChangeNodes.add(selectedNode);
            } else if (object instanceof ChangeSetModel || object instanceof ChangeLogModel) {
                toMoveChangeNodes.addAll(ChangeLogTreeKt.getChildrenNodeByUserObjectType(selectedNode, ChangeModel.class, true));
            }
            tree.getMyTreeModel().removeNodeFromParent(selectedNode);
        }
        $this$forEach$iv = toMoveChangeNodes;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DefaultMutableTreeNode it = (DefaultMutableTreeNode)element$iv;
            boolean bl = false;
            tree.removeNodeFromCache(it);
        }
        if (this.isIgnore) {
            DefaultMutableTreeNode ignoredNode = tree.getIgnoredNode();
            Iterator iterator = toMoveChangeNodes.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                DefaultMutableTreeNode toMoveChangeNode = (DefaultMutableTreeNode)e;
                tree.getMyTreeModel().insertNodeInto(toMoveChangeNode, ignoredNode, ignoredNode.getChildCount());
            }
        }
    }
}

