/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common;

import com.intellij.jpa.jpb.model.backend.ed.indexing.EntitySearch;
import com.intellij.jpa.jpb.model.liquibase.ns.ImplicitNamingStrategy;
import com.intellij.jpa.jpb.model.liquibase.ns.SpringImplicitNamingStrategy;
import com.intellij.jpa.jpb.model.model.DbIdentifierHelper;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.orm.ep.OrmMappingProvider;
import com.intellij.jpa.jpb.model.orm.jpa.JpaOrmFramework;
import com.intellij.jpa.jpb.model.orm.jpa.model.CustomJpaOrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import liquibase.ext.intellij.database.connection.IntellijConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\n\u001a\u00020\u000bH&J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\n\u001a\u00020\u000bH&J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/intellij/liquibase/common/IntellijDatabaseManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "findEntityByTableName", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;", "intellijConnection", "Lliquibase/ext/intellij/database/connection/IntellijConnection;", "tableName", "", "collectEntitiesToProcess", "", "collectAllEntities", "getImplicitNameStrategy", "Lcom/intellij/jpa/jpb/model/liquibase/ns/ImplicitNamingStrategy;", "Companion", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nIntellijDatabaseManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntellijDatabaseManager.kt\ncom/intellij/liquibase/common/IntellijDatabaseManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n1617#2,9:47\n1869#2:56\n1870#2:58\n1626#2:59\n295#2,2:60\n1#3:57\n*S KotlinDebug\n*F\n+ 1 IntellijDatabaseManager.kt\ncom/intellij/liquibase/common/IntellijDatabaseManager\n*L\n22#1:47,9\n22#1:56\n22#1:58\n22#1:59\n27#1:60,2\n22#1:57\n*E\n"})
public abstract class IntellijDatabaseManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public IntellijDatabaseManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public OrmEntity findEntityByTableName(@NotNull IntellijConnection intellijConnection, @NotNull String tableName) {
        OrmEntity ormEntity;
        Intrinsics.checkNotNullParameter((Object)intellijConnection, (String)"intellijConnection");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        EntitySearch entitySearch = EntitySearch.getInstance((Project)intellijConnection.getProject());
        OrmFramework ormFramework = intellijConnection.getGenerationContext().getOrmFramework();
        if (Intrinsics.areEqual((Object)ormFramework, (Object)JpaOrmFramework.INSTANCE)) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = this.collectAllEntities(intellijConnection);
            EntitySearch entitySearch2 = entitySearch;
            boolean $i$f$mapNotNull = false;
            void var9_10 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PsiClass it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                OrmEntity it = (OrmEntity)element$iv$iv;
                boolean bl2 = false;
                SmartPsiElementPointer smartPsiElementPointer = it.getClassPsiPointer();
                if ((smartPsiElementPointer != null ? (PsiClass)smartPsiElementPointer.getElement() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            PsiClass psiClass = entitySearch2.findByTableName((Collection)((List)destination$iv$iv), tableName);
            if (psiClass == null) {
                return null;
            }
            PsiClass foundEntityClass = psiClass;
            EntityPsi entityPsi = EntityPsi.getInstance((PsiClass)foundEntityClass);
            Intrinsics.checkNotNullExpressionValue((Object)entityPsi, (String)"getInstance(...)");
            ormEntity = (OrmEntity)new CustomJpaOrmEntity((Entity)entityPsi);
        } else {
            Object v5;
            block6: {
                OrmMappingProvider ormMappingProvider = OrmMappingProvider.Companion.findForFramework(ormFramework);
                if (ormMappingProvider == null) {
                    return null;
                }
                OrmMappingProvider ormMappingProvider2 = ormMappingProvider;
                Iterable $this$firstOrNull$iv = this.collectAllEntities(intellijConnection);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    OrmEntity it = (OrmEntity)element$iv;
                    boolean bl = false;
                    if (!DbIdentifierHelper.compareIdentifier((String)ormMappingProvider2.getTableName(it), (String)tableName)) continue;
                    v5 = element$iv;
                    break block6;
                }
                v5 = null;
            }
            ormEntity = v5;
        }
        return ormEntity;
    }

    @NotNull
    public abstract List<OrmEntity> collectEntitiesToProcess(@NotNull IntellijConnection var1);

    @NotNull
    public abstract List<OrmEntity> collectAllEntities(@NotNull IntellijConnection var1);

    @NotNull
    public ImplicitNamingStrategy getImplicitNameStrategy() {
        return (ImplicitNamingStrategy)SpringImplicitNamingStrategy.Companion.getInstance(this.project);
    }

    @JvmStatic
    @NotNull
    public static final IntellijDatabaseManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/liquibase/common/IntellijDatabaseManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/liquibase/common/IntellijDatabaseManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.liquibase.common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IntellijDatabaseManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(IntellijDatabaseManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (IntellijDatabaseManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

