/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common;

import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.db.HibernateSqlType;
import com.intellij.jpa.jpb.model.db.HibernateTypes;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.liquibase.common.JavaType;
import com.intellij.liquibase.common.LiquibaseGenerationContext;
import com.intellij.liquibase.common.config.MappingType;
import com.intellij.liquibase.common.ddl.DbMappingSettings;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import liquibase.structure.core.DataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\bH\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\u0010\u0010%\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u00128VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006("}, d2={"Lcom/intellij/liquibase/common/DatatypeJavaType;", "Lcom/intellij/liquibase/common/JavaType;", "datatype", "Lcom/intellij/jpa/jpb/model/model/Datatype;", "length", "", "decimalDigits", "isNationalized", "", "jdbcTypeCode", "<init>", "(Lcom/intellij/jpa/jpb/model/model/Datatype;Ljava/lang/Integer;Ljava/lang/Integer;ZLjava/lang/Integer;)V", "getDatatype", "()Lcom/intellij/jpa/jpb/model/model/Datatype;", "getLength", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "id", "", "getId", "()Ljava/lang/String;", "id$delegate", "Lkotlin/Lazy;", "getSqlTypeFor", "dbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "context", "Lcom/intellij/liquibase/common/LiquibaseGenerationContext;", "toLiquibaseDataType", "Lliquibase/structure/core/DataType;", "isTypeChanged", "liquibaseType", "isCompatibilityStringType", "mappingSettings", "Lcom/intellij/liquibase/common/ddl/DbMappingSettings;", "isDecimalJdbcTypeCode", "toString", "isValid", "isConvertibleType", "liquibaseTypeName", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nJavaType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaType.kt\ncom/intellij/liquibase/common/DatatypeJavaType\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,297:1\n1617#2,9:298\n1869#2:307\n1870#2:309\n1626#2:310\n1869#2,2:311\n1617#2,9:313\n1869#2:322\n1870#2:324\n1626#2:325\n1#3:308\n1#3:323\n*S KotlinDebug\n*F\n+ 1 JavaType.kt\ncom/intellij/liquibase/common/DatatypeJavaType\n*L\n172#1:298,9\n172#1:307\n172#1:309\n172#1:310\n196#1:311,2\n144#1:313,9\n144#1:322\n144#1:324\n144#1:325\n172#1:308\n144#1:323\n*E\n"})
public final class DatatypeJavaType
implements JavaType {
    @NotNull
    private final Datatype datatype;
    @Nullable
    private final Integer length;
    @Nullable
    private final Integer decimalDigits;
    private final boolean isNationalized;
    @Nullable
    private final Integer jdbcTypeCode;
    @NotNull
    private final Lazy id$delegate;

    public DatatypeJavaType(@NotNull Datatype datatype, @Nullable Integer length, @Nullable Integer decimalDigits, boolean isNationalized, @Nullable Integer jdbcTypeCode) {
        Intrinsics.checkNotNullParameter((Object)datatype, (String)"datatype");
        this.datatype = datatype;
        this.length = length;
        this.decimalDigits = decimalDigits;
        this.isNationalized = isNationalized;
        this.jdbcTypeCode = jdbcTypeCode;
        this.id$delegate = LazyKt.lazy(() -> DatatypeJavaType.id_delegate$lambda$0(this));
    }

    public /* synthetic */ DatatypeJavaType(Datatype datatype, Integer n, Integer n2, boolean bl, Integer n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n = null;
        }
        if ((n4 & 4) != 0) {
            n2 = null;
        }
        if ((n4 & 8) != 0) {
            bl = false;
        }
        if ((n4 & 0x10) != 0) {
            n3 = null;
        }
        this(datatype, n, n2, bl, n3);
    }

    @NotNull
    public final Datatype getDatatype() {
        return this.datatype;
    }

    @Nullable
    public final Integer getLength() {
        return this.length;
    }

    @Override
    @NotNull
    public String getId() {
        Lazy lazy = this.id$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getSqlTypeFor(@NotNull DbType dbType, @NotNull LiquibaseGenerationContext context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DbMappingSettings mappingSettings = DbMappingSettings.Companion.getInstance(dbType, context.getProject());
        Datatype finalDatatype = this.datatype;
        if (this.datatype instanceof Datatypes.BasicDatatype && this.isNationalized) {
            if (((Datatypes.BasicDatatype)this.datatype).isString()) {
                finalDatatype = (Datatype)HibernateTypes.INSTANCE.getNationalizedType();
            } else {
                Datatype[] datatypeArray = new Datatype[]{this.datatype};
                if (Datatypes.BasicDatatype.LobString.isSame(datatypeArray)) {
                    Datatypes.BasicDatatype basicDatatype = Datatypes.BasicDatatype.NClob;
                    Intrinsics.checkNotNullExpressionValue((Object)basicDatatype, (String)"NClob");
                    finalDatatype = (Datatype)basicDatatype;
                }
            }
        }
        if ((string = context.getOverriddenSqlType(finalDatatype, dbType, this.jdbcTypeCode)) == null) {
            string = mappingSettings.getSqlTypeFor(finalDatatype, this.jdbcTypeCode, this.length, this.decimalDigits);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DataType toLiquibaseDataType(@NotNull LiquibaseGenerationContext context) {
        String string;
        HibernateSqlType hibernateSqlType;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List<DbType> dbTypes = context.getSupportedDbTypes();
        Iterable $this$mapNotNull$iv = dbTypes;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DbType it = (DbType)element$iv$iv;
            boolean bl2 = false;
            if (this.getSqlTypeFor(it, context) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List uniquePresentations = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        if (uniquePresentations.size() <= 1) {
            String string2 = (String)CollectionsKt.firstOrNull((List)uniquePresentations);
            if (string2 == null) {
                string2 = "#unknown";
            }
            Iterable $this$toLiquibaseDataType_u24lambda_u241 = $this$mapNotNull$iv = new DataType(string2);
            boolean bl = false;
            $this$toLiquibaseDataType_u24lambda_u241.setColumnSize(this.length);
            $this$toLiquibaseDataType_u24lambda_u241.setDecimalDigits(this.decimalDigits);
            return $this$mapNotNull$iv;
        }
        HibernateSqlType hibernateSqlType2 = hibernateSqlType = this.jdbcTypeCode == null ? null : HibernateSqlType.Companion.findBySqlCode(this.jdbcTypeCode.intValue());
        if (hibernateSqlType != null) {
            string = "SqlTypes." + hibernateSqlType.name();
        } else {
            Object object;
            String string3 = this.datatype.getLabel();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLabel(...)");
            String string4 = string3.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
            if (Intrinsics.areEqual((Object)string4, (Object)this.datatype.getLabel())) {
                String string5 = this.datatype.getLabel();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getLabel(...)");
                String string6 = string5.toLowerCase(Locale.ROOT);
                object = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
            } else {
                destination$iv$iv = StringUtil.decapitalize((String)this.datatype.getLabel());
                Intrinsics.checkNotNull((Object)destination$iv$iv);
                object = destination$iv$iv;
            }
            Object labelWithProperCapitalization = object;
            string = (String)labelWithProperCapitalization + ".type";
        }
        String typePropertyId = string;
        Iterable $this$forEach$iv = dbTypes;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            DbType it = (DbType)element$iv;
            boolean bl = false;
            String string7 = this.getSqlTypeFor(it, context);
            if (string7 == null) {
                string7 = "#unknown";
            }
            context.putLiquibaseProperty(typePropertyId, string7, it);
        }
        Iterable $this$toLiquibaseDataType_u24lambda_u243 = iterable = new DataType("$\\[" + typePropertyId + "\\]");
        boolean bl = false;
        $this$toLiquibaseDataType_u24lambda_u243.setColumnSize(this.length);
        $this$toLiquibaseDataType_u24lambda_u243.setDecimalDigits(this.decimalDigits);
        return iterable;
    }

    @Override
    public boolean isTypeChanged(@NotNull DataType liquibaseType, @NotNull LiquibaseGenerationContext context) {
        boolean scaleChanged;
        Datatype[] precisionChanged2;
        boolean precisionChanged2;
        Datatype[] datatypeArray;
        Intrinsics.checkNotNullParameter((Object)liquibaseType, (String)"liquibaseType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DbMappingSettings mappingSettings = DbMappingSettings.Companion.getInstance(context.getMainDbType(), context.getProject());
        MappingType.SqlTypeParameter sqlTypeParameter = context.getSqlTypeParameter(this.datatype, context.getMainDbType(), this.jdbcTypeCode);
        String string = this.getSqlTypeFor(context.getMainDbType(), context);
        if (string == null) {
            string = "#unsupported";
        }
        String attributeSqlType = string;
        String dbType = liquibaseType.getTypeName();
        if (sqlTypeParameter == MappingType.SqlTypeParameter.NOTHING && StringsKt.contains$default((CharSequence)attributeSqlType, (char)'(', (boolean)false, (int)2, null)) {
            Intrinsics.checkNotNull((Object)dbType);
            if (!StringsKt.contains$default((CharSequence)dbType, (char)'(', (boolean)false, (int)2, null)) {
                attributeSqlType = StringsKt.substringBeforeLast$default((String)attributeSqlType, (char)'(', null, (int)2, null);
            }
        }
        Intrinsics.checkNotNull((Object)dbType);
        Integer n = liquibaseType.getColumnSize();
        boolean typeChanged = mappingSettings.typeChanged(this.datatype, attributeSqlType, dbType, n != null ? n : -1);
        if (typeChanged) {
            return true;
        }
        if ((this.isDecimalJdbcTypeCode() || Datatypes.BasicDatatype.BigDecimal.isSame(datatypeArray = new Datatype[]{this.datatype}) && (sqlTypeParameter == null || sqlTypeParameter == MappingType.SqlTypeParameter.PRECISION_AND_SCALE)) && (precisionChanged2 = mappingSettings.precisionChanged(this.length, liquibaseType.getColumnSize(), attributeSqlType, dbType))) {
            return true;
        }
        if ((this.isDecimalJdbcTypeCode() || Datatypes.BasicDatatype.BigDecimal.isSame(precisionChanged2 = new Datatype[]{this.datatype}) && (sqlTypeParameter == null || sqlTypeParameter == MappingType.SqlTypeParameter.PRECISION_AND_SCALE)) && (scaleChanged = mappingSettings.scaleChanged(this.decimalDigits, liquibaseType.getDecimalDigits(), attributeSqlType, dbType))) {
            return true;
        }
        if (this.isCompatibilityStringType(mappingSettings) && sqlTypeParameter == null || sqlTypeParameter == MappingType.SqlTypeParameter.LENGTH) {
            return mappingSettings.lengthChanged(attributeSqlType, dbType, this.length, liquibaseType.getColumnSize());
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCompatibilityStringType(DbMappingSettings mappingSettings) {
        if (this.jdbcTypeCode != null) {
            return mappingSettings.isJdbcTypeCodeLengthAvailable(this.jdbcTypeCode);
        }
        Datatype[] datatypeArray = new Datatype[]{this.datatype};
        if (Datatypes.BasicDatatype.String.isSame(datatypeArray)) return true;
        datatypeArray = new Datatype[]{this.datatype};
        if (Datatypes.BasicDatatype.LobString.isSame(datatypeArray)) return true;
        datatypeArray = new Datatype[]{this.datatype};
        if (!HibernateTypes.INSTANCE.getNationalizedType().isSame(datatypeArray)) return false;
        return true;
    }

    private final boolean isDecimalJdbcTypeCode() {
        return HibernateSqlType.DECIMAL.equalsByCode(this.jdbcTypeCode) || HibernateSqlType.NUMERIC.equalsByCode(this.jdbcTypeCode);
    }

    @NotNull
    public String toString() {
        return this.getId();
    }

    @Override
    public boolean isValid(@NotNull LiquibaseGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSqlTypeFor(context.getMainDbType(), context) != null;
    }

    @Override
    public boolean isConvertibleType(@NotNull String liquibaseTypeName, @NotNull LiquibaseGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)liquibaseTypeName, (String)"liquibaseTypeName");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = this.getSqlTypeFor(context.getMainDbType(), context);
        if (string == null) {
            return false;
        }
        String attrSqlType = string;
        return context.getMappingSettings(context.getMainDbType()).isConvertibleType(attrSqlType, liquibaseTypeName);
    }

    /*
     * WARNING - void declaration
     */
    private static final String id_delegate$lambda$0(DatatypeJavaType this$0) {
        void $this$mapNotNullTo$iv$iv;
        Object object = new Integer[]{this$0.length, this$0.decimalDigits};
        Iterable $this$mapNotNull$iv = CollectionsKt.listOf((Object[])object);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Integer it = (Integer)element$iv$iv;
            boolean bl2 = false;
            Integer n = it;
            if ((n != null ? String.valueOf(n) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Object it = object = (List)destination$iv$iv;
        boolean bl = false;
        Object object2 = !((Collection)it).isEmpty() ? object : null;
        Object sizes = object2 != null && (object = CollectionsKt.joinToString$default((Iterable)((Iterable)object2), (CharSequence)",", (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)56, null)) != null ? object : "";
        String string = this$0.datatype.getFqn();
        Object object3 = this$0.jdbcTypeCode;
        if (object3 == null || (object3 = String.valueOf((Integer)object3)) == null) {
            object3 = "";
        }
        return "basicDatatype." + string + (String)sizes + (String)object3;
    }
}

