/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.compiler.options;

import com.intellij.compiler.impl.CompileScopeUtil;
import com.intellij.compiler.impl.FileSetCompileScope;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.module.view.JavaeeAbstractAction;
import com.intellij.javaee.module.view.nodes.JavaeeFacetNodeDescriptor;
import com.intellij.javaee.ui.packaging.ExplodedWarArtifactType;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.validation.JasperArtifactValidator;
import com.intellij.javaee.web.validation.JasperValidationScopeProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CmdlineRemoteProto;

final class ValidateAction
extends JavaeeAbstractAction {
    ValidateAction() {
    }

    protected boolean isActive(@NotNull AnActionEvent e) {
        JavaeeFacet javaeeFacet;
        if (e == null) {
            ValidateAction.$$$reportNull$$$0(0);
        }
        if ((javaeeFacet = (JavaeeFacet)e.getData(JavaeeFacetNodeDescriptor.FACET_NODE_KEY)) != null) {
            e.getPresentation().setText(J2EEBundle.messagePointer((String)"action.text.validate.facet", (Object[])new Object[]{javaeeFacet.getName()}));
            return true;
        }
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files == null || files.length == 0) {
            return false;
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        WebFacet webFacet = WebUtil.getWebFacet((VirtualFile)files[0], (Project)project);
        if (webFacet == null) {
            return false;
        }
        if (ValidateAction.getWebArtifacts(webFacet).isEmpty()) {
            return false;
        }
        String locationToValidate = ValidateAction.getJSPsLocationToValidate(webFacet, files);
        if (locationToValidate == null) {
            return false;
        }
        e.getPresentation().setText(J2EEBundle.messagePointer((String)"action.name.validate.location", (Object[])new Object[]{locationToValidate}));
        return true;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ValidateAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            ValidateAction.$$$reportNull$$$0(2);
        }
        if ((project = (Project)event.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        JavaeeFacet javaeeFacet = (JavaeeFacet)event.getData(JavaeeFacetNodeDescriptor.FACET_NODE_KEY);
        WebFacet webFacet = javaeeFacet instanceof WebFacet ? (WebFacet)javaeeFacet : null;
        ArrayList<VirtualFile> originalFileDirs = new ArrayList<VirtualFile>();
        if (webFacet == null) {
            Object[] files = (VirtualFile[])event.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
            if (files != null) {
                webFacet = WebUtil.getWebFacet((VirtualFile)files[0], (Project)project);
                ContainerUtil.addAll(originalFileDirs, (Object[])files);
            }
        } else {
            for (Object webRoot : webFacet.getWebRoots()) {
                VirtualFile dir = webRoot.getFile();
                if (dir == null) continue;
                originalFileDirs.add(dir);
            }
        }
        if (webFacet == null || originalFileDirs.isEmpty()) {
            return;
        }
        LinkedHashSet jspFiles = new LinkedHashSet();
        for (VirtualFile dir : originalFileDirs) {
            VfsUtilCore.processFilesRecursively((VirtualFile)dir, file -> {
                if (!file.isDirectory() && ArrayUtil.contains((Object)file.getFileType(), (Object[])Holder.JSP_FILE_TYPES)) {
                    jspFiles.add(file);
                }
                return true;
            });
        }
        List<Artifact> artifacts = ValidateAction.getWebArtifacts(webFacet);
        FileSetCompileScope filesScope = new FileSetCompileScope(jspFiles, Module.EMPTY_ARRAY);
        Set modules = ArtifactUtil.getModulesIncludedInArtifacts(artifacts, (Project)project);
        ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes = new ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>();
        CompileScopeUtil.addScopesForModules((Collection)modules, Collections.emptyList(), scopes, (boolean)false);
        scopes.add(CompileScopeUtil.createScopeForArtifacts(artifacts, (boolean)true));
        scopes.add(JasperValidationScopeProvider.createJspValidationScope(artifacts));
        CompileScopeUtil.setBaseScopeForExternalBuild((CompileScope)filesScope, scopes);
        JasperArtifactValidator.setRunValidation((CompileScope)filesScope);
        CompilerManager.getInstance((Project)project).compile((CompileScope)filesScope, null);
    }

    private static List<Artifact> getWebArtifacts(WebFacet webFacet) {
        Collection artifacts = JavaeeArtifactUtil.getInstance().getArtifactsContainingFacet((JavaeeFacet)webFacet, (ArtifactType)ExplodedWarArtifactType.getInstance());
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (Artifact artifact : artifacts) {
            if (artifact.getOutputPath() == null) continue;
            result.add(artifact);
        }
        return result;
    }

    @Nullable
    private static String getJSPsLocationToValidate(WebFacet webFacet, VirtualFile[] files) {
        List webRoots = webFacet.getWebRoots();
        for (VirtualFile file : files) {
            FileType fileType = file.getFileType();
            if (ArrayUtil.contains((Object)fileType, (Object[])Holder.JSP_FILE_TYPES)) {
                return files.length == 1 ? J2EEBundle.message((String)"location.to.validate.jsp", (Object[])new Object[]{file.getName()}) : J2EEBundle.message((String)"location.to.validate.selected.jsps", (Object[])new Object[0]);
            }
            if (!file.isDirectory() || !WebUtil.isInsideWebRoots((VirtualFile)file, (List)webRoots)) continue;
            if (files.length == 1) {
                return J2EEBundle.message((String)"location.to.validate.all.jsps.in.directory", (Object[])new Object[]{file.getName()});
            }
            return J2EEBundle.message((String)"location.to.validate.all.jsps.in.selected.directories", (Object[])new Object[0]);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/web/compiler/options/ValidateAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/web/compiler/options/ValidateAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class Holder {
        private static final FileType[] JSP_FILE_TYPES = new FileType[]{StdFileTypes.JSP, StdFileTypes.JSPX};

        private Holder() {
        }
    }
}

