/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.coord;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.spatial.projections.Projection;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.coord.CoordinatesMapperKt;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProviderBase;
import org.jetbrains.letsPlot.core.plot.builder.coord.FixedRatioCoordProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\fH\u0016JP\u0010\u0011\u001a\u00020\u00122\u0016\u0010\u0004\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0016\u0010\u0007\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/coord/ProjectionCoordProvider;", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProviderBase;", "projection", "Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/Projection;", "xLim", "Lkotlin/Pair;", "", "yLim", "flipped", "", "(Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/Projection;Lkotlin/Pair;Lkotlin/Pair;Z)V", "adjustGeomSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "hDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "vDomain", "geomSize", "with", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "xReversed", "yReversed", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nProjectionCoordProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectionCoordProvider.kt\norg/jetbrains/letsPlot/core/plot/builder/coord/ProjectionCoordProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
public final class ProjectionCoordProvider
extends CoordProviderBase {
    public ProjectionCoordProvider(@NotNull Projection projection, @NotNull Pair<Double, Double> xLim, @NotNull Pair<Double, Double> yLim, boolean flipped) {
        Intrinsics.checkNotNullParameter((Object)projection, (String)"projection");
        Intrinsics.checkNotNullParameter(xLim, (String)"xLim");
        Intrinsics.checkNotNullParameter(yLim, (String)"yLim");
        super(xLim, yLim, false, false, flipped, projection);
    }

    @Override
    @NotNull
    public CoordProvider with(@NotNull Pair<Double, Double> xLim, @NotNull Pair<Double, Double> yLim, boolean xReversed, boolean yReversed, boolean flipped) {
        Intrinsics.checkNotNullParameter(xLim, (String)"xLim");
        Intrinsics.checkNotNullParameter(yLim, (String)"yLim");
        return new ProjectionCoordProvider(this.getProjection(), xLim, yLim, flipped);
    }

    @Override
    @NotNull
    public DoubleVector adjustGeomSize(@NotNull DoubleSpan hDomain, @NotNull DoubleSpan vDomain, @NotNull DoubleVector geomSize) {
        Intrinsics.checkNotNullParameter((Object)hDomain, (String)"hDomain");
        Intrinsics.checkNotNullParameter((Object)vDomain, (String)"vDomain");
        Intrinsics.checkNotNullParameter((Object)geomSize, (String)"geomSize");
        DoubleRectangle it = new DoubleRectangle(hDomain, vDomain);
        boolean bl = false;
        it = this.getFlipped() ? it.flip() : it;
        boolean bl2 = false;
        it = CoordinatesMapperKt.projectDomain(this.getProjection(), it);
        boolean bl3 = false;
        DoubleRectangle bbox2 = this.getFlipped() ? it.flip() : it;
        double domainRatio = bbox2.getWidth() / bbox2.getHeight();
        return FixedRatioCoordProvider.Companion.reshapeGeom(geomSize, domainRatio);
    }
}

