/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.psi.impl.jspXml;

import com.intellij.jsp.lang.jsp.JspWithOtherWorldIntegrationService;
import com.intellij.jsp.psi.BaseJspElementType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.jsp.jspXml.JspXmlRootTag;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.xml.XmlTagDelegate;
import com.intellij.psi.impl.source.xml.XmlTagImpl;
import com.intellij.psi.impl.source.xml.XmlTagValueImpl;
import com.intellij.psi.tree.CustomParsingType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CharTable;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JspXmlRootTagImpl
extends XmlTagImpl
implements JspXmlRootTag {
    private static final Logger LOG = Logger.getInstance(JspXmlRootTagImpl.class);
    public static final XmlNSDescriptorImpl EMPTY_DESCRIPTOR = new XmlNSDescriptorImpl();
    @NonNls
    private static final String JSP_TAG_PREFIX = "jsp";
    @NonNls
    private static final String JSP_ROOT_TAG = "jsp:root";
    @NonNls
    private static final String JSP_ROOT_TAG_LOCAL = "root";

    public JspXmlRootTagImpl() {
        super((IElementType)BaseJspElementType.JSP_ROOT_TAG);
    }

    @NotNull
    public XmlTagValue getValue() {
        PsiElement[] children;
        ArrayList<XmlTagChild> tagChildren = new ArrayList<XmlTagChild>();
        for (PsiElement child : children = this.getChildren()) {
            if (!(child instanceof XmlTagChild)) continue;
            tagChildren.add((XmlTagChild)child);
        }
        XmlTagChild[] bodyElements = tagChildren.isEmpty() ? XmlTagChild.EMPTY_ARRAY : tagChildren.toArray(XmlTagChild.EMPTY_ARRAY);
        return new XmlTagValueImpl(bodyElements, (XmlTag)this);
    }

    public XmlTag getParentTag() {
        return null;
    }

    public XmlTagChild getNextSiblingInTag() {
        return null;
    }

    public String toString() {
        return "JspXmlRootTag";
    }

    public boolean hasNamespaceDeclarations() {
        return true;
    }

    public XmlTag createChildTag(@NonNls String localName, String namespace, String bodyText, boolean enforceNamespacesDeep) {
        if (namespace.equals("http://java.sun.com/JSP/Page")) {
            CustomParsingType elementType;
            String directiveText;
            CharTable table = SharedImplUtil.findCharTableByTree((ASTNode)this);
            FileElement dummyHolder = DummyHolderFactory.createHolder((PsiManager)this.getManager(), null, (CharTable)table).getTreeElement();
            if (localName.startsWith("directive.")) {
                LOG.assertTrue(bodyText == null || bodyText.isEmpty());
                String directiveName = localName.substring("directive.".length());
                directiveText = "<%@ " + directiveName + " %>";
                elementType = BaseJspElementType.JSP_DIRECTIVE;
            } else if (localName.equals("scriptlet")) {
                directiveText = "<% " + (bodyText != null ? bodyText : "") + " %>";
                elementType = BaseJspElementType.JSP_SCRIPTLET;
            } else if (localName.equals("declaration")) {
                directiveText = "<%! " + (bodyText != null ? bodyText : "") + " %>";
                elementType = BaseJspElementType.JSP_DECLARATION;
            } else if (localName.equals("expression")) {
                directiveText = "<%= " + (bodyText != null ? bodyText : "") + " %>";
                elementType = BaseJspElementType.JSP_EXPRESSION;
            } else {
                return XmlUtil.createChildTag((XmlTag)this, (String)localName, (String)namespace, (String)bodyText, (boolean)enforceNamespacesDeep, this::createTagFromText);
            }
            TreeElement leafElement = (TreeElement)elementType.parse((CharSequence)directiveText, table);
            dummyHolder.rawAddChildren(leafElement);
            return (XmlTag)dummyHolder.getFirstChildNode();
        }
        return XmlUtil.createChildTag((XmlTag)this, (String)localName, (String)namespace, (String)bodyText, (boolean)enforceNamespacesDeep, this::createTagFromText);
    }

    private XmlTag createTagFromText(String text) {
        Language language = this.getLanguage();
        if (!(language instanceof HTMLLanguage)) {
            language = XMLLanguage.INSTANCE;
        }
        return XmlElementFactory.getInstance((Project)this.getProject()).createTagFromText((CharSequence)text, language);
    }

    private Map<String, CachedValue<XmlNSDescriptor>> initNameSpaceMap() {
        return this.initTaglibs().myNamespaceMap;
    }

    private BidirectionalMap<String, String> initNameSpacePrefixMap() {
        return this.initTaglibs().myNamespacePrefixMap;
    }

    private NamespaceData initTaglibs() {
        return (NamespaceData)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.calcNamespaceData(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private NamespaceData calcNamespaceData() {
        return (NamespaceData)RecursionManager.doPreventingRecursion((Object)((Object)this), (boolean)true, () -> {
            HashMap<String, CachedValue<XmlNSDescriptor>> namespaceMap = new HashMap<String, CachedValue<XmlNSDescriptor>>();
            BidirectionalMap namespacePrefixMap = new BidirectionalMap();
            NamespaceData result = new NamespaceData(namespaceMap, (BidirectionalMap<String, String>)namespacePrefixMap);
            try {
                namespacePrefixMap.put((Object)JSP_TAG_PREFIX, (Object)"http://java.sun.com/JSP/Page");
                JspWithOtherWorldIntegrationService.getInstance().fillInNamespaces(this, (BidirectionalMap<String, String>)namespacePrefixMap, namespaceMap);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            return result;
        });
    }

    @NotNull
    public String getNamespaceByPrefix(String prefix) {
        BidirectionalMap<String, String> map = this.initNameSpacePrefixMap();
        if (map == null) {
            return "";
        }
        String ns = (String)map.get((Object)prefix);
        return ns != null ? ns : "";
    }

    public String[] knownNamespaces() {
        String[] stringArray;
        BidirectionalMap<String, String> map = this.initNameSpacePrefixMap();
        if (map != null) {
            stringArray = ArrayUtilRt.toStringArray((Collection)map.values());
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "http://java.sun.com/JSP/Page";
        }
        return stringArray;
    }

    public String getPrefixByNamespace(String prefix) {
        BidirectionalMap<String, String> map = this.initNameSpacePrefixMap();
        if (map == null) {
            return null;
        }
        List keysByValue = map.getKeysByValue((Object)prefix);
        return keysByValue == null || keysByValue.isEmpty() ? null : (String)keysByValue.get(0);
    }

    public XmlNSDescriptor getNSDescriptor(String namespace, boolean strict) {
        Map<String, CachedValue<XmlNSDescriptor>> namespaceMap = this.initNameSpaceMap();
        if (namespaceMap != null && namespaceMap.containsKey(namespace)) {
            if (DumbService.getInstance((Project)this.getProject()).isDumb()) {
                return null;
            }
            XmlNSDescriptor value = (XmlNSDescriptor)namespaceMap.get(namespace).getValue();
            return value == EMPTY_DESCRIPTOR ? null : value;
        }
        PsiElement parentElement = this.getParent();
        if (parentElement instanceof XmlDocument) {
            return ((XmlDocument)parentElement).getDefaultNSDescriptor(namespace, strict);
        }
        return null;
    }

    public XmlElementDescriptor getDescriptor() {
        XmlNSDescriptor directivesLibrary = JspWithOtherWorldIntegrationService.getInstance().getJspManagerInstance(this.getProject()).getActionsLibrary(this.getContainingFile());
        return directivesLibrary == null ? null : directivesLibrary.getElementDescriptor((XmlTag)this);
    }

    @NotNull
    public Map<String, String> getLocalNamespaceDeclarations() {
        BidirectionalMap<String, String> bidirectionalMap = this.initNameSpacePrefixMap();
        if (bidirectionalMap == null) {
            JspXmlRootTagImpl.$$$reportNull$$$0(0);
        }
        return bidirectionalMap;
    }

    @NotNull
    public String getName() {
        return JSP_ROOT_TAG;
    }

    @NotNull
    public String getLocalName() {
        return JSP_ROOT_TAG_LOCAL;
    }

    @NotNull
    public String getNamespace() {
        return "http://java.sun.com/JSP/Page";
    }

    @NotNull
    protected XmlTagDelegate createDelegate() {
        return new JspXmlRootTagDelegate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsp/psi/impl/jspXml/JspXmlRootTagImpl", "getLocalNamespaceDeclarations"));
    }

    private static final class NamespaceData {
        private final BidirectionalMap<String, String> myNamespacePrefixMap;
        private final Map<String, CachedValue<XmlNSDescriptor>> myNamespaceMap;

        NamespaceData(Map<String, CachedValue<XmlNSDescriptor>> namespaceMap, BidirectionalMap<String, String> namespacePrefixMap) {
            this.myNamespaceMap = namespaceMap;
            this.myNamespacePrefixMap = namespacePrefixMap;
        }
    }

    private class JspXmlRootTagDelegate
    extends XmlTagImpl.XmlTagImplDelegate {
        private JspXmlRootTagDelegate() {
            super((XmlTagImpl)JspXmlRootTagImpl.this);
        }

        protected XmlTag @NotNull [] calcSubTags(boolean processIncludes) {
            ArrayList<XmlTag> result = new ArrayList<XmlTag>();
            for (PsiElement child : JspXmlRootTagImpl.this.getChildren()) {
                if (!(child instanceof XmlTag)) continue;
                result.add((XmlTag)child);
            }
            XmlTag[] xmlTagArray = result.toArray(XmlTag.EMPTY);
            if (xmlTagArray == null) {
                JspXmlRootTagDelegate.$$$reportNull$$$0(0);
            }
            return xmlTagArray;
        }

        protected TreeElement bodyInsert(TreeElement child) {
            return this.genericInsert(child, null, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsp/psi/impl/jspXml/JspXmlRootTagImpl$JspXmlRootTagDelegate", "calcSubTags"));
        }
    }
}

