/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.javaee.web.lexer;

import com.intellij.java.syntax.JavaSyntaxDefinition;
import com.intellij.jsp.javaee.web.lexer.EscapedJavaLexer;
import com.intellij.jsp.lang.lexer.JspHighlightingLexer;
import com.intellij.jsp.psi.BaseJspSyntaxElementType;
import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.lexer.Lexer;
import com.intellij.platform.syntax.lexer.LexerPosition;
import com.intellij.platform.syntax.util.lexer.LexerBase;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.jsp.JspFile;
import org.jetbrains.annotations.NotNull;

public class JspJavaLexer
extends LexerBase {
    private final JspHighlightingLexer myJspLexer = new JspHighlightingLexer();
    private final Lexer myJavaLexer;
    private final EscapedJavaLexer myEscapedJavaLexer;
    private Lexer myCurJavaLexer = null;

    public JspJavaLexer(JspFile file, LanguageLevel languageLevel) {
        this.myJavaLexer = JavaSyntaxDefinition.createLexer((LanguageLevel)languageLevel);
        this.myEscapedJavaLexer = new EscapedJavaLexer('\"', languageLevel);
        this.myJspLexer.setFile((FileViewProvider)file.getViewProvider());
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            JspJavaLexer.$$$reportNull$$$0(0);
        }
        this.myJspLexer.start(buffer, startOffset, endOffset, initialState);
        this.setupJavaLexer();
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myJspLexer.getBufferSequence();
        if (charSequence == null) {
            JspJavaLexer.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    public int getState() {
        return this.myJspLexer.getState();
    }

    public SyntaxElementType getTokenType() {
        SyntaxElementType tokenType = this.myJspLexer.getTokenType();
        if (tokenType == null) {
            return null;
        }
        if (tokenType == BaseJspSyntaxElementType.JSP_SCRIPTLET || tokenType == BaseJspSyntaxElementType.JSP_EXPRESSION || tokenType == BaseJspSyntaxElementType.JSP_DECLARATION) {
            return this.myCurJavaLexer.getTokenType();
        }
        return tokenType;
    }

    public int getTokenStart() {
        SyntaxElementType tokenType = this.myJspLexer.getTokenType();
        if (tokenType == BaseJspSyntaxElementType.JSP_SCRIPTLET || tokenType == BaseJspSyntaxElementType.JSP_EXPRESSION || tokenType == BaseJspSyntaxElementType.JSP_DECLARATION) {
            return this.myCurJavaLexer.getTokenStart();
        }
        return this.myJspLexer.getTokenStart();
    }

    public int getTokenEnd() {
        SyntaxElementType tokenType = this.myJspLexer.getTokenType();
        if (tokenType == BaseJspSyntaxElementType.JSP_SCRIPTLET || tokenType == BaseJspSyntaxElementType.JSP_EXPRESSION || tokenType == BaseJspSyntaxElementType.JSP_DECLARATION) {
            return this.myCurJavaLexer.getTokenEnd();
        }
        return this.myJspLexer.getTokenEnd();
    }

    public void advance() {
        SyntaxElementType tokenType = this.myJspLexer.getTokenType();
        if (tokenType == BaseJspSyntaxElementType.JSP_SCRIPTLET || tokenType == BaseJspSyntaxElementType.JSP_EXPRESSION || tokenType == BaseJspSyntaxElementType.JSP_DECLARATION) {
            this.myCurJavaLexer.advance();
            if (this.myCurJavaLexer.getTokenType() != null) {
                return;
            }
        }
        this.myJspLexer.advance();
        this.setupJavaLexer();
    }

    private void setupJavaLexer() {
        while (true) {
            SyntaxElementType tokenType;
            if ((tokenType = this.myJspLexer.getTokenType()) == BaseJspSyntaxElementType.JSP_EXPRESSION) {
                if (this.myJspLexer.isInsideDQAttributeValue()) {
                    this.myEscapedJavaLexer.setSurroundingQuote('\"');
                    this.myCurJavaLexer = this.myEscapedJavaLexer;
                } else if (this.myJspLexer.isInsideSQAttributeValue()) {
                    this.myEscapedJavaLexer.setSurroundingQuote('\'');
                    this.myCurJavaLexer = this.myEscapedJavaLexer;
                } else {
                    this.myCurJavaLexer = this.myJavaLexer;
                }
            } else if (tokenType == BaseJspSyntaxElementType.JSP_SCRIPTLET || tokenType == BaseJspSyntaxElementType.JSP_DECLARATION) {
                this.myCurJavaLexer = this.myJavaLexer;
            } else {
                return;
            }
            this.myCurJavaLexer.start(this.myJspLexer.getBufferSequence(), this.myJspLexer.getTokenStart(), this.myJspLexer.getTokenEnd());
            if (this.myCurJavaLexer.getTokenType() != null) {
                return;
            }
            this.myJspLexer.advance();
        }
    }

    @NotNull
    public LexerPosition getCurrentPosition() {
        return new Position(this.myCurJavaLexer != null ? this.myCurJavaLexer.getCurrentPosition() : null, this.myJspLexer.getCurrentPosition());
    }

    public void restore(@NotNull LexerPosition position) {
        if (position == null) {
            JspJavaLexer.$$$reportNull$$$0(2);
        }
        Position p = (Position)position;
        this.myJspLexer.restore(p.getJspPosition());
        LexerPosition javaPos = p.getJavaPosition();
        if (javaPos != null && javaPos.getOffset() < this.myCurJavaLexer.getBufferEnd()) {
            this.myCurJavaLexer.restore(javaPos);
        } else {
            this.myCurJavaLexer = null;
            this.setupJavaLexer();
        }
    }

    public int getBufferEnd() {
        return this.myJspLexer.getBufferEnd();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsp/javaee/web/lexer/JspJavaLexer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsp/javaee/web/lexer/JspJavaLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class Position
    implements LexerPosition {
        private final LexerPosition myJavaPosition;
        private final LexerPosition myJspPosition;

        Position(LexerPosition javaPosition, LexerPosition jspPosition) {
            this.myJavaPosition = javaPosition;
            this.myJspPosition = jspPosition;
        }

        public int getOffset() {
            return Math.max(this.myJspPosition.getOffset(), this.myJavaPosition.getOffset());
        }

        public LexerPosition getJavaPosition() {
            return this.myJavaPosition;
        }

        public LexerPosition getJspPosition() {
            return this.myJspPosition;
        }

        public int getState() {
            throw new UnsupportedOperationException("Method getState is not yet implemented in " + this.getClass().getName());
        }
    }
}

