/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.javaee.web.inspections;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.jsp.JavaeeJspBundle;
import com.intellij.jsp.javaee.web.inspections.AbstractWrapFix;
import com.intellij.jsp.javaee.web.inspections.unescapedEl.SafeTagInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class WrapInTagFix
extends AbstractWrapFix {
    @FileModifier.SafeFieldForPreview
    private final SafeTagInfo myTagInfo;

    public WrapInTagFix(SafeTagInfo tagInfo) {
        this.myTagInfo = tagInfo;
    }

    @NotNull
    public String getName() {
        String ns = "http://java.sun.com/jsp/jstl/core".equals(this.myTagInfo.namespace) ? "JSTL" : this.myTagInfo.namespace;
        String string = JavaeeJspBundle.message("intention.name.wrap.in.tag", ns, this.myTagInfo.tagName);
        if (string == null) {
            WrapInTagFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected String getNamespace() {
        return this.myTagInfo.namespace;
    }

    @Override
    protected StringBuilder buildNewText(String prefix, String text) {
        StringBuilder builder = new StringBuilder().append('<').append(prefix).append(':').append(this.myTagInfo.tagName);
        if (StringUtil.isEmpty((String)this.myTagInfo.attributeName)) {
            builder.append('>').append(text).append('<').append(this.myTagInfo.tagName).append("/>");
        } else {
            builder.append(' ').append(this.myTagInfo.attributeName).append("=\"").append(text).append("\"/>");
        }
        return builder;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            WrapInTagFix.$$$reportNull$$$0(1);
        }
        if (previewDescriptor == null) {
            WrapInTagFix.$$$reportNull$$$0(2);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            WrapInTagFix.$$$reportNull$$$0(3);
        }
        return intentionPreviewInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsp/javaee/web/inspections/WrapInTagFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsp/javaee/web/inspections/WrapInTagFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

