/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scopes;

import com.intellij.database.model.DasDataSource;
import com.intellij.database.scopes.DataSourcePackageSet;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetParserExtension;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbPackageSetParserExtension
implements PackageSetParserExtension {
    private static final Pattern UUID = Pattern.compile("ds\\[((?:[^]]|]])+)]");

    @Nullable
    public PackageSet parsePackageSet(Lexer lexer, String scope2, String modulePattern) {
        if (modulePattern != null || scope2 == null) {
            return null;
        }
        return new DataSourcePackageSet(scope2);
    }

    @Nullable
    public String parseScope(Lexer lexer) {
        int start = lexer.getTokenStart();
        CharSequence buf = lexer.getBufferSequence();
        if (!StringUtil.startsWith((CharSequence)buf, (int)start, (CharSequence)"ds[")) {
            return null;
        }
        Matcher matcher = UUID.matcher(buf);
        matcher.region(start, lexer.getBufferEnd());
        if (!matcher.lookingAt()) {
            return null;
        }
        lexer.start(buf, matcher.end(), lexer.getBufferEnd());
        return matcher.group(1).replace("]]", "]");
    }

    @NotNull
    public static String compose(@NotNull DasDataSource ds) {
        if (ds == null) {
            DbPackageSetParserExtension.$$$reportNull$$$0(0);
        }
        return DbPackageSetParserExtension.compose(ds.getName());
    }

    @NotNull
    public static String compose(@NotNull String name) {
        if (name == null) {
            DbPackageSetParserExtension.$$$reportNull$$$0(1);
        }
        String string = "ds[" + name.replace("]", "]]") + "]";
        if (string == null) {
            DbPackageSetParserExtension.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/scopes/DbPackageSetParserExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/scopes/DbPackageSetParserExtension";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "compose";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compose";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

