/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.DatabasePluginId;
import com.intellij.database.Dbms;
import com.intellij.database.csv.CsvFormatsSettings;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.extensions.ExtensionScriptsUtil;
import com.intellij.database.extensions.ExtractorScripts;
import com.intellij.database.extractors.BaseExtractorsHelper;
import com.intellij.database.extractors.DataAggregatorFactory;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DbExtractorConfig;
import com.intellij.database.extractors.DbScriptDataExtractor;
import com.intellij.database.extractors.ExtractorConfig;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.SqlInsertsExtractorFactory;
import com.intellij.database.extractors.SqlUpdatesExtractorFactory;
import com.intellij.database.extractors.WhereClauseExtractorFactory;
import com.intellij.database.extractors.XlsxExtractorFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbExtractorsHelper
extends BaseExtractorsHelper {
    public static final DbExtractorsHelper INSTANCE = new DbExtractorsHelper();

    @NotNull
    public DataExtractorFactory createScriptExtractorFactory(@NotNull String scriptFileName, @Nullable BiConsumer<String, Project> installPlugin) {
        if (scriptFileName == null) {
            DbExtractorsHelper.$$$reportNull$$$0(0);
        }
        return new DbScript(scriptFileName, installPlugin);
    }

    @NotNull
    public DataAggregatorFactory createScriptAggregatorFactory(@NotNull String scriptFileName, @Nullable BiConsumer<String, Project> installPlugin) {
        if (scriptFileName == null) {
            DbExtractorsHelper.$$$reportNull$$$0(1);
        }
        return new DbScript(scriptFileName, installPlugin);
    }

    public DataExtractorFactory getDefaultExtractorFactory(@NotNull CoreGrid<GridRow, GridColumn> grid, @Nullable BiConsumer<String, Project> installPlugin, @Nullable CsvFormatsSettings settings) {
        if (grid == null) {
            DbExtractorsHelper.$$$reportNull$$$0(2);
        }
        return DataGridUtilCore.getDbms(grid).in(Dbms.DOCUMENT_ORIENTED) ? DataExtractorFactories.findById((String)"JSON-Groovy.json.groovy", installPlugin, (CsvFormatsSettings)settings) : null;
    }

    @NotNull
    public ExtractorConfig createExtractorConfig(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ObjectFormatter formatter) {
        if (grid == null) {
            DbExtractorsHelper.$$$reportNull$$$0(3);
        }
        if (formatter == null) {
            DbExtractorsHelper.$$$reportNull$$$0(4);
        }
        DbDataSource system = DataGridUtilCore.getDatabaseSystem(grid);
        return new DbExtractorConfig(grid.getProject(), DataGridUtilCore.getDbms(grid), formatter, DataGridUtilCore.getDatabaseTable(grid), system == null ? null : system.getVersion());
    }

    @NotNull
    public List<DataExtractorFactory> getBuiltInFactories() {
        List<XlsxExtractorFactory> list = List.of(new SqlInsertsExtractorFactory(), new SqlUpdatesExtractorFactory(), new WhereClauseExtractorFactory(), new XlsxExtractorFactory());
        if (list == null) {
            DbExtractorsHelper.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptFileName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/DbExtractorsHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/DbExtractorsHelper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltInFactories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createScriptExtractorFactory";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createScriptAggregatorFactory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultExtractorFactory";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createExtractorConfig";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private static class DbScript
    extends BaseExtractorsHelper.Script {
        DbScript(@NotNull String scriptFileName, @Nullable BiConsumer<String, Project> installPlugin) {
            if (scriptFileName == null) {
                DbScript.$$$reportNull$$$0(0);
            }
            super(scriptFileName, installPlugin);
        }

        @Nullable
        public DataExtractor createExtractor(@NotNull ExtractorConfig config) {
            if (config == null) {
                DbScript.$$$reportNull$$$0(1);
            }
            DbExtractorConfig dbConfig = (DbExtractorConfig)ObjectUtils.tryCast((Object)config, DbExtractorConfig.class);
            Path script2 = ExtractorScripts.findExtractorScript((String)this.myScriptFileName);
            if (script2 == null || dbConfig == null) {
                return super.createExtractor(config);
            }
            ExtensionScriptsUtil.prepareScript((Path)script2);
            IdeScriptEngine engine = ExtensionScriptsUtil.getEngineFor((Project)dbConfig.getProject(), (PluginId)DatabasePluginId.get(), (Path)script2, (BiConsumer)this.myInstallPlugin);
            return engine == null ? null : new DbScriptDataExtractor(config.getProject(), script2, engine, config.getObjectFormatter(), dbConfig.getTable(), dbConfig.getDbms(), false, true);
        }

        @Nullable
        public DataExtractor createAggregator(@NotNull ExtractorConfig config) {
            if (config == null) {
                DbScript.$$$reportNull$$$0(2);
            }
            DbExtractorConfig dbConfig = (DbExtractorConfig)ObjectUtils.tryCast((Object)config, DbExtractorConfig.class);
            Path script2 = ExtractorScripts.findAggregatorScript((String)this.myScriptFileName);
            if (script2 == null || dbConfig == null) {
                return super.createAggregator(config);
            }
            ExtensionScriptsUtil.prepareScript((Path)script2);
            IdeScriptEngine engine = ExtensionScriptsUtil.getEngineFor((Project)dbConfig.getProject(), (PluginId)DatabasePluginId.get(), (Path)script2, null, (boolean)false);
            return engine == null ? null : new DbScriptDataExtractor(config.getProject(), script2, engine, config.getObjectFormatter(), dbConfig.getTable(), dbConfig.getDbms(), true, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scriptFileName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/extractors/DbExtractorsHelper$DbScript";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createExtractor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createAggregator";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

