/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliCredentialsManager;
import com.intellij.database.cli.CliRunTarget;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.ConsoleLogger;
import com.intellij.database.datagrid.DataAuditors;
import com.intellij.database.introspection.IndefiniteIntrospectionTask;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.IntrospectionTasks;
import com.intellij.database.introspection.RunIntrospection;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.eel.EelApi;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CliRunner
implements Disposable {
    private static final Logger LOG = Logger.getInstance(CliRunner.class);
    private static final int TIMEOUT_MS = 300;
    private final LocalDataSource myDataSource;
    private final CliConfiguration myConfiguration;
    private final List<String> myParameterizable;
    private final String myCommand;
    private final Project myProject;
    private final CliRunTarget myRunTarget;
    private final EelApi myEel;
    private final WSLDistribution myWSLDistribution;

    public CliRunner(@NotNull Project project, @NotNull LocalDataSource source, @NotNull CliConfiguration configuration, @NotNull List<String> parameterizable, @NotNull String command, @NotNull CliRunTarget runTarget, @Nullable WSLDistribution distribution, @Nullable EelApi eel) {
        if (project == null) {
            CliRunner.$$$reportNull$$$0(0);
        }
        if (source == null) {
            CliRunner.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            CliRunner.$$$reportNull$$$0(2);
        }
        if (parameterizable == null) {
            CliRunner.$$$reportNull$$$0(3);
        }
        if (command == null) {
            CliRunner.$$$reportNull$$$0(4);
        }
        if (runTarget == null) {
            CliRunner.$$$reportNull$$$0(5);
        }
        this.myDataSource = source;
        this.myProject = project;
        this.myConfiguration = configuration;
        this.myParameterizable = parameterizable;
        this.myCommand = command;
        this.myRunTarget = runTarget;
        this.myWSLDistribution = distribution;
        this.myEel = eel;
    }

    public void dispose() {
    }

    public void run() {
        AtomicReference<ProgressIndicator> ref = new AtomicReference<ProgressIndicator>();
        Ref reporterRef = Ref.create();
        String title = this.myConfiguration.getName() + " (" + this.myDataSource.getName() + ")";
        ConsoleView view = DbUIUtil.addConsole(this.myProject, title, () -> true, () -> this.runBackgroundable(ref, (DataAuditors.PrintingAdapter)reporterRef.get()), ref);
        reporterRef.set((Object)new ConsoleLogger(view));
        this.runBackgroundable(ref, (DataAuditors.PrintingAdapter)reporterRef.get());
    }

    private void runBackgroundable(final @NotNull AtomicReference<ProgressIndicator> indicatorRef, final @NotNull DataAuditors.PrintingAdapter reporter) {
        if (indicatorRef == null) {
            CliRunner.$$$reportNull$$$0(6);
        }
        if (reporter == null) {
            CliRunner.$$$reportNull$$$0(7);
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, this.myConfiguration.getOperation().getTaskTitle()){

            public void run(final @NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicatorRef.set(indicator);
                try (CliCredentialsManager manager = new CliCredentialsManager(CliRunner.this.myDataSource, CliRunner.this.myConfiguration, CliRunner.this.myProject, CliRunner.this.myCommand);){
                    Pair<String, String> commandAndPassword = manager.getCommandAndPassword(CliRunner.this.myRunTarget);
                    String command = (String)commandAndPassword.getFirst();
                    String password = (String)commandAndPassword.getSecond();
                    CliConfiguration.CliBuilder builder = CliRunner.this.myConfiguration.getCliBuilder(CliRunner.this.myProject);
                    CliConfiguration.CliBuilderContext builderContext = new CliConfiguration.CliBuilderContext(CliRunner.this.myDataSource, CliRunner.this.myParameterizable, command, password, CliRunner.this.myRunTarget, CliRunner.this.myWSLDistribution, CliRunner.this.myEel);
                    Pair<GeneralCommandLine, String> lineAndCommand = builder.build(builderContext);
                    GeneralCommandLine line = (GeneralCommandLine)lineAndCommand.first;
                    String finalCommand = (String)lineAndCommand.second;
                    final CliConfiguration.CliNotificationManager notificationManager = builder.getNotificationManager();
                    notificationManager.start(indicator, (DasDataSource)CliRunner.this.myDataSource);
                    ColoredProcessHandler handler2 = new ColoredProcessHandler(line);
                    builder.primeProcess((OSProcessHandler)handler2, line, builderContext);
                    handler2.addProcessListener(new ProcessListener(){

                        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                            if (event == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (outputType == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            notificationManager.update(indicator, reporter, event.getText(), outputType);
                        }

                        public void processTerminated(@NotNull ProcessEvent event) {
                            if (event == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            int exitCode = event.getExitCode();
                            String name = CliRunner.this.myConfiguration.getName();
                            DataSourceUtil.showNotification((Project)CliRunner.this.myProject, (String)CliRunner.this.myDataSource.getName(), (String)(exitCode == 0 ? DatabaseBundle.message((String)"database.cli.integration.run.process.run.success", (Object[])new Object[]{name}) : DatabaseBundle.message((String)"database.cli.integration.run.process.run.error", (Object[])new Object[]{name, exitCode})), (boolean)true, (List)ContainerUtil.emptyList());
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "event";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "outputType";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/intellij/database/cli/CliRunner$1$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "onTextAvailable";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "processTerminated";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                    handler2.startNotify();
                    while (!handler2.waitFor(300L)) {
                        if (indicator.isCanceled()) {
                            handler2.destroyProcess();
                            CliRunner.this.notifyEnd(finalCommand, reporter, notificationManager, true);
                        }
                        indicator.checkCanceled();
                    }
                    CliRunner.this.notifyEnd(finalCommand, reporter, notificationManager, false);
                }
                catch (ExecutionException e) {
                    LOG.warn((Throwable)e);
                    reporter.println(e.getMessage(), ConsoleViewContentType.ERROR_OUTPUT);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/cli/CliRunner$1", "run"));
            }
        });
    }

    private void notifyEnd(@NotNull String command, @NotNull DataAuditors.PrintingAdapter reporter, @NotNull CliConfiguration.CliNotificationManager manager, boolean cancelled) {
        String arg;
        if (command == null) {
            CliRunner.$$$reportNull$$$0(8);
        }
        if (reporter == null) {
            CliRunner.$$$reportNull$$$0(9);
        }
        if (manager == null) {
            CliRunner.$$$reportNull$$$0(10);
        }
        if (StringUtil.isEmpty((String)(arg = this.myConfiguration.getFileParameterSearcher().search(command, this.myParameterizable)))) {
            return;
        }
        String path = DbCliUtil.clearString(arg, StringUtil::unquoteString);
        File file = new File(path);
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        if (virtualFile == null || !file.exists()) {
            return;
        }
        manager.finished(path, reporter, cancelled);
        if (this.myConfiguration.getOperation() != CliConfiguration.Operation.RESTORE) {
            return;
        }
        IndefiniteIntrospectionTask task = IntrospectionTasks.prepareGeneralTask((String)this.myDataSource.getUniqueId());
        RunIntrospection.runAsyncIntrospection((Project)this.myProject, (LocalDataSource)this.myDataSource, (IntrospectionTask)task);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterizable";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runTarget";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicatorRef";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/cli/CliRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "runBackgroundable";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyEnd";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

