/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PackageStatementElement
extends CompositeElement
implements Constants {
    private static final Logger LOG = Logger.getInstance(PackageStatementElement.class);

    public PackageStatementElement() {
        super(PACKAGE_STATEMENT);
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 102: {
                return this.findChildByType(PACKAGE_KEYWORD);
            }
            case 103: {
                return this.findChildByType(JAVA_CODE_REFERENCE);
            }
            case 22: {
                return TreeUtil.findChildBackward((ASTNode)this, (IElementType)SEMICOLON);
            }
            case 8: {
                return this.findChildByType(MODIFIER_LIST);
            }
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PackageStatementElement.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == PACKAGE_KEYWORD) {
            return 102;
        }
        if (i == JAVA_CODE_REFERENCE) {
            return 103;
        }
        if (i == SEMICOLON) {
            return 22;
        }
        if (i == MODIFIER_LIST) {
            return 8;
        }
        return 0;
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/tree/java/PackageStatementElement", "getChildRole"));
    }
}

