/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.javadoc;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiInlineDocTagImpl
extends CompositePsiElement
implements PsiInlineDocTag,
Constants {
    private static final TokenSet TAG_VALUE_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{DOC_TAG_VALUE_ELEMENT, DOC_METHOD_OR_FIELD_REF, DOC_FRAGMENT_REF});
    static final TokenSet VALUE_BIT_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{TAG_VALUE_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{JAVA_CODE_REFERENCE, DOC_TAG_VALUE_TOKEN, DOC_COMMENT_DATA, DOC_INLINE_TAG, DOC_REFERENCE_HOLDER, DOC_COMMENT_BAD_CHARACTER, DOC_SNIPPET_TAG_VALUE, DOC_SHARP, DOC_LBRACKET, DOC_RBRACKET, DOC_LPAREN, DOC_RPAREN, DOC_CODE_FENCE, DOC_INLINE_CODE_FENCE, DOC_MARKDOWN_CODE_BLOCK, DOC_COMMA})});

    public PsiInlineDocTagImpl() {
        super(DOC_INLINE_TAG);
    }

    @Override
    public PsiDocComment getContainingComment() {
        CompositeElement scope = this.getTreeParent();
        while (scope.getElementType() != JavaDocElementType.DOC_COMMENT) {
            scope = scope.getTreeParent();
        }
        return (PsiDocComment)SourceTreeToPsiMap.treeElementToPsi((ASTNode)scope);
    }

    @Override
    public PsiElement getNameElement() {
        return this.findPsiChildByType(DOC_TAG_NAME);
    }

    @Override
    public PsiElement @NotNull [] getDataElements() {
        PsiElement[] psiElementArray = this.getChildrenAsPsiElements(VALUE_BIT_SET, PsiElement.ARRAY_FACTORY);
        if (psiElementArray == null) {
            PsiInlineDocTagImpl.$$$reportNull$$$0(0);
        }
        return psiElementArray;
    }

    @Override
    public PsiDocTagValue getValueElement() {
        return (PsiDocTagValue)this.findPsiChildByType(TAG_VALUE_BIT_SET);
    }

    @Override
    @NotNull
    public String getName() {
        PsiElement nameElement = this.getNameElement();
        if (nameElement == null) {
            return "";
        }
        String string = nameElement.getText().substring(1);
        if (string == null) {
            PsiInlineDocTagImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiInlineDocTagImpl.$$$reportNull$$$0(2);
        }
        assert (child.getTreeParent() == this) : child.getTreeParent();
        IElementType i = child.getElementType();
        if (i == DOC_TAG_NAME) {
            return 105;
        }
        if (i == JavaDocElementType.DOC_COMMENT || i == DOC_INLINE_TAG) {
            return 106;
        }
        if (i == DOC_INLINE_TAG_START) {
            return 108;
        }
        if (i == DOC_INLINE_TAG_END) {
            return 109;
        }
        if (TAG_VALUE_BIT_SET.contains(i)) {
            return 242;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiInlineDocTagImpl.$$$reportNull$$$0(3);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitInlineDocTag(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        PsiElement nameElement = this.getNameElement();
        return "PsiInlineDocTag:" + (nameElement != null ? nameElement.getText() : null);
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            PsiInlineDocTagImpl.$$$reportNull$$$0(4);
        }
        PsiImplUtil.setName(this.getNameElement(), name);
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/javadoc/PsiInlineDocTagImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/javadoc/PsiInlineDocTagImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

