/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.constants.CdiAnnoConstants;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.annotations.NotNull;

public final class CdiStereotypeInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(@NotNull PsiClass aClass, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (aClass == null) {
            CdiStereotypeInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            CdiStereotypeInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            CdiStereotypeInspection.$$$reportNull$$$0(2);
        }
        if (aClass.isAnnotationType() && AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)CdiAnnoConstants.STEREOTYPE_ANNOTATION.fqn(module), (int)0)) {
            CdiStereotypeInspection.checkStereotype(aClass, holder);
        }
    }

    private static void checkStereotype(PsiClass aClass, ProblemsHolder holder) {
        PsiAnnotation[] psiAnnotations = CdiCommonUtils.getQualifierAnnotations((PsiModifierListOwner)aClass);
        String namedAnnotation = CdiAnnoConstants.NAMED_ANNOTATION.fqn((PsiElement)aClass);
        for (PsiAnnotation psiAnnotation : psiAnnotations) {
            if (namedAnnotation.equals(psiAnnotation.getQualifiedName())) {
                if (psiAnnotation.getParameterList().getAttributes().length == 0) continue;
                CdiStereotypeInspection.registerProblem(holder, CdiStereotypeInspection.getIdentifyingElement(psiAnnotation), CdiInspectionBundle.message("CdiStereotypeInspection.non.empty.named.annotations.not.allowed", new Object[0]));
                continue;
            }
            CdiStereotypeInspection.registerProblem(holder, CdiStereotypeInspection.getIdentifyingElement(psiAnnotation), CdiInspectionBundle.message("CdiStereotypeInspection.qualified.annotations.not.allowed", new Object[0]));
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, (String[])new String[]{CdiAnnoConstants.TYPED_ANNOTATION.fqn((PsiElement)aClass)});
        if (annotation != null) {
            CdiStereotypeInspection.registerProblem(holder, CdiStereotypeInspection.getIdentifyingElement(annotation), CdiInspectionBundle.message("CdiStereotypeInspection.not.allowed.for.stereotypes", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "aClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
        }
        objectArray[1] = "com/intellij/cdi/highlighting/CdiStereotypeInspection";
        objectArray[2] = "checkClass";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

