/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ssh.AbstractProcessBuilder;
import com.intellij.ssh.ExecChannelConfig;
import com.intellij.ssh.SessionConfig;
import com.intellij.ssh.SshConnectionService;
import com.intellij.ssh.SshException;
import com.intellij.ssh.channels.ExecChannel;
import com.intellij.ssh.process.SshExecProcess;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u0000H\u0014J\u001a\u0010\u000e\u001a\u00020\u00002\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bJ\u001c\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ssh/ExecBuilder;", "Lcom/intellij/ssh/AbstractProcessBuilder;", "sessionConfig", "Lcom/intellij/ssh/SessionConfig;", "command", "", "ExecBuilder", "(Lcom/intellij/ssh/SessionConfig;Ljava/lang/String;)V", "getCommand", "()Ljava/lang/String;", "execChannelWrapperFactory", "Lkotlin/Function1;", "Lcom/intellij/ssh/channels/ExecChannel;", "getThis", "withExecChannelWrapperFactory", "factory", "execute", "Lcom/intellij/ssh/process/SshExecProcess;", "timeoutInSeconds", "", "redirectErrorStream", "", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nssh.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ssh.kt\ncom/intellij/ssh/ExecBuilder\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,431:1\n42#2,3:432\n*S KotlinDebug\n*F\n+ 1 ssh.kt\ncom/intellij/ssh/ExecBuilder\n*L\n221#1:432,3\n*E\n"})
public final class ExecBuilder
extends AbstractProcessBuilder<ExecBuilder> {
    @NotNull
    private final String command;
    @NotNull
    private Function1<? super ExecChannel, ? extends ExecChannel> execChannelWrapperFactory;

    public ExecBuilder(@NotNull SessionConfig sessionConfig, @NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        super(sessionConfig);
        this.command = command;
        this.execChannelWrapperFactory = ExecBuilder::d;
    }

    @NotNull
    public final String getCommand() {
        return this.command;
    }

    @Override
    @NotNull
    protected ExecBuilder getThis() {
        return this;
    }

    @NotNull
    public final ExecBuilder withExecChannelWrapperFactory(@NotNull Function1<? super ExecChannel, ? extends ExecChannel> factory) {
        ExecBuilder execBuilder;
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        ExecBuilder execBuilder2 = execBuilder = this;
        boolean bl = false;
        execBuilder2.execChannelWrapperFactory = factory;
        return execBuilder;
    }

    @JvmOverloads
    @NotNull
    public final SshExecProcess execute(int timeoutInSeconds, boolean redirectErrorStream) throws SshException {
        ExecChannelConfig execChannelConfig = new ExecChannelConfig(this.command, this.getAllocatePty(), redirectErrorStream, timeoutInSeconds, TimeUnit.SECONDS);
        boolean bl = false;
        Class<SshConnectionService> clazz = SshConnectionService.class;
        Object object = ApplicationManager.getApplication().getService(clazz);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + clazz.getName() + " (classloader=" + clazz.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ExecChannel execChannel = ((SshConnectionService)object).exec(this.getSessionConfig(), execChannelConfig);
        return new SshExecProcess((ExecChannel)this.execChannelWrapperFactory.invoke((Object)execChannel), this.getAllocatePty());
    }

    public static /* synthetic */ SshExecProcess execute$default(ExecBuilder execBuilder, int n, boolean bl, int n2, Object object) throws SshException {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return execBuilder.execute(n, bl);
    }

    @JvmOverloads
    @NotNull
    public final SshExecProcess execute(int timeoutInSeconds) throws SshException {
        return ExecBuilder.execute$default(this, timeoutInSeconds, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final SshExecProcess execute() throws SshException {
        return ExecBuilder.execute$default(this, 0, false, 3, null);
    }

    private static final ExecChannel d(ExecChannel execChannel) {
        Intrinsics.checkNotNullParameter((Object)execChannel, (String)"it");
        return execChannel;
    }
}

