/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.bitwise;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.util.ExpressionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public final class PointlessBitwiseExpressionJSInspection
extends JavaScriptInspection {
    public boolean m_ignoreExpressionsContainingConstants = false;

    @Override
    @NotNull
    @InspectionMessage
    public String buildErrorString(Object ... args) {
        JSExpression expr = (JSExpression)args[0];
        String replacementExpression = this.calculateReplacementExpression(expr);
        String string = InspectionJSBundle.message("pointless.bitwise.expression.problem.descriptor", replacementExpression, expr.getText());
        if (string == null) {
            PointlessBitwiseExpressionJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_ignoreExpressionsContainingConstants", (String)InspectionJSBundle.message("pointless.bitwise.expression.ignore.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PointlessBitwiseExpressionJSInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    String calculateReplacementExpression(JSExpression expression) {
        JSBinaryExpression exp = (JSBinaryExpression)expression;
        JSExpression lhs = exp.getLOperand();
        JSExpression rhs = exp.getROperand();
        IElementType tokenType = exp.getOperationSign();
        assert (lhs != null);
        assert (rhs != null);
        assert (tokenType != null);
        if (tokenType == JSTokenTypes.AND) {
            if (this.isZero(lhs) || this.isAllOnes(rhs)) {
                return lhs.getText();
            }
            return rhs.getText();
        }
        if (tokenType == JSTokenTypes.OR) {
            if (this.isZero(lhs) || this.isAllOnes(rhs)) {
                return rhs.getText();
            }
            return lhs.getText();
        }
        if (tokenType == JSTokenTypes.XOR) {
            if (this.isAllOnes(lhs)) {
                return "~" + rhs.getText();
            }
            if (this.isAllOnes(rhs)) {
                return "~" + lhs.getText();
            }
            if (this.isZero(rhs)) {
                return lhs.getText();
            }
            return rhs.getText();
        }
        if (tokenType == JSTokenTypes.LTLT || tokenType == JSTokenTypes.GTGT || tokenType == JSTokenTypes.GTGTGT) {
            return lhs.getText();
        }
        throw new IncorrectOperationException("Token type " + tokenType.getClass().getName() + " not supported!");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessBitwiseVisitor();
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return new PointlessBitwiseFix();
    }

    private boolean isZero(JSExpression expression) {
        if (this.m_ignoreExpressionsContainingConstants && !(expression instanceof JSLiteralExpression)) {
            return false;
        }
        Object value = ExpressionUtil.computeConstantExpression((JSExpression)expression);
        return value instanceof Integer && (Integer)value == 0;
    }

    private boolean isAllOnes(JSExpression expression) {
        if (this.m_ignoreExpressionsContainingConstants && !(expression instanceof JSLiteralExpression)) {
            return false;
        }
        Object value = ExpressionUtil.computeConstantExpression((JSExpression)expression);
        return value instanceof Integer && (Integer)value == Integer.MAX_VALUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/bitwise/PointlessBitwiseExpressionJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class PointlessBitwiseVisitor
    extends BaseInspectionVisitor {
        private final TokenSet BITWISE_TOKENS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.AND, JSTokenTypes.OR, JSTokenTypes.XOR, JSTokenTypes.LTLT, JSTokenTypes.GTGT, JSTokenTypes.GTGTGT});

        private PointlessBitwiseVisitor() {
        }

        public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
            if (expression == null) {
                PointlessBitwiseVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSBinaryExpression(expression);
            IElementType sign = expression.getOperationSign();
            boolean isPointless = this.isPointless(sign, expression.getROperand(), expression.getLOperand());
            if (isPointless) {
                this.registerErrorForChild((PsiElement)expression, sign, expression);
            }
        }

        private boolean isPointless(IElementType sign, JSExpression rhs, JSExpression lhs) {
            if (!this.BITWISE_TOKENS.contains(sign) || lhs == null || rhs == null) {
                return false;
            }
            if (sign == JSTokenTypes.AND) {
                return this.andExpressionIsPointless(lhs, rhs);
            }
            if (sign == JSTokenTypes.OR) {
                return this.orExpressionIsPointless(lhs, rhs);
            }
            if (sign == JSTokenTypes.XOR) {
                return this.xorExpressionIsPointless(lhs, rhs);
            }
            if (sign == JSTokenTypes.LTLT || sign == JSTokenTypes.GTGT || sign == JSTokenTypes.GTGTGT) {
                return this.shiftExpressionIsPointless(rhs);
            }
            return false;
        }

        private boolean andExpressionIsPointless(JSExpression lhs, JSExpression rhs) {
            return PointlessBitwiseExpressionJSInspection.this.isZero(lhs) || PointlessBitwiseExpressionJSInspection.this.isZero(rhs) || PointlessBitwiseExpressionJSInspection.this.isAllOnes(lhs) || PointlessBitwiseExpressionJSInspection.this.isAllOnes(rhs);
        }

        private boolean orExpressionIsPointless(JSExpression lhs, JSExpression rhs) {
            return PointlessBitwiseExpressionJSInspection.this.isZero(lhs) || PointlessBitwiseExpressionJSInspection.this.isZero(rhs) || PointlessBitwiseExpressionJSInspection.this.isAllOnes(lhs) || PointlessBitwiseExpressionJSInspection.this.isAllOnes(rhs);
        }

        private boolean xorExpressionIsPointless(JSExpression lhs, JSExpression rhs) {
            return PointlessBitwiseExpressionJSInspection.this.isZero(lhs) || PointlessBitwiseExpressionJSInspection.this.isZero(rhs) || PointlessBitwiseExpressionJSInspection.this.isAllOnes(lhs) || PointlessBitwiseExpressionJSInspection.this.isAllOnes(rhs);
        }

        private boolean shiftExpressionIsPointless(JSExpression rhs) {
            return PointlessBitwiseExpressionJSInspection.this.isZero(rhs);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/bitwise/PointlessBitwiseExpressionJSInspection$PointlessBitwiseVisitor", "visitJSBinaryExpression"));
        }
    }

    private class PointlessBitwiseFix
    extends InspectionJSFix {
        private PointlessBitwiseFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("pointless.bitwise.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                PointlessBitwiseFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            JSExpression expression = (JSExpression)descriptor.getPsiElement();
            String newExpression = PointlessBitwiseExpressionJSInspection.this.calculateReplacementExpression(expression);
            PointlessBitwiseFix.replaceExpression(expression, newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bitwise/PointlessBitwiseExpressionJSInspection$PointlessBitwiseFix", "getFamilyName"));
        }
    }
}

